#include "util/swu_securityEngine.h"
 
#ifdef CHECKSUM_TOOL_LOCALBUILD
#else
#include "base/imp/swupd_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_CHECKSUM
#include "trcGenProj/Header/checksum_tool.cpp.trc.h"
#endif
#endif



using std::string;

// Todo(efs1hi): Some ideas how we could increase the performance if this tool:
//               - Usual it is used to pipe into a tar file. We could use libarchive to
//                 untar directly, getting a zero-copy.
//               - Do the reading and writing of data in own threads.

void print_help() {
   ETG_TRACE_USR2(("checksum_tool [options]"));
   ETG_TRACE_USR2(("Options:"));
   ETG_TRACE_USR2(("    -h|--help          Print this help message and leave"));
   ETG_TRACE_USR2(("    -i|--infile FILE   Read input from FILE (- means stdin, DEFAULT)"));
   ETG_TRACE_USR2(("    -o|--outfile FILE  Write output to FILE (- means stdout, NONE means no output, stdout is DEFAULT)"));
   ETG_TRACE_USR2(("    -c|--crcfile FILE  Use FILE as checksum file (mandatory)"));
   ETG_TRACE_USR2(("    -v|--verify        Verify the checksum, if not set the digests will be created"));
}

int main(int argc, char **argv) {
   string inFile = "";
   string outFile = "-";
   string paramFile = "";
   bool verify = false;

   vInitPlatformEtg(); // initialize the trace backend no cleanup required
   
   int i = 0;
   while (i < argc) {
      if ((0 == strcmp(argv[i], "-h")) || (0 == strcmp(argv[i], "--help"))) {
         print_help();
         SWU_EXIT(0);
      } else if (!strcmp(argv[i], "-i") || !strcmp(argv[i], "--infile")) {
         i++;
         if(i >= argc) {
            ETG_TRACE_FATAL(("Command line error: option %s needs a parameter.", argv[i - 1]));
            SWU_EXIT(1);
         }
         inFile = argv[i];
         ETG_TRACE_USR1(("infile is %s\n", inFile.c_str()));
      } else if (!strcmp(argv[i], "-o") || !strcmp(argv[i], "--outfile")) {
         i++;
         if(i >= argc) {
            ETG_TRACE_FATAL(("Command line error: option %s needs a parameter.", argv[i - 1]));
            SWU_EXIT(1);
         }
         outFile = argv[i];
         ETG_TRACE_USR2(("outfile is %s\n", outFile.c_str()));
      } else if (!strcmp(argv[i], "-c") || !strcmp(argv[i], "--crcfile")) {
         i++;
         if(i >= argc) {
            ETG_TRACE_FATAL(("Command line error: option %s needs a parameter.", argv[i - 1]));
            SWU_EXIT(1);
         }
         paramFile = argv[i];
         ETG_TRACE_USR2(("paramFile is %s\n", paramFile.c_str()));
      } else if (!strcmp(argv[i], "-v") || !strcmp(argv[i], "--verify")) {
         verify = true;
      }
      i++;
   }
   if(paramFile == "") {
      ETG_TRACE_FATAL(("Missing Parameters File."));
      SWU_EXIT(1);
   }
   
   if(inFile == paramFile) {
      ETG_TRACE_FATAL(("Parameters File and input File my not be same."));
      SWU_EXIT(1);
   }
   if(outFile == paramFile) {
      ETG_TRACE_FATAL(("Parameters File and output File my not be same."));
      SWU_EXIT(1);
   }
   if((outFile != "") && (outFile == inFile)) {
      ETG_TRACE_FATAL(("input File and output File my not be same."));
      SWU_EXIT(1);
   }

   class swu::SecurityEngine engine;
   if(false == engine.readParameters(paramFile)) {
      ETG_TRACE_FATAL(("Error reading parameters file %s", paramFile.c_str()));
      SWU_EXIT(1);
   }
   ETG_TRACE_USR2(("Verify = %d ", verify));
   ETG_TRACE_USR2(("Digest type %d", engine._enDigestType));
   ETG_TRACE_USR2(("Digest filesize %u", engine._fileLength));
   ETG_TRACE_USR2(("Digest blocksize %u", engine._blockLength));
   ETG_TRACE_USR2(("Digests amount %d", engine._digests.size()));
   
   /*
   if(false == checksum.writeParameters(paramFile + "new")) {
      ETG_TRACE_FATAL(("failed to save  checksum file"));
   }
   */

   if (true == verify) {
      if(false == engine.processAndCatenate(inFile, outFile)) {
         ETG_TRACE_FATAL(("Could not verify checksum"));
         SWU_EXIT(1);
      }
      ETG_TRACE_USR2(("VERIFY OK"));
   } 
   else {
      if(false == engine.processAndCatenate(inFile, outFile, verify)) { 
         ETG_TRACE_FATAL(("Could not create checksum"));
         SWU_EXIT(1);
      }
      if(false == engine.writeParameters(paramFile + "new")) {
         ETG_TRACE_FATAL(("Could not Write checksum to file %s", paramFile.c_str()));
         SWU_EXIT(1);
      }
   }
   ETG_TRACE_USR1(("swu_common_base_checksum_tool finished succesfully"));
   SWU_EXIT(0);
}
