/*
 * swu_macros.h
 *
 *  Created on: 27.03.2015
 *      Author: ltt2hi
 */

#ifndef _SWU_MACROS_H
#define _SWU_MACROS_H

//------------------------------------------------------------------------------
// DECLARATIONS
//------------------------------------------------------------------------------

#define SWU_DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(class)              \
public:                                                                 \
    class(void);                                                        \
    virtual ~class(void)

//------------------------------------------------------------------------------

#define SWU_DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(class)            \
protected:                                                              \
    static class* mpInstance;                                           \
                                                                        \
public:                                                                 \
    static class* getInstance ( void );                                 \
    static void deleteInstance ( void )

//------------------------------------------------------------------------------

#define SWU_DECL_GET_AND_RELEASE_INSTANCE(className)                    \
className* getInstanceOf##className( void );                            \
void releaseInstanceOf##className ( void )

//------------------------------------------------------------------------------
// IMPLEMENTATIONS
//------------------------------------------------------------------------------

#define SWU_IMPL_SINGLETON(className)                                   \
className* className::mpInstance = 0;                                   \
                                                                        \
className* className::getInstance ( void )                              \
{                                                                       \
    if ( !mpInstance )                                                  \
    {                                                                   \
        mpInstance = OSAL_NEW className;                                \
    }                                                                   \
    return mpInstance;                                                  \
}                                                                       \
                                                                        \
void className::deleteInstance ( void )                                 \
{                                                                       \
    if ( mpInstance )                                                   \
    {                                                                   \
        OSAL_DELETE mpInstance;                                         \
        mpInstance = 0;                                                 \
    }                                                                   \
}

//------------------------------------------------------------------------------

#define SWU_IMPL_GET_AND_RELEASE_INSTANCE(className)                    \
className* getInstanceOf##className( void )                             \
{                                                                       \
    return className::getInstance();                                    \
}                                                                       \
                                                                        \
void releaseInstanceOf##className ( void )                              \
{                                                                       \
    className::deleteInstance();                                        \
}

//------------------------------------------------------------------------------

#define SWU_IMPL_GET_AND_RELEASE_MOCK_INSTANCE(className,mockClassName) \
bool mockClassName::preventSingletonCreation = false;                   \
bool mockClassName::useMockSingleton = false;                           \
                                                                        \
className* getInstanceOf##className( void )                             \
{                                                                       \
    if ( mockClassName::useMockSingleton )                              \
    {                                                                   \
        return (mockClassName::preventSingletonCreation) ? 0 : mockClassName::getInstance();  \
    }                                                                   \
    return className::getInstance();                                    \
}                                                                       \
                                                                        \
void releaseInstanceOf##className ( void )                              \
{                                                                       \
    if ( mockClassName::useMockSingleton )                              \
    {                                                                   \
        mockClassName::deleteInstance();                                \
    }                                                                   \
    else                                                                \
    {                                                                   \
        className::deleteInstance();                                    \
    }                                                                   \
}

//------------------------------------------------------------------------------

#define SWU_DECL_STATIC_VAR_FOR_GET_AND_RELEASE_MOCK_INSTANCE()         \
public:                                                                 \
    static bool preventSingletonCreation;                               \
    static bool useMockSingleton

//------------------------------------------------------------------------------

#endif /* _SWU_MACROS_H */
