/*
 * checksum.hpp
 *
 *  Created on: Dec 10, 2013
 *      Author: efs1hi
 */

#ifndef CHECKSUM_HPP_
#define CHECKSUM_HPP_

#include <string>
#include <vector>
#include <istream>
#include <ostream>
#include <stdint.h>
#include "tinyxml/tinyxml.h"

#ifdef CHECKSUM_TOOL_LOCALBUILD
#define ETG_TRACE_FATAL(a)    { printf a; printf("\n"); }
#define ETG_TRACE_ERR(a)      { printf a; printf("\n"); }
#define ETG_TRACE_USR1(a)     { printf a; printf("\n"); }
#define ETG_TRACE_USR2(a)     { printf a; printf("\n"); }
#define ETG_TRACE_USR3(a)     { printf a; printf("\n"); }
#define ETG_TRACE_USR4(a)     { printf a; printf("\n"); }
#define vInitPlatformEtg()
#endif
/**
 * This struct reflects mostly the information given from FC Update over ASF
 */
class ChecksumData {

public:   
   ChecksumData();

   ChecksumData(const ChecksumData &copyFrom);

   // Deletes the checksum objects
   ~ChecksumData() {};


   bool readCRCFile(::std::string file);
   bool writeCRCFile(::std::string file);

   std::string checksum_type;
   long long int blockLength;
   long long int fileLength;
   ::std::vector< ::std::vector< uint8_t > > checksums;
   static const int BUFFER_SIZE = 65536;
   
/**   Function processAndCatenate
 *    Does Verify or Create a checksum.
 *
 * @param inFile A file name where the checksum needs to be verified or calculated
 * @param outFile Output file name. 
 *           If that is NULL - the preccessed data are not output to file
 * @param doVerify if true the method verifies the checksum, if false - generates one. 
 * @return false on error, true if the verification could be checked. A wrong
 *         checksum also result in a return value true, as it could be checked.
 *         Only result tells then if the the verification was successful.
 */
bool processAndCatenate(std::string inFile, std::string outFile,
      bool doVerify);

bool processAndCatenate(std::string inFileName, std::string outFileName);

   static const ::std::string CHECKSUMTYPE_NONE() {return "NONE";}
   static const ::std::string CHECKSUMTYPE_SHA1() {return "SHA1";}
   static const ::std::string CHECKSUMTYPE_SHA256() {return "SHA256";}
   static const ::std::string CHECKSUMTYPE_MD5() {return "MD5";}
   static const ::std::string CHECKSUM_FILENAME() {return "/tmp/swupdate/data_checksum_file.xml";}

private:
   bool readFromXml(TiXmlElement *);
   TiXmlElement *toXml();

   static const ::std::string NAME() {return "CKSUM";}
   static const ::std::string TYPE() {return "TYPE";}
   static const ::std::string SEGLEN() {return "SEGLEN";}
   static const ::std::string FILELEN() {return "SIZE";}
   static const ::std::string SERIES() {return "CKSUM_SERIES";}
   static const ::std::string VALUE() {return "VAL";}
   ::std::vector< uint8_t > readVectorFromString(const char *in);
/**
 * This method can create or verify checksums. It is mostly designed to
 * be called by the more convenient functions generateAndCatenate and verifyAndCatenate.
 *
 * @param inFile A file handle to read the data from, that shall be verified or
 *               the checksums shall be created for.
 * @param outFile if this is not null all data read from inData is written to out file handle
 * @param verify if true the function takes the checksums from the checksum
 *               vector and checks if they are valid. if false the checksum
 *               are computed and added to the vector.
 * @return false on error, true if the verification could be checked or the
 *         checksums could be created. A wrong checksum in verification
 *         also result in a return value true, as it could be checked. Only
 *         result tells then if the the verification was successful.
 */
   bool runThroughStream(int inFile, int *outFile, bool verify);

};

#endif /* CHECKSUM_HPP_ */
