/*************************************************************************
* FILE:         UpdateLog.h
* PROJECT:      Gen3
* SW-COMPONENT: SW Update
*----------------------------------------------------------------------
*
* DESCRIPTION:  Gen3 Software Update Logging
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author        | Modification
*
* 2014-03-04  W.Stautz		  01.00

---------------------------------------------------------------------------
* 2014-08-27 Neera.K.Ponnappa,Apoorva K R  Modified for :CMG3G-5311  IS1604_Optimize Logging (update.log)@V850 Update Ctrl
                                                         CMG3G-5318  IS1604_Optimize Logging (update.log)@Teseo Update Ctrl
**************************************************************************/

#ifndef UPDATE_LOG_H
#define UPDATE_LOG_H
#include <pthread.h>
#include <string>
//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
 #define OSAL_S_IMPORT_INTERFACE_GENERIC
 #include "osal_if.h"
#endif

//-----------------------------------------------------------------------------
// defines
//-----------------------------------------------------------------------------

#define DL_WIN_MAIN_DEV   0
#define DL_OSAL_BENCH_DEV 1
#define DL_TARGET_DEV     2
#define DL_LOG_INFO       "@info"
#define DL_LOG_SERVICE    "@service"
#define DL_LOG_ERROR      "@error"
#define DL_FILE_PATH_MAX   256

//-----------------------------------------------------------------------------
// function prototypes
//-----------------------------------------------------------------------------

using namespace std;
namespace ai_sw_update {
namespace common {

long int dl_getFileSize (tCString fileName);


class UpdateLog
{
public:

	static tVoid vUpdateLogOpen  ();
	static tVoid vUpdateLogTrace (const char *format, ...);
	static tVoid vUpdateLogClose ();
	static tVoid vUpdateLogTest  ();
	static tVoid vVerifyLogOpen  ();
	static tString vGetUpdateLog ();
	static tVoid vVerifyLogTrace (tCString buffer);
	static tVoid vVerifyLogClose();
	static tBool needToCutOff ();
	static tVoid cutOff ();
	static UpdateLog *vGetInstance(tU32 devEnvironmentType);
	static tBool bMkdirInFS (tCString CStrFileSystem, tCString CStrPath);
	static tVoid vSetLogFile (tCString cStrLogFileName);

	UpdateLog (tU32 devEnvironmentType);
	~UpdateLog();

private:
	static tInt UpdateLogFileTrace;
	static tInt verifyLogFileTrace;
	static tString updateLogFile;
	static tString verifyLogFile;
	static UpdateLog *oneInstance;
	static char cUpdateLogFilePath[DL_FILE_PATH_MAX];

	//UpdateLog (tU32 devEnvironmentType);
	//~UpdateLog();

};

} // namespace ai_sw_update {
} // namespace common {

#endif


