/**
 * @file SystemCall.h
 * @author kut2hi
 * @copyright (c) 2013 Robert Bosch Car Multimedia GmbH
 * @addtogroup ai_sw_update/common
 * @{
 */

#ifndef AI_SW_UPDATE_COMMON_BASE_SYSTEMCALL_H_
#define AI_SW_UPDATE_COMMON_BASE_SYSTEMCALL_H_

#include <string>
#include <cstring>
#include <stdint.h>

namespace ai_sw_update {
namespace common {

#define DL_MAX_STDERR_OUTPUT 2048
#define DL_MAX_STDOUT_OUTPUT 2048

extern std::string usbLogPath;

struct SystemCallExecResult {
   char stdOut[DL_MAX_STDOUT_OUTPUT];
   char stdErr[DL_MAX_STDERR_OUTPUT];
   int retValue;
};

/**
 * Class for executing system calls.
 */
class SystemCall {
public:

   static int32_t execCommand(const std::string & inSystemCall);

   /**
    * Executes the system() function.
    *
    * TBC: On the Gen3 target system() currently works, but returns -1 each time. errno is set to 10 ("No child processes")
    * Therefore the exec functions return statically "true". Error cannot be detected currently.
    *
    * @param inSystemCall
    * @return true in every case, no error checking possible at the moment
    */
   static const bool exec(const std::string & inSystemCall, SystemCallExecResult* result = 0, bool global_fail = true);

   static const bool hasError();

   static const int32_t getErrorCode();

   static const bool clearError();
};

} // namespace common
} // namespace ai_sw_update

#endif // AI_SW_UPDATE_COMMON_BASE_SYSTEMCALL_H_
