#ifndef AI_SW_UPDATE_COMMON_BASE_BOOTCHAINMGR_H_
#define AI_SW_UPDATE_COMMON_BASE_BOOTCHAINMGR_H_

//@todo:
// Implementation is taken over from GM Gen2 DL-Core. It needs to be refactored:
// - refactor complete file / implementation
// - remove OSAL
// - refactor tracing
// - enable TTFis tracing
// - code cleanup


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


namespace ai_sw_update {
namespace common {

// Magic sector 1
#define DL_MAGIC_SECTOR_VALID_FLAG        0x00160000
#define DL_MAGIC_SECTOR_COUNTER_FLAG      0x00160010
#define DL_UPDATE_STATUS_FLAG             0x00160020
#define DL_ETHERNET_FLAG                  0x00160030
#define DL_ROOTFS_FLAG                    0x00160040

// Magic sector 2
#define DL_MAGIC_SECTOR_VALID_FLAG_2      0x00180000
#define DL_MAGIC_SECTOR_COUNTER_FLAG_2    0x00180010
#define DL_UPDATE_STATUS_FLAG_2           0x00180020
#define DL_ETHERNET_FLAG_2                0x00180030
#define DL_ROOTFS_FLAG_2                  0x00180040

// Values
#define DL_UPDATE_STATE_SUCCESS           0xFFFFFFFF // Normal operation (default)
#define DL_UPDATE_STATE_FAILURE           0x2342ABCD // Recovery-Download-Mode
#define DL_UPDATE_STATE_RECOVERY          0x2342ABCD // Recovery-Download-Mode
#define DL_MAGIC_SECTOR_VALID             0xDEADBEEF // Sector OK
#define DL_MAGIC_SECTOR_INVALID           0xFFFFFFFF // Sector invalid
#define DL_ROOTFS_1                       0xFFFFFFFF // Boot chain 1 (default)
#define DL_ROOTFS_2                       0x5AA501CB // Boot chain 2

// Misc
#define DNL_MAGIC_ARRAY_SIZE              (5 * 4)           // 20 DWORDs
#define DNL_MAGIC_AREA_SIZE               (DNL_MAGIC_ARRAY_SIZE * 4)  // 80 Bytes
#define DNL_MAGIC1_BASE_ADDRESS           DL_MAGIC_SECTOR_VALID_FLAG
#define DNL_MAGIC2_BASE_ADDRESS           DL_MAGIC_SECTOR_VALID_FLAG_2
#define DL_UPDATE_STATUS_FLAG_OFFSET      (DL_UPDATE_STATUS_FLAG - DNL_MAGIC1_BASE_ADDRESS)
#define DL_ETHERNET_FLAG_OFFSET           (DL_ETHERNET_FLAG      - DNL_MAGIC1_BASE_ADDRESS)
#define DL_ROOTFS_FLAG_OFFSET             (DL_ROOTFS_FLAG        - DNL_MAGIC1_BASE_ADDRESS)


// legacy functions taken from GM Gen2 DL-Core
tBool bWriteMagicToRawFlash (unsigned int u32FlashMagicOffset, unsigned int u32Value); // analysed
tBool bReadMagicFromRawFlash (const unsigned int inFlashAddress, unsigned int& outValue); // analysed
tBool bWriteMagicBootChain (const unsigned int inFlashAddress, const unsigned int inValue);
tBool bReadFlagFromRawFlash (off_t u32FlashAdress, tPU32 pu32Value);
tBool bReadMagicAreas (tU32  u32FlashMagicOffset, tPU32 pu32MagicIndex, tPU32 pu32FlashMagicArea1, tPU32 pu32FlashMagicArea2, tPU32 pu32MagicAreaSelected); // analysed




/**
 * Manager class for boot chains.
 * @todo add legacy functionality to this class in order to provide an integrate approach to modify boot chain control data.
 */
class BootChainMgr
{
public:

  /**
   * Activates the recovery mode for the active boot chain.
   * @return true for success, else false
   */
  static const bool activateRecoveryMode();


  /**
   * Activates the application mode for the active boot chain.
   * @return true for success, else false
   */
  static const bool activateApplicationMode();

  /**
   * Switch the active boot chain to One.
   * @return true for success, else false
   */
  static const bool switchBootChainOne();

  /**
   * Switch the active boot chain to Two.
   * @return true for success, else false
   */
  static const bool switchBootChainTwo();

  //@todo: activateBootChain(param BC1, BC2);
  //@todo: BC1 or BC2 activeBootchain();
};



/*
class Utils
{
  result = readBytesToBuffer(io *buf, in bufSize, address, bytes)



class ConfigItem
{
  properties:
    address:
      segment: depends on containing Sektor
      offset (0x00, 0x10, ...) depends on value

    value: val(address): readBytesToBuffer(address, valueSize), alternatively read complete sector to buffer and then copy relevant bytes from buffer
    valueSize: currently 4 bytes (max. 16 bytes possible)
    invariant: maxValueSize = 16
l}


class Sector(segment)
{
  properties:
    segment (0x160000 or 0x180000)

    ConfigItem validity
    ConfigItem counter
    ConfigItem recovery
    ConfigItem alternativeDL
    ConfigItem bootchain

  methods:
    serialize()
    {
    }

    deserialize()
    {
    }

    erase()
    {
      MTD_IO: erase with linux mtd methods
    }


}
*/



} // namespace ai_sw_update {
} // namespace common {

#endif // AI_SW_UPDATE_COMMON_BASE_BOOTCHAINMGR_H_
