/*
 * dldab_macros.h
 *
 *  Created on: 27.03.2015
 *      Author: ltt2hi
 */

#ifndef _DLDAB_MACROS_H
#define _DLDAB_MACROS_H

//------------------------------------------------------------------------------
// DECLARATIONS
//------------------------------------------------------------------------------

#define SWU_DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(class)              \
public:                                                                 \
    class(void);                                                        \
    virtual ~class(void)

//------------------------------------------------------------------------------

#define SWU_DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(class)            \
protected:                                                              \
    static class* mpInstance;                                           \
                                                                        \
public:                                                                 \
    static class* poGetInstance ( void );                                 \
    static void bRemoveInstance ( void )

//------------------------------------------------------------------------------

#define SWU_DECL_GET_AND_RELEASE_INSTANCE(className)                    \
className* getInstanceOf##className( void );                            \
void releaseInstanceOf##className ( void )

//------------------------------------------------------------------------------
// IMPLEMENTATIONS
//------------------------------------------------------------------------------

#define SWU_IMPL_SINGLETON(className)                                   \
className* className::mpInstance = 0;                                   \
                                                                        \
className* className::poGetInstance ( void )                              \
{                                                                       \
    if ( !mpInstance )                                                  \
    {                                                                   \
        mpInstance = OSAL_NEW className;                                \
    }                                                                   \
    return mpInstance;                                                  \
}                                                                       \
                                                                        \
void className::bRemoveInstance ( void )                                 \
{                                                                       \
    if ( mpInstance )                                                   \
    {                                                                   \
        OSAL_DELETE mpInstance;                                         \
        mpInstance = 0;                                                 \
    }                                                                   \
}

//------------------------------------------------------------------------------

#define SWU_IMPL_GET_AND_RELEASE_INSTANCE(className)                    \
className* getInstanceOf##className( void )                             \
{                                                                       \
    return className::poGetInstance();                                    \
}                                                                       \
                                                                        \
void releaseInstanceOf##className ( void )                              \
{                                                                       \
    className::bRemoveInstance();                                        \
}

//------------------------------------------------------------------------------

#define SWU_IMPL_GET_AND_RELEASE_MOCK_INSTANCE(className,mockClassName) \
bool mockClassName::preventSingletonCreation = false;                   \
bool mockClassName::useMockSingleton = false;                           \
                                                                        \
className* getInstanceOf##className( void )                             \
{                                                                       \
    if ( mockClassName::useMockSingleton )                              \
    {                                                                   \
        return (mockClassName::preventSingletonCreation) ? 0 : mockClassName::poGetInstance();  \
    }                                                                   \
    return className::poGetInstance();                                    \
}                                                                       \
                                                                        \
void releaseInstanceOf##className ( void )                              \
{                                                                       \
    if ( mockClassName::useMockSingleton )                              \
    {                                                                   \
        mockClassName::bRemoveInstance();                                \
    }                                                                   \
    else                                                                \
    {                                                                   \
        className::bRemoveInstance();                                    \
    }                                                                   \
}

//------------------------------------------------------------------------------

#define SWU_DECL_STATIC_VAR_FOR_GET_AND_RELEASE_MOCK_INSTANCE()         \
public:                                                                 \
    static bool preventSingletonCreation;                               \
    static bool useMockSingleton

//------------------------------------------------------------------------------

#endif /* _DLDAB_MACROS_H */
