/**********************************************************************************************
* FILE:           dl_tclDABPlusMain.h
* PROJECT:        Nissan
* SW-COMPONENT:   Download
*----------------------------------------------------------------------------------------------
* DESCRIPTION:  DAB Plus Firmware Main Class
* In this file class dl_tclDABPlusMain is defined. An object of this class is created by the
* dl_Copy class. This class is a singletone class.
*----------------------------------------------------------------------------------------------
* COPYRIGHT: (c) 2011 Robert Bosch Car Multimedia GmbH, Hildesheim
* HISTORY:
* Date       |Author								  |Modification
* 21.02.11   |Ghatikar Nageetha (CM-AI/PJ-VW36 RBEI)  |Initial
**********************************************************************************************/

#ifndef  _DL_DAB_PLUS_MAIN_H
#define  _DL_DAB_PLUS_MAIN_H


//----------------------------------------------------------------------------------------
// includes
//----------------------------------------------------------------------------------------

#include "dldab_includes.h"
#include "dldab_defines.h"
#include "dldab_ProcessCmd.h"

#define DL_PATH_LENGTH 256
//----------------------------------------------------------------------------------------
// Forward Declarations
//----------------------------------------------------------------------------------------
class dldab_tclProcessCmd;

//----------------------------------------------------------------------------------------
// class definition
//----------------------------------------------------------------------------------------
class dl_tclDABPlusMain
{
    SWU_DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dl_tclDABPlusMain);

	public:
		tU32 u32GetSizeOfAdmin(tPU8 pu8Buffer, tU32 u32SizeOfFile ) const;

		tBool bRunSequence(tCString xloaderFileName, tCString adr3FileName) const;
		tBool bRunReadSequence(tCString xloaderFileName, tCString adr3FileName, tCString outFileName) const;
		tBool bRunReadVersionSequence(tCString xloaderFileName, tU32 adr3AddressOfVersion, tCString versionFileName) const;

		tBool bRunADR3Thread(tString xloaderFileName, tString adr3FileName) const;
		static tVoid vADR3Thread(tPVoid arg);
		static tVoid vStartADR3Dnl(tCString fileNames); // TTFIS ETG_I

		tVoid vBreakADR3Thread();
		static tVoid vBreakADR3Dnl(); // TTFIS ETG_I

		tVoid vResetADR3();
		static tVoid vResetADR3Dnl(); // TTFIS ETG_I
		static tVoid vGetStatusADR3Dnl(); // TTFIS ETG_I

		static tU32 u32GetStatusADR3 ();

		tString myXloaderFileName[DL_PATH_LENGTH];
		tString myAdr3FileName[DL_PATH_LENGTH];

	protected:
		dl_tclDABPlusMain();

		~dl_tclDABPlusMain();

	private:
		tBool bRunSequenceXloader(tCString xloaderFileName) const;
		tBool bRunSequenceWriteFile(tCString adr3FileName) const;
		tBool bRunSequenceReadFile(tCString adr3FileName, tCString outFileName) const;
		tBool bRunSequenceReadVersion(tU32 adr3AddressOfVersion, tCString versionFileName) const;
		tBool bWriteVersionToFile(tPU8 versionName, tCString versionFileName) const;
		tBool bGetVersionFromRegistry (tPU8 au8RamBuffer, tU32 u32Length) const;
		dldab_tclProcessCmd* m_poProcessCmd;

};

SWU_DECL_GET_AND_RELEASE_INSTANCE(dl_tclDABPlusMain);

#endif

//EOF
