/**********************************************************************************************
* FILE:           dl_Adr3App.cpp
* PROJECT:        G3G
* SW-COMPONENT:   Download
*----------------------------------------------------------------------------------------------
* DESCRIPTION:  Standalone "APP" for ADR3-Download
*
*----------------------------------------------------------------------------------------------
* COPYRIGHT: (c) 2014 Robert Bosch Car Multimedia GmbH, Hildesheim
**********************************************************************************************/

#include "dl_tclDABPlusMain.h"
class dl_tclDABPlusMain;
#include "dldab_ProcessCmd.h"
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#define OSAL_S_IMPORT_INTERFACE_TYPES
#include "osal_if.h"
#define ETG_ENABLED
#include "trace_interface.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
/* Needed for Trace */
#define ETG_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etg_if.h"
#endif

/* Needed for ETG trace */
#ifdef DL_ADR3_GEN2_CORE
#include "dl_Adr3TraceMacros.h"
#else
#include "ai_sw_update/common/base/imp/swupd_trace.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL TR_TTFIS_SWUPDATE_CTRL
#define ETG_I_TTFIS_CMD_PREFIX "DNL_"
#define ETG_I_FILE_PREFIX dl_Adr3App::
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SWUPDATE_ADR3
#include "trcGenProj/Header/dl_Adr3App.cpp.trc.h"
#endif

#define VERSION_FOR_APPLICATION_INTERFACE_COMPATIBILITY    1
#define SWU_COMMON_ADR3_APP_EXIT_CODE                      98
#define USED_OSAL_PREFIX                                   "/dev/root/"

static tVoid vAdr3DefaultHandlerTraceCmds (const tU8* pcu8Data);

/*************************************************************************/

tVoid vAdr3DefaultHandlerTraceCmds (const tU8* pcu8Data)
{
  ETG_TRACE_FATAL(("dl_Adr3App: Unknown ETG_I command= %x", ETG_LIST_LEN((tU8)pcu8Data[0]), ETG_LIST_PTR_T8(&pcu8Data[1]) ));
}

/*************************************************************************/

void usage(char *argv[])
{
	printf ("Usage for Write:\n  %s -w -x <XLOADER-FILE> -f <ADR3-FILE>\n",argv[0]);
	printf ("Usage for Read:\n  %s -r -x <XLOADER-FILE> -f <ADR3-FILE> -o <ADR3-OUT-FILE>\n",argv[0]);
	printf ("Usage for Version:\n  %s -v -x <XLOADER-FILE> -o <ADR3-OUT-FILE>\n",argv[0]);
	printf ("Usage for Version (if specific address unequal 0x2020 has to be used):\n  %s -v -x <XLOADER-FILE> -o <ADR3-OUT-FILE> -a <FROM-ADDRESS>\n",argv[0]);
	printf ("Usage for Interface version (old versions returned 99):\n  %s -i\n",argv[0]);
	printf ("Current interface version is %d\n",VERSION_FOR_APPLICATION_INTERFACE_COMPATIBILITY);
	printf ("Old interface to write flash still available:\n  %s <XLOADER-FILE> <ADR3-FILE>\n",argv[0]);
	printf ("Additionally option -p can be used to define /dev/root/ as prefix for <XLOADER-FILE> and <ADR3-FILE>\n");
}

/*************************************************************************/

void vCheckToIntroduceOsalPrefx(tBool bOsalPrefix, tCString xloaderFileName, tCString adr3FileName)
{
	tU16 PrefixLength = 0;

	if (bOsalPrefix == TRUE)
	{
		PrefixLength = OSAL_u32StringLength(USED_OSAL_PREFIX);
		(void)OSAL_szStringConcat(getInstanceOfdl_tclDABPlusMain()->myXloaderFileName, USED_OSAL_PREFIX);
		(void)OSAL_szStringConcat(getInstanceOfdl_tclDABPlusMain()->myAdr3FileName, USED_OSAL_PREFIX);
	}

	if (OSAL_u32StringLength(xloaderFileName)+PrefixLength+1 >= DL_PATH_LENGTH)
	{
		printf ("String too long in vCheckToIntroduceOsalPrefx (XLOADER-FILE = %s)\n", xloaderFileName);
		OSAL_vSetProcessExitCode(SWU_COMMON_ADR3_APP_EXIT_CODE);
		OSAL_vProcessExit();
	}
	(void)OSAL_szStringConcat(getInstanceOfdl_tclDABPlusMain()->myXloaderFileName, xloaderFileName);

	if (OSAL_u32StringLength(adr3FileName)+PrefixLength+1 >= DL_PATH_LENGTH)
	{
		printf ("String too long in vCheckToIntroduceOsalPrefx (ADR3-FILE = %s)\n", adr3FileName);
		OSAL_vSetProcessExitCode(SWU_COMMON_ADR3_APP_EXIT_CODE);
		OSAL_vProcessExit();
	}
	(void)OSAL_szStringConcat(getInstanceOfdl_tclDABPlusMain()->myAdr3FileName, adr3FileName);
}

/*************************************************************************/

int main( int argc, char *argv[] )
{
	int opt = 0;
	tBool returnValue = FALSE;
	tBool bOptionWrite = FALSE;
	tBool bOptionRead = FALSE;
	tBool bOptionVersion = FALSE;
	tBool bOptionOsalPrefix = FALSE;
	tCString xloaderFileName = "EMPTY";
	tCString adr3FileName = "EMPTY";
	tCString outFileName = "EMPTY";
	char *endptr;
	tU32 u32LastStatus = 0;
	tU32 u32VersionAddress = 0x00002020;

	vInitPlatformEtg();
	
	ETG_TRACE_FATAL (("ADR3_APP ETG_TRACE RUNNING"));
	ETG_I_REGISTER_CHN(vAdr3DefaultHandlerTraceCmds);
	ETG_TRACE_FATAL (("ETG_I_REGISTER_CHN STARTED"));

    while ((opt = getopt(argc, argv, "piwrvx:f:o:a:")) != -1) {
        switch (opt) {
        case 'p':
            bOptionOsalPrefix = TRUE;
            break;
        case 'i':
			OSAL_vSetProcessExitCode(VERSION_FOR_APPLICATION_INTERFACE_COMPATIBILITY);
			OSAL_vProcessExit();
            break;
        case 'w':
            bOptionWrite = TRUE;
            break;
        case 'r':
            bOptionRead = TRUE;
            break;
        case 'v':
            bOptionVersion = TRUE;
            break;
        case 'x':
            xloaderFileName = optarg;
            break;
        case 'f':
            adr3FileName = optarg;
            break;
        case 'o':
            outFileName = optarg;
            break;
        case 'a':
            u32VersionAddress = strtol(optarg, &endptr, 0);
            break;
        default: /* '?' */
			usage(argv);
			OSAL_vSetProcessExitCode(SWU_COMMON_ADR3_APP_EXIT_CODE);
			OSAL_vProcessExit();
            break;
       }
    }

	if ((bOptionWrite == FALSE) && (bOptionRead == FALSE) && (bOptionVersion == FALSE))
	{
		// For compatibility with old parameter style
		if (argc == 3)
		{
			xloaderFileName = argv[1];
			adr3FileName = argv[2];
			printf ("XLOADER-FILE = %s\n", xloaderFileName);
			printf ("ADR3-FILE = %s\n", adr3FileName);
			returnValue = getInstanceOfdl_tclDABPlusMain()->bRunSequence(xloaderFileName, adr3FileName);
			releaseInstanceOfdl_tclDABPlusMain();
		}
		else
		{
			usage(argv);
			OSAL_vSetProcessExitCode(SWU_COMMON_ADR3_APP_EXIT_CODE);
			OSAL_vProcessExit();
		}
	}
	else if ((bOptionWrite == TRUE) && (bOptionRead == FALSE) && (bOptionVersion == FALSE))
	{
		vCheckToIntroduceOsalPrefx(bOptionOsalPrefix, xloaderFileName, adr3FileName);
		printf ("WRITE FLASH\nXLOADER-FILE = %s\nADR3-FILE = %s\n", (tCString)getInstanceOfdl_tclDABPlusMain()->myXloaderFileName, (tCString)getInstanceOfdl_tclDABPlusMain()->myAdr3FileName);
		returnValue = getInstanceOfdl_tclDABPlusMain()->bRunSequence((tCString)getInstanceOfdl_tclDABPlusMain()->myXloaderFileName, (tCString)getInstanceOfdl_tclDABPlusMain()->myAdr3FileName);
		releaseInstanceOfdl_tclDABPlusMain();
	}
	else if ((bOptionWrite == FALSE) && (bOptionRead == TRUE) && (bOptionVersion == FALSE))
	{
		vCheckToIntroduceOsalPrefx(bOptionOsalPrefix, xloaderFileName, adr3FileName);
		printf ("READ FLASH\nXLOADER-FILE = %s\nADR3-FILE = %s\nOUT-FILE = %s\n", (tCString)getInstanceOfdl_tclDABPlusMain()->myXloaderFileName, (tCString)getInstanceOfdl_tclDABPlusMain()->myAdr3FileName, outFileName);
		returnValue = getInstanceOfdl_tclDABPlusMain()->bRunReadSequence((tCString)getInstanceOfdl_tclDABPlusMain()->myXloaderFileName, (tCString)getInstanceOfdl_tclDABPlusMain()->myAdr3FileName, outFileName);
		releaseInstanceOfdl_tclDABPlusMain();
	}
	else if ((bOptionWrite == FALSE) && (bOptionRead == FALSE)&& (bOptionVersion == TRUE))
	{
		vCheckToIntroduceOsalPrefx(bOptionOsalPrefix, xloaderFileName, adr3FileName);
		printf ("GET VERSION FROM ADDRESS 0x%x\nXLOADER-FILE = %s\nOUT-FILE = %s\n", u32VersionAddress, (tCString)getInstanceOfdl_tclDABPlusMain()->myXloaderFileName, outFileName);
		returnValue = getInstanceOfdl_tclDABPlusMain()->bRunReadVersionSequence((tCString)getInstanceOfdl_tclDABPlusMain()->myXloaderFileName, u32VersionAddress, outFileName);
		releaseInstanceOfdl_tclDABPlusMain();
	}
	else
	{
		usage(argv);
		OSAL_vSetProcessExitCode(SWU_COMMON_ADR3_APP_EXIT_CODE);
		OSAL_vProcessExit();
	}
	
	if (returnValue == FALSE)
	{
		u32LastStatus = dl_tclDABPlusMain::u32GetStatusADR3();
		printf ("u32LastStatus %d\n",u32LastStatus);
		if (u32LastStatus == 0)
		{
			u32LastStatus = DL_ADR3_UNKNOWN_ERROR;
			printf ("Error, see logfile\n");
		}
	}

	ETG_I_UNREGISTER_CHN();

    OSAL_vSetProcessExitCode(u32LastStatus);
	OSAL_vProcessExit();
	return u32LastStatus;
}


