/************************************************************************
* FILE:			tclSpiADR3.h
* PROJECT:      Nissan
* SW-COMPONENT: Download
*-------------------------------------------------------------------------
*
* DESCRIPTION: tclADR3Driver class for the ADR3 communication
*              
*-------------------------------------------------------------------------
* AUTHOR:		Ghatikar Nageetha (CM-AI/PJ-VW36 RBEI)
* COPYRIGHT:    (c) 2011 Robert Bosch Car Multimedia GmbH, Hildesheim
* HISTORY:      Rev 1.0 
*				Initial version
**************************************************************************/
#ifndef _tclSpiADR3_h_
#define _tclSpiADR3_h_

#include "tclSpiIF.h"
#include "tclADR3Driver.h"
#include "../dldab_includes.h"

class tclSpiADR3 : public tclSpiIF
{
    SWU_DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(tclSpiADR3);

public:

   virtual tBool bOpen();
   
   virtual tBool bClose();

   virtual tS32 s32Read(tPS8 u8Buffer, tU32 u32Count);

   virtual tS32 s32Write(tPCS8 u8Buffer, tU32 u32Count);

   virtual tBool bSetReadTimeout();
   
   virtual tBool bReset();
   
   const char* name() const;
   
protected:          

   tclSpiADR3() : OpenCount(0), sem(name()) {}

   virtual ~tclSpiADR3(){}
   
   int OpenCount;
   
   tclSemaphore sem;

private:

   tclADR3Driver SpiWrapper;

};

SWU_DECL_GET_AND_RELEASE_INSTANCE(tclSpiADR3);




#endif //_tclSpiADR3_h_

//EOF

























