/************************************************************************
* FILE:			tclADR3Driver.h
* PROJECT:      Nissan
* SW-COMPONENT: Download
*-------------------------------------------------------------------------
*
* DESCRIPTION: tclADR3Driver class for the ADR3 communication
*              
*-------------------------------------------------------------------------
* AUTHOR:		Ghatikar Nageetha (CM-AI/PJ-VW36 RBEI)
* COPYRIGHT:    (c) 2011 Robert Bosch Car Multimedia GmbH, Hildesheim
* HISTORY:      Rev 1.0 
*				Initial version
**************************************************************************/
#ifndef _tclADR3Driver_
#define _tclADR3Driver_

class tclADR3Driver
{
public:
   tclADR3Driver():fd((OSAL_tIODescriptor)OSAL_ERROR){}
   ~tclADR3Driver(){}

    tBool bOpen ();

    tBool bClose();

    tS32 s32Read (tPS8 pBuffer, tU32 u32Count);

    tS32 s32Write (tPCS8 pBuffer, tU32 u32Count);

    tBool bSetReadTimeout();

    tBool bReset();

	static tVoid vCallback(tU32 u32State);

protected:

   OSAL_tIODescriptor fd;
   static tU32 u32ADR3CtrlState;
   
};


#endif // _tclADR3Driver_ 

//EOF



