


#ifndef _tclSemaphore_h_
#define _tclSemaphore_h_

class tclSemaphore 
{
public:

   static const int SemNameSize = 255;

   tclSemaphore(const char* name)  :_hHandle(OSAL_C_INVALID_HANDLE),_bValid(false)
   {
      if(name) { strncpy(_name,name,SemNameSize); _bValid = OSAL_ERROR != OSAL_s32SemaphoreCreate(_name, &_hHandle, 1); }
      else     { strncpy(_name,"Sem_With_No_Name",SemNameSize); }
   }

   ~tclSemaphore()
   {
      if(_bValid) { OSAL_s32SemaphoreClose(_hHandle);  OSAL_s32SemaphoreDelete(tCString(_name)); }
   }

   operator OSAL_tSemHandle() const {return _hHandle;}

   
protected: 

   tclSemaphore()  :_hHandle(OSAL_C_INVALID_HANDLE),_bValid(false){_name[0]=0;}

   char            _name[SemNameSize];
   OSAL_tSemHandle _hHandle;
   tBool           _bValid;
};


class dl_semaphore_protection 
{
public:
   dl_semaphore_protection(OSAL_tSemHandle hSem):_hSem(hSem)
   { 
      tS32 s32RetVal = OSAL_OK ;
      do
      {
         s32RetVal = OSAL_s32SemaphoreWait( _hSem, 20000 );   
         NORMAL_M_ASSERT(s32RetVal == OSAL_OK); 
      }
      while(s32RetVal != OSAL_OK);
   }

   virtual ~dl_semaphore_protection()
   { 
      OSAL_s32SemaphorePost(_hSem); 
   }

protected:

   dl_semaphore_protection():_hSem(OSAL_C_INVALID_HANDLE){}
   dl_semaphore_protection(const dl_semaphore_protection& other):_hSem(OSAL_C_INVALID_HANDLE){ if(this != &other){_hSem = other._hSem;} }
   dl_semaphore_protection&  operator=(const dl_semaphore_protection& other)
   { 
      if(this != &other){_hSem = other._hSem; }
      return *this;
   }

   OSAL_tSemHandle _hSem; 
};



#endif //_tclSemaphore_h_

//EOF

























