///////////////////////////////////////////////////////////////////////////////
//
// File: DABPlusDNLFsm.cpp
//
// Generated by SMC 4.4.0 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#include <string.h>

#ifndef __INCLUDED_DABPLUSDNLFSM__
#include "DABPlusDNLFsm.h"
#endif

namespace DABPlusDNLFsm
{

const unsigned int MAX_TRIGGER_EVENTS = 20;

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class Fsm;
class FsmSuperState;

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states.
//
///////////////////////////////////////////////////////////////////////////////

class FsmState
{
public:
   //! name of the FSM's state
   virtual const char* getStateName ( void ) const = 0;

   //! resetting state internals
   virtual void reset ( void ) {}

   // event functions 
   virtual void evChecksum ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDataTnfrCmd ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDownload ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evErase ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evFailure ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNormalMode ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRead ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReadFlash ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReadVersion ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSend ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evVerified ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evVerify ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evxLdrRead ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! default implementation for the Entry action
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! default implementation for the Exit action
   virtual void exit  ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! return the parent state
   virtual FsmSuperState* getParent ( void );


protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmState ( void );
   //! constructor for a substate of the given superstate
   FsmState ( FsmSuperState& parent );
   //! class destructor
   virtual ~FsmState ( void );

   //! pointer to the superstate
   FsmSuperState* mpParent;
};

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

class FsmSuperState
   : public FsmState
{
public:
   //! class constructor for a superstate without parent
   FsmSuperState ( FsmState& defState, bool histEnable=false );
   //! class constructor for a superstate with parent
   FsmSuperState ( FsmSuperState& parent, FsmState& defState, bool histEnable=false );

   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );
   //! default action
   virtual void defaultAction ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! resetting state internals
   virtual void reset ( void ) { _history = 0; }

   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );

private:
   //coverity fix for 47282
   FsmSuperState& operator = ( const FsmSuperState & );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmSuperState ( void );

   //! pointer to the default substate
   FsmState* _default;
   //! pointer to the history substate
   const FsmState* _history;
   //! flag that indicates if history is enabled or not
   bool _historyEnable;
};

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_CHECKSUM_STATEState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DLDAB_CHECKSUM_STATEState
   : public FsmState
{
public:
   //! default constructor
   DLDAB_CHECKSUM_STATEState ( void );

   DLDAB_CHECKSUM_STATEState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evNormalMode ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSend ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DLDAB_CHECKSUM_STATEState::mStateName = "DLDAB_CHECKSUM_STATE";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_DATA_TRANSFER_STATEState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DLDAB_DATA_TRANSFER_STATEState
   : public FsmState
{
public:
   //! default constructor
   DLDAB_DATA_TRANSFER_STATEState ( void );

   DLDAB_DATA_TRANSFER_STATEState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evChecksum ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSend ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DLDAB_DATA_TRANSFER_STATEState::mStateName = "DLDAB_DATA_TRANSFER_STATE";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_ERROR_STATEState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DLDAB_ERROR_STATEState
   : public FsmState
{
public:
   //! default constructor
   DLDAB_ERROR_STATEState ( void );

   DLDAB_ERROR_STATEState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evFailure ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSend ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DLDAB_ERROR_STATEState::mStateName = "DLDAB_ERROR_STATE";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_FAILURE_STATEState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DLDAB_FAILURE_STATEState
   : public FsmState
{
public:
   //! default constructor
   DLDAB_FAILURE_STATEState ( void );

   DLDAB_FAILURE_STATEState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DLDAB_FAILURE_STATEState::mStateName = "DLDAB_FAILURE_STATE";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_IDLE_STATEState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DLDAB_IDLE_STATEState
   : public FsmState
{
public:
   //! default constructor
   DLDAB_IDLE_STATEState ( void );

   DLDAB_IDLE_STATEState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evVerify ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DLDAB_IDLE_STATEState::mStateName = "DLDAB_IDLE_STATE";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_INITIALIZATION_STATEState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DLDAB_INITIALIZATION_STATEState
   : public FsmState
{
public:
   //! default constructor
   DLDAB_INITIALIZATION_STATEState ( void );

   DLDAB_INITIALIZATION_STATEState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evDownload ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DLDAB_INITIALIZATION_STATEState::mStateName = "DLDAB_INITIALIZATION_STATE";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_NORMAL_STATEState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DLDAB_NORMAL_STATEState
   : public FsmState
{
public:
   //! default constructor
   DLDAB_NORMAL_STATEState ( void );

   DLDAB_NORMAL_STATEState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DLDAB_NORMAL_STATEState::mStateName = "DLDAB_NORMAL_STATE";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_PROCESS_COMMANDS_STATEState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DLDAB_PROCESS_COMMANDS_STATEState
   : public FsmSuperState
{
public:
   //! default constructor
   DLDAB_PROCESS_COMMANDS_STATEState ( void );

   DLDAB_PROCESS_COMMANDS_STATEState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evFailure ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DLDAB_PROCESS_COMMANDS_STATEState::mStateName = "DLDAB_PROCESS_COMMANDS_STATE";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_READ_FROM_FLASH_STATEState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DLDAB_READ_FROM_FLASH_STATEState
   : public FsmState
{
public:
   //! default constructor
   DLDAB_READ_FROM_FLASH_STATEState ( void );

   DLDAB_READ_FROM_FLASH_STATEState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evNormalMode ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSend ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DLDAB_READ_FROM_FLASH_STATEState::mStateName = "DLDAB_READ_FROM_FLASH_STATE";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_READ_STATEState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DLDAB_READ_STATEState
   : public FsmState
{
public:
   //! default constructor
   DLDAB_READ_STATEState ( void );

   DLDAB_READ_STATEState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evFailure ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRead ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DLDAB_READ_STATEState::mStateName = "DLDAB_READ_STATE";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_READ_VERSION_STATEState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DLDAB_READ_VERSION_STATEState
   : public FsmState
{
public:
   //! default constructor
   DLDAB_READ_VERSION_STATEState ( void );

   DLDAB_READ_VERSION_STATEState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evNormalMode ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSend ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DLDAB_READ_VERSION_STATEState::mStateName = "DLDAB_READ_VERSION_STATE";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_READ_XLOADER_STATEState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DLDAB_READ_XLOADER_STATEState
   : public FsmState
{
public:
   //! default constructor
   DLDAB_READ_XLOADER_STATEState ( void );

   DLDAB_READ_XLOADER_STATEState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evErase ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSend ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DLDAB_READ_XLOADER_STATEState::mStateName = "DLDAB_READ_XLOADER_STATE";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_SECTORERASE_STATEState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DLDAB_SECTORERASE_STATEState
   : public FsmState
{
public:
   //! default constructor
   DLDAB_SECTORERASE_STATEState ( void );

   DLDAB_SECTORERASE_STATEState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evDataTnfrCmd ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSend ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DLDAB_SECTORERASE_STATEState::mStateName = "DLDAB_SECTORERASE_STATE";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_SPI_BOOTMODE_STATEState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DLDAB_SPI_BOOTMODE_STATEState
   : public FsmSuperState
{
public:
   //! default constructor
   DLDAB_SPI_BOOTMODE_STATEState ( void );

   DLDAB_SPI_BOOTMODE_STATEState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );

protected:
   static const char* mStateName;
};

const char* DLDAB_SPI_BOOTMODE_STATEState::mStateName = "DLDAB_SPI_BOOTMODE_STATE";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_VERIFY_STATEState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DLDAB_VERIFY_STATEState
   : public FsmState
{
public:
   //! default constructor
   DLDAB_VERIFY_STATEState ( void );

   DLDAB_VERIFY_STATEState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evVerified ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DLDAB_VERIFY_STATEState::mStateName = "DLDAB_VERIFY_STATE";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_WRITE_STATEState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DLDAB_WRITE_STATEState
   : public FsmState
{
public:
   //! default constructor
   DLDAB_WRITE_STATEState ( void );

   DLDAB_WRITE_STATEState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evFailure ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRead ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DLDAB_WRITE_STATEState::mStateName = "DLDAB_WRITE_STATE";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_XLoader_STATEState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DLDAB_XLoader_STATEState
   : public FsmState
{
public:
   //! default constructor
   DLDAB_XLoader_STATEState ( void );

   DLDAB_XLoader_STATEState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evReadFlash ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReadVersion ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSend ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evxLdrRead ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DLDAB_XLoader_STATEState::mStateName = "DLDAB_XLoader_STATE";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DNL_DAB_FIRMAREState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DNL_DAB_FIRMAREState
   : public FsmSuperState
{
public:
   //! default constructor
   DNL_DAB_FIRMAREState ( void );

   DNL_DAB_FIRMAREState ( FsmBody& b );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions

protected:
   static const char* mStateName;
};

const char* DNL_DAB_FIRMAREState::mStateName = "DNL_DAB_FIRMARE";

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBody
//
// This is the finite state machine's body class 'FsmBody'.
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody
{
    struct FsmDeferredEvent
    {
          FsmDeferredEvent() : mEvent(evUnknown), mArg(0) {}
          FsmEvent mEvent;
          void*    mArg;
    };

public:
    //! class constructor
    FsmBody ( void );

    //! connect the FSM body with its frontend
    void connect ( Fsm* frontend );

    //! initialize the FSM: set initial state and execute initial actions
    void init ( void );

    //! this method is used to stimulate the FSM with events
    void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the active state
    const char* getStateName ( void ) const;

    //! push trigger events to the event queue
    bool addEvent ( const FsmEvent& event, void* arg  );
    //! get event from the event queue
    bool getEvent ( FsmEvent& event, void** arg  );
    //! get event from the event queue
    bool isQueueEmpty ( void ) const;

    // set the FSM's internal state and propagate to default or history substate
    void setState ( FsmState& state, void* pArg );
    // set the FSM's internal state (no propagation
    void setState ( FsmState* pState );
    // return the active state object
    const FsmState* getState ( void ) const;

    //! static state objects
    DLDAB_CHECKSUM_STATEState oDLDAB_CHECKSUM_STATEState;
    DLDAB_DATA_TRANSFER_STATEState oDLDAB_DATA_TRANSFER_STATEState;
    DLDAB_ERROR_STATEState oDLDAB_ERROR_STATEState;
    DLDAB_FAILURE_STATEState oDLDAB_FAILURE_STATEState;
    DLDAB_IDLE_STATEState oDLDAB_IDLE_STATEState;
    DLDAB_INITIALIZATION_STATEState oDLDAB_INITIALIZATION_STATEState;
    DLDAB_NORMAL_STATEState oDLDAB_NORMAL_STATEState;
    DLDAB_PROCESS_COMMANDS_STATEState oDLDAB_PROCESS_COMMANDS_STATEState;
    DLDAB_READ_FROM_FLASH_STATEState oDLDAB_READ_FROM_FLASH_STATEState;
    DLDAB_READ_STATEState oDLDAB_READ_STATEState;
    DLDAB_READ_VERSION_STATEState oDLDAB_READ_VERSION_STATEState;
    DLDAB_READ_XLOADER_STATEState oDLDAB_READ_XLOADER_STATEState;
    DLDAB_SECTORERASE_STATEState oDLDAB_SECTORERASE_STATEState;
    DLDAB_SPI_BOOTMODE_STATEState oDLDAB_SPI_BOOTMODE_STATEState;
    DLDAB_VERIFY_STATEState oDLDAB_VERIFY_STATEState;
    DLDAB_WRITE_STATEState oDLDAB_WRITE_STATEState;
    DLDAB_XLoader_STATEState oDLDAB_XLoader_STATEState;
    DNL_DAB_FIRMAREState oDNL_DAB_FIRMAREState;

    //! frontend for this body
    Fsm* mpFrontend;
    //! link to the active state object
    FsmState* mpState;

    //! busy indicator flag
    bool mBusyFlag;

    //! queue of trigger events
    FsmEvent mEventQueue[MAX_TRIGGER_EVENTS];
    //! queue of arguments for trigger events
    void*    mParamQueue[MAX_TRIGGER_EVENTS];
    //! index of the queue's front element
    unsigned int mQueueHead;
    //! index of the queue's back element
    unsigned int mQueueTail;
    //! number of queued events
    unsigned int mQueueSize;
};

///////////////////////////////////////////////////////////////////////////////
//
// Default implementation for all events.
//
///////////////////////////////////////////////////////////////////////////////

void
FsmState::evChecksum ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evChecksum *** 
}

void
FsmState::evDataTnfrCmd ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDataTnfrCmd *** 
}

void
FsmState::evDownload ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDownload *** 
}

void
FsmState::evErase ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evErase *** 
}

void
FsmState::evError ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evError *** 
}

void
FsmState::evFailure ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evFailure *** 
}

void
FsmState::evNormalMode ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evNormalMode *** 
}

void
FsmState::evRead ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRead *** 
}

void
FsmState::evReadFlash ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evReadFlash *** 
}

void
FsmState::evReadVersion ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evReadVersion *** 
}

void
FsmState::evSend ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evSend *** 
}

void
FsmState::evSuccess ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evSuccess *** 
}

void
FsmState::evVerified ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evVerified *** 
}

void
FsmState::evVerify ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evVerify *** 
}

void
FsmState::evxLdrRead ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evxLdrRead *** 
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states components.
//
///////////////////////////////////////////////////////////////////////////////

FsmState::FsmState ( void )
   : mpParent(0)
{}

FsmState::FsmState ( FsmSuperState& parent )
   : mpParent(&parent)
{}

FsmState::~FsmState ( void )
{
   // make lint happy
   mpParent = 0;
}

void
FsmState::entry ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

void
FsmState::exit ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

const FsmState*
FsmState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.setState(this);
   entry(b,s,pArg);
   return this;
}

FsmSuperState*
FsmState::getParent ( void )
{
   return (mpParent) ? mpParent : 0;
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

FsmSuperState::FsmSuperState ( FsmState& defState, bool histEnable )
   : _default(&defState),
     _history(0),
     _historyEnable(histEnable)
{}

FsmSuperState::FsmSuperState ( FsmSuperState& parent, FsmState& defState, bool histEnable )
   : FsmState(parent),
     _default(&defState),
     _history(0),
     _historyEnable(histEnable)
{}

FsmSuperState::FsmSuperState ( void )
   : _default(0),
     _history(0),
     _historyEnable(false)
{}

const FsmState*
FsmSuperState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   const FsmState* pState = 0;

   // we have crossed a state boundary
   b.setState(this);
   // execute the entry actions for this superstate
   entry(b,s,pArg);
   
   if ( _history && _historyEnable )
   {
      pState = const_cast<FsmState*>(_history)->propagate(b,s,pArg);
   }
   else
   {
      defaultAction(b,s,pArg);
      if ( _default ) {
         pState = _default->propagate(b,s,pArg);
      }
   }
   
   return pState;
}

void
FsmSuperState::savepoint ( FsmBody& b )
{
   if ( _historyEnable )
   {
      _history = b.getState();
   }
}

void
FsmSuperState::defaultAction ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /*pArg*/ )
{
   //... empty as default ...
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_CHECKSUM_STATEState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DLDAB_CHECKSUM_STATEState::DLDAB_CHECKSUM_STATEState ( void )
{}

DLDAB_CHECKSUM_STATEState::DLDAB_CHECKSUM_STATEState ( FsmBody& b )
   : FsmState(b.oDLDAB_SPI_BOOTMODE_STATEState) 
{}

void
DLDAB_CHECKSUM_STATEState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.CreateChecksumCmd(pArg);
}

void
DLDAB_CHECKSUM_STATEState::evNormalMode ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.DnlFinished(pArg) )
   {
        b.setState(b.oDLDAB_NORMAL_STATEState,pArg);
    }
}

void
DLDAB_CHECKSUM_STATEState::evSend ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oDLDAB_SPI_BOOTMODE_STATEState.savepoint(b);

   b.setState(b.oDLDAB_PROCESS_COMMANDS_STATEState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_DATA_TRANSFER_STATEState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DLDAB_DATA_TRANSFER_STATEState::DLDAB_DATA_TRANSFER_STATEState ( void )
{}

DLDAB_DATA_TRANSFER_STATEState::DLDAB_DATA_TRANSFER_STATEState ( FsmBody& b )
   : FsmState(b.oDLDAB_SPI_BOOTMODE_STATEState) 
{}

void
DLDAB_DATA_TRANSFER_STATEState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.CreateDataMsgFrames(pArg);
}

void
DLDAB_DATA_TRANSFER_STATEState::evChecksum ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.DataSent(pArg) )
   {
        b.setState(b.oDLDAB_CHECKSUM_STATEState,pArg);
    }
}

void
DLDAB_DATA_TRANSFER_STATEState::evSend ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oDLDAB_SPI_BOOTMODE_STATEState.savepoint(b);

   b.setState(b.oDLDAB_PROCESS_COMMANDS_STATEState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_ERROR_STATEState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DLDAB_ERROR_STATEState::DLDAB_ERROR_STATEState ( void )
{}

DLDAB_ERROR_STATEState::DLDAB_ERROR_STATEState ( FsmBody& b )
   : FsmState(b.oDLDAB_PROCESS_COMMANDS_STATEState) 
{}

void
DLDAB_ERROR_STATEState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.HandleError(pArg);
}

void
DLDAB_ERROR_STATEState::evFailure ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oDLDAB_FAILURE_STATEState,pArg);
}

void
DLDAB_ERROR_STATEState::evSend ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oDLDAB_WRITE_STATEState,pArg);
}

void
DLDAB_ERROR_STATEState::evSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.ValidRsp(pArg) )
   {
        b.setState(b.oDLDAB_SPI_BOOTMODE_STATEState,pArg);
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_FAILURE_STATEState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DLDAB_FAILURE_STATEState::DLDAB_FAILURE_STATEState ( void )
{}

DLDAB_FAILURE_STATEState::DLDAB_FAILURE_STATEState ( FsmBody& b )
   : FsmState(b.oDNL_DAB_FIRMAREState) 
{}

void
DLDAB_FAILURE_STATEState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.ErrorReport(pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_IDLE_STATEState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DLDAB_IDLE_STATEState::DLDAB_IDLE_STATEState ( void )
{}

DLDAB_IDLE_STATEState::DLDAB_IDLE_STATEState ( FsmBody& b )
   : FsmState(b.oDLDAB_SPI_BOOTMODE_STATEState) 
{}

void
DLDAB_IDLE_STATEState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.ReadAck(pArg);
}

void
DLDAB_IDLE_STATEState::evVerify ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.SPIMode(pArg) )
   {
        b.setState(b.oDLDAB_VERIFY_STATEState,pArg);
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_INITIALIZATION_STATEState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DLDAB_INITIALIZATION_STATEState::DLDAB_INITIALIZATION_STATEState ( void )
{}

DLDAB_INITIALIZATION_STATEState::DLDAB_INITIALIZATION_STATEState ( FsmBody& b )
   : FsmState(b.oDNL_DAB_FIRMAREState) 
{}

void
DLDAB_INITIALIZATION_STATEState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.OpenPort(pArg);
}

void
DLDAB_INITIALIZATION_STATEState::evDownload ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.PortOpened(pArg) )
   {
        b.setState(b.oDLDAB_SPI_BOOTMODE_STATEState,pArg);
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_NORMAL_STATEState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DLDAB_NORMAL_STATEState::DLDAB_NORMAL_STATEState ( void )
{}

DLDAB_NORMAL_STATEState::DLDAB_NORMAL_STATEState ( FsmBody& b )
   : FsmState(b.oDLDAB_SPI_BOOTMODE_STATEState) 
{}

void
DLDAB_NORMAL_STATEState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.NotifyDNLFinished(pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_PROCESS_COMMANDS_STATEState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DLDAB_PROCESS_COMMANDS_STATEState::DLDAB_PROCESS_COMMANDS_STATEState ( void )
{}

DLDAB_PROCESS_COMMANDS_STATEState::DLDAB_PROCESS_COMMANDS_STATEState ( FsmBody& b )
   : FsmSuperState(b.oDNL_DAB_FIRMAREState, b.oDLDAB_WRITE_STATEState, false)
{}

void
DLDAB_PROCESS_COMMANDS_STATEState::evFailure ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oDLDAB_FAILURE_STATEState,pArg);
}

void
DLDAB_PROCESS_COMMANDS_STATEState::evSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.ValidRsp(pArg) )
   {
        b.setState(b.oDLDAB_SPI_BOOTMODE_STATEState,pArg);
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_READ_FROM_FLASH_STATEState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DLDAB_READ_FROM_FLASH_STATEState::DLDAB_READ_FROM_FLASH_STATEState ( void )
{}

DLDAB_READ_FROM_FLASH_STATEState::DLDAB_READ_FROM_FLASH_STATEState ( FsmBody& b )
   : FsmState(b.oDLDAB_SPI_BOOTMODE_STATEState) 
{}

void
DLDAB_READ_FROM_FLASH_STATEState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.CreateReadFlashCmd(pArg);
}

void
DLDAB_READ_FROM_FLASH_STATEState::evNormalMode ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oDLDAB_NORMAL_STATEState,pArg);
}

void
DLDAB_READ_FROM_FLASH_STATEState::evSend ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oDLDAB_SPI_BOOTMODE_STATEState.savepoint(b);

   b.setState(b.oDLDAB_PROCESS_COMMANDS_STATEState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_READ_STATEState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DLDAB_READ_STATEState::DLDAB_READ_STATEState ( void )
{}

DLDAB_READ_STATEState::DLDAB_READ_STATEState ( FsmBody& b )
   : FsmState(b.oDLDAB_PROCESS_COMMANDS_STATEState) 
{}

void
DLDAB_READ_STATEState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.ReadAck(pArg);
   s.VerifyRsp(pArg);
}

void
DLDAB_READ_STATEState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.ErrorResponse(pArg) )
   {
        b.setState(b.oDLDAB_ERROR_STATEState,pArg);
    }
}

void
DLDAB_READ_STATEState::evFailure ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oDLDAB_FAILURE_STATEState,pArg);
}

void
DLDAB_READ_STATEState::evRead ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oDLDAB_READ_STATEState,pArg);
}

void
DLDAB_READ_STATEState::evSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.ValidRsp(pArg) )
   {
        b.setState(b.oDLDAB_SPI_BOOTMODE_STATEState,pArg);
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_READ_VERSION_STATEState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DLDAB_READ_VERSION_STATEState::DLDAB_READ_VERSION_STATEState ( void )
{}

DLDAB_READ_VERSION_STATEState::DLDAB_READ_VERSION_STATEState ( FsmBody& b )
   : FsmState(b.oDLDAB_SPI_BOOTMODE_STATEState) 
{}

void
DLDAB_READ_VERSION_STATEState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.CreateReadVersionCmd(pArg);
}

void
DLDAB_READ_VERSION_STATEState::evNormalMode ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oDLDAB_NORMAL_STATEState,pArg);
}

void
DLDAB_READ_VERSION_STATEState::evSend ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oDLDAB_SPI_BOOTMODE_STATEState.savepoint(b);

   b.setState(b.oDLDAB_PROCESS_COMMANDS_STATEState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_READ_XLOADER_STATEState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DLDAB_READ_XLOADER_STATEState::DLDAB_READ_XLOADER_STATEState ( void )
{}

DLDAB_READ_XLOADER_STATEState::DLDAB_READ_XLOADER_STATEState ( FsmBody& b )
   : FsmState(b.oDLDAB_SPI_BOOTMODE_STATEState) 
{}

void
DLDAB_READ_XLOADER_STATEState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.CreateReadCmd(pArg);
}

void
DLDAB_READ_XLOADER_STATEState::evErase ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.xloaderRspSuccess(pArg) )
   {
        b.setState(b.oDLDAB_SECTORERASE_STATEState,pArg);
    }
}

void
DLDAB_READ_XLOADER_STATEState::evSend ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oDLDAB_SPI_BOOTMODE_STATEState.savepoint(b);

   b.setState(b.oDLDAB_PROCESS_COMMANDS_STATEState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_SECTORERASE_STATEState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DLDAB_SECTORERASE_STATEState::DLDAB_SECTORERASE_STATEState ( void )
{}

DLDAB_SECTORERASE_STATEState::DLDAB_SECTORERASE_STATEState ( FsmBody& b )
   : FsmState(b.oDLDAB_SPI_BOOTMODE_STATEState) 
{}

void
DLDAB_SECTORERASE_STATEState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.CreateMsgFrame(pArg);
}

void
DLDAB_SECTORERASE_STATEState::evDataTnfrCmd ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.EraseSuccess(pArg) )
   {
        b.setState(b.oDLDAB_DATA_TRANSFER_STATEState,pArg);
    }
}

void
DLDAB_SECTORERASE_STATEState::evSend ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oDLDAB_SPI_BOOTMODE_STATEState.savepoint(b);

   b.setState(b.oDLDAB_PROCESS_COMMANDS_STATEState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_SPI_BOOTMODE_STATEState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DLDAB_SPI_BOOTMODE_STATEState::DLDAB_SPI_BOOTMODE_STATEState ( void )
{}

DLDAB_SPI_BOOTMODE_STATEState::DLDAB_SPI_BOOTMODE_STATEState ( FsmBody& b )
   : FsmSuperState(b.oDNL_DAB_FIRMAREState, b.oDLDAB_IDLE_STATEState, true)
{}

void
DLDAB_SPI_BOOTMODE_STATEState::savepoint ( FsmBody& b )
{
   if ( _historyEnable )
   {
      _history = b.getState();
      while (  _history && (_history->getStateName() != b.oDLDAB_IDLE_STATEState.getStateName()) && (_history->getStateName() != b.oDLDAB_VERIFY_STATEState.getStateName()) && (_history->getStateName() != b.oDLDAB_XLoader_STATEState.getStateName()) && (_history->getStateName() != b.oDLDAB_READ_XLOADER_STATEState.getStateName()) && (_history->getStateName() != b.oDLDAB_READ_FROM_FLASH_STATEState.getStateName()) && (_history->getStateName() != b.oDLDAB_READ_VERSION_STATEState.getStateName()) && (_history->getStateName() != b.oDLDAB_SECTORERASE_STATEState.getStateName()) && (_history->getStateName() != b.oDLDAB_DATA_TRANSFER_STATEState.getStateName()) && (_history->getStateName() != b.oDLDAB_CHECKSUM_STATEState.getStateName()) && (_history->getStateName() != b.oDLDAB_NORMAL_STATEState.getStateName()) )
      {
         _history = const_cast<FsmState*>(_history)->getParent();
      }
   }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_VERIFY_STATEState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DLDAB_VERIFY_STATEState::DLDAB_VERIFY_STATEState ( void )
{}

DLDAB_VERIFY_STATEState::DLDAB_VERIFY_STATEState ( FsmBody& b )
   : FsmState(b.oDLDAB_SPI_BOOTMODE_STATEState) 
{}

void
DLDAB_VERIFY_STATEState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.VerifyData(pArg);
}

void
DLDAB_VERIFY_STATEState::evVerified ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.VerificationSucess(pArg) )
   {
        b.setState(b.oDLDAB_XLoader_STATEState,pArg);
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_WRITE_STATEState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DLDAB_WRITE_STATEState::DLDAB_WRITE_STATEState ( void )
{}

DLDAB_WRITE_STATEState::DLDAB_WRITE_STATEState ( FsmBody& b )
   : FsmState(b.oDLDAB_PROCESS_COMMANDS_STATEState) 
{}

void
DLDAB_WRITE_STATEState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.SendMsg(pArg);
}

void
DLDAB_WRITE_STATEState::evFailure ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oDLDAB_FAILURE_STATEState,pArg);
}

void
DLDAB_WRITE_STATEState::evRead ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.AckReceived(pArg) )
   {
        b.setState(b.oDLDAB_READ_STATEState,pArg);
    }
}

void
DLDAB_WRITE_STATEState::evSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.ValidRsp(pArg) )
   {
        b.setState(b.oDLDAB_SPI_BOOTMODE_STATEState,pArg);
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DLDAB_XLoader_STATEState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DLDAB_XLoader_STATEState::DLDAB_XLoader_STATEState ( void )
{}

DLDAB_XLoader_STATEState::DLDAB_XLoader_STATEState ( FsmBody& b )
   : FsmState(b.oDLDAB_SPI_BOOTMODE_STATEState) 
{}

void
DLDAB_XLoader_STATEState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.CreateMsgFrame(pArg);
}

void
DLDAB_XLoader_STATEState::evReadFlash ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oDLDAB_READ_FROM_FLASH_STATEState,pArg);
}

void
DLDAB_XLoader_STATEState::evReadVersion ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oDLDAB_READ_VERSION_STATEState,pArg);
}

void
DLDAB_XLoader_STATEState::evSend ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oDLDAB_SPI_BOOTMODE_STATEState.savepoint(b);

   b.setState(b.oDLDAB_PROCESS_COMMANDS_STATEState,pArg);
}

void
DLDAB_XLoader_STATEState::evxLdrRead ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.xloaderDnlSuccess(pArg) )
   {
        b.setState(b.oDLDAB_READ_XLOADER_STATEState,pArg);
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DNL_DAB_FIRMAREState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DNL_DAB_FIRMAREState::DNL_DAB_FIRMAREState ( void )
{}

DNL_DAB_FIRMAREState::DNL_DAB_FIRMAREState ( FsmBody& b )
   : FsmSuperState(b.oDLDAB_INITIALIZATION_STATEState, false)
{}

///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

Fsm::Fsm ( void )
    : mpBehaviour(0),
      mpBody(0)
{
}

Fsm::Fsm ( FsmBehaviour* server )
    : mpBehaviour(server),
      mpBody(0)
{
    mpBody = new FsmBody();
}

Fsm::~Fsm ( void )
{
    if ( mpBody )
    {
        delete mpBody;
        mpBody = 0;
    }
    mpBehaviour = 0;
}

void
Fsm::init ( void )
{
    
    if ( mpBody )
    {
        // connect the body with its frontend
        mpBody->connect(this);
        {
            mpBody->init();
        }
    }
}

const char*
Fsm::getStateName (void) const
{
    return ( mpBody ) ? mpBody->getStateName() : 0;
}

void 
Fsm::acceptEvent ( FsmEvent event, void* pArg )
{
    if ( mpBody )
    {
        // forward the event to the FSM body (handle-body pattern)
        mpBody->acceptEvent(event,pArg);
    }
}
///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

FsmBody::FsmBody ( void ) :
      oDLDAB_CHECKSUM_STATEState(*this),
      oDLDAB_DATA_TRANSFER_STATEState(*this),
      oDLDAB_ERROR_STATEState(*this),
      oDLDAB_FAILURE_STATEState(*this),
      oDLDAB_IDLE_STATEState(*this),
      oDLDAB_INITIALIZATION_STATEState(*this),
      oDLDAB_NORMAL_STATEState(*this),
      oDLDAB_PROCESS_COMMANDS_STATEState(*this),
      oDLDAB_READ_FROM_FLASH_STATEState(*this),
      oDLDAB_READ_STATEState(*this),
      oDLDAB_READ_VERSION_STATEState(*this),
      oDLDAB_READ_XLOADER_STATEState(*this),
      oDLDAB_SECTORERASE_STATEState(*this),
      oDLDAB_SPI_BOOTMODE_STATEState(*this),
      oDLDAB_VERIFY_STATEState(*this),
      oDLDAB_WRITE_STATEState(*this),
      oDLDAB_XLoader_STATEState(*this),
      oDNL_DAB_FIRMAREState(*this),
      mpFrontend(0),
      mpState(0),
      mBusyFlag(false),
      mQueueHead(0),
      mQueueTail(0),
      mQueueSize(0)
{
    (void) ::memset(mEventQueue,0,sizeof(FsmEvent)*MAX_TRIGGER_EVENTS);
    (void) ::memset(mParamQueue,0,sizeof(void*)*MAX_TRIGGER_EVENTS);
}

void
FsmBody::init ( void )
{
    oDLDAB_CHECKSUM_STATEState.reset();
    oDLDAB_DATA_TRANSFER_STATEState.reset();
    oDLDAB_ERROR_STATEState.reset();
    oDLDAB_FAILURE_STATEState.reset();
    oDLDAB_IDLE_STATEState.reset();
    oDLDAB_INITIALIZATION_STATEState.reset();
    oDLDAB_NORMAL_STATEState.reset();
    oDLDAB_PROCESS_COMMANDS_STATEState.reset();
    oDLDAB_READ_FROM_FLASH_STATEState.reset();
    oDLDAB_READ_STATEState.reset();
    oDLDAB_READ_VERSION_STATEState.reset();
    oDLDAB_READ_XLOADER_STATEState.reset();
    oDLDAB_SECTORERASE_STATEState.reset();
    oDLDAB_SPI_BOOTMODE_STATEState.reset();
    oDLDAB_VERIFY_STATEState.reset();
    oDLDAB_WRITE_STATEState.reset();
    oDLDAB_XLoader_STATEState.reset();
    oDNL_DAB_FIRMAREState.reset();

    setState(oDNL_DAB_FIRMAREState,0);
}

void
FsmBody::connect ( Fsm* frontend )
{
    mpFrontend = frontend;
}

const char*
FsmBody::getStateName ( void ) const
{
    return ( mpState ) ? mpState->getStateName() : 0;
}

bool
FsmBody::addEvent ( const FsmEvent& event, void* param )
{
    if ( mQueueSize < MAX_TRIGGER_EVENTS )
    {
        mQueueSize++;
        mEventQueue[mQueueTail] = event;
        mParamQueue[mQueueTail] = param;
        mQueueTail++;
        if ( mQueueTail == MAX_TRIGGER_EVENTS )
        {
            mQueueTail = 0;
        }
        return true;
    }
    return false;
}

bool
FsmBody::getEvent ( FsmEvent& event, void** param )
{
    if ( !mQueueSize || !param )
    {
        return false;
    }
    mQueueSize--;
    event  = mEventQueue[mQueueHead];
    *param = mParamQueue[mQueueHead];
    mQueueHead++;
    if ( mQueueHead == MAX_TRIGGER_EVENTS )
    {
        mQueueHead = 0;
    }
    return true;
}

bool
FsmBody::isQueueEmpty ( void ) const
{
    return ( mQueueSize ) ? false : true;
}

void 
FsmBody::acceptEvent ( FsmEvent event, void* pArg )
{
    (void) addEvent(event,pArg);

    if ( mBusyFlag )
    {
        return;
    }

    mBusyFlag = true;
    while ( !isQueueEmpty() )
    {
        FsmEvent nextEvent = evUnknown;
        void*    nextArg   = 0;
        if ( !getEvent(nextEvent,&nextArg) )
        {
            break;
        }

        switch (nextEvent)
        {
        case evChecksum:
            if ( mpState ) mpState->evChecksum(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evDataTnfrCmd:
            if ( mpState ) mpState->evDataTnfrCmd(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evDownload:
            if ( mpState ) mpState->evDownload(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evErase:
            if ( mpState ) mpState->evErase(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evError:
            if ( mpState ) mpState->evError(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evFailure:
            if ( mpState ) mpState->evFailure(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evNormalMode:
            if ( mpState ) mpState->evNormalMode(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRead:
            if ( mpState ) mpState->evRead(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evReadFlash:
            if ( mpState ) mpState->evReadFlash(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evReadVersion:
            if ( mpState ) mpState->evReadVersion(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evSend:
            if ( mpState ) mpState->evSend(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evSuccess:
            if ( mpState ) mpState->evSuccess(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evVerified:
            if ( mpState ) mpState->evVerified(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evVerify:
            if ( mpState ) mpState->evVerify(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evxLdrRead:
            if ( mpState ) mpState->evxLdrRead(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        default:
            //... unknown event ...
            break;
        } //lint !e788: not all items used within defaulted switch
    }
    mBusyFlag = false;
}

void 
FsmBody::setState ( FsmState& state, void* pArg )
{
    if ( mpFrontend )
    {
        mpState = const_cast<FsmState*>(state.propagate(*this,*(mpFrontend->mpBehaviour),pArg));
    }
}

void 
FsmBody::setState ( FsmState* pState )
{
    mpState = pState;
}

const FsmState*
FsmBody::getState ( void ) const
{
    return mpState;
}


} // namespace
