/*!
*******************************************************************************
* \file              SPIDatabaseMngr.h
* \brief             Abstract Class for the DatabaseMngrIntf
*******************************************************************************
\verbatim
PROJECT:         Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Interface class for Database in SPI.
The Database library used here is sqlite3.

COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                            | Modifications
Sep 15 2018|  Ram Chaithanya S A(RBEI/ECO2)     | Initial Version

\endverbatim
******************************************************************************/

#ifndef SPIDATABASESQLITE3_H_
#define SPIDATABASESQLITE3_H_

/******************************************************************************
| includes:
| 
|----------------------------------------------------------------------------*/
#if !(defined(_LINUXX86MAKE_) || defined(_LINUXX86_64_))
#include <sqlite3.h>
#endif
#include "SPIDatabaseMngrIntf.h"
/******************************************************************************
| defines and macros and constants(scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

class SPIDatabaseSQLite3:public SPIDatabaseMngrIntf
{
public:
 
   /***************************************************************************
   ** FUNCTION: SPIDatabaseSQLite3::SPIDatabaseSQLite3()
   ***************************************************************************/
   /*!
    * \fn      SPIDatabaseSQLite3()
    * \brief   Constructor
    * \sa      SPIDatabaseSQLite3()
    ***************************************************************************/

   SPIDatabaseSQLite3();

   /***************************************************************************
   ** FUNCTION: SPIDatabaseSQLite3::~SPIDatabaseSQLite3()
   ***************************************************************************/
   /*!
   * \fn      ~SPIDatabaseSQLite3()
   * \brief   Destructor
   * \sa      SPIDatabaseSQLite3()
   ***************************************************************************/
   ~SPIDatabaseSQLite3();

   /***************************************************************************
    ** FUNCTION: bInitialize();
    ***************************************************************************/
   /*!
    * \fn      bInitialize();
    * \brief   Wrapper Pure Virual Member function for initializing sqlite3
    **************************************************************************/

    t_Bool bInitialize();

   /***************************************************************************
    ** FUNCTION: bUninitialize();
    ***************************************************************************/
   /*!
    * \fn      bUninitialize();
    * \brief   Wrapper Pure Virual Member function for deinitializing sqlite3
    **************************************************************************/

    t_Bool bUnInitialize();

   /***************************************************************************
   ** FUNCTION: SPI_DB_open(const t_String &DatabasePath)
   ***************************************************************************/
   /*!
   * \fn      SPI_DB_open(const t_String &DatabasePath)
   * \brief   Wrapper Member function for sqlite3_open
   **************************************************************************/

   t_S32    SPI_DB_open(const t_String &DatabasePath);

   /***************************************************************************
    ** FUNCTION: SPI_DB_exec(t_String szQuery, char *ErrorMsg)
    ***************************************************************************/
   /*!
    * \fn      SPI_DB_exec(t_String szQuery, char *ErrorMsg)
    * \brief   Wrapper Member function for sqlite3_exec
    **************************************************************************/

   t_U32    SPI_DB_exec(t_String szQuery, char *ErrorMsg);

   /***************************************************************************
    ** FUNCTION: SPI_DB_free(t_Char *SQLString)
    ***************************************************************************/
   /*!
    * \fn      SPI_DB_free(t_Char *SQLString)
    * \brief   Wrapper Member function for sqlite3_free
    **************************************************************************/

    void     SPI_DB_free(t_Char *SQLString);

   /***************************************************************************
    ** FUNCTION: SPI_DB_mprintf(const t_String &SQLString)
    ***************************************************************************/
   /*!
    * \fn      SPI_DB_mprintf(const t_String &SQLString)
    * \brief   Wrapper Member function for sqlite3_free
    **************************************************************************/

    t_Char*  SPI_DB_mprintf(const char* SQLString,...);

   /***************************************************************************
    ** FUNCTION: SPI_DB_errmsg()
    ***************************************************************************/
   /*!
    * \fn      SPI_DB_errmsg()
    * \brief   Wrapper Member function for sqlite3_errmsg
    **************************************************************************/

    t_String SPI_DB_errmsg();

   /***************************************************************************
    ** FUNCTION: SPI_DB_close()
    ***************************************************************************/
   /*!
    * \fn       SPI_DB_close()
    * \brief    Wrapper Member function for sqlite3_close
    **************************************************************************/

    int SPI_DB_close();

   /***************************************************************************
    ** FUNCTION:  SPI_DB_prepare_v2(const char* Query,int nbyte)
    ***************************************************************************/
   /*!
    * \fn       SPI_DB_prepare_v2(const char* Query,int nbyte)
    * \brief    Wrapper Member function for sqlite3_prepare_v2
    **************************************************************************/

    int SPI_DB_prepare_v2(const char* Query,int nbyte);

   /***************************************************************************
    ** FUNCTION: SPI_DB_step() 
    ***************************************************************************/
   /*!
    * \fn      SPI_DB_step()
    * \brief   Wrapper Member function for sqlite3_step
    **************************************************************************/

   int SPI_DB_step();

   /***************************************************************************
    ** FUNCTION:  SPI_DB_column_int(int icol)
    ***************************************************************************/
   /*!
    * \fn       SPI_DB_column_int(int icol)
    * \brief   Wrapper Member function for sqlite3_column_int
    **************************************************************************/

   t_U32 SPI_DB_column_int(int icol);

   /***************************************************************************
    ** FUNCTION:  SPI_DB_finalize()
    ***************************************************************************/
   /*!
    * \fn      SPI_DB_finalize()
    * \brief   Wrapper Member function for sqlite3_finalize
    **************************************************************************/

   int SPI_DB_finalize();

   /***************************************************************************
    ** FUNCTION: SPI_DB_bind_int(t_U8 scou8FirstParameter, t_U32 u32Key) 
    ***************************************************************************/
   /*!
    * \fn      SPI_DB_bind_int(t_U8 scou8FirstParameter, t_U32 u32Key) 
    * \brief   Wrapper Member function for sqlite3_bind_int
    **************************************************************************/

   int SPI_DB_bind_int(t_U8 scou8FirstParameter, t_U32 u32Key);

   /***************************************************************************
    ** FUNCTION:  SPI_DB_bind_blob(int n,const void* info,int count)
    ***************************************************************************/
   /*!
    * \fn      SPI_DB_bind_blob(int n,const void* info,int count)  
    * \brief   Wrapper Member function for sqlite3_bind_blob
    **************************************************************************/

   int SPI_DB_bind_blob(int n,const void* info,int count);

   /***************************************************************************
    ** FUNCTION: SPI_DB_column_text(t_U8 icol)
    ***************************************************************************/
   /*!
    * \fn      SPI_DB_column_text(t_U8 icol)
    * \brief   Wrapper Member function for sqlite3_column_text
    **************************************************************************/

   const unsigned char*  SPI_DB_column_text(t_U8 icol);

   /***************************************************************************
    ** FUNCTION:  SPI_DB_column_blob(int icol)
    ***************************************************************************/
   /*!
    * \fn      SPI_DB_column_blob(int icol)
    * \brief   Wrapper Member function for sqlite3_column_blob
    **************************************************************************/

   const void*  SPI_DB_column_blob(int icol);

private:
#if !(defined(_LINUXX86MAKE_) || defined(_LINUXX86_64_))
     //! Sqlite database handler
     sqlite3 *m_SQLitedb;
     // Sqlite Statment handler
     sqlite3_stmt *m_poStatement;
#endif
};

#endif // SPIDATABASESQLITE3_H_
