/*!
 *******************************************************************************
 * \file              RespBase.h
 * \brief             Base class from which all responses classes are derived
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:  Smart Phone Integration
 DESCRIPTION:   Base class which provides madndatory registration ID for the
 components to register. All the response classes derive from this
 base class and the tenRegID is supplied during creation of the derived
 response class object
 COPYRIGHT:     &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 29.08.2013 |  Pruthvi Thej Nagaraju       | Initial Version
 26.02.2016 |  Rachana L Achar             | Added navigation element in tenRegID enum
 26.02.2016 |  Rachana L Achar             | Added notification element in tenRegID enum

 \endverbatim
 ******************************************************************************/

#ifndef RESPBASE_H_
#define RESPBASE_H_

/******************************************************************************
 | includes:
 | 1)RealVNC sdk - includes
 | 2)Typedefines
 |----------------------------------------------------------------------------*/
#include "BaseTypes.h"

/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/
typedef enum
{
   e16VNCDISCOVERER_REGID = 1,
   e16DAP_REGID  = 2,
   e16VIEWER_REGID  = 3,
   e16AUDIO_REGID  = 4,
   e16CRCB_REGID  =5,
   e16NOTIFICATIONS_REGID  = 6,
   e16CDB_REGID  = 7,
   e16AAP_AUDIO_REGID = 8,
   e16AAP_BT_REGID  = 9,
   e16_DISCOVERER_REGID  = 10,
   e16AAP_INPUT_REGID  = 11,
   e16AAP_SENSOR_REGID  = 12,
   e16AAP_SESSION_REGID  = 13,
   e16AAP_VIDEO_REGID  = 14,
   e16AAP_MEDIAPLAYBACK_REGID = 15,
   e16AAP_NAVIGATION = 16,
   e16AAP_NOTIFICATION = 17,
   e16MYSPIN_VIDEO_REGID = 18,
   e16MYSPIN_SESSION_REGID = 19,
   e16AOAP_DISC_REGID = 20,
   e16MYSPIN_AUDIO_REGID = 21,
   e16EXT_POSITION_REGID = 22,
   e16EXT_SENSOR_REGID = 23,
   e16EXT_WIFI_REGID = 24,
   e16EXT_APPLEDISCOVERER_REGID = 25,
   e16EXT_ROLESWITCH_REGID =26,
   e16EXT_METADATA_REGID=27,
   e16EXT_NAVDATA_REGID=28,
   e16EXT_NATIVETRANSPORT_REGID=29,
   e16EXT_BLUETOOTH_REGID=30,
   e16DIPO_DISCOVERER_REGID = 31,
   e16BDCL_AUDIO_REGID = 32,
   e16BDCL_BLUETOOTH_REGID = 33,
   e16BDCL_CARDATA_REGID = 34,
   e16BDCL_INPUT_REGID = 35,
   e16BDCL_MEDIADATA_REGID = 36,
   e16BDCL_SESSION_REGID = 37,
   e16BDCL_VIDEO_REGID = 38,
   e16DIPO_VIDEO_REGID = 39,
   e16DIPO_SESSION_REGID = 40,
   e16DIPO_AUDIO_REGID = 41,
   e16DIPO_RSRCMNGR_REGID = 42,
   e16DIPO_INPUT_REGID = 43,
   e16DIPO_BLUETOOTH_REGID = 44,
   e16BDCL_NAVIGATION_REGID = 45,
   e16EXT_NAVDATA_GPRMCDATASTATUS_REGID = 46,
   e16EXT_OOBT_REGID = 47,
   E16CDB_MEDIADATA_REGID = 48,
   E16CDB_NAVIDATA_REGID = 49,
   e16EXT_TELEPHONE_REGID = 50,
   e16AAP_VENDOREXTSN_REGID = 51,
   e16EXT_MEDIADEVINFO_REGID = 52,
   e16ONCAR_VIDEO_REGID = 53,
   e16ONCAR_SESSION_REGID = 54,
   e16ONCAR_BLUETOOTH_REGID = 55,
   e16ONCAR_INPUT_REGID = 56,
   e16ONCAR_AUDIO_REGID = 57,
   e16ONCAR_METADATA_REGID = 58,
   e16EXT_CLOCK_REGID = 59
}tenRegID;

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/*!
 * \class RespBase
 * \brief Base class which provides madndatory registration ID for the
 *             components to register. All the response classes derive from this
 *              base class and the tenRegID is supplied during creation of the derived
 *               response class object
 */

class RespBase
{
   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  RespBase::RespBase(tenRegID eRegID)
       ***************************************************************************/
      /*!
       * \fn      RespBase(tenRegID eRegID)
       * \brief   Paramaterized constructor
       * \param   enRegID : provides the ID to be identify the type of response
       **************************************************************************/
      RespBase(tenRegID enRegID);

      /***************************************************************************
       ** FUNCTION:  RespBase::~RespBase()
       ***************************************************************************/
      /*!
       * \fn      ~RespBase()
       * \brief   Destructor
       **************************************************************************/
      virtual ~RespBase();

      /***************************************************************************
       ** FUNCTION:  tenRegID enGetRegID()
       ***************************************************************************/
      /*!
       * \fn      tenRegID enGetRegID()
       * \brief   returns the registration ID of the calling object
       **************************************************************************/
      tenRegID enGetRegID()const;
   private:
      /*
       * \brief stores the registration ID of the calling object
       */
      tenRegID m_enRegID;
};

#endif /* RESPBASE_H_ */
