/*!
*******************************************************************************
* \file              HIDUtils.h
* \brief             Utils class Hid Descriptors
*******************************************************************************
\verbatim
PROJECT:        G3G
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    HID Utils class for Hid Descriptors
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                      | Modifications
May 30,2019|  ptr4kor                     | Initial Version

\endverbatim
******************************************************************************/
#ifndef HIDUTILS_H_
#define HIDUTILS_H_

#include "BaseTypes.h"
#include <vector>

static const t_U8 scou8HID_USAGE          = 0x09;
static const t_U8 scou8HID_USAGE_TWOBYTE  = 0x0A;

/****************************************************************************/
/*!
* \class HIDUtils
* \brief HIDUtils class
*
* HIDUtils class is helper class to build HID decriptors
****************************************************************************/

class HIDUtils
{
public:
  /***************************************************************************
   *********************************PUBLIC************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  HIDUtils::HIDUtils()
   ***************************************************************************/
   /*!
   * \fn     HIDUtils()
   * \brief  Constructor
   * \sa     ~HIDUtils()
   **************************************************************************/
   HIDUtils();

  /***************************************************************************
   ** FUNCTION:  HIDUtils::~HIDUtils()
   ***************************************************************************/
   /*!
   * \fn     ~HIDUtils()
   * \brief  Destructor
   * \sa     HIDUtils()
   **************************************************************************/
   ~HIDUtils();


   /***************************************************************************
   ** FUNCTION: t_Void HIDUtils::vAddUsage()
   ***************************************************************************/
   /*!
   * \fn    t_Void vAddUsage(const t_U8 cou8Usage)
   * \brief  method to Add Usage
   * \param  cou8Usage    : [IN] Usage Value.
   * \retval t_Void
   **************************************************************************/
   t_Void vAddUsage(const t_U8 cou8Usage);

   /***************************************************************************
   ** FUNCTION: t_Void HIDUtils::vAddUsage()
   ***************************************************************************/
   /*!
   * \fn    t_Void vAddUsage(const std::vector<t_U8>& corfrvecu8Usage)
   * \brief  method to Add Usage
   * \param  corfrvecu8Usage    : [IN] Usage Value.
   * \retval t_Void
   **************************************************************************/
   t_Void vAddUsage(const std::vector<t_U8>& corfrvecu8Usage);


   /***************************************************************************
   ** FUNCTION: t_Void HIDUtils::vAddUsagePage()
   ***************************************************************************/
   /*!
   * \fn    t_Void vAddUsagePage(const t_U8 cou8UsagePage)
   * \brief  method to Add Usage Page
   * \param  cou8UsagePage    : [IN] Usage Page Value.
   * \retval t_Void
   **************************************************************************/
   t_Void vAddUsagePage(const t_U8 cou8UsagePage);

   /***************************************************************************
   ** FUNCTION: t_Void HIDUtils::vStartCollection()
   ***************************************************************************/
   /*!
   * \fn    t_Void vStartCollection(const t_U8 cou8StartCollection)
   * \brief  method to setcollection
   * \param  cou8StartCollection    : [IN] Collection Value
   * \retval t_Void
   **************************************************************************/
   t_Void vStartCollection(const t_U8 cou8StartCollection);

   /***************************************************************************
   ** FUNCTION: t_Void HIDUtils::vAddLogicalMinMax()
   ***************************************************************************/
   /*!
   * \fn    t_Void vAddLogicalMinMax(const t_U8 cou8Min,const t_U8 cou8Max)
   * \brief  method to Add Logical Min Max
   * \param  cou8Min    : [IN] Logical Min Value
   * \param  cou8Max    : [IN] Logical Max Value
   * \retval t_Void
   **************************************************************************/
   t_Void vAddLogicalMinMax(const t_U8 cou8Min, const t_U8 cou8Max);

   /***************************************************************************
   ** FUNCTION: t_Void HIDUtils::vAddReportSize()
   ***************************************************************************/
   /*!
   * \fn    t_Void vAddReportSize(const t_U8 cou8ReportSize)
   * \brief  method to Add ReportSize
   * \param  cou8ReportSize    : [IN] Report Size Value
   * \retval t_Void
   **************************************************************************/
   t_Void vAddReportSize(const t_U8 cou8ReportSize);

   /***************************************************************************
   ** FUNCTION: t_Void HIDUtils::vAddReportCount()
   ***************************************************************************/
   /*!
   * \fn    t_Void vAddReportCount(const t_U8 cou8ReportCount)
   * \brief  method to Add Report Count
   * \param  cou8ReportCount    : [IN] Report Count
   * \retval t_Void
   **************************************************************************/
   t_Void vAddReportCount(const t_U8 cou8ReportCount);

   /***************************************************************************
   ** FUNCTION: t_Void HIDUtils::vAddInput()
   ***************************************************************************/
   /*!
   * \fn    t_Void vAddInput(const t_U8 cou8Input)
   * \brief  method to Add Input
   * \param  cou8Input    : [IN] Input Value
   * \retval t_Void
   **************************************************************************/
   t_Void vAddInput(const t_U8 cou8Input);

   /***************************************************************************
   ** FUNCTION: t_Void HIDUtils::vEndCollection()
   ***************************************************************************/
   /*!
   * \fn    t_Void vEndCollection()
   * \brief  method to Add Collection.
   * \retval t_Void
   **************************************************************************/
   t_Void vEndCollection();

   /***************************************************************************
   ** FUNCTION: t_Void HIDUtils::vGetHidDescriptor()
   ***************************************************************************/
   /*!
   * \fn    t_Void vAddUsage(std::vector<t_U8> &rfrVecu8HIDDescriptor)
   * \brief  method to Populate the Hid Information vector
   * \param  rfrvecu8HIDDescriptor : [OUT] vector with Hid Information
   * \retval t_Void
   **************************************************************************/
   t_Void vGetHIDDescriptor(std::vector<t_U8> &rfrvecu8HIDDescriptor);

   /***************************************************************************
   **************************END OF PUBLIC************************************
   ***************************************************************************/

private:
   std::vector<t_U8> m_vecu8HIDDescriptor;

   /***************************************************************************
   ***************************PRIVATE*****************************************
   ***************************************************************************/

   /***************************************************************************
   **************************END OF PRIVATE************************************
   ***************************************************************************/
};


#endif

