//! Taken from AHL label : DI_COMMONBASE_14.0V05
/*!
 *******************************************************************************
 * \file             crc.cpp
 * \brief            check sum calculation utility
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    calculates checksum from a data stream the 32-bit CRC sum.
 The calculation is performed using a 32-bit Table which is split into
 16-bit high part and low part
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 01.02.2014 |  Pruthvi Thej Nagaraju       | Initial Version

 \endverbatim
 ******************************************************************************/

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include <stdlib.h>
#include "crc.h"

#define INIT_VALUE      0xFFFFFFFFL;
#define XOROUT          0xFFFFFFFFL;

static const uint32_t cou32InitialReminder = 0x0000;
static const uint32_t cou32FinalXorValue = 0x0000;
static const uint8_t cou8NoofBits = 8;
static const uint32_t cou32DataWidth = (cou8NoofBits * sizeof(uint16_t));

//! \brief 16bit crc lookup table
static uint16_t crc16Table[] = { 0x0000, 0x8005, 0x800f, 0x000a, 0x801b, 0x001e, 0x0014, 0x8011,
         0x8033, 0x0036, 0x003c, 0x8039, 0x0028, 0x802d, 0x8027, 0x0022, 0x8063, 0x0066, 0x006c,
         0x8069, 0x0078, 0x807d, 0x8077, 0x0072, 0x0050, 0x8055, 0x805f, 0x005a, 0x804b, 0x004e,
         0x0044, 0x8041, 0x80c3, 0x00c6, 0x00cc, 0x80c9, 0x00d8, 0x80dd, 0x80d7, 0x00d2, 0x00f0,
         0x80f5, 0x80ff, 0x00fa, 0x80eb, 0x00ee, 0x00e4, 0x80e1, 0x00a0, 0x80a5, 0x80af, 0x00aa,
         0x80bb, 0x00be, 0x00b4, 0x80b1, 0x8093, 0x0096, 0x009c, 0x8099, 0x0088, 0x808d, 0x8087,
         0x0082, 0x8183, 0x0186, 0x018c, 0x8189, 0x0198, 0x819d, 0x8197, 0x0192, 0x01b0, 0x81b5,
         0x81bf, 0x01ba, 0x81ab, 0x01ae, 0x01a4, 0x81a1, 0x01e0, 0x81e5, 0x81ef, 0x01ea, 0x81fb,
         0x01fe, 0x01f4, 0x81f1, 0x81d3, 0x01d6, 0x01dc, 0x81d9, 0x01c8, 0x81cd, 0x81c7, 0x01c2,
         0x0140, 0x8145, 0x814f, 0x014a, 0x815b, 0x015e, 0x0154, 0x8151, 0x8173, 0x0176, 0x017c,
         0x8179, 0x0168, 0x816d, 0x8167, 0x0162, 0x8123, 0x0126, 0x012c, 0x8129, 0x0138, 0x813d,
         0x8137, 0x0132, 0x0110, 0x8115, 0x811f, 0x011a, 0x810b, 0x010e, 0x0104, 0x8101, 0x8303,
         0x0306, 0x030c, 0x8309, 0x0318, 0x831d, 0x8317, 0x0312, 0x0330, 0x8335, 0x833f, 0x033a,
         0x832b, 0x032e, 0x0324, 0x8321, 0x0360, 0x8365, 0x836f, 0x036a, 0x837b, 0x037e, 0x0374,
         0x8371, 0x8353, 0x0356, 0x035c, 0x8359, 0x0348, 0x834d, 0x8347, 0x0342, 0x03c0, 0x83c5,
         0x83cf, 0x03ca, 0x83db, 0x03de, 0x03d4, 0x83d1, 0x83f3, 0x03f6, 0x03fc, 0x83f9, 0x03e8,
         0x83ed, 0x83e7, 0x03e2, 0x83a3, 0x03a6, 0x03ac, 0x83a9, 0x03b8, 0x83bd, 0x83b7, 0x03b2,
         0x0390, 0x8395, 0x839f, 0x039a, 0x838b, 0x038e, 0x0384, 0x8381, 0x0280, 0x8285, 0x828f,
         0x028a, 0x829b, 0x029e, 0x0294, 0x8291, 0x82b3, 0x02b6, 0x02bc, 0x82b9, 0x02a8, 0x82ad,
         0x82a7, 0x02a2, 0x82e3, 0x02e6, 0x02ec, 0x82e9, 0x02f8, 0x82fd, 0x82f7, 0x02f2, 0x02d0,
         0x82d5, 0x82df, 0x02da, 0x82cb, 0x02ce, 0x02c4, 0x82c1, 0x8243, 0x0246, 0x024c, 0x8249,
         0x0258, 0x825d, 0x8257, 0x0252, 0x0270, 0x8275, 0x827f, 0x027a, 0x826b, 0x026e, 0x0264,
         0x8261, 0x0220, 0x8225, 0x822f, 0x022a, 0x823b, 0x023e, 0x0234, 0x8231, 0x8213, 0x0216,
         0x021c, 0x8219, 0x0208, 0x820d, 0x8207, 0x0202 };
/*!
 * \brief
 * CRC 32 bit LOOKUP TABLE
 * ================
 * The following CRC lookup table was generated automatically
 * by the Rocksoft^tm Model CRC Algorithm Table Generation
 * Program V1.0 using the following model parameters:
 *
 *    Width   : 2 bytes.
 *    Poly    : 0x04C11DB7L
 *    Reverse : TRUE.
 *
 * The table was when generating in high-and low-order byte
 * Split.
 *
 */

uint16_t gaCrcTable_High[256] = { 0x0000, 0x7707, 0xEE0E, 0x9909, 0x076D,
         0x706A, 0xE963, 0x9E64, 0x0EDB, 0x79DC, 0xE0D5, 0x97D2, 0x09B6, 0x7EB1,
         0xE7B8, 0x90BF, 0x1DB7, 0x6AB0, 0xF3B9, 0x84BE, 0x1ADA, 0x6DDD, 0xF4D4,
         0x83D3, 0x136C, 0x646B, 0xFD62, 0x8A65, 0x1401, 0x6306, 0xFA0F, 0x8D08,
         0x3B6E, 0x4C69, 0xD560, 0xA267, 0x3C03, 0x4B04, 0xD20D, 0xA50A, 0x35B5,
         0x42B2, 0xDBBB, 0xACBC, 0x32D8, 0x45DF, 0xDCD6, 0xABD1, 0x26D9, 0x51DE,
         0xC8D7, 0xBFD0, 0x21B4, 0x56B3, 0xCFBA, 0xB8BD, 0x2802, 0x5F05, 0xC60C,
         0xB10B, 0x2F6F, 0x5868, 0xC161, 0xB666, 0x76DC, 0x01DB, 0x98D2, 0xEFD5,
         0x71B1, 0x06B6, 0x9FBF, 0xE8B8, 0x7807, 0x0F00, 0x9609, 0xE10E, 0x7F6A,
         0x086D, 0x9164, 0xE663, 0x6B6B, 0x1C6C, 0x8565, 0xF262, 0x6C06, 0x1B01,
         0x8208, 0xF50F, 0x65B0, 0x12B7, 0x8BBE, 0xFCB9, 0x62DD, 0x15DA, 0x8CD3,
         0xFBD4, 0x4DB2, 0x3AB5, 0xA3BC, 0xD4BB, 0x4ADF, 0x3DD8, 0xA4D1, 0xD3D6,
         0x4369, 0x346E, 0xAD67, 0xDA60, 0x4404, 0x3303, 0xAA0A, 0xDD0D, 0x5005,
         0x2702, 0xBE0B, 0xC90C, 0x5768, 0x206F, 0xB966, 0xCE61, 0x5EDE, 0x29D9,
         0xB0D0, 0xC7D7, 0x59B3, 0x2EB4, 0xB7BD, 0xC0BA, 0xEDB8, 0x9ABF, 0x03B6,
         0x74B1, 0xEAD5, 0x9DD2, 0x04DB, 0x73DC, 0xE363, 0x9464, 0x0D6D, 0x7A6A,
         0xE40E, 0x9309, 0x0A00, 0x7D07, 0xF00F, 0x8708, 0x1E01, 0x6906, 0xF762,
         0x8065, 0x196C, 0x6E6B, 0xFED4, 0x89D3, 0x10DA, 0x67DD, 0xF9B9, 0x8EBE,
         0x17B7, 0x60B0, 0xD6D6, 0xA1D1, 0x38D8, 0x4FDF, 0xD1BB, 0xA6BC, 0x3FB5,
         0x48B2, 0xD80D, 0xAF0A, 0x3603, 0x4104, 0xDF60, 0xA867, 0x316E, 0x4669,
         0xCB61, 0xBC66, 0x256F, 0x5268, 0xCC0C, 0xBB0B, 0x2202, 0x5505, 0xC5BA,
         0xB2BD, 0x2BB4, 0x5CB3, 0xC2D7, 0xB5D0, 0x2CD9, 0x5BDE, 0x9B64, 0xEC63,
         0x756A, 0x026D, 0x9C09, 0xEB0E, 0x7207, 0x0500, 0x95BF, 0xE2B8, 0x7BB1,
         0x0CB6, 0x92D2, 0xE5D5, 0x7CDC, 0x0BDB, 0x86D3, 0xF1D4, 0x68DD, 0x1FDA,
         0x81BE, 0xF6B9, 0x6FB0, 0x18B7, 0x8808, 0xFF0F, 0x6606, 0x1101, 0x8F65,
         0xF862, 0x616B, 0x166C, 0xA00A, 0xD70D, 0x4E04, 0x3903, 0xA767, 0xD060,
         0x4969, 0x3E6E, 0xAED1, 0xD9D6, 0x40DF, 0x37D8, 0xA9BC, 0xDEBB, 0x47B2,
         0x30B5, 0xBDBD, 0xCABA, 0x53B3, 0x24B4, 0xBAD0, 0xCDD7, 0x54DE, 0x23D9,
         0xB366, 0xC461, 0x5D68, 0x2A6F, 0xB40B, 0xC30C, 0x5A05, 0x2D02 };

uint16_t gaCrcTable_Low[256] = { 0x0000, 0x3096, 0x612C, 0x51BA, 0xC419, 0xF48F,
         0xA535, 0x95A3, 0x8832, 0xB8A4, 0xE91E, 0xD988, 0x4C2B, 0x7CBD, 0x2D07,
         0x1D91, 0x1064, 0x20F2, 0x7148, 0x41DE, 0xD47D, 0xE4EB, 0xB551, 0x85C7,
         0x9856, 0xA8C0, 0xF97A, 0xC9EC, 0x5C4F, 0x6CD9, 0x3D63, 0x0DF5, 0x20C8,
         0x105E, 0x41E4, 0x7172, 0xE4D1, 0xD447, 0x85FD, 0xB56B, 0xA8FA, 0x986C,
         0xC9D6, 0xF940, 0x6CE3, 0x5C75, 0x0DCF, 0x3D59, 0x30AC, 0x003A, 0x5180,
         0x6116, 0xF4B5, 0xC423, 0x9599, 0xA50F, 0xB89E, 0x8808, 0xD9B2, 0xE924,
         0x7C87, 0x4C11, 0x1DAB, 0x2D3D, 0x4190, 0x7106, 0x20BC, 0x102A, 0x8589,
         0xB51F, 0xE4A5, 0xD433, 0xC9A2, 0xF934, 0xA88E, 0x9818, 0x0DBB, 0x3D2D,
         0x6C97, 0x5C01, 0x51F4, 0x6162, 0x30D8, 0x004E, 0x95ED, 0xA57B, 0xF4C1,
         0xC457, 0xD9C6, 0xE950, 0xB8EA, 0x887C, 0x1DDF, 0x2D49, 0x7CF3, 0x4C65,
         0x6158, 0x51CE, 0x0074, 0x30E2, 0xA541, 0x95D7, 0xC46D, 0xF4FB, 0xE96A,
         0xD9FC, 0x8846, 0xB8D0, 0x2D73, 0x1DE5, 0x4C5F, 0x7CC9, 0x713C, 0x41AA,
         0x1010, 0x2086, 0xB525, 0x85B3, 0xD409, 0xE49F, 0xF90E, 0xC998, 0x9822,
         0xA8B4, 0x3D17, 0x0D81, 0x5C3B, 0x6CAD, 0x8320, 0xB3B6, 0xE20C, 0xD29A,
         0x4739, 0x77AF, 0x2615, 0x1683, 0x0B12, 0x3B84, 0x6A3E, 0x5AA8, 0xCF0B,
         0xFF9D, 0xAE27, 0x9EB1, 0x9344, 0xA3D2, 0xF268, 0xC2FE, 0x575D, 0x67CB,
         0x3671, 0x06E7, 0x1B76, 0x2BE0, 0x7A5A, 0x4ACC, 0xDF6F, 0xEFF9, 0xBE43,
         0x8ED5, 0xA3E8, 0x937E, 0xC2C4, 0xF252, 0x67F1, 0x5767, 0x06DD, 0x364B,
         0x2BDA, 0x1B4C, 0x4AF6, 0x7A60, 0xEFC3, 0xDF55, 0x8EEF, 0xBE79, 0xB38C,
         0x831A, 0xD2A0, 0xE236, 0x7795, 0x4703, 0x16B9, 0x262F, 0x3BBE, 0x0B28,
         0x5A92, 0x6A04, 0xFFA7, 0xCF31, 0x9E8B, 0xAE1D, 0xC2B0, 0xF226, 0xA39C,
         0x930A, 0x06A9, 0x363F, 0x6785, 0x5713, 0x4A82, 0x7A14, 0x2BAE, 0x1B38,
         0x8E9B, 0xBE0D, 0xEFB7, 0xDF21, 0xD2D4, 0xE242, 0xB3F8, 0x836E, 0x16CD,
         0x265B, 0x77E1, 0x4777, 0x5AE6, 0x6A70, 0x3BCA, 0x0B5C, 0x9EFF, 0xAE69,
         0xFFD3, 0xCF45, 0xE278, 0xD2EE, 0x8354, 0xB3C2, 0x2661, 0x16F7, 0x474D,
         0x77DB, 0x6A4A, 0x5ADC, 0x0B66, 0x3BF0, 0xAE53, 0x9EC5, 0xCF7F, 0xFFE9,
         0xF21C, 0xC28A, 0x9330, 0xA3A6, 0x3605, 0x0693, 0x5729, 0x67BF, 0x7A2E,
         0x4AB8, 0x1B02, 0x2B94, 0xBE37, 0x8EA1, 0xDF1B, 0xEF8D };
/****************************************************************************/
/*                   End of CRC Lookup Table                                */
/****************************************************************************/

/***************************************************************************
 ** FUNCTION:  u32CalcCRC32
 ***************************************************************************/

uint32_t u32CalcCRC32(const unsigned char* pczBlk_Adr, uint32_t u32Blk_Len)
{
   uint16_t u16CrcHigh = 0;
   uint16_t u16CrcLow = 0;
   uint32_t u32TableOffset = 0;
   uint32_t u32Crc32 = INIT_VALUE;

   while (u32Blk_Len--)
   {
      /* Calculate table offset*/

      if (NULL != pczBlk_Adr)
      {
         u32TableOffset = (u32Crc32 ^ *pczBlk_Adr) & 0xFFL;

         u16CrcHigh = gaCrcTable_High[u32TableOffset];
         u16CrcLow = gaCrcTable_Low[u32TableOffset];

         /* Calculate the 32-bit CRC*/
         u32Crc32 = ((u16CrcHigh << 16) + u16CrcLow) ^ (u32Crc32 >> 8);

         /* increment the adddress*/
         pczBlk_Adr++;
      }//End of if (NULL != pczBlk_Adr)
   }//End of while (u32Blk_Len--)

   /* CRC has yet to be XORed*/
   u32Crc32 ^= XOROUT;
   return u32Crc32;
}

/***************************************************************************
** FUNCTION:  u16Reflect
***************************************************************************/
static uint32_t u16Reflect(uint16_t u16Data, uint8_t u8SizeofData)
{
   uint16_t  u16Reflection = 0x0000;
   uint8_t  u8Bit = 0;

   /*
    * Reflect the u16Data about the center bit.
    */
   for (u8Bit = 0; u8Bit < u8SizeofData; ++u8Bit)
   {
      /*
       * If the LSB bit is set, set the Reflection of it.
       */
      if (u16Data & 0x01)
      {
         u16Reflection = static_cast<uint16_t>(u16Reflection | (1 << ((u8SizeofData - 1) - u8Bit)));
      }/*if (u16Data & 0x01)*/

      u16Data = static_cast<uint16_t>((u16Data >> 1));
   }/*for (u8Bit = 0; u8Bit < u8SizeofData; ++u8Bit)*/

   return (u16Reflection);

}  /* reflect() */

/***************************************************************************
** FUNCTION:  u16CalcCRC16
***************************************************************************/
uint16_t u16CalcCRC16(const unsigned char* pczMessage, uint64_t u32MsgSize)
{
   uint16_t u16Remainder = cou32InitialReminder;
   uint8_t u8Data = 0;
   uint32_t u32ByteCount = 0;
   uint16_t u16CRCResult = 0;
   /*
    * Divide the message by the polynomial, a byte at a time.
    */
   if (NULL != pczMessage)
   {
      for (u32ByteCount = 0; u32ByteCount < u32MsgSize; ++u32ByteCount)
      {
         u8Data = static_cast<uint8_t>(u16Reflect((pczMessage[u32ByteCount]), cou8NoofBits)
               ^ (u16Remainder >> (cou32DataWidth - cou8NoofBits)));
         u16Remainder = static_cast<uint16_t>(crc16Table[u8Data] ^ (u16Remainder << cou8NoofBits));
      }
   /*
    * The final remainder is the CRC.
    */
   u16CRCResult = static_cast<uint16_t>((u16Reflect((u16Remainder), cou32DataWidth)
         ^ cou32FinalXorValue));
   }
   return u16CRCResult;
} /* u16CalcCRC16() */
