/***********************************************************************/
/*!
* \file  spi_tclDynamicConfiguration.h
* \brief  Implementation of the Class spi_tclDynamicConfiguration
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Dynamic Configuration for SPI
AUTHOR:         kmo6kor
COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
07.06.2018  | kmo6kor               | Initial Version
23.08.2018  | BDU6KOR               | added the functions which use datapool object from ConfigReader.cpp
\endverbatim
*************************************************************************/


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/


/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/
/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/
#include "spi_tclDynamicConfiguration.h"

static const t_U16 scou16Width_8Inch = 800;
static const t_U16 scou16Height_8Inch = 480;
static const t_U16 scou16Width_8InchMM = 156;
static const t_U16 scou16Height_8InchMM = 82;
static const t_U16 scou16LayerId = 6500;
static const t_U16 scou16SurfaceId = 201;
static const t_U16 scou16TouchLayerId = 6600;
static const t_U16 scou16TouchSurfaceId = 202;
static const t_U16 scou16mySPINWidth_8Inch = 1055;
static const t_U16 scou16mySPINHeight_8Inch = 720;

static const t_String sczPixelAspectRatio = "1.14";

#define SEVEN_TWENTY 720
#define DPI_FOUR_EIGHTY 160
#define DPI_SEVEN_TWENTY 240
#define DPI_TEN_EIGHTY 360

// Includes all header files for FI of datapool
#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#endif

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_CONFIGREADER
#include "trcGenProj/Header/spi_tclDynamicConfiguration.cpp.trc.h"
#endif
#endif

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclDynamicConfiguration::spi_tclDynamicConfiguration(...)
 ***************************************************************************/
spi_tclDynamicConfiguration::spi_tclDynamicConfiguration(spi_tclDynamicConfigurationReaderBase* poDynamicConfigurationReader):
spi_tclDynamicConfigurationBase(poDynamicConfigurationReader)
{
   ETG_TRACE_USR1(("spi_tclDynamicConfiguration::spi_tclDynamicConfiguration Entered"));
   vReadScreenConfigs();
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclDynamicConfiguration::~spi_tclDynamicConfiguration(...)
 ***************************************************************************/
spi_tclDynamicConfiguration::~spi_tclDynamicConfiguration()
{
   ETG_TRACE_USR1(("spi_tclDynamicConfiguration::~spi_tclDynamicConfiguration Entered"));
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDynamicConfiguration::vSetVehicleManufacturerInformation()
***************************************************************************/
t_Void spi_tclDynamicConfiguration::vSetVehicleManufacturerInformation(const trVehicleManufacturerInformation& corfrVehicleManufacturerInfoAttr)
{
   ETG_TRACE_USR1(("spi_tclDynamicConfiguration::vSetVehicleManufacturerInformation() entered"));

   m_oLock.s16Lock();
   //Set the Vehicle Manufacturer Information in data pool, if there is any change in the current values
   if(m_rVehicleManufacturerInformation != corfrVehicleManufacturerInfoAttr)
   {
      if((NULL != m_poDynamicConfigurationReader) && (true != m_poDynamicConfigurationReader->bWriteVehicleManufacturerInformation(corfrVehicleManufacturerInfoAttr)))
      {
         ETG_TRACE_ERR(("spi_tclDynamicConfiguration::vSetVehicleManufacturerInformation: Error in setting values in datapool"));
      }//if(true != m_poDynamicConfigurationReader).

      //Update the member variables of this class, to use in current power cycle.
      m_rVehicleManufacturerInformation = corfrVehicleManufacturerInfoAttr;
   }//if(m_rVehicleManufacturerInformation != corfrVehicleManufacturerInfoAttr)
   m_oLock.vUnlock();

     //on populating the member variable
     ETG_TRACE_USR4(("Vehicle Make = %s",m_rVehicleManufacturerInformation.szVehicleMake.c_str()));
     ETG_TRACE_USR4(("Vehicle Model = %s",m_rVehicleManufacturerInformation.szVehicleModel.c_str()));
     ETG_TRACE_USR4(("Vehicle Model Year = %s",m_rVehicleManufacturerInformation.szVehicleModelYear.c_str()));
     ETG_TRACE_USR4(("Vehicle HU Software Version = %s",m_rVehicleManufacturerInformation.szVehicleHUSwVersion.c_str()));
     ETG_TRACE_USR4(("Vehicle HU Hardware Version = %s",m_rVehicleManufacturerInformation.szVehicleHUHwVersion.c_str()));
     ETG_TRACE_USR4(("Vehicle HU Make = %s",m_rVehicleManufacturerInformation.szVehicleHUMake.c_str()));
     ETG_TRACE_USR4(("Vehicle HU Model = %s",m_rVehicleManufacturerInformation.szVehicleHUModel.c_str()));
     ETG_TRACE_USR4(("Vehicle HU Software Build = %s",m_rVehicleManufacturerInformation.szVehicleHUSwBuild.c_str()));

     ETG_TRACE_USR4(("DriverSide Information = %u",ETG_ENUM(DRIVER_SIDE_INFO,m_rVehicleManufacturerInformation.enDriverSideInfo)));
     ETG_TRACE_USR4(("Vehicle SupportedSPITechnologies Information  = %d",m_rVehicleManufacturerInformation.u16SupportedSPITechnologiesInfo));
     ETG_TRACE_USR1(("Native Navigation Supported= %d ",ETG_ENUM(BOOL, m_rVehicleManufacturerInformation.bIsNativeNavSupported)));
     ETG_TRACE_USR1(("Rotary Control Supported= %d ",ETG_ENUM(BOOL, m_rVehicleManufacturerInformation.bIsRotaryCtrlSupported)));
     ETG_TRACE_USR4(("Vehicle OEM Name is = %s",m_rVehicleManufacturerInformation.rOEMIconDetails.szOEMName.c_str()));
     ETG_TRACE_USR4(("Vehicle OEM Path is = %s",m_rVehicleManufacturerInformation.rOEMIconDetails.szOEMPath.c_str()));

}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDynamicConfiguration::vSetDriveSideInfoToDatapool()
***************************************************************************/
t_Void spi_tclDynamicConfiguration::vSetDriveSideInfoToDatapool(tenDriveSideInfo enDriveSideInfo)
{
   ETG_TRACE_USR1(("spi_tclDynamicConfiguration::vSetDriveSideInfoToDatapool() entered "));
   if(NULL != m_poDynamicConfigurationReader)
   {
      m_poDynamicConfigurationReader->bWriteDriveSideInfo(enDriveSideInfo);
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDynamicConfiguration::vReadScreenConfigs()
***************************************************************************/
t_Void spi_tclDynamicConfiguration::vReadScreenConfigs()
{
   ETG_TRACE_USR1(("spi_tclDynamicConfiguration::vReadScreenConfigs"));

   trDisplayAttributes rDispAttr;
   t_Bool bResult = false;

   if(NULL != m_poDynamicConfigurationReader)
   {
      bResult = m_poDynamicConfigurationReader->bReadScreenAttributes(rDispAttr);
   }

   if((true == bResult)&&(0 != rDispAttr.u16ScreenWidth))
   {
      m_oLock.s16Lock();
      //Read is successful and there are valid values in Data pool
      m_rDisplayAttributes = rDispAttr ;
      m_oLock.vUnlock();
   }//if(true != oDatapool.bReadScreenAttributes(rDispAttr))
   else
   {
      vSetDefaultDisplayAttributes();
   }//else

}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDynamicConfiguration::vSetDisplayAttributes()
***************************************************************************/
t_Void spi_tclDynamicConfiguration::vSetDefaultDisplayAttributes()
{
        ETG_TRACE_USR1(("spi_tclDynamicConfiguration::vSetDisplayAttributes entered"));

      m_oLock.s16Lock();
      //There are no values/Invalid values in Datapool, populate with the default values
      //(currently populated with default values).
      m_rDisplayAttributes.u16ScreenWidth = scou16Width_8Inch;
      m_rDisplayAttributes.u16ScreenHeight = scou16Height_8Inch;
      m_rDisplayAttributes.u16ScreenWidthMm = scou16Width_8InchMM;
      m_rDisplayAttributes.u16ScreenHeightMm = scou16Height_8InchMM;
      m_rDisplayAttributes.enDisplayType = e8CAPACITIVE_SCREEN;

      trDisplayLayerAttributes rMLDispLayerAttr;
      rMLDispLayerAttr.enDevCat = e8DEV_TYPE_MIRRORLINK;
      rMLDispLayerAttr.u16TouchLayerID = scou16LayerId;
      rMLDispLayerAttr.u16TouchSurfaceID = scou16SurfaceId;
      rMLDispLayerAttr.enTouchEventType = e8MULTI_TOUCH;
      m_rDisplayAttributes.vecDisplayLayerAttr.push_back(rMLDispLayerAttr);

      trDisplayLayerAttributes rDiPoDispLayerAttr;
      rDiPoDispLayerAttr.enDevCat = e8DEV_TYPE_DIPO;
      rDiPoDispLayerAttr.u16TouchLayerID = scou16TouchLayerId;
      rDiPoDispLayerAttr.u16TouchSurfaceID = scou16TouchSurfaceId;
      rDiPoDispLayerAttr.enTouchEventType = e8MULTI_TOUCH;
      m_rDisplayAttributes.vecDisplayLayerAttr.push_back(rDiPoDispLayerAttr);

      trDisplayLayerAttributes rAAPDispLayerAttr;
      rAAPDispLayerAttr.enDevCat = e8DEV_TYPE_ANDROIDAUTO;
      rAAPDispLayerAttr.u16TouchLayerID = scou16TouchLayerId;
      rAAPDispLayerAttr.u16TouchSurfaceID = scou16TouchSurfaceId;
      rAAPDispLayerAttr.enTouchEventType = e8MULTI_TOUCH;
      m_rDisplayAttributes.vecDisplayLayerAttr.push_back(rAAPDispLayerAttr);

      trDisplayLayerAttributes rBDCLDispLayerAttr;
      rBDCLDispLayerAttr.enDevCat = e8DEV_TYPE_CARLIFE;
      rBDCLDispLayerAttr.u16TouchLayerID = scou16LayerId;
      rBDCLDispLayerAttr.u16TouchSurfaceID = scou16SurfaceId;
      rBDCLDispLayerAttr.enTouchEventType = e8MULTI_TOUCH;
      m_rDisplayAttributes.vecDisplayLayerAttr.push_back(rBDCLDispLayerAttr);

      trDisplayLayerAttributes rMySpinDispLayerAttr;
      rMySpinDispLayerAttr.enDevCat = e8DEV_TYPE_MYSPIN;
      rMySpinDispLayerAttr.u16TouchLayerID = scou16TouchLayerId;
      rMySpinDispLayerAttr.u16TouchSurfaceID = scou16TouchSurfaceId;
      rMySpinDispLayerAttr.enTouchEventType = e8MULTI_TOUCH;
      m_rDisplayAttributes.vecDisplayLayerAttr.push_back(rMySpinDispLayerAttr);

      for(t_U8 u8Index=0;u8Index<m_rDisplayAttributes.vecDisplayLayerAttr.size();u8Index++)
      {
         m_rDisplayAttributes.vecDisplayLayerAttr[u8Index].u16VideoLayerID = scou16LayerId;
         m_rDisplayAttributes.vecDisplayLayerAttr[u8Index].u16VideoSurfaceID = scou16SurfaceId;
         m_rDisplayAttributes.vecDisplayLayerAttr[u8Index].u16LayerWidth = m_rDisplayAttributes.u16ScreenWidth;
         m_rDisplayAttributes.vecDisplayLayerAttr[u8Index].u16LayerHeight = m_rDisplayAttributes.u16ScreenHeight;
         m_rDisplayAttributes.vecDisplayLayerAttr[u8Index].u16DisplayWidthMm = m_rDisplayAttributes.u16ScreenWidthMm;
         m_rDisplayAttributes.vecDisplayLayerAttr[u8Index].u16DisplayHeightMm = m_rDisplayAttributes.u16ScreenHeightMm;
        m_rDisplayAttributes.vecDisplayLayerAttr[u8Index].szPixelAspectRatio = sczPixelAspectRatio;
        m_rDisplayAttributes.vecDisplayLayerAttr[u8Index].u16dpi = DPI_FOUR_EIGHTY;
      }//for(t_U8 u8Index=0;u8Index<m_rDisplayAttributes.v

      m_oLock.vUnlock();

}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDynamicConfiguration::vGetPixelAspectRatio()
***************************************************************************/
t_Void spi_tclDynamicConfiguration::vGetPixelAspectRatio(t_String& rfszPixelAspectRatio)
{
   ETG_TRACE_USR1(("spi_tclDynamicConfiguration::vGetPixelAspectRatio() entered "));
   rfszPixelAspectRatio = sczPixelAspectRatio;
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDynamicConfiguration::bReadVehicleManufacturerInfofromDatapool()
***************************************************************************/
 t_Bool spi_tclDynamicConfiguration::bReadVehicleManufacturerInfofromDatapool(trVehicleManufacturerInformation& rfrVehicleManufacturerInformation)
{
   ETG_TRACE_USR1(("spi_tclDynamicConfiguration::bReadVehicleManufacturerInfofromDatapool() entered"));

//   t_Bool bResult = false;
//   if(NULL != m_poDynamicConfigurationReader)
//   {
//      bResult = m_poDynamicConfigurationReader->bReadVehicleManufacturerInformation(rfrVehicleManufacturerInformation);
//   }
//   return bResult;

   ETG_TRACE_USR4(("spi_tclDynamicConfiguration::bReadVehicleManufacturerInfofromDatapool() left"));
   return false;
}

 /***************************************************************************
 ** FUNCTION:  t_String spi_tclDynamicConfiguration::szGetSoftwareVersion()
 ***************************************************************************/
 t_String spi_tclDynamicConfiguration::szGetSoftwareVersion() const
 {
    ETG_TRACE_USR1(("spi_tclDynamicConfiguration::szGetSoftwareVersion entered"));

    t_String szSwVersion;
    if(NULL != m_poDynamicConfigurationReader)
    {
       szSwVersion = m_poDynamicConfigurationReader->szGetSoftwareVersion();
    }
    return szSwVersion;
 }
