/***********************************************************************/
/*!
* \file  spi_tclSensorPVDataClientHandler.h
* \brief SENSOR PV Service Class
*************************************************************************
\verbatim

PROJECT        :   Gen3
SW-COMPONENT   :   Smart Phone Integration
DESCRIPTION    :
AUTHOR         :   SHITANSHU SHEKHAR (RBEI/ECO2:HSK5KOR)
COPYRIGHT      :   &copy; RBEI

HISTORY:
Date        | Author                         | Modification
28.12.2016  | SHITANSHU SHEKHAR (RBEI/ECO2)  | Initial Version

\endverbatim
*************************************************************************/

#ifndef _SPI_TCL_CLIENTHANDLER_SENSORPVDATA_H_
#define _SPI_TCL_CLIENTHANDLER_SENSORPVDATA_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

#include "SPITypes.h"
#include "Lock.h"
/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/
//Bit field type describing the validity of elements in dead reckoning information.

enum tenDeadreckoning_Info_Validity
{
   //drTimestamp is valid.
   e8TimestampIsValid = 0x00000001,

   // drLatitude and drLongitude are valid.
   e8PositionIsValid = 0x00000002,

   //drHeading is valid.
   e8HeadingIsValid = 0x00000004,

   //drSpeed is valid.
   e8SpeedIsValid = 0x00000008,

   //drAltitude is valid.
   e8AltitudeIsValid = 0x00000010,

   //drTurnrateX is valid.
   e8TurnrateXIsValid = 0x00000020,

   //drTurnrateY is valid.
   e8TurnrateYIsValid = 0x00000040,

   //drTurnrateZ is valid.
   e8TurnrateZIsValid = 0x00000080,

   //drAccelerationX is valid.
   e8AccelerationXIsValid = 0x00000100,

   //drAccelerationY is valid.
   e8AccelerationYIsValid = 0x00000200,

   //drAccelerationZ is valid.
   e8AccelerationZIsValid = 0x00000400
};

/* Forward declarations */
/**
 * \brief   SENSOR_PV_FI Client handler class
 */
class spi_tclSensorPVDataClientHandler
   : public ahl_tclBaseOneThreadClientHandler
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclSensorPVDataClientHandler::spi_tclSensorPVDataClientHandler(..)
   ***************************************************************************/
   /*!
   * \fn     spi_tclSensorPVDataClientHandler(ahl_tclBaseOneThreadApp* poMainApp)
   * \brief  Parametrized Constructor
   * \param  poMainApp : [IN] Pointer to main app.
   * \sa
   **************************************************************************/
   spi_tclSensorPVDataClientHandler(ahl_tclBaseOneThreadApp* poMainApp);

   /***************************************************************************
   ** FUNCTION:  virtual spi_tclSensorPVDataClientHandler::~spi_tclSensorPVDataClientHandler()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclSensorPVDataClientHandler()
   * \brief   Destructor
   * \sa
   **************************************************************************/
   virtual ~spi_tclSensorPVDataClientHandler();

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclSensorPVDataClientHandler::vOnServiceAvailable()
   ***************************************************************************/
   /*!
   * \fn      vOnServiceAvailable()
   * \brief   This function is called by the framework if the service of our server
   *         becomes available, e.g. server has been started.
   * \sa
   **************************************************************************/
   virtual t_Void vOnServiceAvailable();

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclSensorPVDataClientHandler::vOnServiceUnavailable()
   ***************************************************************************/
   /*!
   * \fn      vOnServiceUnavailable()
   * \brief   This function is called by the framework if the service of our server
   *         becomes unavailable, e.g. server has been shut down.
   * \sa
   **************************************************************************/
   virtual t_Void vOnServiceUnavailable();

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclSensorPVDataClientHandler::vRegisterForProperties()
   **************************************************************************/
   /*!
   * \fn      vRegisterForProperties()
   * \brief   Registers for interested properties to the client handler.
   * \param   enDataType: [IN] Indicates type of data being subscribed
   **************************************************************************/
   virtual t_Void vRegisterForProperties(tenSensorDataType enDataType);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclSensorPVDataClientHandler::vUnregisterForProperties()
   **************************************************************************/
   /*!
   * \fn      vUnregisterForProperties()
   * \brief   Registers for interested properties to the client handler.
   * \param   enDataType: [IN] Indicates type of data being un-subscribed
   **************************************************************************/
   virtual t_Void vUnregisterForProperties(tenSensorDataType enDataType);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclSensorPVDataClientHandler::vOnDeadreckoningStatus()
   ***************************************************************************/
   /*!
   * \fn      vOnDeadreckoningStatus(amt_tclServiceData* poMessage)
   * \brief   This Property represents the calculated dead reckoning
   *          position of the device including quality values.
   * \param   poMessage: [IN] Pointer to DeadreckoningStatus message
   * \sa
   **************************************************************************/
   t_Void vOnDeadreckoningStatus(amt_tclServiceData* poMessage);

   /***************************************************************************
     ** FUNCTION:  t_Void spi_tclSensorPVDataClientHandler::vRegisterCallbacks()
     ***************************************************************************/
     /*!
     * \fn      vOnDeadreckoningStatus(amt_tclServiceData* poMessage)
     * \brief   Interface to register for lOcation data callbacks.
     * \param   trLocationDataCallbacks: [IN] Call Back Structure
     * \sa
     **************************************************************************/
   t_Void vRegisterCallbacks(trLocationDataCallbacks rLocDataCallbacks);

   /***************************************************************************
    * Message map definition macro
    ***************************************************************************/
   DECLARE_MSG_MAP(spi_tclSensorPVDataClientHandler)

   /*************************************************************************
   ****************************END OF PUBLIC*********************************
   *************************************************************************/

private:
   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclSensorPVDataClientHandler::spi_tclSensorPVDataClientHandler()
   ***************************************************************************/
   /*!
   * \fn     spi_tclSensorPVDataClientHandler()
   * \brief  Default Constructor, will not be implemented.
   **************************************************************************/
   spi_tclSensorPVDataClientHandler();

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class
   * 'spi_tclSensorPVDataClientHandler' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   spi_tclSensorPVDataClientHandler& operator=(const spi_tclSensorPVDataClientHandler &oClientHandler);

   /***************************************************************************************************************
   ** FUNCTION:   spi_tclSensorDataClientHandler::vSendAutoRegisterPropertyRequest
   ***************************************************************************************************************/   /*!
   * \fn     vSendAutoRegisterPropertyRequest()
   * \brief  Send loppback message to entry thread for property registration
   **************************************************************************/
   t_Void vSendAutoRegisterPropertyRequest(t_U16 u16FunctionID);

   /***************************************************************************************************************
   ** FUNCTION:   spi_tclSensorDataClientHandler::vSendAutoRegisterPropertyRequest
   ***************************************************************************************************************/   /*!
   * \fn     vSendAutoUnregisterPropertyRequest()
   * \brief  Send loppback message to entry thread for property unregistration
   **************************************************************************/
   t_Void vSendAutoUnregisterPropertyRequest(t_U16 u16FunctionID);

   /*************************************************************************
    ****************************END OF PRIVATE********************************
    *************************************************************************/


   /***************************************************************************
   *! Data members
   ***************************************************************************/

   /*
    * Main application pointer
    */
   ahl_tclBaseOneThreadApp*   m_poMainApp;
   /*
    * Structure containing callbacks to SENSOR_PV_FI data subscriber.
    */
   trLocationDataCallbacks    m_rLocDataCallbacks;
   /*
    * Lock used to protect simultaneous access of std::function
    */
   Lock m_lock;
};
#endif  // spi_tclSensorPVDataClientHandler
