/*!
*******************************************************************************
* \file              spi_tclSPMClient.h
* \brief             SPM Client handler class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    SPM Client handler class
COPYRIGHT:      &copy; RBEI

HISTORY:
 Date       |  Author                           | Modifications
 15.11.2014 |  Hari Priya E R (RBEI/ECP2)       | Initial Version

\endverbatim
******************************************************************************/

/******************************************************************************
| includes:
|----------------------------------------------------------------------------*/
#include "spi_tclSPMClient.h"
#include "spi_LoopbackTypes.h"
//For message dispatcher
#include "FIMsgDispatch.h"
using namespace shl::msgHandler;

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#include "Trace.h"
#ifdef TARGET_BUILD
   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_TCLSERVICE
      #include "trcGenProj/Header/spi_tclSPMClient.cpp.trc.h"
   #endif
#endif

/******************************************************************************
| defines and macros and constants(scope: module-local)
|----------------------------------------------------------------------------*/
#define SPM_FI_MAJOR_VERSION  SPM_COREFI_C_U16_SERVICE_MAJORVERSION 
#define SPM_FI_MINOR_VERSION  SPM_COREFI_C_U16_SERVICE_MINORVERSION 


/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
typedef spm_corefi_tclMsgSubStatesSet spm_tFiSubStatesSet;

/******************************************************************************
| defines and macros and constants(scope: module-local)
|----------------------------------------------------------------------------*/
#define SPM_SUBSTATE_PHONE_CALL   (spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_PHONE)
#define SPM_SUBSTATE_TEMP         (spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_SPI_PHONE)
#define SPM_SUBSTATE_PERM         (spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_PUSH_TO_TALK)

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

// +++ MESSAGE MAP: enter the function IDs (FID) and the corresponding functions here.
//      the function will be called when a message with the corresponding FID arrives +++
BEGIN_MSG_MAP(spi_tclSPMClient, ahl_tclBaseWork)
ON_MESSAGE_SVCDATA( SPM_COREFI_C_U16_SPISTATE,AMT_C_U8_CCAMSG_OPCODE_STATUS,vHandleSpiState)
END_MSG_MAP()


/***************************************************************************
*********************************PUBLIC*************************************
***************************************************************************/

/***************************************************************************
** FUNCTION:  spi_tclSPMClient::spi_tclSPMClient(spi_tclBluetoothPolicyBase...
**************************************************************************/
spi_tclSPMClient::spi_tclSPMClient(ahl_tclBaseOneThreadApp* poMainAppl)
     : ahl_tclBaseOneThreadClientHandler(
         poMainAppl,                           /* Application Pointer */
         CCA_C_U16_SRV_SPM,                         /* ID of used Service */
         SPM_FI_MAJOR_VERSION,           /* MajorVersion of used Service */
         SPM_FI_MINOR_VERSION),          /* MinorVersion of used Service */
       m_poMainAppl(poMainAppl)
{
   NORMAL_M_ASSERT(nullptr != m_poMainAppl);
}//! end of spi_tclSPMClient()

/***************************************************************************
** FUNCTION:  virtual spi_tclSPMClient::~spi_tclSPMClient...
**************************************************************************/
spi_tclSPMClient::~spi_tclSPMClient()
{
   ETG_TRACE_USR1(("~spi_tclSPMClient() entered "));

   m_poMainAppl = nullptr;
}//! end of spi_tclSPMClient()

/***************************************************************************
** FUNCTION:  spi_tclSPMClient::vOnServiceAvailable()
**************************************************************************/
tVoid spi_tclSPMClient::vOnServiceAvailable()
{
   ETG_TRACE_USR1(("spi_tclSPMClient::vOnServiceAvailable() entered "));
   vRegisterForProperties();
}//! end of vOnServiceAvailable()

/***************************************************************************
** FUNCTION:  spi_tclSPMClient::vOnServiceUnavailable()
**************************************************************************/
tVoid spi_tclSPMClient::vOnServiceUnavailable()
{
   ETG_TRACE_USR1(("spi_tclSPMClient::vOnServiceUnavailable() entered "));
}//! end of vOnServiceUnavailable()

/***************************************************************************
** FUNCTION:  t_Void spi_tclSPMClient::vRegisterForProperties()
**************************************************************************/
t_Void spi_tclSPMClient::vRegisterForProperties()
{
   ETG_TRACE_USR1(("spi_tclSPMClient::vRegisterForProperties() entered "));

#ifdef VARIANT_S_FTR_ENABLE_SPM_HANDLE_SPI_STATE
   vAddAutoRegisterForProperty(SPM_COREFI_C_U16_SPISTATE);
#endif
   ETG_TRACE_USR1(("spi_tclSPMClient::vRegisterForProperties() left "));
   //! Register for interested properties
}//! end of vRegisterForProperties()

/***************************************************************************
** FUNCTION:  t_Void spi_tclSPMClient::vUnregisterForProperties()
**************************************************************************/
t_Void spi_tclSPMClient::vUnregisterForProperties()
{
   ETG_TRACE_USR1(("spi_tclSPMClient::vUnregisterForProperties() entered "));
   #ifdef VARIANT_S_FTR_ENABLE_SPM_HANDLE_SPI_STATE
      vRemoveAutoRegisterForProperty(SPM_COREFI_C_U16_SPISTATE);
   #endif
   //! Unregister subscribed properties
}//! end of vUnregisterForProperties()


/***************************************************************************
** FUNCTION: t_Void spi_tclSPMClient::vSendSpmPhoneSubState(...)
**************************************************************************/
t_Void  spi_tclSPMClient::vSendSpmPhoneSubState(tBool bSubStateData)
{
   ETG_TRACE_USR1(("spi_tclSPMClient::vSendSpmPhoneSubState with bSubStateData:%d\n",
      ETG_ENUM(BOOL,bSubStateData)));
   spm_tFiSubStatesSet oFiSubStatesSet;
   // set parameter
   oFiSubStatesSet.SubStateData = bSubStateData;
   oFiSubStatesSet.SubStateType.enType = SPM_SUBSTATE_PHONE_CALL;

    if (FALSE == bPostMessage(oFiSubStatesSet))
   {
      ETG_TRACE_ERR(("vSendSpmPhoneSubState: Posting SPMSubState Property Set failed! \n"));
   }
}

/***************************************************************************
** FUNCTION: t_Void spi_tclSPMClient::vSendSpmSubState(...)
**************************************************************************/
t_Void  spi_tclSPMClient::vSendSpmSubState(tenSpmSubState enSpmSubState, t_Bool bSubStateData)
{
   ETG_TRACE_USR1(("spi_tclSPMClient::vSendSpmSubState with enSpmSubState=%d bSubStateData=%d\n",
         enSpmSubState, ETG_ENUM(BOOL,bSubStateData)));
   if(e8SPM_SUBSTATE_NOT_KNOWN != enSpmSubState)
   {
      spm_tFiSubStatesSet oFiSubStatesSet;
      oFiSubStatesSet.SubStateType.enType = ((e8SPM_SUBSTATE_TEMPORARY == enSpmSubState) ? SPM_SUBSTATE_TEMP : SPM_SUBSTATE_PERM);
      oFiSubStatesSet.SubStateData = bSubStateData;

      if (FALSE == bPostMessage(oFiSubStatesSet))
      {
         ETG_TRACE_ERR(("vSendSpmSubState: Posting SPMSubState Property Set failed! \n"));
      }
   }
}

/***************************************************************************
** FUNCTION: t_Void spi_tclSPMClient::vHandleSpiState(...)
**************************************************************************/
tVoid spi_tclSPMClient::vHandleSpiState( amt_tclServiceData* poMessage )
{
    ETG_TRACE_USR1(("spi_tclSPMClient:: vHandleSpiState() entered"));
    fi_tclVisitorMessage oMsg( poMessage );
    spm_corefi_tclMsgSpiStateStatus   oData;
    if (oMsg.s32GetData(oData, SPM_FI_MAJOR_VERSION)!= OSAL_ERROR)
    {
       if (nullptr != m_poMainAppl)
       {
          ETG_TRACE_USR1(( "spi_tclSPMClient::vHandleSpiState( ): Get new System Status from SPM: %d", ETG_ENUM(SPI_SYSTEM_STATES, (tU8)oData.SpiState.enType) ));
          tLbSPISate oSPIStateMsg
          (
                   m_poMainAppl->u16GetAppId(), // Source AppID
                   m_poMainAppl->u16GetAppId(), // Target AppID
                   0, // RegisterID
                   0, // CmdCounter
                   CCA_C_U16_SRV_SMARTPHONEINTEGRATION,    // ServiceID
                   SPI_C_U16_IFID_SPI_STATE, // Function ID
                   AMT_C_U8_CCAMSG_OPCODE_STATUS//,      // Opcode
          );
          oSPIStateMsg.vSetByte(static_cast<tU8>(oData.SpiState.enType));
          if (true == oSPIStateMsg.bIsValid())
           {
              if (AIL_EN_N_NO_ERROR != m_poMainAppl->enPostMessage(&oSPIStateMsg, TRUE))
              {
                 ETG_TRACE_ERR(("spi_tclSPMClient::vHandleSpiState() Loopback message posting failed! "));
              }
           } //if (true == oSPIStateMsg.bIsValid())
           else
           {
               ETG_TRACE_ERR(("spi_tclSPMClient::vHandleSpiState(): Loopback message creation failed! "));
           }
       }
    }
    ETG_TRACE_USR1(("spi_tclSystemStateClient::vHandleSpiState left "));
}
/***************************************************************************
*********************************PRIVATE************************************
***************************************************************************/

/*******************************************************************************
** FUNCTION:   spi_tclSPMClient::bPostMethodStart(most_navfi_tclMsgBaseMessage...
*******************************************************************************/
t_Bool spi_tclSPMClient::bPostMessage(const spm_FiMsgBase& rfcoSPMMsgBase)const
{
   ETG_TRACE_USR1((" %s entered \n", __PRETTY_FUNCTION__));
   tBool bSuccess = FALSE;

   if (nullptr != m_poMainAppl)
   {
      //! Create Msg context
      trMsgContext rMsgCtxt;
      rMsgCtxt.rUserContext.u32SrcAppID  = CCA_C_U16_APP_SMARTPHONEINTEGRATION;
      rMsgCtxt.rUserContext.u32DestAppID = u16GetServerAppID();
      rMsgCtxt.rUserContext.u32RegID     = u16GetRegID();
      rMsgCtxt.rUserContext.u32CmdCtr    = 0;

      //!Post BT settings MethodStart
      FIMsgDispatch oMsgDispatcher(m_poMainAppl);
      bSuccess = oMsgDispatcher.bSendMessage(rfcoSPMMsgBase, rMsgCtxt, SPM_FI_MAJOR_VERSION);
   }

   ETG_TRACE_USR2(("bPostMethodStart() left with: Message (FID = 0x%x) Post Success = %u \n",
         rfcoSPMMsgBase.u16GetFunctionID(), bSuccess));
   return bSuccess;
}



///////////////////////////////////////////////////////////////////////////////
// <EOF>


