/*!
 *******************************************************************************
 * \file             spi_tclMplayResp.h
 * \brief            Response to HMI from Mplay class
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Response  to HMI  from Mplay class.
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 10.01.2014 |  Pruthvi Thej Nagaraju       | Initial Version
 05.11.2014 |  Ramya Murthy                | Added Application metadata response

 \endverbatim
 ******************************************************************************/

#ifndef SPI_TCLMPLAYRESP_H_
#define SPI_TCLMPLAYRESP_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "SPITypes.h"


/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/*!
 * \class spi_tclConnSettings
 * \brief Response  to HMI  from Mplay class
 */
class spi_tclMplayResp
{

   public:
      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclMplayResp::spi_tclMplayResp
       ***************************************************************************/
      /*!
       * \fn     spi_tclMplayResp()
       * \brief  Default Constructor
       * \sa      ~spi_tclMplayResp()
       **************************************************************************/
      spi_tclMplayResp()
      {

      }

      /***************************************************************************
       ** FUNCTION:  spi_tclMplayResp::~spi_tclMplayResp
       ***************************************************************************/
      /*!
       * \fn     ~spi_tclMplayResp()
       * \brief  Virtual Destructor
       * \sa     spi_tclMplayResp()
       **************************************************************************/
      virtual ~spi_tclMplayResp()
      {

      }

      /***************************************************************************
      ** FUNCTION: t_Void spi_tclMplayResp::vPostDipoRoleSwitchResponse
      ***************************************************************************/
      /*!
      * \fn     vPostDipoRoleSwitchResponse
      * \brief  Post response to DIPO role switch request
      * \param  [IN] bRoleSwitchRequired : true if role switch is required. otherwise false
      * \param  [IN] rfcorUsrCntxt : User context
      * \sa
      **************************************************************************/
      virtual t_Void vPostDipoRoleSwitchResponse(tenRoleSwitchResponse /*enRoleswitchRes*/,const t_U32 /*cou32DeviceHandle*/,
            const trUserContext& /*rfcorUsrCntxt*/)
      {

      }


      /***************************************************************************
      ** FUNCTION: t_Void spi_tclDiPoConnection::vPostApplicationMediaMetaData(...
      ***************************************************************************/
      /*!
      * \fn     vPostApplicationMediaMetaData(const trAppMediaMetaData& rfcorApplicationMediaMetaData,
      *            const trUserContext& rfcorUsrCntxt)
      * \brief  Interface to notify application media metadata to the client.
      * \param  [IN] rfcorApplicationMediaMetaData : Contains the media metadata information
      *              related to an application.
      * \param  [IN] rfcorUsrCntxt    : User Context Details.
      * \sa
      **************************************************************************/
      virtual t_Void vPostApplicationMediaMetaData(const trAppMediaMetaData& /*rfcorApplicationMediaMetaData*/,
         const trUserContext& /*rfcorUsrCntxt*/) {}

      /***************************************************************************
      ** FUNCTION: t_Void spi_tclDiPoConnection::vPostApplicationPhoneData(...
      ***************************************************************************/
      /*!
      * \fn     vPostApplicationPhoneData(const trAppPhoneData& rfcorApplicationPhoneData,
      *            const trUserContext& rfcorUsrCntxt)
      * \brief  Interface to notify application media metadata to the client.
      * \param  [IN] rfcorApplicationPhoneData : Contains the phone related information.
      * \param  [IN] rfcorUsrCntxt    : User Context Details.
      * \sa
      **************************************************************************/
      virtual t_Void vPostApplicationPhoneData(const trAppPhoneData& /*rfcorApplicationPhoneData*/,
         const trUserContext& /*rfcorUsrCntxt*/) {}

      /***************************************************************************
      ** FUNCTION: t_Void spi_tclDiPoConnection::vPostApplicationMediaPlaytime(...
      ***************************************************************************/
      /*!
      * \fn     vPostApplicationMediaPlaytime(const trAppMediaPlaytime& rfcorApplicationMediaPlaytime,
      *            const trUserContext& rfcorUsrCntxt)
      * \brief  Interface to notify application media metadata to the client.
      * \param  [IN] rfcorApplicationMediaPlaytime : Contains the media play time of current playing track.
      * \param  [IN] rfcorUsrCntxt    : User Context Details.
      * \sa
      **************************************************************************/
      virtual t_Void vPostApplicationMediaPlaytime(const trAppMediaPlaytime& /*rfcorApplicationMediaPlaytime*/,
         const trUserContext& /*rfcorUsrCntxt*/) {}

};
#endif // SPI_TCLMPLAYRESP_H_
