/*!
*******************************************************************************
* \file              spi_tclDiaglogClient.h
* \brief             DIAGLOG Client handler class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    DIAGLOG Client handler class
COPYRIGHT:      &copy; RBEI

HISTORY:
 Date       |  Author                           | Modifications
 14.09.2018 |  Rajendra Naik Vadthe (RBEI/ECO2)       | Initial Version

\endverbatim
******************************************************************************/

/******************************************************************************
| includes:
|----------------------------------------------------------------------------*/
#include "spi_tclDiaglogClient.h"
//For message dispatcher
#include "FIMsgDispatch.h"
using namespace shl::msgHandler;

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#define DIAGLIB_INCLUDE_GENERIC
#include <diaglib_if.h>
using namespace diaglib;

#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include "vd_diaglog_if.h"

#include "Trace.h"
#ifdef TARGET_BUILD
   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_APPLICATION
      #include "trcGenProj/Header/spi_tclDiaglogClient.cpp.trc.h"
   #endif
#endif

/******************************************************************************
| defines and macros and constants(scope: module-local)
|----------------------------------------------------------------------------*/
#define DIAGLOG_FI_MAJOR_VERSION   1
#define DIAGLOG_FI_MINOR_VERSION   0

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

// +++ MESSAGE MAP: enter the function IDs (FID) and the corresponding functions here.
//      the function will be called when a message with the corresponding FID arrives +++
BEGIN_MSG_MAP(spi_tclDiaglogClient, ahl_tclBaseWork)
ON_MESSAGE_SVCDATA( MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT,
					AMT_C_U8_CCAMSG_OPCODE_STATUS,
					vHandle_DiaglogSendNextTestResult_Status)
END_MSG_MAP()


/***************************************************************************
 *********************************PUBLIC*************************************
 ***************************************************************************/

/***************************************************************************
 ** FUNCTION:  spi_tclDiaglogClient::spi_tclDiaglogClient(ahl_tclBaseOneThreadApp* poMainAppl)
 **************************************************************************/
spi_tclDiaglogClient::spi_tclDiaglogClient(ahl_tclBaseOneThreadApp* poMainAppl)
: ahl_tclBaseOneThreadClientHandler(
         poMainAppl, /* Application Pointer */
         CCA_C_U16_SRV_DIAGLOG, /* ID of used Service */
         DIAGLOG_FI_MAJOR_VERSION, /* MajorVersion of used Service */
         DIAGLOG_FI_MINOR_VERSION), /* MinorVersion of used Service */
m_poMainAppl(poMainAppl),
m_enCurDTCStatus(e8DTC_NOT_SURE),m_bIsServiceAvailable (false),m_bIsRegistrationSuccess (false)
{
   ETG_TRACE_USR1(("spi_tclDiaglogClient() entered "));
   NORMAL_M_ASSERT(nullptr != m_poMainAppl);
} //! end of spi_tclDiaglogClient()

/***************************************************************************
 ** FUNCTION:  virtual spi_tclDiaglogClient::~spi_tclDiaglogClient...
 **************************************************************************/
spi_tclDiaglogClient::~spi_tclDiaglogClient()
{
   ETG_TRACE_USR1(("~spi_tclDiaglogClient() entered "));
   m_poMainAppl = nullptr;
} //! end of spi_tclDiaglogClient()

/***************************************************************************
 ** FUNCTION:  spi_tclDiaglogClient::vOnServiceAvailable()
 **************************************************************************/
tVoid spi_tclDiaglogClient::vOnServiceAvailable()
{
   ETG_TRACE_USR1(("spi_tclDiaglogClient::vOnServiceAvailable() entered AppID = %u", u16GetServerAppID()));
   m_bIsServiceAvailable = true;
   m_bIsRegistrationSuccess = true;
   vRegisterForProperties();
} //! end of vOnServiceAvailable()

/***************************************************************************
 ** FUNCTION:  spi_tclDiaglogClient::vOnServiceUnavailable()
 **************************************************************************/
tVoid spi_tclDiaglogClient::vOnServiceUnavailable()
{
   ETG_TRACE_USR1(("spi_tclDiaglogClient::vOnServiceUnavailable() entered AppID = %u", u16GetServerAppID()));
   m_bIsServiceAvailable = false;
   m_bIsRegistrationSuccess = false;
} //! end of vOnServiceUnavailable()

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclDiaglogClient::vRegisterForProperties()
 **************************************************************************/
t_Void spi_tclDiaglogClient::vRegisterForProperties()
{
   ETG_TRACE_USR1(("spi_tclDiaglogClient::vRegisterForProperties() entered "));
#ifdef VARIANT_S_FTR_ENABLE_SPI_DIAGLOG
   vAddAutoRegisterForProperty(MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT);
#endif
   //! Register for interested properties
} //! end of vRegisterForProperties()

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclDiaglogClient::vUnregisterForProperties()
 **************************************************************************/
t_Void spi_tclDiaglogClient::vUnregisterForProperties()
{
   ETG_TRACE_USR1(("spi_tclDiaglogClient::vUnregisterForProperties() entered "));
#ifdef VARIANT_S_FTR_ENABLE_SPI_DIAGLOG
   vRemoveAutoRegisterForProperty(MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT);
#endif
   //! Unregister subscribed properties
} //! end of vUnregisterForProperties()

/***************************************************************************
 ** FUNCTION:  spi_tclMPlayClientHandler::vPopulateMessageContext(trMsgContext
 ***************************************************************************/
t_Void spi_tclDiaglogClient::vPopulateMessageContext(trMsgContext &rMsgContext) const
{
   ETG_TRACE_USR1((" %s entered \n", __PRETTY_FUNCTION__));
   rMsgContext.rUserContext.u32DestAppID = u16GetServerAppID();
   rMsgContext.rUserContext.u32SrcAppID = CCA_C_U16_APP_SMARTPHONEINTEGRATION;
   rMsgContext.rUserContext.u32RegID = u16GetRegID();
   rMsgContext.rUserContext.u32CmdCtr = 0;
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclDiaglogClient::vSendTestResult()
 ***************************************************************************/
t_Void spi_tclDiaglogClient::vSendTestResult(tenITCTest ITC_test, tenITCTestResult ITC_result)
{
   midw_diaglogfi_tclMsgSaveTestResultMethodStart oStartSaveTestResultMS;
   midw_fi_tcl_TestResult oTestResult;

   ETG_TRACE_USR1(("spi_tclDiaglogClient::vSendTestResult() entered ITC_test=%d ITC_result=%d", ITC_test, ITC_result));
   if (e8ITC_USB_OPEN_LOAD == ITC_test)
   {
      oTestResult.TroubleCode = 0xB000;
      oTestResult.Result.enType = (midw_fi_tcl_e8_TestResult::tenType)(ITC_result);
      oStartSaveTestResultMS.TestResultList.TestResultList.push_back(oTestResult);
   }
   else if (e8ITC_USB_COMMUNICATION_PROBLEM == ITC_test)
   {
      oTestResult.TroubleCode = 0xB001;
      oTestResult.Result.enType = (midw_fi_tcl_e8_TestResult::tenType)(ITC_result);
      ETG_TRACE_USR1(("oTestResult.TroubleCode =0x%x oTestResult.Result.enType=%d ", oTestResult.TroubleCode, oTestResult.Result.enType));
      oStartSaveTestResultMS.TestResultList.TestResultList.push_back(oTestResult);
   }
   // generate message context
   trMsgContext rMsgContext;
   vPopulateMessageContext(rMsgContext);
   FIMsgDispatch msgDispatcher(m_poMainAppl);

   // Send method start to diaglog fi
   t_Bool bStatus = msgDispatcher.bSendMessage(oStartSaveTestResultMS, rMsgContext,
   DIAGLOG_FI_MAJOR_VERSION);
   //TO CHECK::Can oStartSaveTestResultMS.vDestroy as methodstart is leaving out of scope

   ETG_TRACE_USR4(("spi_tclDiaglogClient::vSendTestResult send status:%d", ETG_ENUM(BOOL, bStatus)));
}

t_Void spi_tclDiaglogClient::vHandleDeviceDTCStatus(tenDTCStatus enDevDTCStatus)
{
   ETG_TRACE_USR1(("spi_tclDiaglogClient::vHandleDeviceDTCStatus() entered enDevITCStatus=%d current status=%d", enDevDTCStatus, m_enCurDTCStatus));
   if (m_enCurDTCStatus != enDevDTCStatus)
   {
      m_enCurDTCStatus = enDevDTCStatus;
      if (m_bIsServiceAvailable)
      {
         if ((e8DTC_CONNECTED == m_enCurDTCStatus))
         {
            //Send_ITC_Codes
            vSendTestResult(e8ITC_USB_OPEN_LOAD, e8ITC_TEST_RESULT_PASSED);
            vSendTestResult(e8ITC_USB_COMMUNICATION_PROBLEM, e8ITC_TEST_RESULT_PASSED);
         }
         else if (e8DTC_NOT_CONNECTED == m_enCurDTCStatus)
         {
            //Send_ITC_Codes
            vSendTestResult(e8ITC_USB_OPEN_LOAD, e8ITC_TEST_RESULT_FAILED);
            vSendTestResult(e8ITC_USB_COMMUNICATION_PROBLEM, e8ITC_TEST_RESULT_FAILED);
         }
         else if (e8DTC_NOT_SURE == m_enCurDTCStatus)
         {
            vSendTestResult(e8ITC_USB_OPEN_LOAD, e8ITC_TEST_RESULT_NO_RESULT);
            vSendTestResult(e8ITC_USB_OPEN_LOAD, e8ITC_TEST_RESULT_NO_RESULT);
         }
      }
   }
}

/*-----------------------------------------------------------------------------*
 * t_Void vHandle_DiaglogSendNextTestResult_Status(amt_tclServiceData* poMessage)*
 *-----------------------------------------------------------------------------*/
t_Void spi_tclDiaglogClient::vHandle_DiaglogSendNextTestResult_Status(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR1(("Begin: vHandle_DiaglogSendNextTestResult_Status : Retest and Send results "));
   ETG_TRACE_USR1(("***************/vHandle_DiaglogSendNextTestResult_Status**********"));

   midw_diaglogfi_tclMsgSaveTestResultMethodStart ms;
   // Create a FI visitor message for the received CCA message
   fi_tclVisitorMessage oVisitorMsg(poMessage);

   // Create the FI data object
   midw_diaglogfi_tclMsgSendNextTestResultStatus oResultStatus;

   if (oVisitorMsg.s32GetData(oResultStatus) != OSAL_ERROR)
   {
      ETG_TRACE_USR1(("Before Checking NextTestResultStruct Status=%d", oResultStatus.NextTestResultStruct.Status));
      if (TRUE == oResultStatus.NextTestResultStruct.Status) //TRUE :client is required to send next test result to DiagLog
      //(FALSE if this is a confirmation message from the Diaglog that thel UpReg has been succesful)
      {
         ETG_TRACE_USR1(("Before Checking if ITCList is empty"));
         //-----------------------------------------------
         //diagnosis asks for all ITCs
         //-----------------------------------------------
         if (oResultStatus.NextTestResultStruct.ITCList.empty()) //if the List of DTC's  is empty and "NextTestResultStruct.Status == True" then the client should report all the DTCs for which he is reponsible.

         { /* All Test result is empty, hence clear all the local test results.
          so the latest test results can be sent when timer slot is available*/
            ETG_TRACE_USR1(("vHandle_DiaglogSendNextTestResult_Status:m_enCurDTCStatus=%d", m_enCurDTCStatus));
            if (e8DTC_CONNECTED == m_enCurDTCStatus)
            {
               //UPDATE RESULTS to DIAGLOG AS TEST_PASS
               vSendTestResult(e8ITC_USB_OPEN_LOAD, e8ITC_TEST_RESULT_PASSED);
               vSendTestResult(e8ITC_USB_COMMUNICATION_PROBLEM, e8ITC_TEST_RESULT_PASSED);
            }
            else if (e8DTC_NOT_CONNECTED == m_enCurDTCStatus)
            {
               //UPDATE RESULTS to DIAGLOG AS TEST_FAIL
               vSendTestResult(e8ITC_USB_OPEN_LOAD, e8ITC_TEST_RESULT_FAILED);
               vSendTestResult(e8ITC_USB_COMMUNICATION_PROBLEM, e8ITC_TEST_RESULT_FAILED);
            }
            else if (e8DTC_NOT_SURE == m_enCurDTCStatus)
            {
               //UPDATE RESULTS to DIAGLOG as NOT_SURE
               vSendTestResult(e8ITC_USB_OPEN_LOAD, e8ITC_TEST_RESULT_NO_RESULT);
               vSendTestResult(e8ITC_USB_OPEN_LOAD, e8ITC_TEST_RESULT_NO_RESULT);
            }
         }  // if (oResultStatus.NextTestResultStruct.ITCList.empty())
         //-----------------------------------------------
         //diagnosis asks for specific ITCs
         //-----------------------------------------------
         else
         {
            ETG_TRACE_USR1(("***************/ ITCList is not empty!IGNORE RESULTS**********"));

         }  // if-else (oResultStatus.NextTestResultStruct.ITCList.empty())
      }
      else
      {
         ETG_TRACE_USR1(("vHandle_DiaglogSendNextTestResult_Status: UpReg has been succesful...NO SHARING OF RESULTS "));
         if (m_bIsServiceAvailable && m_bIsRegistrationSuccess
                  && ((e8DTC_CONNECTED == m_enCurDTCStatus) || (e8DTC_NOT_CONNECTED == m_enCurDTCStatus)))
         {
            if (e8DTC_CONNECTED == m_enCurDTCStatus)
            {
               ETG_TRACE_USR1(("Dev is Connected and before vSendTestResult as PASS"));
               //UPDATE RESULTS to DIAGLOG AS TEST_PASS
               vSendTestResult(e8ITC_USB_OPEN_LOAD, e8ITC_TEST_RESULT_PASSED);
               vSendTestResult(e8ITC_USB_COMMUNICATION_PROBLEM, e8ITC_TEST_RESULT_PASSED);
            }
            else if (e8DTC_NOT_CONNECTED == m_enCurDTCStatus)
            {
               ETG_TRACE_USR1(("Dev is NOT Connected and before vSendTestResult as FAILED"));
               //UPDATE RESULTS to DIAGLOG AS TEST_FAIL
               vSendTestResult(e8ITC_USB_OPEN_LOAD, e8ITC_TEST_RESULT_FAILED);
               vSendTestResult(e8ITC_USB_COMMUNICATION_PROBLEM, e8ITC_TEST_RESULT_FAILED);
            }
            m_bIsRegistrationSuccess = false;

         }
      }
   }
   else
   {
      ETG_TRACE_ERR((" Received message is invalid."));
   }  // if-else (oVisitorMsg.s32GetData(oResultStatus) != OSAL_ERROR)
   oResultStatus.vDestroy();
   ETG_TRACE_USR1(("End  : vHandle_DiaglogSendNextTestResult_Status : Retest and Send results "));
}
///////////////////////////////////////////////////////////////////////////////
// <EOF>


