/*!
 *******************************************************************************
 * \file             spi_tclAudioIn.h
 * \brief            Audio Input Handling using ECNR
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Audio Input Handling using ECNR
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 24.03.2014 |  Pruthvi Thej Nagaraju       | Initial Version

 \endverbatim
 ******************************************************************************/

#ifndef SPI_TCLAUDIOIN_H_
#define SPI_TCLAUDIOIN_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "spi_tclEcnr_generated.h"
#include "spi_tclAudioInBase.h"

/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/*!
 * \class spi_tclAudioInBase
 * \brief Audio Input Handling using ECNR
 */

class spi_tclAudioIn: public spi_tclAudioInBase
{
   public:
      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclAudioIn::spi_tclAudioIn
       ***************************************************************************/
      /*!
       * \fn     spi_tclAudioIn()
       * \brief  Default Constructor
       * \sa      ~spi_tclAudioIn()
       **************************************************************************/
      spi_tclAudioIn();

      /***************************************************************************
       ** FUNCTION:  spi_tclAudioIn::~spi_tclAudioIn
       ***************************************************************************/
      /*!
       * \fn     ~spi_tclAudioIn()
       * \brief  virtual Destructor
       * \sa     spi_tclAudioIn()
       **************************************************************************/
      virtual ~spi_tclAudioIn();

      /***************************************************************************
       ** FUNCTION:  spi_tclAudioIn::bSubscribeForAudioIn
       ***************************************************************************/
      /*!
       * \fn     bSubscribeForAudioIn()
       * \brief  implements spi_tclAudioInBase::bSubscribeForAudioIn
       * \sa     spi_tclAudioInBase::bSubscribeForAudioIn
       **************************************************************************/
      t_Bool bSubscribeForAudioIn();

      /***************************************************************************
       ** FUNCTION:  spi_tclAudioIn::vInitializeAudioIn
       ***************************************************************************/
      /*!
       * \fn     vInitializeAudioIn(tenAudioInDataSet enAudioDataSet)
       * \brief  implements spi_tclAudioInBase::vInitializeAudioIn
       * \sa     spi_tclAudioInBase::vInitializeAudioIn
       **************************************************************************/
      t_Void vInitializeAudioIn(tenAudioInDataSet enAudioDataSet);

      /***************************************************************************
       ** FUNCTION:  spi_tclAudioIn::vUnitializeAudioIn
       ***************************************************************************/
      /*!
       * \fn     vUnitializeAudioIn()
       * \brief  implements spi_tclAudioInBase::vUnitializeAudioIn
       * \sa     spi_tclAudioInBase::vUnitializeAudioIn
       **************************************************************************/
      t_Void vUnitializeAudioIn();

      /***************************************************************************
       ** FUNCTION:  spi_tclAudioIn::vStartAudioIn
       ***************************************************************************/
      /*!
       * \fn     vStartAudioIn()
       * \brief  implements spi_tclAudioInBase::vStartAudioIn
       * \sa     spi_tclAudioInBase::vStartAudioIn
       **************************************************************************/
      t_Void vStartAudioIn();

      /***************************************************************************
       ** FUNCTION:  spi_tclAudioIn::vStopAudioIn
       ***************************************************************************/
      /*!
       * \fn     vStopAudioIn()
       * \brief  implements spi_tclAudioInBase::vStopAudioIn
       * \sa     spi_tclAudioInBase::vStopAudioIn
       **************************************************************************/
      t_Void vStopAudioIn();

      /***************************************************************************
       ** FUNCTION:  spi_tclAudioIn::vSetAudioInConfig
       ***************************************************************************/
      /*!
       * \fn     vSetAudioInConfig(tenAudioInDataSet enAudioDataSet)
       * \brief  implements spi_tclAudioInBase::vSetAudioInConfig
       * \sa     spi_tclAudioInBase::vSetAudioInConfig
       **************************************************************************/
      t_Void vSetAudioInConfig(tenAudioInDataSet enAudioDataSet);

      /***************************************************************************
       ** FUNCTION:  spi_tclAudioIn::vSetWBAudio
       ***************************************************************************/
      /*!
       * \fn     vSetWBAudio()
       * \brief  implements spi_tclAudioInBase::vSetWBAudio
       * \sa     spi_tclAudioInBase::vSetWBAudio
       **************************************************************************/
      t_Void vSetWBAudio(t_Bool bSettoWB);

      /***************************************************************************
       ** FUNCTION:  spi_tclAudioIn::vSetAlsaDevice
       ***************************************************************************/
      /*!
       * \fn     vSetAlsaDevice()
       * \brief  implements spi_tclAudioInBase::vSetAlsaDevice
       * \sa     spi_tclAudioInBase::vSetAlsaDevice
       **************************************************************************/
      t_Void vSetAlsaDevice(t_U32 u32AlsaDeviceSelector, t_String szAlsaDeviceName);

   private:

      /***************************************************************************
       *********************************PRIVATE***********************************
       ***************************************************************************/

      /*************************************************************************
       **  FUNCTION : spi_tclAudioIn::spi_tclAudioIn(const spi_tclAudioIn &corfAudioIn)
       *************************************************************************/
      /*!
       * \fn     spi_tclAudioIn(const spi_tclAudioIn &corfAudioIn)
       * \brief  Copy constructor: Made private to prevent unintended usage
       *         of Default copy constructor
       * \param  corfAudioIn : [IN] reference to AudioIn class
       *************************************************************************/
      spi_tclAudioIn(const spi_tclAudioIn &corfAudioIn);

      /*************************************************************************
       **  FUNCTION : spi_tclAudioIn& operator=(const spi_tclAudioIn &corfAudioIn)
       *************************************************************************/
      /*!
       * \fn     spi_tclAudioIn& operator=(const spi_tclAudioIn &corfAudioIn) {}
       * \brief  Overloaded function: Made private to prevent unintended usage of
       *         default assignment operator
       * \param  corfAudioIn : [IN] reference to AudioIn class
       *************************************************************************/
      spi_tclAudioIn& operator=(const spi_tclAudioIn &corfAudioIn);

      /***************************************************************************
       ** FUNCTION:  spi_tclAudioIn::vDbusNameAppearedCb
       ***************************************************************************/
      /*!
       * \fn     vDbusNameAppearedCb
       * \brief  Invoked when the name being watched is known to have to have a owner.
       * \param  connection: The GDBusConnection the name is being watched on
       * \param  name: The name being watched.
       * \param  name_owner: Unique name of the owner of the name being watched.
       * \param  pUserData: User data passed to g_bus_watch_name().
       **************************************************************************/
      static t_Void vDbusNameAppearedCb(GDBusConnection *poconnection, const gchar *name,
                                          const gchar *name_owner, gpointer pUserData);

      /***************************************************************************
       ** FUNCTION:  spi_tclAudioIn::vDbusNameVanishedCb
       ***************************************************************************/
      /*!
       * \fn     vDbusNameVanishedCb
       * \brief  Invoked when the name being watched is known not to have to have a owner.
       * \param  connection: The GDBusConnection the name is being watched on or NULL.
       * \param  name: The name being watched.
       * \param  pUserData: User data passed to g_bus_watch_name().
       **************************************************************************/
      static t_Void vDbusNameVanishedCb(GDBusConnection *poconnection, const gchar *name, gpointer pUserData);

      //! Instance of DBus proxy for ECNR Service
      OrgBoschEcnrService *m_poEcnrService;

      //! Instance of DBus proxy for ECNR Service for AlSA
      OrgBoschEcnrAlsa *m_poEcnrAlsa;


};

#endif /* SPI_TCLAUDIOIN_H_ */
