/***********************************************************************/
/*!
 * \file    spi_tclAAPVideoDispatcher.cpp
 * \brief   Message Dispatcher for Video Messages
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Video Messages
 AUTHOR:         Shiva Kumar Gurija
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 20.03.2015  | Shiva Kumar Gurija    | Initial Version
 21.08.2015  | Sameer Chandra        | Added new video Config message
 \endverbatim
 *************************************************************************/

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "spi_tclMySPINRespVideo.h"
#include "spi_tclMySPINVideoDispatcher.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
#include "trcGenProj/Header/spi_tclMySPINVideoDispatcher.cpp.trc.h"
#endif
#endif

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/
//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(DISPATCHER* poDispatcher)      \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleVideoMsg(this);                  \
   }                                                        \
}

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/***************************************************************************
 ** FUNCTION:  MySPINVideoMsgBase::MySPINVideoMsgBase
 ***************************************************************************/
MySPINVideoMsgBase::MySPINVideoMsgBase()
{
   ETG_TRACE_USR1(("MySPINVideoMsgBase() entered "));
   vSetServiceID( e32MODULEID_MYSPINVIDEO);
}

/***************************************************************************
 ** FUNCTION:  PlaybackStartMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(FirstFBRenderedMsg, spi_tclMySPINVideoDispatcher)
;

/***************************************************************************
 ** FUNCTION:  PlaybackStartOnLaunchMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(PlaybackStartOnLaunchMsg, spi_tclMySPINVideoDispatcher)
;

/***************************************************************************
 ** FUNCTION:  PlaybackStoppedMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(PlaybackStoppedMsg, spi_tclMySPINVideoDispatcher)
;

/***************************************************************************
 ** FUNCTION:  spi_tclAAPVideoDispatcher::vHandleVideoMsg(FirstFBRenderedMsg..)
 ***************************************************************************/
t_Void spi_tclMySPINVideoDispatcher::vHandleVideoMsg(FirstFBRenderedMsg* poFirstFBRendered) const
{
   ETG_TRACE_USR1(("FirstFBRenderedMsgDispatcher"));
   if (NULL != poFirstFBRendered)
   {
      CALL_REG_OBJECTS(spi_tclMySPINRespVideo,
               e16MYSPIN_VIDEO_REGID,
               vFirstFBRenderedCallback(poFirstFBRendered->u32DeviceID));
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINVideoDispatcher::vHandleVideoMsg(PlaybackStartOnLaunchMsg..)
 ***************************************************************************/
t_Void spi_tclMySPINVideoDispatcher::vHandleVideoMsg(PlaybackStartOnLaunchMsg* poPlaybackStartOnLaunchMsg) const
{
   ETG_TRACE_USR1(("PlaybackStartOnLaunchoDispatcher"));
   if (NULL != poPlaybackStartOnLaunchMsg)
   {
      CALL_REG_OBJECTS(spi_tclMySPINRespVideo,
               e16MYSPIN_VIDEO_REGID,
               vPlaybackStartOnLaunchCallback(poPlaybackStartOnLaunchMsg->u32DeviceID));
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINVideoDispatcher::vHandleVideoMsg(PlaybackStoppedMsg..)
 ***************************************************************************/
t_Void spi_tclMySPINVideoDispatcher::vHandleVideoMsg(PlaybackStoppedMsg* poPlaybackStoppedMsg) const
{
   ETG_TRACE_USR1(("PlaybackStoppedMsgDispatcher"));
   if (NULL != poPlaybackStoppedMsg)
   {
      CALL_REG_OBJECTS(spi_tclMySPINRespVideo,
               e16MYSPIN_VIDEO_REGID,
               vPlaybackStop(poPlaybackStoppedMsg->u32DeviceID));
   }
}
///////////////////////////////////////////////////////////////////////////////
// <EOF>
