/***********************************************************************/
/*!
 * \file   spi_tclAAPRespVideo.h
 * \brief  Target Adapter Call backs output interface
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    VideoSink Call backs output interface
 AUTHOR:         tch5kor
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 11.05.2015  | tch5kor               | Initial Version

 \endverbatim
 *************************************************************************/
#ifndef _SPI_TCLMYSPINRESPVIDEO_H_
#define _SPI_TCLMYSPINRESPVIDEO_H_

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "RespBase.h"
#include "mySPINTypes.h"

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
 * \class  spi_tclMySPINRespVideo
 * \brief
 *****************************************************************************/
class spi_tclMySPINRespVideo: public RespBase
{

   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINRespVideo::spi_tclMySPINRespVideo()
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINRespVideo()
       * \brief   Default Constructor
       * \sa      ~spi_tclMySPINRespVideo()
       **************************************************************************/
      spi_tclMySPINRespVideo() :
         RespBase(e16MYSPIN_VIDEO_REGID)
      {
      }

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINRespVideo::~spi_tclMySPINRespVideo()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclMySPINRespVideo()
       * \brief   Destructor
       * \sa      spi_tclMySPINRespVideo()
       **************************************************************************/
      virtual ~spi_tclMySPINRespVideo()
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINRespVideo::vFirstFBRenderedCallback()
       ***************************************************************************/
      /*!
       * \fn      virtual t_Void vFirstFBRenderedCallback()
       * \brief   method to update that the first FB has been rendered
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vFirstFBRenderedCallback(t_U32 u32DeviceHandle)
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINRespVideo::vPlaybackStartOnLaunchCallback()
       ***************************************************************************/
      /*!
       * \fn      virtual t_Void vPlaybackStartOnLaunchCallback()
       * \brief   method to update that the Video Play back is started
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vPlaybackStartOnLaunchCallback(t_U32 u32DeviceHandle)
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINRespVideo::vPlaybackStop()
       ***************************************************************************/
      /*!
       * \fn      virtual t_Void vPlaybackStop()
       * \brief   method to update that the Video Play back is stopped
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vPlaybackStop(t_U32 u32DeviceHandle)
      {
      }

      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/

   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINRespVideo(const spi_tclMySPINRespVideo...
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINRespVideo(const spi_tclMySPINRespVideo& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclAAPRespVideo()
       ***************************************************************************/
      spi_tclMySPINRespVideo(const spi_tclMySPINRespVideo& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINRespVideo& operator=( const spi_tclMySPINRespVideo...
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINRespVideo& operator=(const spi_tclMySPINRespVideo& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclMySPINRespVideo(const spi_tclMySPINRespVideo& otrSrc)
       ***************************************************************************/
      spi_tclMySPINRespVideo& operator=(const spi_tclMySPINRespVideo& corfoSrc);

      /***************************************************************************
       ****************************END OF PROTECTED********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/

}; //class spi_tclMySPINRespVideo

#endif //_SPI_TCLMYSPINPRESPVIDEO_H_
///////////////////////////////////////////////////////////////////////////////
// <EOF>
