/***********************************************************************/
/*!
 * \file  spi_tclMySPINCmdVideo.h
 * \brief  Implementation of the Class spi_tclMySPINCmdVideo
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:
 AUTHOR:         gri2kor
 COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH
 HISTORY:
 Date        | Author                | Modification
 12.04.2016  | Chaitra Srinivasa     | Adding comments

 \endverbatim
 *************************************************************************/

#ifndef _SPI_TCLMYSPINCMDVIDEO_H_
#define _SPI_TCLMYSPINCMDVIDEO_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "mySPINTypes.h"

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/
/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/

class spi_tclMySPINCmdVideo
{

   public:

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdVideo::spi_tclMySPINCmdVideo()
       ***************************************************************************/
      /*!
       * \fn    spi_tclMySPINCmdVideo()
       * \brief Constructor
       **************************************************************************/
      spi_tclMySPINCmdVideo();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdVideo::~spi_tclMySPINCmdVideo()
       ***************************************************************************/
      /*!
       * \fn    ~spi_tclMySPINCmdVideo()
       * \brief Destructor
       **************************************************************************/
      virtual ~spi_tclMySPINCmdVideo();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdVideo::t_Bool bInitialize()
       ***************************************************************************/
      /*!
       * \fn    t_Bool bInitialize()
       * \brief Method for initialization
       * \retval t_Bool
       **************************************************************************/
      t_Bool bInitialize();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdVideo::t_Void vUninitialize()
       ***************************************************************************/
      /*!
       * \fn    t_Void vUninitialize()
       * \brief Method for uninitialization
       * \retval t_Void
       **************************************************************************/
      t_Void vUninitialize();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdVideo::t_Void vSetFrameProperties(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vSetFrameProperties(t_U32 u32DevID,
       *                          const trMySpinVideoConfig& corfrVideoConfig)
       * \brief Method to set frame properties
       * \param u32DevID: [IN]Device ID
       * \param corfrVideoConfig: [IN]Structure for video configuration
       * \retval t_Void
       **************************************************************************/
      t_Void vSetFrameProperties(t_U32 u32DevID, const trMySpinVideoConfig& corfrVideoConfig);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdVideo:: tenErrorCode enStartVideoPlayback(...)
       ***************************************************************************/
      /*!
       * \fn     tenErrorCode enStartVideoPlayback(t_U32 u32DevID,
       *                                   t_Bool bTriggeredOnLaunch=false)
       * \brief Method for starting video play back
       * \param u32DevID: [IN]Device ID
       * \param bTriggeredOnLaunch: [IN]To check whether video is triggered on
       *                            launch or not
       * \retval tenErrorCode
       **************************************************************************/
      tenErrorCode enStartVideoPlayback(t_U32 u32DevID, t_Bool bTriggeredOnLaunch = true);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdVideo::tenErrorCode enStopVideoPlayback(...)
       ***************************************************************************/
      /*!
       * \fn    tenErrorCode enStopVideoPlayback(t_U32 u32DevID)
       * \brief Method to stop video play back
       * \param u32DevID: [IN]Device ID
       * \retval tenErrorCode
       **************************************************************************/
      tenErrorCode enStopVideoPlayback(t_U32 u32DevID);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdVideo::t_Void vSetWaylandTouch(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vSetWaylandTouch(t_U32 u32DevID,
       *                                t_Bool bEnableTouch)
       * \brief Method to set wayland touch
       * \param u32DevID: [IN]Device ID
       * \param bEnableTouch: [IN]To check whether touch is enabled or not
       * \retval t_Void
       **************************************************************************/
      t_Void vSetWaylandTouch(t_U32 u32DevID, t_Bool bEnableTouch);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdVideo::t_Void vPumpEvents(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vPumpEvents(t_U32 u32DevID,
       *                           t_S32 s32TimeOut)
       * \brief Method to pump events
       * \param u32DevID: [IN]Device ID
       * \param s32TimeOut: [IN]String for time out
       * \retval t_Void
       **************************************************************************/
      t_Void vPumpEvents(t_U32 u32DevID, t_S32 s32TimeOut);

   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINCmdVideo(const spi_tclMySPINCmdVideo...
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINCmdVideo(
       *                             const spi_tclMySPINCmdVideo& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       ***************************************************************************/
      spi_tclMySPINCmdVideo(const spi_tclMySPINCmdVideo& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINCmdVideo& operator=( const spi_tcl...
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINCmdVideo& operator=(
       *                          const spi_tclMySPINCmdVideo& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       ***************************************************************************/
      spi_tclMySPINCmdVideo& operator=(const spi_tclMySPINCmdVideo& otrSrc);

   private:

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdVideo::t_Void vFirstFrameRenderedCallback(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vFirstFrameRenderedCallback(t_Void *poContext)
       * \brief Call back for first rendered frame
       * \param poContext: [IN]Pointer for context
       * \retval t_Void
       **************************************************************************/
      static t_Void vFirstFrameRenderedCallback(t_Void *poContext);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdVideo::t_Void vLayerManagerDeinitializedCallback(..)
       ***************************************************************************/
      /*!
       * \fn    t_Void vLayerManagerDeinitializedCallback(t_Void *poContext)
       * \brief Call back for layer manager deinitialization
       * \param poContext: [IN]Pointer for context
       * \retval t_Void
       **************************************************************************/
      static t_Void vLayerManagerDeinitializedCallback(t_Void *poContext);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdVideo::t_Void vLayerManagerInitializedCallback(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vLayerManagerInitializedCallback(t_Void *poContext)
       * \brief Call back for layer manager initialization
       * \param poContext: [IN]Pointer for context
       * \retval t_Void
       **************************************************************************/
      static t_Void vLayerManagerInitializedCallback(t_Void *poContext);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdVideo::MSPIN_PIXEL_FORMAT enGetPixelFormat(...)
       ***************************************************************************/
      /*!
       * \fn    MSPIN_PIXEL_FORMAT enGetPixelFormat(tenPixelFormat enPixelFormat)
       * \brief Method to get pixel format
       * \param enPixelFormat: [IN]To store pixel format
       * \retval MSPIN_PIXEL_FORMAT
       **************************************************************************/
      MSPIN_PIXEL_FORMAT enGetPixelFormat(tenPixelFormat enPixelFormat);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdVideo::MSPIN_FRAME_COMPRESSION enGetPixelComp(...)
       ***************************************************************************/
      /*!
       * \fn    MSPIN_FRAME_COMPRESSION enGetPixelComp(tenPixelCompression enPixelComp)
       * \brief Method to get pixel compression
       * \param enPixelComp: [IN] To store pixel compresssion
       * \retval MSPIN_FRAME_COMPRESSION
       **************************************************************************/
      MSPIN_FRAME_COMPRESSION enGetPixelComp(tenPixelCompression enPixelComp);

};
#endif // ifndef _SPI_TCLMYSPINCMDVIDEO_H_
