/***********************************************************************/
/*!
* \file  spi_tclMySPINCmdVehicleData.h
* \brief  Implementation of the Class spi_tclMySPINCmdVehicleData
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         tch5kor
COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
\endverbatim
*************************************************************************/


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/


/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

#define MYSPIN_LOCATION_DATA_REQUEST 1
#define MYSPIN_VEHCILE_MOVEMENT_DATA 2
#define MYSPIN_VEHICLE_DAYNIGHT_MODE 3

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/
/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "spi_tclMySPINCmdVehicleData.h"
#include "spi_tclMySPINTAVehicleDataIntf.h"
#include "spi_tclMySPINTADataIntf.h"
//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_DATASERVICE
      #include "trcGenProj/Header/spi_tclMySPINCmdVehicleData.cpp.trc.h"
   #endif
#endif
//lint -save -e110 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1039 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e129 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e19 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1055 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e58 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e530 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported

tvVehicleDataRequestCb spi_tclMySPINCmdVehicleData::m_VehicleDataRequestCb = NULL;
tvPostNightMode spi_tclMySPINCmdVehicleData::ftvPostNightModeCb = NULL;
tenVehicleConfiguration spi_tclMySPINCmdVehicleData::m_enDayNightConfiguration = e8_DAY_MODE;

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINCmdVehicleData::spi_tclMySPINCmdVehicleData()
 ***************************************************************************/
spi_tclMySPINCmdVehicleData::spi_tclMySPINCmdVehicleData()
{
    spi_tclMySPINCmdVehicleData::ftvPostNightModeCb = std::bind(&spi_tclMySPINCmdVehicleData::vSetNightMode,
                                                                this,
                                                                SPI_FUNC_PLACEHOLDERS_2);
}
/***************************************************************************
 ** FUNCTION:  spi_tclMySPINCmdVehicleData::~spi_tclMySPINCmdVehicleData()
 ***************************************************************************/
spi_tclMySPINCmdVehicleData::~spi_tclMySPINCmdVehicleData()
{

}
/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINCmdVehicleData::vNavigateToCallback()
 ***************************************************************************/
t_Void spi_tclMySPINCmdVehicleData::vNavigateToCallback()
{


}
/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINCmdVehicleData::vVehicleDataRequestCallback()
 ***************************************************************************/
t_Void spi_tclMySPINCmdVehicleData::vVehicleDataRequestCallback(t_Void *poContext, t_Bool request,
      t_U8 u8length, t_U32 *u32keyList)
{

   trMySPINContext* rMySPINContext = (trMySPINContext*)poContext;
   ETG_TRACE_USR1(("Received Vehicle Data Request for dev [%d] ",rMySPINContext->u32DeviceHandle));

   t_U8 u8DataType = 0;

   for(t_U8 u8Index=0; u8Index < u8length; u8Index++)
   {
      switch (u32keyList[u8Index])
      {
         case MYSPIN_LOCATION_DATA_REQUEST:
         {
            ETG_TRACE_USR2(("Start pushing Location data [%d]",ETG_ENUM(BOOL,request)));
            u8DataType |= (1<<1);
            // Inform, only support vehicle data via cb mechanism, rest use old mechanisms.
            if (NULL != m_VehicleDataRequestCb)
            {
                (m_VehicleDataRequestCb)(rMySPINContext->u32DeviceHandle,request,u8DataType);
            }
         }
         break;

         case MYSPIN_VEHCILE_MOVEMENT_DATA:
         {
            ETG_TRACE_USR2(("Start pushing Movement data [%d]",ETG_ENUM(BOOL,request)));
            u8DataType |= (1<<2);
         }
         break;

         case MYSPIN_VEHICLE_DAYNIGHT_MODE:
         {
            ETG_TRACE_USR2(("Start pushing Day Night data [%d]",ETG_ENUM(BOOL,request)));
            u8DataType |= (1<<3);
            ftvPostNightModeCb(rMySPINContext->u32DeviceHandle,
                               spi_tclMySPINCmdVehicleData::m_enDayNightConfiguration);
         }
         break;

         default:
         {
            ETG_TRACE_USR2(("Unsupported Data Requested"));
         }
         break;
      }
   }


}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINCmdVehicleData::vSetMovingStatus()
 ***************************************************************************/
t_Void spi_tclMySPINCmdVehicleData::vSetMovingStatus(t_U32 u32DeviceHandle,
                                                     tenVehicleMovementState enVehicleMovementState)
{
   spi_tclMySPINTADataIntf oTADataIntf;
   spi_tclMySPINTAVehicleDataIntf* poMySPINTAVehIntf = oTADataIntf.poGetTAVehDataIntfInst();

   if (NULL != poMySPINTAVehIntf)
   {
     t_Bool bIsMoving = false;
     bIsMoving = (e8VEHICLE_MOVEMENT_STATE_FORWARD == enVehicleMovementState);

     poMySPINTAVehIntf->vSetMovingStatus(u32DeviceHandle,bIsMoving);
   }

}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINCmdVehicleData::vSetNightMode()
 ***************************************************************************/
t_Void spi_tclMySPINCmdVehicleData::vSetNightMode(t_U32 u32DeviceHandle,
                                                  tenVehicleConfiguration enVehicleConfiguration)
{
   m_enDayNightConfiguration = enVehicleConfiguration;
   spi_tclMySPINTADataIntf oTADataIntf;
   spi_tclMySPINTAVehicleDataIntf* poMySPINTAVehIntf = oTADataIntf.poGetTAVehDataIntfInst();

   if (NULL != poMySPINTAVehIntf)
   {
      t_Bool bIsNightMode = false;
      bIsNightMode = (e8_NIGHT_MODE == m_enDayNightConfiguration);
      poMySPINTAVehIntf->vSetNightMode(u32DeviceHandle,bIsNightMode);

   }

}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINCmdVehicleData::vSetVehicleBTMACAddress()
 ***************************************************************************/
t_Void spi_tclMySPINCmdVehicleData::vSetVehicleBTMACAddress(t_U32 u32DeviceHandle, t_String szVehicleBTAddress)
{
   spi_tclMySPINTADataIntf oTADataIntf;
   spi_tclMySPINTAVehicleDataIntf* poMySPINTAVehIntf = oTADataIntf.poGetTAVehDataIntfInst();

   if (NULL != poMySPINTAVehIntf)
   {
      poMySPINTAVehIntf->vSetVehicleBTMACAddress(u32DeviceHandle,szVehicleBTAddress);
   }

}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINCmdVehicleData::vSetVehicleManufactureInfo()
 ***************************************************************************/
t_Void spi_tclMySPINCmdVehicleData::vSetVehicleManufactureInfo(const t_U32 u32DeviceHandle, t_U16 u16VehicleType, t_String szVehicleManufacturerName, t_String szVehicleManufacturerScope)
{
   spi_tclMySPINTADataIntf oTADataIntf;
   spi_tclMySPINTAVehicleDataIntf* poMySPINTAVehIntf = oTADataIntf.poGetTAVehDataIntfInst();

   if (NULL != poMySPINTAVehIntf)
   {
       poMySPINTAVehIntf->vSetVehicleManufactureInfo(u32DeviceHandle, u16VehicleType, szVehicleManufacturerName, szVehicleManufacturerScope);
   }
}
/***************************************************************************
 ** FUNCTION:
 ***************************************************************************/
t_Void spi_tclMySPINCmdVehicleData::vSendPositionData(t_U32 u32DeviceHandle,t_String szNmeaSentence)
{
   spi_tclMySPINTADataIntf oTADataIntf;
   spi_tclMySPINTAVehicleDataIntf* poMySPINTAVehIntf = oTADataIntf.poGetTAVehDataIntfInst();

   if (NULL != poMySPINTAVehIntf)
   {
	  t_String szJsonString;
	  szJsonString = "{\"value\":\"" + szNmeaSentence + "\"}";
      poMySPINTAVehIntf->vSendVehicleData(u32DeviceHandle,MYSPIN_LOCATION_DATA_REQUEST,szJsonString);
   }
}
/***************************************************************************
 ** FUNCTION:
 ***************************************************************************/
t_Void spi_tclMySPINCmdVehicleData::vRegisterCallbacks(t_U32 u32DeviceHandle ,
                                                       tvVehicleDataRequestCb VehicleDataRequestCb,t_Bool bIsNativeNavigationEnabled)
{
   spi_tclMySPINTADataIntf oTADataIntf;
   spi_tclMySPINTAVehicleDataIntf* poMySPINTAVehIntf = oTADataIntf.poGetTAVehDataIntfInst();

   m_VehicleDataRequestCb = VehicleDataRequestCb;

   if (NULL != poMySPINTAVehIntf)
   {
      trVehicleDataCbs rVehicleDataCbs;
      rVehicleDataCbs.vVehicleDataRequestCb = &spi_tclMySPINCmdVehicleData::vVehicleDataRequestCallback;

      poMySPINTAVehIntf->vRegisterVehicleDataCbs(u32DeviceHandle,rVehicleDataCbs, bIsNativeNavigationEnabled);
   }
}
//lint -restore
