/***********************************************************************/
/*!
 * \file  spi_tclAAPSessionDispatcher.h
 * \brief Message Dispatcher for Session Messages. implemented using
 *       double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Session Messages
 AUTHOR:         tch5kor
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 03.12.2015  | tch5kor               | Initial Version

 \endverbatim
 *************************************************************************/

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/

#include "RespRegister.h"
#include "spi_tclMySPINSessionDispatcher.h"
#include "spi_tclMySPINRespSession.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
#include "trcGenProj/Header/spi_tclMySPINSessionDispatcher.cpp.trc.h"
#endif
#endif

//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(                               \
         DISPATCHER* poDispatcher)                          \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleSessionMsg(this);             \
   }                                                        \
   vDeAllocateMsg();                                        \
}


/***************************************************************************
 ** FUNCTION:  MySPINSessionMsgBase::MySPINSessionMsgBase
 ***************************************************************************/
MySPINSessionMsgBase::MySPINSessionMsgBase(): m_u32DeviceHandle(0)
{
   vSetServiceID (e32MODULEID_MYSPINSESSION);
}

/***************************************************************************
 ** FUNCTION:  AAPServiceDiscoveryMsg::AAPServiceDiscoveryMsg
 ***************************************************************************/
MySPINAppInactiveMsg::MySPINAppInactiveMsg() : m_bIsInActive(true)
{
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  AAPServiceDiscoveryMsg::AAPServiceDiscoveryMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(MySPINAppInactiveMsg, spi_tclMySPINSessionDispatcher);

/***************************************************************************
 ** FUNCTION:  MySPINAppInactiveMsg::vAllocateMsg
 ***************************************************************************/
t_Void MySPINAppInactiveMsg::vAllocateMsg()
{

}

/***************************************************************************
 ** FUNCTION:  MySPINAppInactiveMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void MySPINAppInactiveMsg::vDeAllocateMsg()
{

}

/***************************************************************************
 ** FUNCTION:  MySPINAppTransitionMsg::MySPINAppTransitionMsg
 ***************************************************************************/
MySPINAppTransitionMsg::MySPINAppTransitionMsg() : m_bIsActive(true)
{
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  MySPINAppTransitionMsg::MySPINAppTransitionMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(MySPINAppTransitionMsg, spi_tclMySPINSessionDispatcher);

/***************************************************************************
 ** FUNCTION:  MySPINAppTransitionMsg::vAllocateMsg
 ***************************************************************************/
t_Void MySPINAppTransitionMsg::vAllocateMsg()
{

}

/***************************************************************************
 ** FUNCTION:  MySPINAppTransitionMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void MySPINAppTransitionMsg::vDeAllocateMsg()
{

}

/***************************************************************************
 ** FUNCTION:  MySPINInitiateCallMsg::MySPINInitiateCallMsg
 ***************************************************************************/
MySPINInitiateCallMsg::MySPINInitiateCallMsg()
{
   memset(m_szTelephoneNumber,'\0',MAX_LENGTH);
   memset(m_szDisplayContent,'\0',MAX_LENGTH);
   
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  MySPINInitiateCallMsg::MySPINInitiateCallMsg
 ***************************************************************************/
MySPINInitiateCallMsg::~MySPINInitiateCallMsg()
{
   vDeAllocateMsg();
}
/***************************************************************************
 ** FUNCTION:  MySPINInitiateCallMsg::MySPINInitiateCallMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(MySPINInitiateCallMsg, spi_tclMySPINSessionDispatcher);

/***************************************************************************
 ** FUNCTION:  MySPINInitiateCallMsg::vAllocateMsg
 ***************************************************************************/
t_Void MySPINInitiateCallMsg::vAllocateMsg()
{

}

/***************************************************************************
 ** FUNCTION:  MySPINInitiateCallMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void MySPINInitiateCallMsg::vDeAllocateMsg()
{

}


/***************************************************************************
 ** FUNCTION:  MySPINBTProfileMsg::MySPINBTProfileMsg
 ***************************************************************************/
MySPINBTProfileMsg::MySPINBTProfileMsg() : m_bIsHFPConnected(false),
                                           m_bIsA2DPConnected(false)
{
   memset(m_szFriendlyName,'\0',MAX_LENGTH);
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  MySPINBTProfileMsg::MySPINBTProfileMsg
 ***************************************************************************/
MySPINBTProfileMsg::~MySPINBTProfileMsg()
{
   vDeAllocateMsg();
}
/***************************************************************************
 ** FUNCTION:  MySPINBTProfileMsg::MySPINBTProfileMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(MySPINBTProfileMsg, spi_tclMySPINSessionDispatcher);

/***************************************************************************
 ** FUNCTION:  MySPINBTProfileMsg::vAllocateMsg
 ***************************************************************************/
t_Void MySPINBTProfileMsg::vAllocateMsg()
{

}

/***************************************************************************
 ** FUNCTION:  MySPINBTProfileMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void MySPINBTProfileMsg::vDeAllocateMsg()
{

}

/***************************************************************************
 ** FUNCTION:  MySPINVoiceSessionMsg::MySPINVoiceSessionMsg
 ***************************************************************************/
MySPINVoiceSessionMsg::MySPINVoiceSessionMsg() : m_enMySPINVoiceSessionReq(e8VOICESESSION_REQUEST_UNKNOWN)
{
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  MySPINVoiceSessionMsg::MySPINVoiceSessionMsg
 ***************************************************************************/
MySPINVoiceSessionMsg::~MySPINVoiceSessionMsg()
{
   vDeAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  MySPINVoiceSessionMsg::MySPINVoiceSessionMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(MySPINVoiceSessionMsg, spi_tclMySPINSessionDispatcher);

/***************************************************************************
 ** FUNCTION:  MySPINBTProfileMsg::vAllocateMsg
 ***************************************************************************/
t_Void MySPINVoiceSessionMsg::vAllocateMsg()
{

}

/***************************************************************************
 ** FUNCTION:  MySPINVoiceSessionMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void MySPINVoiceSessionMsg::vDeAllocateMsg()
{

}

/***************************************************************************
 ** FUNCTION:  MySPINSessionErrorMsg::MySPINSessionErrorMsg
 ***************************************************************************/
MySPINSessionErrorMsg::MySPINSessionErrorMsg() : enErrorCode(e8MSPIN_ERROR_UNKNOWN)
{
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  MySPINSessionErrorMsg::MySPINSessionErrorMsg
 ***************************************************************************/
MySPINSessionErrorMsg::~MySPINSessionErrorMsg()
{
   vDeAllocateMsg();
}
/***************************************************************************
 ** FUNCTION:  MySPINSessionErrorMsg::MySPINSessionErrorMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(MySPINSessionErrorMsg, spi_tclMySPINSessionDispatcher);

/***************************************************************************
 ** FUNCTION:  MySPINBTProfileMsg::vAllocateMsg
 ***************************************************************************/
t_Void MySPINSessionErrorMsg::vAllocateMsg()
{

}

/***************************************************************************
 ** FUNCTION:  MySPINSessionErrorMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void MySPINSessionErrorMsg::vDeAllocateMsg()
{

}

/***************************************************************************
 ** FUNCTION:  MySPINPTTAvailable::MySPINPTTAvailable
 ***************************************************************************/
MySPINPTTAvailable::MySPINPTTAvailable() : m_bIsPTTAvail(false)
{
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  MySPINPTTAvailable::MySPINPTTAvailable
 ***************************************************************************/
MySPINPTTAvailable::~MySPINPTTAvailable()
{
   vDeAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  MySPINPTTAvailable::MySPINPTTAvailable
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(MySPINPTTAvailable, spi_tclMySPINSessionDispatcher);

/***************************************************************************
 ** FUNCTION:  MySPINPTTAvailable::vAllocateMsg
 ***************************************************************************/
t_Void MySPINPTTAvailable::vAllocateMsg()
{

}

/***************************************************************************
 ** FUNCTION:  MySPINPTTAvailable::vDeAllocateMsg
 ***************************************************************************/
t_Void MySPINPTTAvailable::vDeAllocateMsg()
{

}

/***************************************************************************
 ** FUNCTION:  MySPINBTStateUpdateMsg::MySPINBTStateUpdateMsg
 ***************************************************************************/
MySPINBTStateUpdateMsg::MySPINBTStateUpdateMsg()
{
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  MySPINBTStateUpdateMsg::MySPINBTStateUpdateMsg
 ***************************************************************************/
MySPINBTStateUpdateMsg::~MySPINBTStateUpdateMsg()
{
   vDeAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  MySPINBTStateUpdateMsg::MySPINBTStateUpdateMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(MySPINBTStateUpdateMsg, spi_tclMySPINSessionDispatcher);

/***************************************************************************
 ** FUNCTION:  MySPINBTStateUpdateMsg::vAllocateMsg
 ***************************************************************************/
t_Void MySPINBTStateUpdateMsg::vAllocateMsg()
{

}

/***************************************************************************
 ** FUNCTION:  MySPINBTStateUpdateMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void MySPINBTStateUpdateMsg::vDeAllocateMsg()
{

}

/***************************************************************************
 ** FUNCTION:  spi_tclAAPSessionDispatcher::spi_tclAAPSessionDispatcher
 ***************************************************************************/
spi_tclMySPINSessionDispatcher::spi_tclMySPINSessionDispatcher()
{
   ETG_TRACE_USR1((" spi_tclMySPINSessionDispatcher::spi_tclMySPINSessionDispatcher() entered \n"));
}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINSessionDispatcher::~spi_tclMySPINSessionDispatcher
 ***************************************************************************/
spi_tclMySPINSessionDispatcher::~spi_tclMySPINSessionDispatcher()
{
   ETG_TRACE_USR1((" spi_tclMySPINSessionDispatcher::~spi_tclMySPINSessionDispatcher() \n"));
}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINSessionDispatcher::vHandleSessionMsg(MySPINAppInactiveMsg* poDeviceInfoMsg)
 ***************************************************************************/
t_Void spi_tclMySPINSessionDispatcher::vHandleSessionMsg(MySPINAppInactiveMsg* poMySPINAppInactiveMsg) const
{
   ETG_TRACE_USR1((" spi_tclMySPINSessionDispatcher::vHandleSessionMsg(MySPINAppInactiveMsg* poMySPINAppInactiveMsg) \n"));
   if (NULL != poMySPINAppInactiveMsg)
   {
      CALL_REG_OBJECTS(spi_tclMySPINRespSession,
               e16MYSPIN_SESSION_REGID,
               vLauncherAppInactiveCb((poMySPINAppInactiveMsg->m_bIsInActive)));
   } // if (NULL != poDeviceInfoMsg)
}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINSessionDispatcher::vHandleSessionMsg(MySPINAppTransitionMsg* poDeviceInfoMsg)
 ***************************************************************************/
t_Void spi_tclMySPINSessionDispatcher::vHandleSessionMsg(MySPINAppTransitionMsg* poMySPINAppTransitionMsg) const
{
   ETG_TRACE_USR1((" spi_tclMySPINSessionDispatcher::vHandleSessionMsg(MySPINAppTransitionMsg* poMySPINAppTransitionMsg) \n"));
   if (NULL != poMySPINAppTransitionMsg)
   {
      CALL_REG_OBJECTS(spi_tclMySPINRespSession,
               e16MYSPIN_SESSION_REGID,
               vAppTransitionCb((poMySPINAppTransitionMsg->m_bIsActive)));
   } // if (NULL != poDeviceInfoMsg)
}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINSessionDispatcher::vHandleSessionMsg(MySPINInitiateCallMsg* poDeviceInfoMsg)
 ***************************************************************************/
t_Void spi_tclMySPINSessionDispatcher::vHandleSessionMsg(MySPINInitiateCallMsg* oMySPINInitiateCallMsg) const
{
   ETG_TRACE_USR1((" spi_tclMySPINSessionDispatcher::Initiate Call message entered"));
   if (NULL != oMySPINInitiateCallMsg)
   {
      CALL_REG_OBJECTS(spi_tclMySPINRespSession,
               e16MYSPIN_SESSION_REGID,
               vInitiateCallCb((oMySPINInitiateCallMsg->m_szTelephoneNumber),
                               (oMySPINInitiateCallMsg->m_szDisplayContent)));
   } // if (NULL != poDeviceInfoMsg)
}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINSessionDispatcher::vHandleSessionMsg(MySPINBTProfileMsg* poDeviceInfoMsg)
 ***************************************************************************/
t_Void spi_tclMySPINSessionDispatcher::vHandleSessionMsg(MySPINBTProfileMsg* oMySPINBTProfileMsg) const
{
   ETG_TRACE_USR1((" spi_tclMySPINSessionDispatcher::BT Profile message entered"));

   if (NULL != oMySPINBTProfileMsg)
   {
      CALL_REG_OBJECTS(spi_tclMySPINRespSession,
               e16MYSPIN_SESSION_REGID,
               vBTProfileInfoCb((oMySPINBTProfileMsg->u32GetDeviceHandle()),
                               (oMySPINBTProfileMsg->m_bIsHFPConnected),
                               (oMySPINBTProfileMsg->m_bIsA2DPConnected),
                               (oMySPINBTProfileMsg->m_szFriendlyName)));
   } // if (NULL != oMySPINBTProfileMsg)

}
/***************************************************************************
 ** FUNCTION:  spi_tclMySPINSessionDispatcher::vHandleSessionMsg(MySPINVoiceSessionMsg* poMySPINVoiceSessionMsg)
 ***************************************************************************/
t_Void spi_tclMySPINSessionDispatcher::vHandleSessionMsg(MySPINVoiceSessionMsg* oMySPINVoiceSessionMsg) const
{
   ETG_TRACE_USR1((" spi_tclMySPINSessionDispatcher::Voice session message entered"));

   if (NULL != oMySPINVoiceSessionMsg)
   {
      CALL_REG_OBJECTS(spi_tclMySPINRespSession,
               e16MYSPIN_SESSION_REGID,
               vVoiceSessionCb(oMySPINVoiceSessionMsg->m_enMySPINVoiceSessionReq));
   }

}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINSessionDispatcher::vHandleSessionMsg(MySPINSessionErrorMsg* poMySPINSessionErrorMsg)
 ***************************************************************************/
t_Void spi_tclMySPINSessionDispatcher::vHandleSessionMsg(MySPINSessionErrorMsg* poMySPINSessionErrorMsg) const
{
   ETG_TRACE_USR1((" Handle mySPIN Session Error Message"));

   if (NULL != poMySPINSessionErrorMsg)
   {
      CALL_REG_OBJECTS(spi_tclMySPINRespSession,
               e16MYSPIN_SESSION_REGID,
               vMySPINSessionErrorCb((poMySPINSessionErrorMsg->u32GetDeviceHandle()),(poMySPINSessionErrorMsg->enErrorCode)));
   }

}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINSessionDispatcher::vHandleSessionMsg(MySPINPTTAvailable* poMySPINPTTAvailMsg)
 ***************************************************************************/
t_Void spi_tclMySPINSessionDispatcher::vHandleSessionMsg(MySPINPTTAvailable* poMySPINPTTAvailMsg) const
{
   ETG_TRACE_USR1((" Handle mySPIN Session Error Message"));

   if (NULL != poMySPINPTTAvailMsg)
   {
      CALL_REG_OBJECTS(spi_tclMySPINRespSession,
               e16MYSPIN_SESSION_REGID,
               vMySPINPTTAvailableCb(poMySPINPTTAvailMsg->m_bIsPTTAvail));
   }

}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINSessionDispatcher::vHandleSessionMsg(MySPINBTStateUpdateMsg* poMySPINBTStateUpdateMsg)
 ***************************************************************************/
t_Void spi_tclMySPINSessionDispatcher::vHandleSessionMsg(MySPINBTStateUpdateMsg* poMySPINBTStateUpdateMsg) const
{
   ETG_TRACE_USR1((" Handle mySPIN BT State Update Message"));

   if (NULL != poMySPINBTStateUpdateMsg)
   {
      CALL_REG_OBJECTS(spi_tclMySPINRespSession,
               e16MYSPIN_SESSION_REGID,
               vPostBTStateUpdate());
   }

}
