/***********************************************************************/
/*!
 * \file  spi_tclMySPINSessionDispatcher.h
 * \brief Message Dispatcher for Session Messages. implemented using
 *       double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Session Messages
 AUTHOR:         tch5kor
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 03.12.2015  | tch5kor               | Initial Version
 11.04.2016  | Chaitra Srinivasa     | Adding comments

 \endverbatim
 *************************************************************************/
#ifndef SPI_TCLMYSPINSESSIONDISPATCHER_H_
#define SPI_TCLMYSPINSESSIONDISPATCHER_H_

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "mySPINTypes.h"
#include "RespRegister.h"

/**************Forward Declarations******************************************/
class spi_tclMySPINSessionDispatcher;

/****************************************************************************/
/*!
 * \class MySPINSessionMsgBase
 * \brief Base Message type for all Session messages
 ****************************************************************************/
class MySPINSessionMsgBase: public trMsgBase
{
   public:
      /***************************************************************************
       ** FUNCTION:  MySPINSessionMsgBase::MySPINSessionMsgBase
       ***************************************************************************/
      /*!
       * \fn      MySPINSessionMsgBase()
       * \brief   Default constructor
       **************************************************************************/
      MySPINSessionMsgBase();

      /***************************************************************************
       ** FUNCTION:  MySPINSessionMsgBase::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclMySPINSessionDispatcher* poSessionDispatcher)
       * \brief   Pure virtual function to be overridden by inherited classes for
       *          dispatching the message
       * \param poSessionDispatcher : pointer to Message dispatcher for Session
       * \retval t_Void
       **************************************************************************/
      virtual t_Void vDispatchMsg(spi_tclMySPINSessionDispatcher* poSessionDispatcher) = 0;

      /***************************************************************************
       ** FUNCTION:  MySPINSessionMsgBase::~MySPINSessionMsgBase
       ***************************************************************************/
      /*!
       * \fn      ~MySPINSessionMsgBase()
       * \brief   Destructor
       **************************************************************************/
      virtual ~MySPINSessionMsgBase()
      {

      }

      /***************************************************************************
       ** FUNCTION:  MySPINSessionMsgBase::u32GetDeviceHandle
       ***************************************************************************/
      /*!
       * \fn      u32GetDeviceHandle()
       * \brief   returns the device handle
       * \retval t_U32
       **************************************************************************/
      virtual t_U32 u32GetDeviceHandle()
      {
         return m_u32DeviceHandle;
      }

      /***************************************************************************
       ** FUNCTION:  MLSessionMsgBase::vSetDeviceHandle
       ***************************************************************************/
      /*!
       * \fn      vSetDeviceHandle()
       * \brief   sets the device handle
       * \retval t_Void
       **************************************************************************/
      virtual t_Void vSetDeviceHandle(const t_U32 cou32DevHndle)
      {
         m_u32DeviceHandle = cou32DevHndle;
      }
      ;

   private:
      t_U32 m_u32DeviceHandle;
};

/****************************************************************************/
/*!
 * \class MySPINAppInactiveMsg
 * \brief Session attestation response message
 ****************************************************************************/
class MySPINAppInactiveMsg: public MySPINSessionMsgBase
{
   public:
      t_Bool m_bIsInActive;

      /***************************************************************************
       ** FUNCTION:  MySPINAppInactiveMsg::MySPINAppInactiveMsg
       ***************************************************************************/
      /*!
       * \fn      MySPINAppInactiveMsg()
       * \brief   Default constructor
       **************************************************************************/
      MySPINAppInactiveMsg();

      /***************************************************************************
       ** FUNCTION:  MySPINAppInactiveMsg::~MySPINAppInactiveMsg
       ***************************************************************************/
      /*!
       * \fn      ~MySPINAppInactiveMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~MySPINAppInactiveMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  MySPINAppInactiveMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclMySPINSessionDispatcher* poSessionDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param  poSessionDispatcher : pointer to Message dispatcher for Session
       * \retval t_Void
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclMySPINSessionDispatcher* poSessionDispatcher);

      /***************************************************************************
       ** FUNCTION:  MySPINAppInactiveMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       * \retval  t_Void
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  MySPINAppInactiveMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       * \retval t_Void
       **************************************************************************/
      t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class MySPINAppTransitionMsg
 * \brief Session attestation response message
 ****************************************************************************/
class MySPINAppTransitionMsg: public MySPINSessionMsgBase
{
   public:
      t_Bool m_bIsActive;

      /***************************************************************************
       ** FUNCTION:  MySPINAppTransitionMsg::MySPINAppTransitionMsg
       ***************************************************************************/
      /*!
       * \fn      MySPINAppTransitionMsg()
       * \brief   Default constructor
       **************************************************************************/
      MySPINAppTransitionMsg();

      /***************************************************************************
       ** FUNCTION:  MySPINAppTransitionMsg::~MySPINAppTransitionMsg
       ***************************************************************************/
      /*!
       * \fn      ~MySPINAppTransitionMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~MySPINAppTransitionMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  MySPINAppTransitionMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclMySPINSessionDispatcher* poSessionDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param  poSessionDispatcher : pointer to Message dispatcher for Session
       * \retval t_Void
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclMySPINSessionDispatcher* poSessionDispatcher);

      /***************************************************************************
       ** FUNCTION:  MySPINAppTransitionMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       * \retval  t_Void
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  MySPINAppInactiveMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       * \retval  t_Void
       **************************************************************************/
      t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class MySPINInitiateCallMsg
 * \brief Session attestation response message
 ****************************************************************************/
class MySPINInitiateCallMsg: public MySPINSessionMsgBase
{
   public:
      t_Char m_szTelephoneNumber[MAX_LENGTH];
      t_Char m_szDisplayContent[MAX_LENGTH];

      /***************************************************************************
       ** FUNCTION:  MySPINInitiateCallMsg::MySPINInitiateCallMsg
       ***************************************************************************/
      /*!
       * \fn      MySPINInitiateCallMsg()
       * \brief   Default constructor
       **************************************************************************/
      MySPINInitiateCallMsg();

      /***************************************************************************
       ** FUNCTION:  MySPINInitiateCallMsg::~MySPINInitiateCallMsg
       ***************************************************************************/
      /*!
       * \fn      ~MySPINInitiateCallMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~MySPINInitiateCallMsg();

      /***************************************************************************
       ** FUNCTION:  MySPINInitiateCallMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclMySPINSessionDispatcher* poSessionDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poSessionDispatcher : pointer to Message dispatcher for Session
       * \retval  t_Void
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclMySPINSessionDispatcher* poSessionDispatcher);

      /***************************************************************************
       ** FUNCTION:  MySPINInitiateCallMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       * \retval  t_Void
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  MySPINInitiateCallMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       * \retval  t_Void
       **************************************************************************/
      t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class MySPINBTProfileMsg
 * \brief mySPIN BT Profile response message
 ****************************************************************************/
class MySPINBTProfileMsg: public MySPINSessionMsgBase
{
   public:
      t_Bool m_bIsHFPConnected;
      t_Bool m_bIsA2DPConnected;
      t_Char m_szFriendlyName[MAX_LENGTH];

      /***************************************************************************
       ** FUNCTION:  MySPINBTProfileMsg::MySPINBTProfileMsg
       ***************************************************************************/
      /*!
       * \fn      MySPINBTProfileMsg()
       * \brief   Default constructor
       **************************************************************************/
      MySPINBTProfileMsg();

      /***************************************************************************
       ** FUNCTION:  MySPINBTProfileMsg::~MySPINBTProfileMsg
       ***************************************************************************/
      /*!
       * \fn      ~MySPINBTProfileMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~MySPINBTProfileMsg();

      /***************************************************************************
       ** FUNCTION:  MySPINBTProfileMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclMySPINSessionDispatcher* poSessionDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param  poSessionDispatcher : pointer to Message dispatcher for Session
       * \retval t_Void
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclMySPINSessionDispatcher* poSessionDispatcher);

      /***************************************************************************
       ** FUNCTION:  MySPINBTProfileMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       * \retval t_Void
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  MySPINBTProfileMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       * \retval t_Void
       **************************************************************************/
      t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class MySPINVoiceSessionMsg
 * \brief Voice Session Info message
 ****************************************************************************/
class MySPINVoiceSessionMsg: public MySPINSessionMsgBase
{
   public:
      tenMySPINVoiceSessionReq m_enMySPINVoiceSessionReq;

      /***************************************************************************
       ** FUNCTION:  MySPINVoiceSessionMsg::MySPINVoiceSessionMsg
       ***************************************************************************/
      /*!
       * \fn      MySPINVoiceSessionMsg()
       * \brief   Default constructor
       **************************************************************************/
      MySPINVoiceSessionMsg();

      /***************************************************************************
       ** FUNCTION:  MySPINVoiceSessionMsg::~MySPINVoiceSessionMsg
       ***************************************************************************/
      /*!
       * \fn      ~MySPINVoiceSessionMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~MySPINVoiceSessionMsg();

      /***************************************************************************
       ** FUNCTION:  MySPINVoiceSessionMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclMySPINSessionDispatcher* poSessionDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param  poSessionDispatcher : pointer to Message dispatcher for Session
       * \retval t_Void
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclMySPINSessionDispatcher* poSessionDispatcher);

      /***************************************************************************
       ** FUNCTION:  MySPINVoiceSessionMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       * \retval t_Void
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  MySPINVoiceSessionMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void
      vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class MySPINSessionErrorMsg
 * \brief Voice Session Info message
 ****************************************************************************/
class MySPINSessionErrorMsg: public MySPINSessionMsgBase
{
   public:
      //Error Code
      tenMySPINError enErrorCode;

      /***************************************************************************
       ** FUNCTION:  MySPINSessionErrorMsg::MySPINSessionErrorMsg
       ***************************************************************************/
      /*!
       * \fn      MySPINSessionErrorMsg()
       * \brief   Default constructor
       **************************************************************************/
      MySPINSessionErrorMsg();

      /***************************************************************************
       ** FUNCTION:  MySPINSessionErrorMsg::~MySPINSessionErrorMsg
       ***************************************************************************/
      /*!
       * \fn      ~MySPINSessionErrorMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual
      ~MySPINSessionErrorMsg();

      /***************************************************************************
       ** FUNCTION:  MySPINSessionErrorMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclMySPINSessionDispatcher* poSessionDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param  poSessionDispatcher : pointer to Message dispatcher for Session
       **************************************************************************/
      t_Void
      vDispatchMsg(spi_tclMySPINSessionDispatcher* poSessionDispatcher);

      /***************************************************************************
       ** FUNCTION:  MySPINSessionErrorMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void
      vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  MySPINSessionErrorMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void
      vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class MySPINPTTAvailable
 * \brief PTT available status
 ****************************************************************************/
class MySPINPTTAvailable: public MySPINSessionMsgBase
{
   public:
      // PTT available status
      t_Bool m_bIsPTTAvail;

      /***************************************************************************
       ** FUNCTION:  MySPINPTTAvailable::MySPINPTTAvailable
       ***************************************************************************/
      /*!
       * \fn      MySPINPTTAvailable()
       * \brief   Default constructor
       **************************************************************************/
      MySPINPTTAvailable();

      /***************************************************************************
       ** FUNCTION:  MySPINPTTAvailable::~MySPINPTTAvailable
       ***************************************************************************/
      /*!
       * \fn      ~MySPINPTTAvailable()
       * \brief   Destructor
       **************************************************************************/
      virtual
      ~MySPINPTTAvailable();

      /***************************************************************************
       ** FUNCTION:  MySPINPTTAvailable::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclMySPINSessionDispatcher* poSessionDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param  poSessionDispatcher : pointer to Message dispatcher for Session
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclMySPINSessionDispatcher* poSessionDispatcher);

      /***************************************************************************
       ** FUNCTION:  MySPINPTTAvailable::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  MySPINPTTAvailable::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class MySPINBTStateUpdateMsg
 * \brief BT status response message
 ****************************************************************************/
class MySPINBTStateUpdateMsg: public MySPINSessionMsgBase
{
   public:
      /***************************************************************************
       ** FUNCTION:  MySPINBTStateUpdateMsg::MySPINAppTransitionMsg
       ***************************************************************************/
      /*!
       * \fn      MySPINAppTransitionMsg()
       * \brief   Default constructor
       **************************************************************************/
      MySPINBTStateUpdateMsg();

      /***************************************************************************
       ** FUNCTION:  MySPINBTStateUpdateMsg::~MySPINBTStateUpdateMsg
       ***************************************************************************/
      /*!
       * \fn      ~MySPINBTStateUpdateMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~MySPINBTStateUpdateMsg();

      /***************************************************************************
       ** FUNCTION:  MySPINBTStateUpdateMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclMySPINSessionDispatcher* poSessionDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param  poSessionDispatcher : pointer to Message dispatcher for Session
       * \retval t_Void
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclMySPINSessionDispatcher* poSessionDispatcher);

      /***************************************************************************
       ** FUNCTION:  MySPINBTStateUpdateMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       * \retval  t_Void
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  MySPINBTStateUpdateMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       * \retval  t_Void
       **************************************************************************/
      t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class spi_tclMySPINSessionDispatcher
 * \brief Message Dispatcher for Session Messages
 ****************************************************************************/
class spi_tclMySPINSessionDispatcher
{
   public:
      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINSessionDispatcher::spi_tclMySPINSessionDispatcher
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINSessionDispatcher()
       * \brief   Default constructor
       **************************************************************************/
      spi_tclMySPINSessionDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINSessionDispatcher::~spi_tclMySPINSessionDispatcher
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclMySPINSessionDispatcher()
       * \brief   Destructor
       **************************************************************************/
      ~spi_tclMySPINSessionDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINSessionDispatcher::vHandleSessionMsg(MySPINAppInactiveMsg* poMySPINAppInactiveMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleSessionMsg(MySPINAppInactiveMsg* poMySPINAppInactiveMsg)
       * \brief   Handles Messages of MySPINAppInactiveMsg type
       * \param   poLaunchSessionMsg : pointer to AAPServiceDiscoveryMsg.
       * \retval  t_Void
       **************************************************************************/
      t_Void vHandleSessionMsg(MySPINAppInactiveMsg* poMySPINAppInactiveMsg) const;

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINSessionDispatcher::vHandleSessionMsg(MySPINAppTransitionMsg* poMySPINAppInactiveMsg)
       ***************************************************************************/
      /*!
       * \fn     vHandleSessionMsg(MySPINAppInactiveMsg* poMySPINAppInactiveMsg)
       * \brief  Handles Messages of MySPINAppInactiveMsg type
       * \param  poLaunchSessionMsg : pointer to AAPServiceDiscoveryMsg.
       * \retval t_Void
       **************************************************************************/
      t_Void vHandleSessionMsg(MySPINAppTransitionMsg* poMySPINAppTransitionMsg) const;

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINSessionDispatcher::vHandleSessionMsg(MySPINInitiateCallMsg* poMySPINInitiateCallMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleSessionMsg(MySPINInitiateCallMsg* poMySPINInitiateCallMsg)
       * \brief   Handles Messages of MySPINIncomingCallMsg type
       * \param   poLaunchSessionMsg : pointer to MySPINIncomingCallMsg.
       * \retval  t_Void
       **************************************************************************/
      t_Void vHandleSessionMsg(MySPINInitiateCallMsg* poMySPINInitiateCallMsg) const;

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINSessionDispatcher::vHandleSessionMsg(MySPINBTProfileMsg* poMySPINBTProfileMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleSessionMsg(MySPINBTProfileMsg* poMySPINBTProfileMsg)
       * \brief   Handles Messages of MySPINBTProfileMsg type
       * \param   poMySPINBTProfileMsg : pointer to MySPINBTProfileMsg.
       * \retval  t_Void
       **************************************************************************/
      t_Void vHandleSessionMsg(MySPINBTProfileMsg* poMySPINBTProfileMsg) const;

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINSessionDispatcher::vHandleSessionMsg(MySPINVoiceSessionMsg* poMySPINVoiceSessionMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleSessionMsg(MySPINVoiceSessionMsg* poMySPINVoiceSessionMsg)
       * \brief   Handles Messages of MySPINVoiceSessionMsg type
       * \param   poMySPINVoiceSessionMsg : pointer to MySPINVoiceSessionMsg.
       * \retval  t_Void
       **************************************************************************/
      t_Void vHandleSessionMsg(MySPINVoiceSessionMsg* poMySPINVoiceSessionMsg) const;

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINSessionDispatcher::vHandleSessionMsg(MySPINSessionErrorMsg* poMySPINSessionErrorMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleSessionMsg(MySPINSessionErrorMsg* poMySPINSessionErrorMsg)
       * \brief   Handles Messages of MySPINSessionErrorMsg type
       * \param   poMySPINSessionErrorMsg : pointer to MySPINSessionErrorMsg.
       **************************************************************************/
      t_Void vHandleSessionMsg(MySPINSessionErrorMsg* poMySPINSessionErrorMsg) const;
      
      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINSessionDispatcher::vHandleSessionMsg(MySPINPTTAvailable* poMySPINPTTAvailMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleSessionMsg(MySPINPTTAvailable* poMySPINPTTAvailMsg)
       * \brief   Handles Messages of MySPINPTTAvailable type
       * \param   poMySPINPTTAvailMsg : pointer to MySPINPTTAvailable.
       **************************************************************************/
      t_Void vHandleSessionMsg(MySPINPTTAvailable* poMySPINPTTAvailMsg) const;

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINSessionDispatcher::vHandleSessionMsg(MySPINBTStateUpdateMsg* poMySPINBTStateUpdateMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleSessionMsg(MySPINBTStateUpdateMsg* poMySPINBTStateUpdateMsg)
       * \brief   Handles Messages of MySPINBTStateUpdateMsg type
       * \param   poMySPINBTStateUpdateMsg : pointer to MySPINBTStateUpdate.
       **************************************************************************/
      t_Void vHandleSessionMsg(MySPINBTStateUpdateMsg* poMySPINBTStateUpdateMsg) const;
};

#endif /* SPI_TCLAAPSessionDISPATCHER_H_ */
