/***********************************************************************/
/*!
 * \file  spi_tclMySPINCmdInput.h
 * \brief  Implementation of the Class spi_tclMySPINCmdInput
 *************************************************************************
 \verbatim


 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:
 AUTHOR:         tch5kor
 COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH
 HISTORY:
 Date        | Author                | Modification
 11.04.2016  | Chaitra Srinivasa     | Adding comments

 \endverbatim
 *************************************************************************/

#include "mySPINTypes.h"

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

typedef struct
{
      tenKeyCode enKeyCode;
      tenMySPINKeyCode enMySPINKeyCode;

} trMySPINKeys;
typedef struct
{
      tenKeyCode enKeyCode;
      tenMySPINCustomKeyCode enMySPINCustomKeyCode;

} trMySPINCustKeys;
/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/

class spi_tclMySPINCmdInput
{

   public:

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdInput::spi_tclMySPINCmdInput()
       ***************************************************************************/
      /*!
       * \fn    spi_tclMySPINCmdInput()
       * \brief Constructor for spi_tclMySPINCmdInput class
       **************************************************************************/
      spi_tclMySPINCmdInput();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdInput::~spi_tclMySPINCmdInput
       ***************************************************************************/
      /*!
       * \fn    ~spi_tclMySPINCmdInput()
       * \brief Destructor for spi_tclMySPINCmdInput class
       **************************************************************************/
      virtual ~spi_tclMySPINCmdInput();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdInput::t_Bool bInitialize()
       ***************************************************************************/
      /*!
       * \fn    t_Bool bInitialize()
       * \brief Method used for initialization
       * \retval t_Bool
       **************************************************************************/
      t_Bool bInitialize();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdInput::t_Bool vUninitialize()
       ***************************************************************************/
      /*!
       * \fn    t_Void vUninitialize()
       * \brief Method used for uninitialization
       * \retval t_Void
       **************************************************************************/
      t_Void vUninitialize();

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdInput::t_Void vSendKeyEvent(...)
       ***************************************************************************/
      /*!
       * \fn    t_Void vSendKeyEvent(t_U32 u32DeviceHandle,
       *                             tenKeyMode enKeyMode,
       *                             tenKeyCode enKeyCode)
       * \brief Method to send a key event
       * \param u32DeviceHandle: [IN]Device handle
       * \param enKeyMode: [IN]Used for storing key mode
       * \param enKeyCode: [IN]Used for storing key code
       * \retval t_Void
       **************************************************************************/
      t_Void vSendKeyEvent(t_U32 u32DeviceHandle, tenKeyMode enKeyMode, tenKeyCode enKeyCode);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdInput::t_U32 vGetSupportedKeys()
       ***************************************************************************/
      /*!
       * \fn    t_U32 vGetSupportedKeys(t_U32 u32DeviceHandle)
       * \brief Method for getting supported keys
       * \param u32DeviceHandle: [IN]Device handle
       * \retval t_U32
       **************************************************************************/
      t_U32 vGetSupportedKeys(t_U32 u32DeviceHandle);
      

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdInput::t_Void vSendCustomKeyEvent()
       ***************************************************************************/
      /*!
       * \fn    t_Void vSendCustomKeyEvent(t_U32 u32DeviceHandle, 
       *                          tenMySPINCustomKeyMode enCustomKeyMode, 
       *                          tenKeyCode enKeyCode)
       * \brief Method for sending custom keys
       * \param u32DeviceHandle: [IN]Device handle
       * \param enCustomKeyMode: [IN]Custom key mode(myspin)
       * \param enKeyCode:       [IN]Key code
       * \retval t_Void
       **************************************************************************/      
      t_Void vSendCustomKeyEvent(t_U32 u32DeviceHandle, 
                                 tenMySPINCustomKeyMode enCustomKeyMode, 
                                 tenKeyCode enKeyCode);

      /***************************************************************************
       ** FUNCTION: spi_tclMySPINCmdInput::t_Void vSendKnobKeyEvent()
       ***************************************************************************/
      /*!
       * \fn    t_Void vSendKnobKeyEvent(t_U32 u32DeviceHandle, t_S8 s8EncoderDeltaCnt)
       * \brief Method for sending custom keys
       * \param u32DeviceHandle: [IN]Device handle
       * \param s8EncoderDeltaCount: [IN] encoder delta count
       * \retval t_Void
       **************************************************************************/
      t_Void vSendKnobKeyEvent(t_U32 u32DeviceHandle, t_S8 s8EncoderDeltaCnt);

   private:

      //! map between SPI keys and mySPIN keys
      std::map<tenKeyCode, tenMySPINKeyCode> m_MySPINKeyMap;
      
      //! map between SPI keys and myspin custom keys
      std::map<tenKeyCode, tenMySPINCustomKeyCode> m_MySPINCustomKeyMap;      
};

