/***********************************************************************/
/*!
* \file  spi_tclAOAPCmdDiscoverer.h
* \brief  Implementation of the Class spi_tclAOAPCmdDiscoverer
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         tch5kor
COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
11.04.2016  |Chaitra Srinivasa      | Adding comments

\endverbatim
*************************************************************************/

#ifndef _SPI_TCLAOAPCMDDISCOVERER_H_
#define _SPI_TCLAOAPCMDDISCOVERER_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "spi_usb_discoverer_types.h"
#include "spi_usb_discoverer.h"

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

class spi_tclAOAPCmdDiscoverer
{

public:

   /***************************************************************************
   ** FUNCTION: spi_tclAOAPCmdDiscoverer::spi_tclAOAPCmdDiscoverer()
   ***************************************************************************/
   /*!
   * \fn    spi_tclAOAPCmdDiscoverer()
   * \brief Constructor for spi_tclAOAPCmdDiscoverer class
   **************************************************************************/
   spi_tclAOAPCmdDiscoverer();

   /***************************************************************************
   ** FUNCTION: spi_tclAOAPCmdDiscoverer::~spi_tclAOAPCmdDiscoverer()
   ***************************************************************************/
   /*!
   * \fn    ~spi_tclAOAPCmdDiscoverer()
   * \brief Destructor for spi_tclAOAPCmdDiscoverer class
   **************************************************************************/
   virtual ~spi_tclAOAPCmdDiscoverer();

   /***************************************************************************
   ** FUNCTION: spi_tclAOAPCmdDiscoverer::t_Bool bInitialize()
   ***************************************************************************/
   /*!
   * \fn    t_Bool bInitialize()
   * \brief Method used for initialization
   * \retval t_Bool
   **************************************************************************/
   t_Bool bInitialize();

   /***************************************************************************
   ** FUNCTION: spi_tclAOAPCmdDiscoverer::t_Void vUnInitialize()
   ***************************************************************************/
   /*!
   * \fn    t_Void vUnInitialize()
   * \brief Method used for uninitializing
   * \retval t_Void
   **************************************************************************/
   t_Void vUnInitialize();

   /***************************************************************************
   ** FUNCTION: spi_tclAOAPCmdDiscoverer::t_Bool bStartDeviceDiscovery()
   ***************************************************************************/
   /*!
   * \fn    t_Bool bStartDeviceDiscovery()
   * \brief Method to start the discovery of a device
   * \retval t_Bool
   **************************************************************************/
   t_Bool bStartDeviceDiscovery();

   /***************************************************************************
   ** FUNCTION: spi_tclAOAPCmdDiscoverer::t_Void vStopDeviceDiscovery()
   ***************************************************************************/
   /*!
   * \fn    t_Void vStopDeviceDiscovery()
   * \brief Method to stop the discovery of device
   * \retval t_Void
   **************************************************************************/
   t_Void vStopDeviceDiscovery();


   private:
   /***************************************************************************
   ** FUNCTION: spi_tclAOAPCmdDiscoverer::t_Void vCopyUSBDeviceInfo(...)
   ***************************************************************************/
   /*!
   * \fn    t_Void vCopyUSBDeviceInfo(trMySPINUSBDeviceInfo &rfrUSBDeviceInfo,
   *                                const  t_usbDeviceInformation *prUSBDevInfo)
   * \brief Mthod to copy the USB device information
   * \param rfrUSBDeviceInfo: [IN]structure for MySPIN USB device info
   * \param prUSBDevInfo: [IN]pointer for USB device info
   * \retval t_Void
   **************************************************************************/
   t_Void vCopyUSBDeviceInfo(trMySPINUSBDeviceInfo &rfrUSBDeviceInfo,
                      const  t_usbDeviceInformation *prUSBDevInfo);

   /***************************************************************************
   ** FUNCTION: spi_tclAOAPCmdDiscoverer::t_Void vAOAPEntityAppearedCb(...)
   ***************************************************************************/
   /*!
   * \fn    t_Void vAOAPEntityAppearedCb(t_Void *pContext,
   *                                   t_usbDeviceInformation *prUSBDevInfo,
   *                                   t_S32 s32Result)
   * \brief Call back for AOAP entity appearance
   * \param pContext: [IN]Pointer for context
   * \param prUSBDevInfo: [IN]Pointer for USB device info
   * \param s32Result: [IN]String for result
   * \retval t_Void
   **************************************************************************/
   static t_Void vAOAPEntityAppearedCb(t_Void *pContext,
                                       t_usbDeviceInformation *prUSBDevInfo,
                                       t_S32 s32Result);

   /***************************************************************************
   ** FUNCTION: spi_tclAOAPCmdDiscoverer::t_Void vUSBEntityAppearedCb(...)
   ***************************************************************************/
   /*!
   * \fn    t_Void vUSBEntityAppearedCb(t_Void *pContext,
   *                                    t_usbDeviceInformation *prUSBDevInfo,
   *                                    t_S32 s32Result
   * \brief Call back for USB entity appearance
   * \param pContext: [IN]Pointer for context
   * \param prUSBDevInfo: [IN]Pointer for USB device info
   * \param s32Result: [IN]String for result
   * \retval t_Void
   **************************************************************************/
   static t_Void vUSBEntityAppearedCb(t_Void *pContext,
                                      t_usbDeviceInformation *prUSBDevInfo,
                                      t_S32 s32Result);

   /***************************************************************************
   ** FUNCTION: spi_tclAOAPCmdDiscoverer::t_Void vUSBEntityDisappearedCb(...)
   ***************************************************************************/
   /*!
   * \fn    t_Void vUSBEntityDisappearedCb(t_Void *pContext,
   *                                       t_usbDeviceInformation *prUSBDevInfo,
   *                                       t_S32 s32Result)
   * \brief Call back for USB entity disappearance
   * \param pContext: [IN]Pointer for context
   * \param prUSBDevInfo: [IN]Pointer for USB device info
   * \param s32Result: [IN]String for result
   * \retval t_Void
   **************************************************************************/
   static t_Void vUSBEntityDisappearedCb(t_Void *pContext,
                                         t_usbDeviceInformation *prUSBDevInfo,
                                         t_S32 s32Result);

   /***************************************************************************
   ** FUNCTION: spi_tclAOAPCmdDiscoverer::t_U32 u32GenerateUniqueDeviceID(...)
   ***************************************************************************/
   /*!
   * \fn    t_U32 u32GenerateUniqueDeviceID(trMySPINUSBDeviceInfo &rfrUSBDeviceInfo)
   * \brief Method to generate a unique device ID
   * \param rfrUSBDeviceInfo: [IN]Structure for USB device info
   * \retval t_Void
   **************************************************************************/
   t_U32 u32GenerateUniqueDeviceID(trMySPINUSBDeviceInfo &rfrUSBDeviceInfo);

   /***************************************************************************
   ** FUNCTION: spi_tclAOAPCmdDiscoverer:: t_Void vCheckOTGPort(...)
   ***************************************************************************/
   /*!
   * \fn    t_Void vCheckOTGPort(trMySPINUSBDeviceInfo& rfrUSBDeviceInfo)
   * \brief Method to check the OTG port
   * \param rfrUSBDeviceInfo: [IN]Structure for USB device info
   * \retval t_Void
   **************************************************************************/
   t_Void vCheckOTGPort(trMySPINUSBDeviceInfo& rfrUSBDeviceInfo);

   //! Discoverer pointer
   AOAP::UsbDiscoverer *m_poDiscoverer;

   std::map<t_U32, trMySPINUSBDeviceInfo> m_mapMySPINDeviceInfo;

};

#endif // #ifndef _SPI_TCLAOAPCMDDISCOVERER_H_
