/***********************************************************************/
/*!
* \file  spi_tclMySPINMsgQThreadable.h
* \brief implements threading based on MsgQthreader for AAP Wrappers
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    implements threading based on MsgQthreader for AAP Wrappers
AUTHOR:         gri2kor
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification


\endverbatim
*************************************************************************/

#ifndef SPI_TCLMYSPINMSGQTHREADER_H_
#define SPI_TCLMYSPINMSGQTHREADER_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "MsgQThreadable.h"
#include "spi_tclAOAPDiscovererDispatcher.h"
#include "spi_tclMySPINVideoDispatcher.h"
#include "spi_tclMySPINSessionDispatcher.h"
#include "spi_tclMySPINAudioDispatcher.h"


using namespace shl::thread;

/****************************************************************************/
/*!
* \class spi_tclMySPINMsgQThreadable
* \brief implements threading based on MsgQthreader for AAP Wrappers
*
* Responsible for calling the respective dispatchers and to allocate memory
* when a message arrives on Q
*
****************************************************************************/

class spi_tclMySPINMsgQThreadable : public MsgQThreadable
{
   public:

      /***************************************************************************
      ** FUNCTION:  spi_tclMySPINMsgQThreadable::spi_tclMySPINMsgQThreadable()
      ***************************************************************************/
      /*!
      * \fn      spi_tclMySPINMsgQThreadable()
      * \brief   Default Constructor
      * \sa      ~spi_tclMySPINMsgQThreadable()
      **************************************************************************/
      spi_tclMySPINMsgQThreadable();

      /***************************************************************************
      ** FUNCTION:  spi_tclMySPINMsgQThreadable::~spi_tclMySPINMsgQThreadable()
      ***************************************************************************/
      /*!
      * \fn      ~spi_tclMySPINMsgQThreadable()
      * \brief   Destructor
      * \sa      spi_tclMySPINMsgQThreadable()
      **************************************************************************/
      ~spi_tclMySPINMsgQThreadable();

   protected:
      /***************************************************************************
      ** FUNCTION:  spi_tclMySPINMsgQThreadable::vExecute
      ***************************************************************************/
      /*!
      * \fn      t_Void vExecute(tShlMessage *poMessage)
      * \brief   Responsible for posting the message to respective dispatchers
      * \param   poMessage : message received from MsgQ for dispatching
      * \retval  t_Void
      **************************************************************************/
      virtual t_Void vExecute(tShlMessage *poMessage);

      /***************************************************************************
      ** FUNCTION:  spi_tclMySPINMsgQThreadable::tShlMessage* poGetMsgBuffer(size_t )
      ***************************************************************************/
      /*!
      * \fn      tShlMessage* poGetMsgBuffer(size_t )
      * \brief  This function will be called for requesting the storage allocation for received
      *           message
      * \param siBuffer: size of the buffer to be allocated for the received message
      * \retval tShlMessage
      **************************************************************************/
      virtual tShlMessage* poGetMsgBuffer(size_t siBuffer);

   private:
   
      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINMsgQThreadable(const spi_tclMySPINMsgQThreadable...
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINMsgQThreadable(
       *                             const spi_tclMySPINMsgQThreadable& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclMySPINMsgQThreadable()
       ***************************************************************************/
       spi_tclMySPINMsgQThreadable(const spi_tclMySPINMsgQThreadable& corfoSrc);


      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINMsgQThreadable& operator=( const spi_tclAAP...
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINMsgQThreadable& operator=(
       *                          const spi_tclMySPINMsgQThreadable& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclMySPINMsgQThreadable(const spi_tclMySPINMsgQThreadable& otrSrc)
       ***************************************************************************/
       spi_tclMySPINMsgQThreadable& operator=(const spi_tclMySPINMsgQThreadable& corfoSrc);   
   
      //! Pointer to Video dispatcher
      spi_tclMySPINVideoDispatcher* m_poMySPINVideoDispatcher;

      //!Pointer to Session dispatcher
      spi_tclMySPINSessionDispatcher* m_poMySPINSessionDispatcher;

      //!Pointer to Session dispatcher
      spi_tclMySPINAudioDispatcher* m_poMySPINAudioDispatcher;

};


#endif /* SPI_TCLMYSPINMSGQTHREADER_H_ */
