/***********************************************************************/
/*!
 * \file   spi_tclMySPINManager.h
 * \brief  Implementation of the Class spi_tclMySPINManager
 *************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:
 AUTHOR:         gri2kor
 COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH
 HISTORY:
 Date            | Author                | Modification

 \endverbatim
 *************************************************************************/

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "mySPINTypes.h"
#include "spi_tclMySPINManager.h"

#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MYSPINWRAPPER
#include "trcGenProj/Header/spi_tclMySPINManager.cpp.trc.h"
#endif
#endif

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/
/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/
/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/
/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/
tenDeviceSubCategory spi_tclMySPINManager::m_enDeviceSubCategory = e8DEVTYPE_UNKNWON;
tenSessionStatus spi_tclMySPINManager::m_enSessionStatus = e8_SESSION_UNKNOWN;
t_U32 spi_tclMySPINManager::m_u32DeviceHandle = 0;
t_Bool spi_tclMySPINManager::m_bIsHFP = false;
t_String spi_tclMySPINManager::m_szBTAddr;

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINManager::spi_tclMySPINManager()
 ***************************************************************************/
spi_tclMySPINManager::spi_tclMySPINManager() :
   m_poCmdDiscoverer(NULL), m_poCmdAudio(NULL), m_poCmdInput(NULL), m_poCmdSession(NULL), m_poCmdVehicleData(NULL),
            m_poCmdVideo(NULL)
{
   ETG_TRACE_USR1(("spi_tclMySPINManager::spi_tclMySPINManager()"));

   m_poCmdSession = new (std::nothrow) spi_tclMySPINCmdSession();
   SPI_NORMAL_ASSERT(NULL == m_poCmdSession);

   m_poCmdVideo = new (std::nothrow) spi_tclMySPINCmdVideo();
   SPI_NORMAL_ASSERT(NULL == m_poCmdVideo);

   m_poCmdInput = new (std::nothrow) spi_tclMySPINCmdInput();
   SPI_NORMAL_ASSERT(NULL == m_poCmdInput);

   m_poCmdAudio = new (std::nothrow) spi_tclMySPINCmdAudio();
   SPI_NORMAL_ASSERT(NULL == m_poCmdAudio);

   m_poCmdVehicleData = new (std::nothrow) spi_tclMySPINCmdVehicleData();
   SPI_NORMAL_ASSERT(NULL == m_poCmdVehicleData);

}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINManager::~spi_tclMySPINManager()
 ***************************************************************************/
spi_tclMySPINManager::~spi_tclMySPINManager()
{
   ETG_TRACE_USR1(("spi_tclMySPINManager::~spi_tclMySPINManager()"));

   RELEASE_MEM(m_poCmdVehicleData);
   RELEASE_MEM(m_poCmdAudio);
   RELEASE_MEM(m_poCmdInput);
   RELEASE_MEM(m_poCmdVideo);
   RELEASE_MEM(m_poCmdSession);
   RELEASE_MEM(m_poCmdDiscoverer);
}

/***************************************************************************
 ** FUNCTION: spi_tclMySPINCmdAudio* spi_tclMySPINManager::poGetAudioInstance()
 ***************************************************************************/
spi_tclMySPINCmdAudio* spi_tclMySPINManager::poGetAudioInstance()
{
   ETG_TRACE_USR1(("spi_tclMySPINManager::poGetAudioInstance()"));

   return m_poCmdAudio;
}

/***************************************************************************
 ** FUNCTION: spi_tclAOAPCmdDiscoverer* spi_tclMySPINManager::poGetDiscInstance()
 ***************************************************************************/
spi_tclAOAPCmdDiscoverer* spi_tclMySPINManager::poGetDiscInstance()
{
   ETG_TRACE_USR1(("spi_tclMySPINManager::poGetDiscInstance()"));

   return m_poCmdDiscoverer;
}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINCmdInput* spi_tclMySPINManager::poGetInputInstance()
 ***************************************************************************/
spi_tclMySPINCmdInput* spi_tclMySPINManager::poGetInputInstance()
{
   ETG_TRACE_USR1(("spi_tclMySPINManager::poGetInputInstance()"));

   return m_poCmdInput;
}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINCmdSession* spi_tclMySPINManager::poGetSessionInstance()
 ***************************************************************************/
spi_tclMySPINCmdSession* spi_tclMySPINManager::poGetSessionInstance()
{
   ETG_TRACE_USR1(("spi_tclMySPINManager::poGetSessionInstance()"));

   return m_poCmdSession;
}

/***************************************************************************
 ** FUNCTION: spi_tclMySPINCmdVehicleData* spi_tclMySPINManager::poGetVehDataInstance()
 ***************************************************************************/
spi_tclMySPINCmdVehicleData* spi_tclMySPINManager::poGetVehDataInstance()
{
   ETG_TRACE_USR1(("spi_tclMySPINManager::poGetVehDataInstance()"));

   return m_poCmdVehicleData;
}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINCmdVideo* spi_tclMySPINManager::poGetVideoInstance()
 ***************************************************************************/
spi_tclMySPINCmdVideo* spi_tclMySPINManager::poGetVideoInstance()
{
   ETG_TRACE_USR1(("spi_tclMySPINManager::poGetVideoInstance()"));

   return m_poCmdVideo;
}

/***************************************************************************
 ** FUNCTION: t_Bool spi_tclMySPINManager::bRegisterObject()
 ***************************************************************************/
t_Bool spi_tclMySPINManager::bRegisterObject(RespBase *poRespBase)
{
   ETG_TRACE_USR1(("spi_tclMySPINManager::bRegisterObject  Entered "));
   RespRegister *pRespRegister = RespRegister::getInstance();
   t_Bool bRetReg = false;
   if (NULL != pRespRegister)
   {
      bRetReg = pRespRegister->bRegisterObject(poRespBase);
   }
   return bRetReg;
}

/***************************************************************************
 ** FUNCTION: t_Bool spi_tclMySPINManager::bUnRegisterObject()
 ***************************************************************************/
t_Bool spi_tclMySPINManager::bUnRegisterObject(RespBase *poRespBase)
{
   ETG_TRACE_USR1(("spi_tclMySPINManager::bUnRegisterObject  Entered"));
   RespRegister *pRespRegister = RespRegister::getInstance();
   t_Bool bRetReg = false;
   if (NULL != pRespRegister)
   {
      bRetReg = pRespRegister->bUnregisterObject(poRespBase);
   }
   return bRetReg;
}
