/***********************************************************************/
/*!
 * \file  spi_tclAAPSessionDispatcher.h
 * \brief Message Dispatcher for Session Messages. implemented using
 *       double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Session Messages
 AUTHOR:         tch5kor
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 03.12.2015  | tch5kor               | Initial Version

 \endverbatim
 *************************************************************************/

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/

#include "RespRegister.h"
#include "spi_tclMySPINAudioDispatcher.h"
#include "spi_tclMySPINRespAudio.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
#include "trcGenProj/Header/spi_tclMySPINAudioDispatcher.cpp.trc.h"
#endif
#endif

//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(                               \
         DISPATCHER* poDispatcher)                          \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleSessionMsg(this);             \
   }                                                        \
   vDeAllocateMsg();                                        \
}


/***************************************************************************
 ** FUNCTION:  MySPINAudioMsgBase::MySPINAudioMsgBase
 ***************************************************************************/
MySPINAudioMsgBase::MySPINAudioMsgBase(): m_u32DeviceHandle(0)
{
   vSetServiceID (e32MODULEID_MYSPINAUDIO);
}

/***************************************************************************
 ** FUNCTION:  MySPINAudioCmdMsg::MySPINAudioCmdMsg
 ***************************************************************************/
MySPINAudioCmdMsg::MySPINAudioCmdMsg() :
         m_enCommand(e8COMMAND_REQUEST), m_u32RequestID(0), m_enAudioType(e8_AUDIOTYPE_IGNORE)
{
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  AAPServiceDiscoveryMsg::AAPServiceDiscoveryMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(MySPINAudioCmdMsg, spi_tclMySPINAudioDispatcher);

/***************************************************************************
 ** FUNCTION:  MySPINAudioCmdMsg::vAllocateMsg
 ***************************************************************************/
t_Void MySPINAudioCmdMsg::vAllocateMsg()
{

}

/***************************************************************************
 ** FUNCTION:  MySPINAudioCmdMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void MySPINAudioCmdMsg::vDeAllocateMsg()
{

}

/***************************************************************************
 ** FUNCTION:  MySPINVRStreamErrorMsg::MySPINVRStreamErrorMsg
 ***************************************************************************/
MySPINVRStreamErrorMsg::MySPINVRStreamErrorMsg() : m_enError(e8MYSPIN_VR_STREAM_ERROR_UNKNOWN)
{
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  MySPINVRStreamErrorMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(MySPINVRStreamErrorMsg, spi_tclMySPINAudioDispatcher);

/***************************************************************************
 ** FUNCTION:  MySPINVRStreamErrorMsg::vAllocateMsg
 ***************************************************************************/
t_Void MySPINVRStreamErrorMsg::vAllocateMsg()
{

}

/***************************************************************************
 ** FUNCTION:  MySPINVRStreamErrorMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void MySPINVRStreamErrorMsg::vDeAllocateMsg()
{

}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINAudioDispatcher::spi_tclMySPINAudioDispatcher
 ***************************************************************************/
spi_tclMySPINAudioDispatcher::spi_tclMySPINAudioDispatcher()
{
   ETG_TRACE_USR1((" spi_tclMySPINAudioDispatcher::spi_tclMySPINAudioDispatcher() entered \n"));
}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINAudioDispatcher::~spi_tclMySPINAudioDispatcher
 ***************************************************************************/
spi_tclMySPINAudioDispatcher::~spi_tclMySPINAudioDispatcher()
{
   ETG_TRACE_USR1((" spi_tclMySPINAudioDispatcher::~spi_tclMySPINAudioDispatcher() \n"));
}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINAudioDispatcher::vHandleSessionMsg(MySPINAudioCmdMsg* poMySPINAudioCmdMsg)
 ***************************************************************************/
t_Void spi_tclMySPINAudioDispatcher::vHandleSessionMsg(MySPINAudioCmdMsg* poMySPINAudioCmdMsg) const
{
   ETG_TRACE_USR1((" spi_tclMySPINAudioDispatcher::vHandleSessionMsg(MySPINAudioCmdMsg* poMySPINAudioCmdMsg) \n"));
   if (NULL != poMySPINAudioCmdMsg)
   {
      CALL_REG_OBJECTS(spi_tclMySPINRespAudio,
               e16MYSPIN_AUDIO_REGID,
               vAudioRequestCb((poMySPINAudioCmdMsg->u32GetDeviceHandle()),
                                (poMySPINAudioCmdMsg->m_enCommand), (poMySPINAudioCmdMsg->m_u32RequestID),
                                (poMySPINAudioCmdMsg->m_enAudioType)));
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINAudioDispatcher::vHandleSessionMsg(MySPINVRStreamErrorMsg* poMySPINVRStreamErrorMsg)
 ***************************************************************************/
t_Void spi_tclMySPINAudioDispatcher::vHandleSessionMsg(MySPINVRStreamErrorMsg* poMySPINVRStreamErrorMsg) const
{
    ETG_TRACE_USR1((" spi_tclMySPINAudioDispatcher::vHandleSessionMsg(MySPINVRStreamErrorMsg* poMySPINVRStreamErrorMsg) \n"));
    if (NULL != poMySPINVRStreamErrorMsg)
    {
        CALL_REG_OBJECTS(spi_tclMySPINRespAudio,
                         e16MYSPIN_AUDIO_REGID,
                         vVRStreamErrorCb(poMySPINVRStreamErrorMsg->u32GetDeviceHandle(),
                                          poMySPINVRStreamErrorMsg->m_enError));
    }
}
