/***********************************************************************/
/*!
* \file  spi_tclMySPINVideo.cpp
* \brief  Implementation of the Class spi_tclMySPINCmdVideo
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    class for MySPiN Video
AUTHOR:         SHITANSHU SHEKHAR (RBEI/ECP2 : HSK5KOR)
COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                            | Modification
02.11.2015  | SHITANSHU SHEKHAR (RBEI/ECP2)     | Initial Version

\endverbatim
*************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "Timer.h"
#include "spi_tclMySPINManager.h"
#include "spi_tclMySPINCmdVideo.h"
#include "spi_tclMySPINVideo.h"
#include "spi_tclMySPINRespVideo.h"
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_VIDEO
#include "trcGenProj/Header/spi_tclMySPINVideo.cpp.trc.h"
#endif
#endif
//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1055 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/
//wl_pump_events method should be called fro every 25 msec
#define TIMER_PUMP_WL_EVENTS_MSEC (tCU32)40

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/
//Member variable to maintain Timer Index of Wayland touch events timer
static timer_t sWLTimerIndex = 0;

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/
static spi_tclMySPINCmdVideo* spoCmdVideo = NULL;
static t_Bool sbTouchInputTimerRunning = false;
t_U32 spi_tclMySPINVideo::m_u32SelectedDeviceID = 0;

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINVideo::spi_tclMySPINVideo()
 ***************************************************************************/
spi_tclMySPINVideo::spi_tclMySPINVideo()
{
   ETG_TRACE_USR1(("spi_tclMySPINVideo() entered"));
}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINVideo::~spi_tclMySPINVideo()
 ***************************************************************************/
spi_tclMySPINVideo::~spi_tclMySPINVideo()
{
   ETG_TRACE_USR1(("~spi_tclMySPINVideo() entered"));
   m_u32SelectedDeviceID = 0;
   spoCmdVideo = NULL;
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclMySPINVideo::bInitialize()
 ***************************************************************************/
t_Bool spi_tclMySPINVideo::bInitialize()
{
   ETG_TRACE_USR1(("spi_tclMySPINVideo::bInitialize() entered"));

   t_Bool bRet = false;

   spi_tclMySPINManager* poMySPINMngr = spi_tclMySPINManager::getInstance();
   SPI_NORMAL_ASSERT(NULL == poMySPINMngr);

   if (NULL != poMySPINMngr)
   {
      spoCmdVideo = poMySPINMngr->poGetVideoInstance();
      bRet = poMySPINMngr->bRegisterObject((spi_tclMySPINRespVideo*) this);
   }
   return bRet;
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINVideo::vUninitialize()
 ***************************************************************************/
t_Void spi_tclMySPINVideo::vUninitialize()
{
   ETG_TRACE_USR1(("spi_tclMySPINVideo::vUninitialize() entered"));
}

/***************************************************************************
 ** FUNCTION:  t_Void  spi_tclMySPINVideo::vRegisterCallbacks()
 ***************************************************************************/
t_Void spi_tclMySPINVideo::vRegisterCallbacks(const trVideoCallbacks& corfrVideoCallbacks)
{
   ETG_TRACE_USR1(("spi_tclMySPINVideo::vRegisterCallbacks() entered"));
   m_rVideoCallbacks = corfrVideoCallbacks;
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINVideo::vSelectDevice()
 ***************************************************************************/
t_Void spi_tclMySPINVideo::vSelectDevice(const t_U32 cou32DevId, const tenDeviceConnectionReq coenConnReq)
{
   ETG_TRACE_USR1(("spi_tclMySPINVideo:vSelectDevice: Device ID-0x%x Selection Type - %d ", cou32DevId, ETG_ENUM(CONNECTION_REQ,
            coenConnReq)));

   tenErrorCode enErrorCode = e8UNKNOWN_ERROR;

   if ((0 != cou32DevId) && (e8DEVCONNREQ_SELECT == coenConnReq))
   {
      m_u32SelectedDeviceID = cou32DevId;

      //Initialize Video session
      if ((NULL != m_poVideoSettings) && (NULL != spoCmdVideo))
      {

         trVideoConfigData rVideoConfigData;
         tvecVideoConfigList vecVideoConfigList;
         m_poVideoSettings->vGetVideoConfigData(e8DEV_TYPE_MYSPIN, vecVideoConfigList);
         m_poVideoSettings->vGetPrimaryDisplayConfiguration(vecVideoConfigList,rVideoConfigData);

         trMySpinVideoConfig rMySpinVideoConfig;
#ifdef VARIANT_S_FTR_ENABLE_CHERYM31T
          rMySpinVideoConfig.u32LayerId = rVideoConfigData.u32TouchLayerId;
          rMySpinVideoConfig.u32SurfaceId = rVideoConfigData.u32TouchSurfaceId;
#endif
         rMySpinVideoConfig.u32LayerId = rVideoConfigData.u32LayerId;
         rMySpinVideoConfig.u32SurfaceId = rVideoConfigData.u32SurfaceId; 
         rMySpinVideoConfig.u32WidthInPixels = rVideoConfigData.u32ProjScreen_Width;
         rMySpinVideoConfig.u32HeightInPixels = rVideoConfigData.u32ProjScreen_Height;
         rMySpinVideoConfig.u32WidthInMm = rVideoConfigData.u32ProjScreen_Width_Mm;
         rMySpinVideoConfig.u32HeightInMm = rVideoConfigData.u32ProjScreen_Height_Mm;
         rMySpinVideoConfig.enPixelFormat = e8_PIXELFORMAT_RGB565;
         rMySpinVideoConfig.enPixelCompression = PIXEL_COMP_ZLIB;
         rMySpinVideoConfig.enPreferredCompression = PIXEL_COMP_ZLIB;

         ETG_TRACE_USR1(("spi_tclMySPINVideo:u32LayerId %d", rMySpinVideoConfig.u32LayerId));
         ETG_TRACE_USR1(("spi_tclMySPINVideo:u32SurfaceId %d", rMySpinVideoConfig.u32SurfaceId));
         ETG_TRACE_USR1(("spi_tclMySPINVideo:u32WidthInPixels %d", rMySpinVideoConfig.u32WidthInPixels));
         ETG_TRACE_USR1(("spi_tclMySPINVideo:u32HeightInPixels %d", rMySpinVideoConfig.u32HeightInPixels));
         ETG_TRACE_USR1(("spi_tclMySPINVideo:u32WidthInMm %d", rMySpinVideoConfig.u32WidthInMm));
         ETG_TRACE_USR1(("spi_tclMySPINVideo:u32HeightInMm %d", rMySpinVideoConfig.u32HeightInMm));
         ETG_TRACE_USR1(("spi_tclMySPINVideo:enPixelFormat %d", rMySpinVideoConfig.enPixelFormat));
         ETG_TRACE_USR1(("spi_tclMySPINVideo:enPixelCompression %d", rMySpinVideoConfig.enPixelCompression));
         ETG_TRACE_USR1(("spi_tclMySPINVideo:u32PreferredCompression %d", rMySpinVideoConfig.enPreferredCompression));

         //SetFrame
         spoCmdVideo->vSetFrameProperties(m_u32SelectedDeviceID, rMySpinVideoConfig);

         //Set wayland Touch
         t_Bool bEnableTouch = static_cast<t_Bool> (m_poVideoSettings->u8EnableTouchInputEvents());
         spoCmdVideo->vSetWaylandTouch(m_u32SelectedDeviceID, bEnableTouch);

         enErrorCode = e8NO_ERRORS;
      }
   }
   else if ((NULL != spoCmdVideo) && (e8DEVCONNREQ_DESELECT == coenConnReq))
   {
      //@Check whether spi needs to stop playback actively??
      m_u32SelectedDeviceID = 0;
      enErrorCode = (spoCmdVideo->enStopVideoPlayback(cou32DevId));
      vStopTimerTouchEvents();
   }
   if (NULL != m_rVideoCallbacks.fpvSelectDeviceCb)
   {
      (m_rVideoCallbacks.fpvSelectDeviceCb)(cou32DevId, enErrorCode);
   }

}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINVideo::bLaunchVideo()
 ***************************************************************************/
t_Bool spi_tclMySPINVideo::bLaunchVideo(const t_U32 cou32DevId, const t_U32 cou32AppId,
         const tenEnabledInfo coenSelection)
{
   SPI_INTENTIONALLY_UNUSED(coenSelection)
   SPI_INTENTIONALLY_UNUSED(cou32AppId)
   ETG_TRACE_USR1(("spi_tclMySPINVideo:bLaunchVideo: Device ID-0x%x ", cou32DevId));

   tenErrorCode enErrCode = e8UNKNOWN_ERROR;

   //start play back   
   if (NULL != spoCmdVideo)
   {
      enErrCode = spoCmdVideo->enStartVideoPlayback(cou32DevId, true);

      if (enErrCode != e8NO_ERRORS)
      {
         ETG_TRACE_ERR(("Error in starting mySPIN Video Playback"));
      }
      /*else
      {
         //Start timer to send pump events requests to ADIT, so that the 
         //screen changes reflects immediately.
         vStartTimerTouchEvents();
      }*/
   }

   return ((e8NO_ERRORS == enErrCode) ? true : false);
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINVideo::vStartVideoRendering()
 ***************************************************************************/
t_Void spi_tclMySPINVideo::vStartVideoRendering(t_Bool bStartVideoRendering)
{
   ETG_TRACE_USR1(("spi_tclMySPINVideo:vStartVideoRendering entered "));

   if (NULL != m_rVideoCallbacks.fpvVideoRenderStatusCb)
   {
      (m_rVideoCallbacks.fpvVideoRenderStatusCb)(bStartVideoRendering, e8DEV_TYPE_MYSPIN);
   }
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINVideo::vGetVideoSettings()
 ***************************************************************************/
t_Void spi_tclMySPINVideo::vGetVideoSettings(const t_U32 cou32DevId, trVideoAttributes& rfrVideoAttributes)
{
   SPI_INTENTIONALLY_UNUSED(rfrVideoAttributes)
   SPI_INTENTIONALLY_UNUSED(cou32DevId)
   ETG_TRACE_USR1(("spi_tclMySPINVideo:vGetVideoSettings entered "));
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINVideo::vSetServerAspectRatio()
 ***************************************************************************/
t_Void spi_tclMySPINVideo::vSetServerAspectRatio(const tenScreenAspectRatio& corfenScrAspRatio)
{
   SPI_INTENTIONALLY_UNUSED(corfenScrAspRatio)
   ETG_TRACE_USR1(("spi_tclMySPINVideo:vSetServerAspectRatio entered "));
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINVideo::enSetVideoBlockingMode()
 ***************************************************************************/
tenErrorCode spi_tclMySPINVideo::enSetVideoBlockingMode(const t_U32 cou32DevId, const tenBlockingMode coenBlockingMode,
                const tenVideoBlockingReason coenVideoBlockingReason)
{
   SPI_INTENTIONALLY_UNUSED(cou32DevId)
   SPI_INTENTIONALLY_UNUSED(coenBlockingMode)
   SPI_INTENTIONALLY_UNUSED(coenVideoBlockingReason)
   ETG_TRACE_USR1(("spi_tclMySPINVideo:enSetVideoBlockingMode entered "));
   return e8NO_ERRORS;

}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINVideo::vSetOrientationMode()
 ***************************************************************************/
t_Void spi_tclMySPINVideo::vSetOrientationMode(const t_U32 cou32DevId, const tenOrientationMode coenOrientationMode,
         const trUserContext& corfrUsrCntxt)
{
   ETG_TRACE_USR1(("spi_tclMySPINVideo:vSetOrientationMode entered "));

   //send response
   SPI_INTENTIONALLY_UNUSED(coenOrientationMode);
   if (NULL != m_rVideoCallbacks.fpvSetOrientationModeCb)
   {
      (m_rVideoCallbacks.fpvSetOrientationModeCb)(cou32DevId, e8UNSUPPORTED_OPERATION, corfrUsrCntxt, e8DEV_TYPE_MYSPIN);
   }
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINVideo::vOnSelectDeviceResult()
 ***************************************************************************/
t_Void spi_tclMySPINVideo::vOnSelectDeviceResult(const t_U32 cou32DevId, const tenDeviceConnectionReq coenConnReq,
         const tenResponseCode coenRespCode)
{
   ETG_TRACE_USR1(("spi_tclMySPINVideo:vOnSelectDeviceResult entered for [%d]",cou32DevId));

   if ((e8DEVCONNREQ_SELECT == coenConnReq) && (e8FAILURE == coenRespCode))
   {
      ETG_TRACE_USR1(("Failure in Select Device- Perform Clean up"));
      m_u32SelectedDeviceID = 0;
   }
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINVideo::vStartTimerTouchEvents()
 ***************************************************************************/
t_Void spi_tclMySPINVideo::vStartTimerTouchEvents()
{
   //@Note: Timer is used to send wayland touch events to layer manager
   //StartTimer Creates a new Timer every Time & populates the Timer Index
   Timer* poTimer = Timer::getInstance();

   if ((NULL != poTimer) && (false == sbTouchInputTimerRunning) && (true == poTimer->StartTimer(sWLTimerIndex,
            TIMER_PUMP_WL_EVENTS_MSEC,
            TIMER_PUMP_WL_EVENTS_MSEC,
            this,
            bOnSendWLTouchEventsCb,
            NULL)))
   {
      sbTouchInputTimerRunning = true;
      ETG_TRACE_USR1(("vStartTimerTouchEvents: Timer is started"));
   }

}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINVideo::vStopTimerTouchEvents()
 ***************************************************************************/
t_Void spi_tclMySPINVideo::vStopTimerTouchEvents()
{
   //StartTimer creates a new Timer always & populates the Timer Index.
   // So reset the Timer, once the Timer is started
   Timer* poTimer = Timer::getInstance();
   if ((NULL != poTimer) && (true == sbTouchInputTimerRunning))
   {
      poTimer->CancelTimer(sWLTimerIndex);
      //Reset the Timer Index
      sWLTimerIndex = 0;
      sbTouchInputTimerRunning = false;
      ETG_TRACE_USR2(("vStopTimerTouchEvents: Timer is stopped"));
   }
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclMySPINVideo::bOnSendWLTouchEventsCb()
 ***************************************************************************/
t_Bool spi_tclMySPINVideo::bOnSendWLTouchEventsCb(timer_t timerID, t_Void *pObject, const t_Void *pcoUserData)
{
   t_Bool bRet = false;

   SPI_INTENTIONALLY_UNUSED(pcoUserData);
   SPI_INTENTIONALLY_UNUSED(pObject);

   t_S32 s32TimeOut = 35;
   if ((NULL != spoCmdVideo) && (sWLTimerIndex == timerID))
   {
      spoCmdVideo->vPumpEvents(m_u32SelectedDeviceID, s32TimeOut);
      bRet = true;
   }
   return bRet;
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclMySPINVideo::vPlaybackStop()
 ***************************************************************************/
t_Void spi_tclMySPINVideo::vPlaybackStop(t_U32 u32DeviceHandle)
{
    ETG_TRACE_USR1(("spi_tclMySPINVideo::vPlaybackStop entered"));
    vStopTimerTouchEvents();
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclMySPINVideo::vPlaybackStartOnLaunchCallback()
 ***************************************************************************/
t_Void spi_tclMySPINVideo::vPlaybackStartOnLaunchCallback(t_U32 u32DeviceHandle)
{
    ETG_TRACE_USR1(("spi_tclMySPINVideo::vPlaybackStart entered"));
    vStartTimerTouchEvents();
}
//lint restore
///////////////////////////////////////////////////////////////////////////////
// <EOF>
