/***********************************************************************/
/*!
 * \file  spi_tclMySPINVideo.h
 * \brief  Implementation of the Class spi_tclMySPINCmdVideo
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    class for MySPiN Video
 AUTHOR:         SHITANSHU SHEKHAR (RBEI/ECP2 : HSK5KOR)
 COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH
 HISTORY:
 Date        | Author                            | Modification
 02.11.2015  | SHITANSHU SHEKHAR (RBEI/ECP2)        | Initial Version

 \endverbatim
 *************************************************************************/

#ifndef SPI_TCLMYSPINVIDEO_H_
#define SPI_TCLMYSPINVIDEO_H_

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "BaseTypes.h"
#include "SPITypes.h"
#include "spi_tclVideoTypedefs.h"
#include "spi_tclVideoDevBase.h"
#include "spi_tclMySPINRespVideo.h"

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
 * \class    spi_tclMySPINVideo
 * \brief    MySPiN Video implementation
 *           This class interacts with MySPiN Video wrapper to interact with
 *           MySPiN API's
 ****************************************************************************/
class spi_tclMySPINVideo: public spi_tclVideoDevBase, public spi_tclMySPINRespVideo
{
   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINVideo::spi_tclMySPINVideo()
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINVideo()
       * \brief   Default Constructor
       * \sa      ~spi_tclMySPINVideo()
       **************************************************************************/
      spi_tclMySPINVideo();

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINVideo::~spi_tclMySPINVideo()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclMySPINVideo()
       * \brief   Destructor
       * \sa      spi_tclMySPINVideo()
       **************************************************************************/
      ~spi_tclMySPINVideo();

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclMySPINVideo::bInitialize()
       ***************************************************************************/
      /*!
       * \fn      t_Bool bInitialize()
       * \brief   To Initialize all the Video related classes
       * \retval  t_Bool
       * \sa      vUninitialize()
       **************************************************************************/
      t_Bool bInitialize();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINVideo::vUninitialize()
       ***************************************************************************/
      /*!
       * \fn      t_Void vUninitialize()
       * \brief   To Uninitialize all the Video related classes
       * \retval  t_Void
       * \sa      bInitialize()
       **************************************************************************/
      t_Void vUninitialize();

      /***************************************************************************
       ** FUNCTION:  t_Void  spi_tclMySPINVideo::vRegisterCallbacks()
       ***************************************************************************/
      /*!
       * \fn      t_Void vRegisterCallbacks(const trVideoCallbacks& corfrVideoCallbacks)
       * \brief   To Register for the asynchronous responses that are required from
       *          MySPiN Video
       * \param   corfrVideoCallbacks : [IN] Video callbacks structure
       * \retval  t_Void
       **************************************************************************/
      t_Void vRegisterCallbacks(const trVideoCallbacks& corfrVideoCallbacks);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINVideo::vSelectDevice()
       ***************************************************************************/
      /*!
       * \fn      t_Void vSelectDevice(const t_U32 cou32DevId,
       *          const tenDeviceConnectionReq coenConnReq)
       * \brief   To Initialize/UnInitialize Video setup for the currently selected device
       * \pram    cou32DevId : [IN] Unique Device Id
       * \param   coenConnReq : [IN] connected/disconnected
       * \retval  t_Void
       **************************************************************************/
      t_Void vSelectDevice(const t_U32 cou32DevId, const tenDeviceConnectionReq coenConnReq);

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclMySPINVideo::bLaunchVideo()
       ***************************************************************************/
      /*!
       * \fn      t_Bool bLaunchVideo(const t_U32 cou32DevId,
       *                 const t_U32 cou32AppId,
       *                 const tenEnabledInfo coenSelection)
       * \brief   To Launch the Video for the requested app
       * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
       * \pram    cou32AppId  : [IN] Application Id
       * \pram    coenSelection  : [IN] Enable/disable the video
       * \retval  t_Bool
       **************************************************************************/
      t_Bool bLaunchVideo(const t_U32 cou32DevId, const t_U32 cou32AppId, const tenEnabledInfo coenSelection =
               e8USAGE_ENABLED);

      /***************************************************************************
       ** FUNCTION:  t_U32  spi_tclMySPINVideo::vStartVideoRendering()
       ***************************************************************************/
      /*!
       * \fn      t_Void vStartVideoRendering(t_Bool bStartVideoRendering)
       * \brief   Method send request to MySPiN Video either to start or stop
       *          Video Rendering
       * \pram    bStartVideoRendering : [IN] True - Start Video rendering
       *                                      False - Stop Video rendering
       * \retval  t_Void
       **************************************************************************/
      t_Void vStartVideoRendering(t_Bool bStartVideoRendering);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINVideo::vGetVideoSettings()
       ***************************************************************************/
      /*!
       * \fn     t_Void vGetVideoSettings(const t_U32 cou32DevId,
       *                                  trVideoAttributes& rfrVideoAttributes
       * \brief  To get the current Video Settings.
       * \param  cou32DevId         : [IN] Uniquely identifies the target Device.
       * \param  rfrVideoAttributes : [OUT]includes screen size & orientation.
       * \retval t_Void
       * \sa
       **************************************************************************/
      t_Void vGetVideoSettings(const t_U32 cou32DevId, trVideoAttributes& rfrVideoAttributes);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINVideo::vSetScreenSize()
       ***************************************************************************/
      /*!
       * \fn     t_Void vSetServerAspectRatio(const tenScreenAspectRatio& corfenScrAspRatio)
       * \brief  Interface to set the screen aspect ratio of Head Unit.
       * \param  corfenScrAspRatio : [IN] screen aspect ratio
       * \retval t_Void
       * \sa
       **************************************************************************/
      t_Void vSetServerAspectRatio(const tenScreenAspectRatio& corfenScrAspRatio);

      /***************************************************************************
       ** FUNCTION: tenErrorCode spi_tclMySPINVideo::enSetVideoBlockingMode()
       ***************************************************************************/
      /*!
       * \fn     tenErrorCode enSetVideoBlockingMode(const t_U32 cou32DevId,
       *         const tenBlockingMode coenBlockingMode)
       * \brief  Interface to set the display blocking mode.
       * \param  cou32DevId             : [IN] Uniquely identifies the target Device.
       * \param  coenBlockingMode       : [IN] Identifies the Blocking Mode.
       * \retval tenErrorCode
       **************************************************************************/
      tenErrorCode enSetVideoBlockingMode(const t_U32 cou32DevId, const tenBlockingMode coenBlockingMode, const tenVideoBlockingReason coenVideoBlockingReason);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINVideo::vSetOrientationMode()
       ***************************************************************************/
      /*!
       * \fn     t_Void vSetOrientationMode(const t_U32 cou32DevId,
       *                                    const tenOrientationMode coenOrientationMode,
       *                                    const trUserContext& corfrUsrCntxt)= 0
       * \brief  Interface to set the orientation mode of the projected display.
       * \param  cou32DevId          : [IN] Uniquely identifies the target Device.
       * \param  coenOrientationMode : [IN] Orientation Mode Value.
       * \param  corfrUsrCntxt       : [IN] User Context
       * \retval t_Void
       **************************************************************************/
      t_Void vSetOrientationMode(const t_U32 cou32DevId, const tenOrientationMode coenOrientationMode,
               const trUserContext& corfrUsrCntxt);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINVideo::vOnSelectDeviceResult()
       ***************************************************************************/
      /*!
       * \fn      t_Void vOnSelectDeviceResult(const t_U32 cou32DevId,
       *                 const tenDeviceConnectionReq coenConnReq,
       *                 const tenResponseCode coenRespCode)
       * \brief   To perform the actions that are required, after the select device is
       *           successful/failed
       * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
       * \pram    coenConnReq : [IN] Identifies the Connection Request.
       * \pram    coenRespCode: [IN] Response code. Success/Failure
       * \retval  t_Void
       **************************************************************************/
      t_Void vOnSelectDeviceResult(const t_U32 cou32DevId, const tenDeviceConnectionReq coenConnReq,
               const tenResponseCode coenRespCode);

      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/

   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ****************************END OF PROTECTED********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINVideo::vStopTimerTouchEvents()
       ***************************************************************************/
      /*!
       * \fn      t_Void vStopTimerTouchEvents()
       * \brief   To stop the timer
       * \retval  t_Void
       * \sa      vStopTimerTouchEvents()
       **************************************************************************/
      t_Void vStopTimerTouchEvents();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINVideo::vStartTimerTouchEvents()
       ***************************************************************************/
      /*!
       * \fn      t_Void vStartTimerTouchEvents()
       * \brief   To start the timer
       * \retval  t_Void
       * \sa      vStartTimerTouchEvents()
       **************************************************************************/
      t_Void vStartTimerTouchEvents();

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclMySPINVideo::bOnSendWLTouchEventsCb()
       ***************************************************************************/
      /*!
       * \fn      static t_Bool bOnSendWLTouchEventsCb(timer_t timerID ,
       *                                               t_Void *pObject,
       *                                               const t_Void *pcoUserData)
       * \brief   Timer Callback Function to send wayland touch events
       * \param   timerID : [IN] Id of the timer for which the timer is expired
       * \param   pObject : [IN] pointer to the object for which the callback is related to
       * \param   pcoUserData : [IN] User context data
       * \retval  t_Bool
       * \sa      vStartPumpWLEventsTimer()
       **************************************************************************/
      static t_Bool bOnSendWLTouchEventsCb(timer_t timerID, t_Void *pObject, const t_Void *pcoUserData);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINVideo::vPlaybackStop()
       ***************************************************************************/
      /*!
       * \fn      t_Void vPlaybackStop()
       * \brief   method to update that the Video Play back is stopped
       * \retval  t_Void
       **************************************************************************/
      t_Void vPlaybackStop(t_U32 u32DeviceHandle);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINVideo::vPlaybackStartOnLaunchCallback()
       ***************************************************************************/
      /*!
       * \fn      t_Void vPlaybackStartOnLaunchCallback()
       * \brief   method to update that the Video Play back is started
       * \retval  t_Void
       **************************************************************************/
      t_Void vPlaybackStartOnLaunchCallback(t_U32 u32DeviceHandle) override;

      //! Currently selected device
      static t_U32 m_u32SelectedDeviceID;

      trVideoCallbacks m_rVideoCallbacks;

      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/

}; //spi_tclMySPINVideo

#endif // SPI_TCLMYSPINVIDEO_H_
///////////////////////////////////////////////////////////////////////////////
// <EOF>
