/***********************************************************************/
/*!
 * \file    spi_tclMySPINResourceMngr.h
 * \brief   MySPIN Resource Manager
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    MySPIN Resource Manager
 AUTHOR:         Shiva Kumar Gurija
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 04.11.2015  | Shiva Kumar Gurija    | Initial Version
 12.04.2016  | Chaitra Srinivasa     | Adding comments
 \endverbatim
 *************************************************************************/

#ifndef _SPI_TCLMYSPINRESOURCEMNGR_H_
#define _SPI_TCLMYSPINRESOURCEMNGR_H_

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "spi_tclResorceMngrDefines.h"
#include "spi_tclResourceMngrBase.h"
#include "spi_tclMySPINRespSession.h"

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/
class spi_tclMySPINVideoResourceMngr;
class spi_tclMySPINAudioResourceMngr;

/****************************************************************************/
/*!
 * \class  spi_tclMySPINResourceMngr
 * \brief  AAP Resource Manager
 ****************************************************************************/
class spi_tclMySPINResourceMngr: public spi_tclResourceMngrBase, public spi_tclMySPINRespSession
{

   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINResourceMngr::spi_tclMySPINResourceMngr()
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINResourceMngr()
       * \brief   Default Constructor
       * \param   t_Void
       * \sa      ~spi_tclMySPINResourceMngr()
       **************************************************************************/
      spi_tclMySPINResourceMngr();

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINResourceMngr::~spi_tclMySPINResourceMngr()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclMySPINResourceMngr()
       * \brief   Destructor
       * \param   t_Void
       * \sa      spi_tclMySPINResourceMngr()
       **************************************************************************/
      ~spi_tclMySPINResourceMngr();

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclMySPINResourceMngr::bInitialize()
       ***************************************************************************/
      /*!
       * \fn      t_Bool bInitialize()
       * \brief   To Initialize all the Resource Manager related classes
       * \retval  t_Bool
       * \sa      vUninitialize()
       * \retval  t_Bool
       **************************************************************************/
      t_Bool bInitialize();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINResourceMngr::vUninitialize()
       ***************************************************************************/
      /*!
       * \fn      t_Void vUninitialize()
       * \brief   To Uninitialize all the Resource Manager related classes
       * \retval  t_Void
       * \sa      bInitialize()
       **************************************************************************/
      t_Void vUnInitialize();

      /***************************************************************************
       ** FUNCTION:  t_Void  spi_tclMySPINResourceMngr::vRegRsrcMngrCallBack()
       ***************************************************************************/
      /*!
       * \fn      t_Void vRegRsrcMngrCallBack()
       * \brief   To Register for the asynchronous responses that are required from
       *          ML/DiPo Resource Manager
       * \param   rRsrcMngrCallback : [IN] Resource Manager callbacks structure
       * \retval  t_Void
       **************************************************************************/
      t_Void vRegRsrcMngrCallBack(trRsrcMngrCallback rRsrcMngrCallback);
      
      /***************************************************************************
       ** FUNCTION:  t_Void  spi_tclMySPINResourceMngr::vRegisterCallbacks()
       ***************************************************************************/
      /*!
       * \fn      t_Void vRegRsrcMngrCallBack()
       * \brief   To Register for the callback from mediator for device disconnection
       * \retval  t_Void
       **************************************************************************/      
      t_Void vRegisterCallbacks();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINResourceMngr::vSetAccessoryDisplayContext()
       ***************************************************************************/
      /*!
       * \fn      virtual t_Void vSetAccessoryDisplayContext(const t_U32 cou32DevId,
       *        t_Bool bDisplayFlag, tenDisplayContext enDisplayContext)
       * \brief   To send accessory display context related info .
       * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
       * \param   enDevConnType : [IN] Device connection Type USB/WIFI
       * \pram    rfrcUsrCntxt: [IN] User Context Details.
       * \retval  t_Void
       **************************************************************************/
      t_Void vSetAccessoryDisplayContext(const t_U32 cou32DevId, t_Bool bDisplayFlag,
               tenDisplayContext enDisplayContext, const trUserContext& rfrcUsrCntxt);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINResourceMngr::vSelectDevice()
       ***************************************************************************/
      /*!
       * \fn      vSelectDevice(const trSelectDeviceRequest& corfrSelectReq)
       * \brief   To send accessory display context related info .
       * \pram    corfrSelectReq  : [IN] Selection request details.
       * \retval  t_Void
       **************************************************************************/
      t_Void vSelectDevice(const trSelectDeviceRequest& corfrSelectReq);

      /***************************************************************************
       ** FUNCTION:  t_Void  spi_tclMySPINResourceMngr::vOnSPISelectDeviceResult()
       ***************************************************************************/
      /*!
       * \fn      t_Void vOnSPISelectDeviceResult()
       * \brief   Interface to receive result of SPI device selection/deselection
       * \param   u32DevID : [IN] Resource Manager callbacks structure.
       * \param   enDevCat : [IN] Category of the device
       * \param   enDeviceConnReq : [IN] Select/ deselect.
       * \param   enRespCode : [IN] Response code (success/failure)
       * \param   enErrorCode : [IN] Error
       * \retval  t_Void
       **************************************************************************/
      t_Void vOnSPISelectDeviceResult(t_U32 u32DevID, tenDeviceConnectionReq enDeviceConnReq,
               tenResponseCode enRespCode, tenErrorCode enErrorCode);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINResourceMngr::vUpdateDeviceDisplayCntxt()
       ***************************************************************************/
      /*!
       * \fn      virtual t_Void vUpdateDeviceDisplayCntxt(t_Bool bDisplayFlag,
       *           tenDisplayContextReason enDisplayContextReason)
       * \brief   Request HMI to enable/diable Layer
       * \pram    bDisplayFlag      : [IN] TRUE - enable layer
       *                                   FALSE - disable layer
       * \param   enDisplayContextReason : Reason for device display context update.
       * \retval  t_Void
       **************************************************************************/
      t_Void vUpdateDeviceDisplayCntxt(t_Bool bDisplayFlag, tenDisplayContextReason enDisplayContextReason);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINResourceMngr::vOnSessionStatusInfo()
       ***************************************************************************/
      /*!
       * \fn      vOnSessionStatusInfo
       * \brief
       * \param  enSessionStatus : indicates current status of android auto session
       * \retval  t_Void
       **************************************************************************/
      t_Void vOnSessionStatusInfo(tenSessionStatus enSessionStatus);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINResourceMngr::vSetAccessoryDisplayMode(t_U32...
       ***************************************************************************/
      /*!
       * \fn     vSetAccessoryDisplayMode()
       * \brief  Accessory display mode update request.
       * \param  [IN] cu32DeviceHandle      : Uniquely identifies the target Device.
       * \pram    enDevCat    : [IN] Identifies the Connection Request.
       * \param  [IN] corDisplayContext : Display context info
       * \param  [IN] corDisplayConstraint : DiDisplay constraint info
       * \param  [IN] coenDisplayInfo       : Display info flag
       * \retval  t_Void
       * \sa
       **************************************************************************/
      t_Void vSetAccessoryDisplayMode(const t_U32 cu32DeviceHandle, const trDisplayContext corDisplayContext,
                       const trDisplayConstraint corDisplayConstraint, const tenDisplayInfo coenDisplayInfo);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINResourceMngr::vInitiateCall(t_String...
       ***************************************************************************/
      /*!
       * \fn     vInitiateCall()
       * \brief  Request HMI to initiate a call
       * \param  szTelephoneNumber: [IN]string to store telephone number
       * \param  szDisplayText: [IN]string to store display text
       * \sa
       * \retval  t_Void
       **************************************************************************/
      t_Void vInitiateCall(t_String szTelephoneNumber, t_String szDisplayText);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINResourceMngr::vVoiceSessionCb(t_String...
       ***************************************************************************/
      /*!
       * \fn     vVoiceSessionCb()
       * \brief  Request HMI to Acknowledge to voice session request
       * \param  enMySPINVoiceSessionReq: Myspin Voice session request
       * \param  bIsBTConnected: [IN]BT connection status
       * \sa
       * \retval  t_Void
       **************************************************************************/
      t_Void vVoiceSessionCb(tenMySPINVoiceSessionReq enMySPINVoiceSessionReq);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINResourceMngr::vUpdateVoiceSessionStatus(tenBTVoiceSessionStatus...
       ***************************************************************************/
      /*!
       * \fn     vUpdateVoiceSessionStatus()
       * \brief  Update the current voice session status
       * \param  szTelephoneNumber: [IN]string to store telephone number
       * \param  szDisplayText: [IN]string to store display text
       * \sa
       * \retval  t_Void
       **************************************************************************/
      t_Void vUpdateVoiceSessionStatus(tenBTVoiceSessionStatus enBTVoiceSessionStatus);
      
      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINResourceMngr::vOnExtVRStateUpdate(...
       ***************************************************************************/
      /*!
       * \fn     vOnExtVRStateUpdate()
       * \brief  Update the External VR state
       * \param   enExtVRState: External VR state
       * \param   szBTAddress : BT address
       * \param   enVRErrorCode : VR error codes
       * \sa
       * \retval  t_Void
       **************************************************************************/
      t_Void vOnExtVRStateUpdate(t_String szBTAddress,
                              tenExtVRState enExtVRState,
                              tenVRErrorCode enVRErrorCode);
      
      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINResourceMngr::tenMspinVRStatus enGetVRState()
       ***************************************************************************/
      /*!
       * \fn      tenMspinVRStatus enGetVRState()
       * \brief   Method to get myspin VR state
       * \retval  tenMspinVRStatus
       ***************************************************************************/
      tenMspinVRStatus enGetVRState();
      
      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINResourceMngr::vMySPINPTTAvailableCb(t_Bool...
       ***************************************************************************/
      /*!
       * \fn     vMySPINPTTAvailableCb()
       * \brief  Myspin PTT available status
       * \param  bIsPTTAvail: [IN]PTT available status
       * \sa
       * \retval  t_Void
       **************************************************************************/
      t_Void vMySPINPTTAvailableCb(t_Bool bIsPTTAvail);
      
      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINResourceMngr::t_Void vSetVRState()
       ***************************************************************************/
      /*!
       * \fn      vSetVRState(tenMspinVRStatus enVRState)
       * \brief   Method to set myspin VR state
       * \param   enVRState : VR State
       * \retval  t_Void
       ***************************************************************************/
      t_Void vSetVRState(tenMspinVRStatus enVRState);

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINResourceMngr::t_Void vUpdateSpeechAppState()
       ***************************************************************************/
      /*!
       * \fn      vUpdateSpeechAppState(tenSpeechAppState enSpeechAppState)
       * \brief   Method to set myspin VR state
       * \param   enSpeechAppState : Speech app state
       * \retval  t_Void
       ***************************************************************************/
      t_Void vUpdateSpeechAppState(tenSpeechAppState enSpeechAppState);
      
      /***************************************************************************
      ** FUNCTION:  t_Bool spi_tclMySPINResourceMngr::vDeviceDisconStatusCb()
      ***************************************************************************/
      /*!
      * \fn      t_Bool vDeviceDisconStatusCb()
      * \brief   Method to get get deviceconnection status
      * \param   cou32DeviceHandle    : [IN] Device handle
      * \retval  t_Void
      **************************************************************************/
      t_Void vDeviceDisconStatusCb(const t_U32 cou32DeviceHandle);
      
      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/

   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINResourceMngr(const spi_tclMySPINResourceMngr...
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINResourceMngr(
       *                             const spi_tclMySPINResourceMngr& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclMySPINResourceMngr()
       ***************************************************************************/
      spi_tclMySPINResourceMngr(const spi_tclMySPINResourceMngr& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINResourceMngr& operator=( const spi_tclAAP...
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINResourceMngr& operator=(
       *                          const spi_tclMySPINResourceMngr& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclMySPINResourceMngr(const spi_tclMySPINResourceMngr& otrSrc)
       ***************************************************************************/
      spi_tclMySPINResourceMngr& operator=(const spi_tclMySPINResourceMngr& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINResourceMngr::t_Void vSetAccessoryAudioContext(...)
       ***************************************************************************/
      /*!
       * \fn      t_Void vSetAccessoryAudioContext(t_U32, tenAudioContext,
       *                                      t_Bool, const trUserContext&)
       * \brief   Method to set accessory audio context
       * \retval  t_Void
       ***************************************************************************/
      t_Void vSetAccessoryAudioContext(t_U32, tenAudioContext, t_Bool, const trUserContext&);

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINResourceMngr::t_Void vSetAccessoryAppState(...)
       ***************************************************************************/
      /*!
       * \fn      t_Void vSetAccessoryAppState(tenSpeechAppState, tenPhoneAppState,
       *                                           tenNavAppState, const trUserContext&)
       * \brief   Method to set accessory app state
       * \retval  t_Void
       ***************************************************************************/
      t_Void vSetAccessoryAppState(tenSpeechAppState enSpeechAppState, 
                                   tenPhoneAppState enPhoneAppState,
                                   tenNavAppState enNavAppState, 
                                   const trUserContext& rfrUserContext);
      
      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINResourceMngr::t_Void vPostBTStateUpdate(...)
       ***************************************************************************/
      /*!
       * \fn      t_Void vPostBTStateUpdate()
       * \brief   Method to post BT status update
       * \retval  t_Void
       ***************************************************************************/
      t_Void vPostBTStateUpdate() override;

      /***************************************************************************
       ****************************END OF PROTECTED********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

      //! Callback functions to Resource manager
      trRsrcMngrCallback m_rRsrcMngrCb;

      //! Pointer to Video resource manager
      spi_tclMySPINVideoResourceMngr* m_poVideoRsrcMngr;

      //! Pointer to Audio resource manager
      spi_tclMySPINAudioResourceMngr* m_poAudioResrcMgr;

      //! VR started state
      tenMspinVRStatus m_enVRState;
      
      //!Structure varaible to store device app states
      trDiPOAppState m_rDeviceAppStates;

      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/
}; //class spi_tclMySPINResourceMngr

#endif //_SPI_TCLMYSPINRESOURCEMNGR_H_
///////////////////////////////////////////////////////////////////////////////
// <EOF>
