/*!
 *******************************************************************************
 * \file              spi_tclMySPINInputHandler.h
 * \brief             SPI input handler for MySPIN devices
 *******************************************************************************
 \verbatim
 PROJECT:       Gen3
 SW-COMPONENT:  Smart Phone Integration
 DESCRIPTION:   Input handler class to send input events from Headunit to
                MySPIN Device
 AUTHOR:         tch5kor
 COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH

 HISTORY:
 Date        | Author                | Modification
 02.11.2015  | tch5kor               | Initial Version

 \endverbatim
 ******************************************************************************/

#ifndef SPI_TCLMYSPININPUTHANDLER_H_
#define SPI_TCLMYSPININPUTHANDLER_H_

/******************************************************************************
 | includes:
 | 1)RealVNC sdk - includes
 | 2)Typedefines
 |----------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "spi_tclInputDevBase.h"
 

/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

typedef enum
{
   e8SOFT_KEY = 0,
   e8AVPCTRL_KEY ,
   e8IAP_KEY,
   e8CUSTOM_KEY,
   e8INVALID_KEY
} tenMySPINKeyType;

typedef struct
{
   tenKeyCode enKeyCode;
   t_U32 u32BitMask;
}
trSoftKeyCode;

typedef struct
{
   tenKeyCode enKeyCode;
   t_U8 avpCtrlCode;
}
trAVPKeyCode;

typedef struct
{
   tenKeyCode enKeyCode;
   t_U8 u8CustomKeyCode; 
}
trCustomKey;

 typedef struct
{
   tenKeyCode enKeyCode;
   t_U32 u32BitMask;
}
trMySPINKeyCode;
/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/
class spi_tclInputRespIntf;

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/*!
 * \class spi_tclMySPINInputHandler
 * \brief Input handler class to send input events from Headunit to
 MySPIN Device
 *
 */

class spi_tclMySPINInputHandler: public spi_tclInputDevBase
{
   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINInputHandler::spi_tclMySPINInputHandler(spi_tclInputResp ..)
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINInputHandler(spi_tclInputRespIntf* poInputRespIntf)
       * \brief   Parameterised constructor
       * \param   poInputRespIntf: [IN]Input Response Interface Pointer
       * \sa      ~spi_tclMySpinInputHandler()
       **************************************************************************/
      spi_tclMySPINInputHandler();

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINInputHandler::~spi_tclMySPINInputHandler()
       ***************************************************************************/
      /*!
       * \fn     ~ spi_tclMySPINInputHandler()
       * \brief   destructor
       * \sa      spi_tclMySPINInputHandler()
       **************************************************************************/
      ~spi_tclMySPINInputHandler();

      /***************************************************************************
       ** FUNCTION: virtual t_Void spi_tclMySPINInputHandler::vSelectDevice()
       ***************************************************************************/
      /*!
       * \fn      t_Void vSelectDevice(const t_U32 cou32DevId,
       *                 const tenDeviceConnectionReq coenConnReq)
       * \brief   To setup input related info when a device is selected or
       *          de selected.
       * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
       * \pram    coenConnReq : [IN] Identifies the Connection Type.
       * \retval  t_Void
       **************************************************************************/
      t_Void vSelectDevice(const t_U32 cou32DevId, const tenDeviceConnectionReq coenConnReq);

      /***************************************************************************
       ** FUNCTION:  t_Void  spi_tclMySPINInputHandler::vRegisterVideoCallbacks()
       ***************************************************************************/
      /*!
       * \fn      t_Void vRegisterInputCallbacks(const trVideoCallbacks& corfrVideoCallbacks)
       * \brief   To Register for the asynchronous responses that are required from
       *          MySPIN/DiPo Video
       * \param   corfrVideoCallbacks : [IN] Video callabcks structure
       * \retval  t_Void
       **************************************************************************/
      t_Void vRegisterInputCallbacks(const trInputCallbacks& corfrInputCallbacks);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINInputHandler::vOnSelectDeviceResult()
       ***************************************************************************/
      /*!
       * \fn      t_Void vOnSelectDeviceResult(const t_U32 cou32DevId,
       *                 const tenDeviceConnectionReq coenConnReq,
       *                 const tenResponseCode coenRespCode)
       * \brief   To perform the actions that are required, after the select device is
       *           successful/failed
       * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
       * \pram    coenConnReq : [IN] Identifies the Connection Request.
       * \pram    coenRespCode: [IN] Response code. Success/Failure
       * \retval  t_Void
       **************************************************************************/
      t_Void vOnSelectDeviceResult(const t_U32 cou32DevId, const tenDeviceConnectionReq coenConnReq,
               const tenResponseCode coenRespCode);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINInputHandler::vProcessTouchEvent()
       ***************************************************************************/
      /*!
       * \fn      t_Void vOnSelectDeviceResult(const t_U32 cou32DevId,
       *                 const tenDeviceConnectionReq coenConnReq,
       *                 const tenResponseCode coenRespCode)
       * \brief   To perform the actions that are required, after the select device is
       *           successful/failed
       * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
       * \pram    coenConnReq : [IN] Identifies the Connection Request.
       * \pram    coenRespCode: [IN] Response code. Success/Failure
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vProcessTouchEvent(t_U32, trTouchData&) const
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINInputHandler::vProcessKeyEvents()
       ***************************************************************************/
      /*!
       * \fn      t_Void vOnSelectDeviceResult(const t_U32 cou32DevId,
       *                 const tenDeviceConnectionReq coenConnReq,
       *                 const tenResponseCode coenRespCode)
       * \brief   To perform the actions that are required, after the select device is
       *           successful/failed
       * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
       * \pram    coenConnReq : [IN] Identifies the Connection Request.
       * \pram    coenRespCode: [IN] Response code. Success/Failure
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vProcessKeyEvents(t_U32, tenKeyMode, tenKeyCode) const;

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINInputHandler::vProcessKnobKeyEvents()
       ***************************************************************************/
      /*!
       * \fn      t_Void vOnSelectDeviceResult(const t_U32 cou32DevId,
       *                 const tenDeviceConnectionReq coenConnReq,
       *                 const tenResponseCode coenRespCode)
       * \brief   To perform the actions that are required, after the select device is
       *           successful/failed
       * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
       * \pram    coenConnReq : [IN] Identifies the Connection Request.
       * \pram    coenRespCode: [IN] Response code. Success/Failure
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vProcessKnobKeyEvents(t_U32, t_S8) const;

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINInputHandler::enGetKeyType()
       ***************************************************************************/
      /*!
       * \fn      t_Void vOnSelectDeviceResult(const t_U32 cou32DevId,
       *                 const tenDeviceConnectionReq coenConnReq,
       *                 const tenResponseCode coenRespCode)
       * \brief   To perform the actions that are required, after the select device is
       *           successful/failed
       * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
       * \pram    coenConnReq : [IN] Identifies the Connection Request.
       * \pram    coenRespCode: [IN] Response code. Success/Failure
       * \retval  t_Void
       **************************************************************************/
      static tenMySPINKeyType enGetKeyType(tenKeyCode enKeyCode);

      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/

   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ****************************END OF PROTECTED********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE**********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINInputHandler::spi_tclMySPINInputHandler(const spi_tclMySPINInputHandler..
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINInputHandler(const spi_tclMySPINInputHandler &corfrSrc)
       * \brief   Copy constructor, will not be implemented.
       * \note    This is a technique to disable the Copy constructor for this class.
       * \param   corfrSrc : [IN] Source Object
       **************************************************************************/
      spi_tclMySPINInputHandler(const spi_tclMySPINInputHandler& corfrSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINInputHandler& spi_tclMySPINInputHandler::operator= (const..
       ***************************************************************************/
      /*!
       * \fn      spi_tclMySPINInputHandler& operator= (const spi_tclMySPINInputHandler &corfrSrc)
       * \brief   Assignment Operator, will not be implemented.
       * \note    This is a technique to disable the assignment operator for this class.
       *          So if an attempt for the assignment is made linker complains.
       * \param   corfrSrc : [IN] Source Object
       **************************************************************************/
      spi_tclMySPINInputHandler& operator=(const spi_tclMySPINInputHandler& corfrSrc);

      //! Input Callbacks structure
      trInputCallbacks m_rInputCallbacks;

      //! Key Bit mask map
      std::map<tenKeyCode, t_U32> m_keyBitMaskMap;

      //! Key Bit mask map
      std::map<tenKeyCode, t_U8> m_keyAVPMap;
      
      //! Key Bit mask map
      std::map<tenKeyCode, t_U8> m_CustomKeyMap;
      
      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/

};

#endif /* SPI_TCLMYSPININPUTHANDLER_H_ */
