/*!
 *******************************************************************************
 * \file         spi_tclMySPINAOAPConnection.cpp
 * \brief        mySPIN AOAP Connection class
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    
 AUTHOR:         grikor
 COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH
 HISTORY:
 Date        | Author                | Modification
 \endverbatim
 ******************************************************************************/

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "mySPINTypes.h"
#include "spi_tclAOAPRespDiscoverer.h"
#include "spi_tclMySPINCmdSession.h"
#include "spi_tclMySPINManager.h"
#include "spi_tclAOAPCmdDiscoverer.h"
#include "spi_tclMySPINAOAPConnection.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_CONNECTIVITY
#include "trcGenProj/Header/spi_tclMySPINAOAPConnection.cpp.trc.h"
#endif
#endif

//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported


static spi_tclMySPINCmdSession* sapoMySPINCmdSession = NULL;
static t_U32 sU32SelectedDeviceID = 0;

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINAOAPConnection::spi_tclMySPINAOAPConnection
 ***************************************************************************/
spi_tclMySPINAOAPConnection::spi_tclMySPINAOAPConnection():
   m_bSelectionInProgress(false)
{
   ETG_TRACE_USR1(("spi_tclMySPINAOAPConnection::spi_tclMySPINAOAPConnection"));
}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINAOAPConnection::~spi_tclMySPINAOAPConnection
 ***************************************************************************/
spi_tclMySPINAOAPConnection::~spi_tclMySPINAOAPConnection()
{
   ETG_TRACE_USR1(("spi_tclMySPINAOAPConnection::~spi_tclMySPINAOAPConnection"));
   sapoMySPINCmdSession = NULL;
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINAOAPConnection::vRegisterCallbacks
 ***************************************************************************/
t_Void spi_tclMySPINAOAPConnection::vRegisterCallbacks(const trMySPINConnCbs &corfrMySPINConnCbs)
{
   m_rMySPINConnCbs = corfrMySPINConnCbs;
}

/***************************************************************************
 ** FUNCTION: t_Bool spi_tclMySPINAOAPConnection::bInitializeConnection
 ***************************************************************************/
t_Bool spi_tclMySPINAOAPConnection::bInitializeConnection()
{
   t_Bool bRet = true;
   spi_tclMySPINManager* poMySPINMngr = spi_tclMySPINManager::getInstance();
   if (NULL != poMySPINMngr)
   {
      sapoMySPINCmdSession = poMySPINMngr->poGetSessionInstance();
      if (NULL != sapoMySPINCmdSession)
      {
         sapoMySPINCmdSession->bInitialize();
      }
  }
   return bRet;
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINAOAPConnection::vUnInitializeConnection
 ***************************************************************************/
t_Void spi_tclMySPINAOAPConnection::vUnInitializeConnection()
{
   if (NULL != sapoMySPINCmdSession)
   {
      sapoMySPINCmdSession->vUnInitialize();
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclMySPINAOAPConnection::vOnLoadSettings
 ***************************************************************************/
t_Void spi_tclMySPINAOAPConnection::vOnLoadSettings(const trHeadUnitInfo &corfrheadUnitInfo,
                                                    const trVehicleInfo& corfrVehicleInfo,
                                                    t_U16 u16VehicleType)
{
   SPI_INTENTIONALLY_UNUSED(corfrheadUnitInfo);
   SPI_INTENTIONALLY_UNUSED(corfrVehicleInfo);
   SPI_INTENTIONALLY_UNUSED(u16VehicleType);
   //Get the information from Connection settings.
   trMySPINAoapAppInfo rMySPINAoapAppInfo;

   if (NULL != m_poConnSettings)
   {
      m_poConnSettings->vGetMySPINAoapAppInfo(rMySPINAoapAppInfo);

      m_rAccInfo.bAudioSupport = rMySPINAoapAppInfo.bAudioSupport;
      m_rAccInfo.szDescription = rMySPINAoapAppInfo.szDescription;
      m_rAccInfo.szModel = rMySPINAoapAppInfo.szVehicleModelName;
      m_rAccInfo.szUri = rMySPINAoapAppInfo.szUrl;
      m_rAccInfo.szVersion = rMySPINAoapAppInfo.szVersion;
      m_rAccInfo.szSerial = rMySPINAoapAppInfo.szSerial;
      m_rAccInfo.szVendorName = rMySPINAoapAppInfo.szVendorName;
   }

}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclMySPINAOAPConnection::vOnSelectDevice
 ***************************************************************************/
t_Void spi_tclMySPINAOAPConnection::vOnSelectDevice(const t_U32 cou32DevID, tenDeviceConnectionType enDevConnType,
         tenDeviceConnectionReq enDevSelectType, const trUserContext corUsrCntxt,
         const trMySPINDevInfo& corfrMySPINDevInfo)
{
   SPI_INTENTIONALLY_UNUSED(enDevConnType);
   SPI_INTENTIONALLY_UNUSED(corUsrCntxt);

   ETG_TRACE_USR1(("spi_tclMySPINAOAPConnection::vOnSelectDevice() with Request [%d]", ETG_ENUM(CONNECTION_REQ,
            enDevSelectType)));

   tenErrorCode enErrorCode = e8UNKNOWN_ERROR;

   t_Bool bAudioSupport = m_rAccInfo.bAudioSupport;

   if (NULL != sapoMySPINCmdSession)
   {
      if (enDevSelectType == e8DEVCONNREQ_SELECT)
      {
         m_bSelectionInProgress = true;
         sU32SelectedDeviceID = cou32DevID;
         enErrorCode = sapoMySPINCmdSession->enInitMySPINSession(cou32DevID,
                  e8DEVTYPE_AOAP,
                  corfrMySPINDevInfo,
                  m_rAccInfo,
                  bAudioSupport);
         m_bSelectionInProgress = false;

         ETG_TRACE_USR4(("[PARAM]::vOnSelectDevice:Phone supports MySPIN USB Audio -%d", ETG_ENUM(BOOL, bAudioSupport)));
         (e8NO_ERRORS == enErrorCode) ? spi_tclMySPINManager::vSetDeviceSubCategory(e8DEVTYPE_AOAP):
                                        spi_tclMySPINManager::vSetDeviceSubCategory(e8DEVTYPE_UNKNWON);

      }
      else
      {
         enErrorCode = sapoMySPINCmdSession->enUninitMySPINSession(cou32DevID, e8DEVTYPE_AOAP);
         spi_tclMySPINManager::vSetDeviceSubCategory(e8DEVTYPE_UNKNWON);
      }
   }

   if (NULL != m_rMySPINConnCbs.fvSelectDeviceResult)
   {
      (m_rMySPINConnCbs.fvSelectDeviceResult)(cou32DevID, e8DEVTYPE_AOAP, enErrorCode);
   }
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclMySPINAOAPConnection::vOnSelectDeviceResult()
 ***************************************************************************/
t_Void spi_tclMySPINAOAPConnection::vOnSelectDeviceResult(const t_U32 cou32DevID,
         const tenDeviceConnectionReq coenConnReq, const tenResponseCode coenRespCode)
{

   ETG_TRACE_USR2(("[DESC]::vOnSelectDeviceResult: Selection Type [%d]", ETG_ENUM(CONNECTION_REQ, coenConnReq)));

   if ((NULL != sapoMySPINCmdSession) && (e8DEVCONNREQ_SELECT == coenConnReq) && (e8FAILURE == coenRespCode))
   {
      ETG_TRACE_USR1(("spi_tclMySPINAOAPConnection::vOnSelectDeviceResult:Failure on Select Device- Perform Clean up"));
      sapoMySPINCmdSession->enUninitMySPINSession(cou32DevID, e8DEVTYPE_AOAP);

      spi_tclMySPINManager::vSetDeviceSubCategory(e8DEVTYPE_UNKNWON);
      sU32SelectedDeviceID = 0;
   }
}
//lint restore
///////////////////////////////////////////////////////////////////////////////
// <EOF>


