/*!
 *******************************************************************************
 * \file             spi_tclMySPINIAPConnection.h
 * \brief            IAP Connection class for MySPIN
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 02.11.2015 |  tch5kor              | Initial Version
 05.04.2016 | Chaitra Srinivasa     | Adding comments
 \endverbatim
 ******************************************************************************/
#ifndef SPI_TCLMYSPINIAPCONNECTION_H_
#define SPI_TCLMYSPINIAPCONNECTION_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "spi_tclMySPINConnection.h"
#include "spi_tclExtRespNativeTransport.h"
#include "Lock.h"

/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/*!
 * \class spi_tclMySPINConnection
 * \brief Base class for Connection classes. Provides basic connection
 *         interface to be implemented by derived classes
 */
class spi_tclMPlayClientHandler;
class spi_tclMySPINIAPConnection: public spi_tclMySPINConnection,public spi_tclExtRespNativeTransport
{
   public:
      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINIAPConnection::spi_tclMySPINIAPConnection
       ***************************************************************************/
      /*!
       * \fn     spi_tclMySPINIAPConnection()
       * \brief  Default Constructor
       * \sa      ~spi_tclMySPINIAPConnection()
       **************************************************************************/
      spi_tclMySPINIAPConnection();

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINIAPConnection::~spi_tclMySPINIAPConnection
       ***************************************************************************/
      /*!
       * \fn     ~spi_tclMySPINIAPConnection()
       * \brief  virtual Destructor
       * \sa     spi_tclMySPINIAPConnection()
       **************************************************************************/
      ~spi_tclMySPINIAPConnection();

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINIAPConnection::vRegisterCallbacks
       ***************************************************************************/
      /*!
       * \fn     vRegisterCallbacks()
       * \brief  interface for the creator class to register for the required
       *        callbacks.
       *         Mandatory interface
       * \param rfrMySPINConnCbs : reference to the callback structure
       *        populated by the caller
       * \retval t_Void
       **************************************************************************/
      t_Void vRegisterCallbacks(const trMySPINConnCbs &corfrMySPINConnCbs);

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINIAPConnection::bInitializeConnection
       ***************************************************************************/
      /*!
       * \fn     bInitializeConnection()
       * \brief  required initializations.
       *         Mandatory interface
       * \retval returns true on successful initialization and false on failure
       **************************************************************************/
      t_Bool bInitializeConnection();

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINIAPConnection::vUnInitializeConnection
       ***************************************************************************/
      /*!
       * \fn     vUnInitializeConnection()
       * \brief  Uninitialization of sdk's etc
       *         Mandatory interface
       * \retval t_Void
       **************************************************************************/
      t_Void vUnInitializeConnection();

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINIAPConnection::vOnLoadSettings
       ***************************************************************************/
      /*!
       * \fn     vOnLoadSettings()
       * \brief  Called on load settings
       *         Optional interface
       * \param corfrheadUnitInfo : Head unit information
       * \param corfrVehicleInfo : Vehicle info
       * \param u16VehicleType : Vehicle type
       * \retval t_Void
       **************************************************************************/
      t_Void vOnLoadSettings(const trHeadUnitInfo &corfrheadUnitInfo,
                             const trVehicleInfo& corfrVehicleInfo,
                             t_U16 u16VehicleType);

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINIAPConnection::vOnSelectDevice
       ***************************************************************************/
      /*!
       * \fn     vOnSelectDevice
       * \brief  Called when a device is selected by the user. Optional interface
       * \param  cou32DevID : Unique device ID
       * \param  enDevConnType   : Identifies the Connection Type.
       * \param  enDevSelectType : Identifies the Connection Request.
       * \param  corUsrCntxt      : User Context Details.
       * \param  corfrMySPINDevInfo : stores MySPIN device info
       * \retval t_Void
       **************************************************************************/
      t_Void vOnSelectDevice(const t_U32 cou32DevID, tenDeviceConnectionType enDevConnType,
               tenDeviceConnectionReq enDevSelectType, const trUserContext corUsrCntxt,
               const trMySPINDevInfo& corfrMySPINDevInfo);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINIAPConnection::vOnSelectDeviceResult()
       ***************************************************************************/
      /*!
       * \fn      t_Void vOnSelectDeviceResult
       * \brief   To perform the actions that are required, after the select device is
       *           successful/failed
       * \pram    cou32DevID  : [IN] Unique device ID
       * \pram    coenConnReq : [IN] Identifies the Connection Request.
       * \pram    coenRespCode: [IN] Response code. Success/Failure
       * \retval  t_Void
       **************************************************************************/
      t_Void vOnSelectDeviceResult(const t_U32 cou32DevID, const tenDeviceConnectionReq coenConnReq,
               const tenResponseCode coenRespCode);

       /***************************************************************************
        ** FUNCTION:  spi_tclMySPINIAPConnection::vSetSelectionProgressState
        **************************************************************************/
       /*!
        * \fn      vSetSelectionProgressState()
        * \brief   set selection state to myspin Connmanger
        * \retval  t_Void
        *************************************************************************/
       t_Void vOnSetSelectionProgressState(tenDeviceSelectionState enDeviceSelectionState);
       
   protected:
      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINIAPConnection::vPostNativeTransportStartResult()
       ***************************************************************************/
      /*!
       * \fn      t_Void vPostNativeTransportStartResult()
       * \brief   Called by MPlay client handler to inform native transport has started
       * \param   [IN] u32DeviceId: Device ID
       * \sa      None
       **************************************************************************/
      t_Void vPostNativeTransportStartResult(t_U32 u32DeviceId);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINIAPConnection::vPostNativeTransportStopResult()
       ***************************************************************************/
      /*!
       * \fn      t_Void vPostNativeTransportStopResult()
       * \brief   Called by MPlay client handler to inform native transport has stoppped
       * \param   [IN] u32DeviceId: Device ID
       * \sa      None
       **************************************************************************/
      t_Void vPostNativeTransportStopResult(t_U32 u32DeviceId) ;
      

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINIAPConnection::vMySPINSessionErrorCb()
       ***************************************************************************/
      /*!
       * \fn      vMySPINSessionErrorCb
       * \brief   Informs the mySPIN Error from Phone
       * \param   enErrorCode : Voice Session Request
       * \sa
       **************************************************************************/
      t_Void vMySPINSessionErrorCb(tenMySPINError enErrorCode) override;

   private:
      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINIAPConnection::vOnNativeTransportStart()
       ***************************************************************************/
      /*!
       * \fn     t_Void vOnNativeTransportStart(const t_U32 cou32DevID)
       * \brief  Method called on native transport start
       * \param  cou32DevID : [IN] device ID
       * \retval t_Void
       **************************************************************************/
      t_Void vOnNativeTransportStart(const t_U32 cou32DevID);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINIAPConnection::vOnNativeTransportStart()
       ***************************************************************************/
      /*!
       * \fn     t_Void vOnNativeTransportStop(const t_U32 cou32DevID)
       * \brief  Method called on native transport stop
       * \param  cou32DevID : [IN] device ID
       * \retval t_Void
       **************************************************************************/
      t_Void vOnNativeTransportStop(const t_U32 cou32DevID);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINIAPConnection::vSetSelectedDevice()
       ***************************************************************************/
      /*!
       * \fn     t_Void vSetSelectedDevice(const t_U32 cou32DevID)
       * \brief  Method to set
       * \param  cou32DevID : [IN] device ID
       * \retval t_Void
       **************************************************************************/
      t_Void vSetSelectedDevice(const t_U32 cou32DevID);

      /***************************************************************************
       ** FUNCTION: t_U32 spi_tclMySPINIAPConnection::vSetSelectedDevice()
       ***************************************************************************/
      /*!
       * \fn     t_U32 u32GetSelectedDevice()
       * \brief  Method to get the selected device
       * \retval t_Void
       **************************************************************************/
      t_U32 u32GetSelectedDevice();

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINIAPConnection::vGetSelectedDeviceSerial()
       ***************************************************************************/
      /*!
       * \fn     t_Void vGetSelectedDeviceSerial(const t_U32 cou32DevID,
       *                                         t_String& szSerial)
       * \brief  Method called to get the selected device serial
       * \param  cou32DevID : [IN] device ID
       * \param  szSerial : [IN] stores serial info
       * \retval t_Void
       **************************************************************************/
      t_Void vGetSelectedDeviceSerial(const t_U32 cou32DevID, t_String& szSerial);

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclMySPINIAPConnection::bFirstFBRenderTimerCb
       ***************************************************************************/
      /*!
       * \fn     t_Bool bNativeTransportStartTimerCb(timer_t rTimerID, t_Void *pvObject...)
       * \brief  called on expiry of NativeTransportStart timer
       * \param  rTimerID: ID of the timer which has expired
       * \param  pvObject: pointer to object passed while starting the timer
       * \param  pvUserData: data passed during start of the timer
       **************************************************************************/
      static t_Bool bNativeTransportStartTimerCb(timer_t rTimerID, t_Void *pvObject,
            const t_Void *pvUserData);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINIAPConnection::vStartTimer()
       ***************************************************************************/
      /*!
       * \fn     t_Void vStartTimer()
       * \brief  Method to start the timer
       * \param  None
       * \retval  t_Void
       **************************************************************************/
      t_Void vStartTimer();
      
      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINIAPConnection::vStopTimer()
       ***************************************************************************/
      /*!
       * \fn     t_Void vStopTimer()
       * \brief  Method to stop the timer
       * \param  None
       * \retval  t_Void
       **************************************************************************/
      t_Void vStopTimer();

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

      //! Callback structure for MySPIN connection
      trMySPINConnCbs m_rMySPINConnCbs;

      //! Structure for MySPIN accessory info
      trMySPINAccInfo m_rAccInfo;

      std::map<t_U32, trMySPINDevInfo> m_mapDeviceInfo;

      //spi_tclMPlayClientHandler* m_poMplayClientHandler;

      t_U32 m_u32SelectedDevice;

      t_Bool m_bStartTransportAfterSwitch;

      //! Lock for Initial Video Focus
      Lock m_oVideoSetupLock;

      //Lock for native transport stop
      Lock m_oNativeTransportStop;
      //maintain a map to know the switch state of the Phones.
      // DevID, SwitchInProgress || already in AOAP mode.
      
      tenDeviceSelectionState m_enDeviceSelectionState;

      t_String m_szVehicleManufacturerName;
      
      t_String m_szVehicleManufacturerScope;

      tenMySPINError m_enMySPINError;

      t_U16 m_u16VehicleType;

};
#endif // SPI_TCLMYSPINAOAPCONNECTION_H_
