/*!
 *******************************************************************************
 * \file         spi_tclMySPINConnMngr.h
 * \brief        mySPIN connection class
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    
 AUTHOR:         grikor
 COPYRIGHT:      &copy; 2015 Robert Bosch Car Multimedia GmbH
 HISTORY:
 Date        | Author                | Modification
 05.04.2016  | Chaitra Srinivasa     | Adding comments
 \endverbatim
 ******************************************************************************/
#ifndef SPI_TCL_MYSPINCONNMNGR_H_
#define SPI_TCL_MYSPINCONNMNGR_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "spi_tclConnection.h"
#include "mySPINTypes.h"
#include "spi_tclMySPINRespSession.h"

/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/
#define NUM_MYSPIN_CONN_HNDLRS 3

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/
class spi_tclMySPINConnection;

class spi_tclMySPINConnMngr: public spi_tclConnection, public spi_tclMySPINRespSession
{
   public:
      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINConnMngr::spi_tclMySPINConnMngr
       ***************************************************************************/
      /*!
       * \fn     spi_tclMySPINConnMngr()
       * \brief  Default Constructor
       * \sa      ~spi_tclMySPINConnMngr()
       **************************************************************************/
      spi_tclMySPINConnMngr();

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINConnMngr::~spi_tclMySPINConnMngr
       ***************************************************************************/
      /*!
       * \fn     ~spi_tclMySPINConnMngr()
       * \brief  Destructor
       * \sa     spi_tclMySPINConnMngr()
       **************************************************************************/
      ~spi_tclMySPINConnMngr();

      /***************************************************************************
       ** FUNCTION:  spi_tclConnection::vRegisterCallbacks
       ***************************************************************************/
      /*!
       * \fn     vRegisterCallbacks()
       * \brief  interface for the creator class to register for the required
       *        callbacks.
       *         Mandatory interface
       * \param rfrConnCallbacks : reference to the callback structure
       *        populated by the caller
       * \retval t_Void
       **************************************************************************/
      t_Void vRegisterCallbacks(trConnCallbacks &rfrConnCallbacks);

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINConnMngr::bInitializeConnection
       ***************************************************************************/
      /*!
       * \fn     bInitializeConnection()
       * \brief  Initialization of device detection and
       *         any other required initializations
       * \retval returns true on successful initialization and false on failure
       **************************************************************************/
      t_Bool bInitializeConnection();

      /***************************************************************************
       ** FUNCTION:  spi_tclConnection::vUnInitializeConnection
       ***************************************************************************/
      /*!
       * \fn     vUnInitializeConnection()
       * \brief  Uninitialization of sdk's etc
       *         Mandatory interface
       * \retval t_Void
       **************************************************************************/
      t_Void vUnInitializeConnection();

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINConnMngr::vOnLoadSettings
       ***************************************************************************/
      /*!
       * \fn     vOnLoadSettings()
       * \brief  Called on loadsettings
       *         Optional interface
       * \param rfrheadUnitInfo : Head unit information
       * \retval t_Void
       **************************************************************************/
      t_Void vOnLoadSettings(trHeadUnitInfo &rfrheadUnitInfo, tenCertificateType enCertificateType);

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINConnMngr::vOnSaveSettings
       ***************************************************************************/
      /*!
       * \fn     vOnSaveSettings()
       * \brief  Called on savesettings
       *         Optional interface
       * \retval none
       **************************************************************************/
      t_Void vOnSaveSettings();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINConnMngr::vOnSelectDevice()
       ***************************************************************************/
      /*!
       * \fn     t_Void vOnSelectDevice()
       * \brief  Function to get the device selection.
       * \param  cou32DevID : [IN] Unique device ID
       * \param  enDevConnType : [IN] Device connection type
       * \param  enDevSelectType : [IN] Device select type
       * \param  enDAPUsage : [IN] DAP usage is selected as preference
       * \param  enCDBUsage : [IN] CDB usage is selected as preference
       * \param  enSelectReason   :  [IN] Describes whether the device Selection or Deselection is
       *               triggered due to a user action.
       * \param  corfrUsrCntxt : [IN] Stores user context info
       * \retval t_Void
       **************************************************************************/
      t_Void vOnSelectDevice(const t_U32 cou32DevID, tenDeviceConnectionType enDevConnType,
               tenDeviceConnectionReq enDevSelectType, tenEnabledInfo enDAPUsage, tenEnabledInfo enCDBUsage,
               tenSelectReason enSelectionReason, const trUserContext corfrUsrCntxt, tenDeviceType enDeviceType = e8_UNKNOWN_DEVICE);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINConnMngr::vOnSelectDeviceResult()
       ***************************************************************************/
      /*!
       * \fn      t_Void vOnSelectDeviceResult
       * \brief   To perform the actions that are required, after the select device is
       *           successful/failed
       * \param  cou32DevID  : [IN] Uniquely identifies the device ID
       * \param  enDevSelReq : [IN] Identifies the Connection Request.
       * \param  coenRespCode: [IN] Response code. Success/Failure
       * \param  enDevCat    : [IN] Device Category. ML/DiPo
       * \param  enSelectReason   :  [IN] Describes whether the device Selection or Deselection is
       *               triggered due to a user action.
       * \retval  t_Void
       **************************************************************************/
      t_Void vOnSelectDeviceResult(const t_U32 cou32DevID, const tenDeviceConnectionReq enDevSelectType,
               const tenResponseCode coenRespCode, tenDeviceCategory enDevCat, tenSelectReason enSelectionReason,
               tenDeviceType enDeviceType = e8_UNKNOWN_DEVICE);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINConnMngr::vSelectDeviceResultCb()
       ***************************************************************************/
      /*!
       * \fn     vSelectDeviceResultCb(t_U32 u32DevID,
       *                               tenDeviceSubCategory enDevSubCat,
       *                               tenErrorCode enErrorCode)
       * \brief Method gives the result of device selection
       * \param u32DevID : [IN] Unique device handle
       * \param enDevSubCat : [IN] device sub category
       * \param enErrorCode : [IN] identifies different error codes
       * \retval t_Void
       **************************************************************************/
      t_Void vSelectDeviceResultCb(t_U32 u32DevID, tenDeviceSubCategory enDevSubCat, tenErrorCode enErrorCode);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINConnMngr::vSetSelectErrorCb()
       ***************************************************************************/
      /*!
       * \fn     t_Void vSetSelectErrorCb(t_U32 u32DevID,
       *                                  tenErrorCode enErrorCode)
       * \brief  Method to set the selection error
       * \param  u32DevID : [IN] Unique device ID
       * \param  enErrorCode : [IN] identifies different error codes
       * \retval t_Void
       **************************************************************************/
      t_Void vSetSelectErrorCb(t_U32 u32DevID, tenErrorCode enErrorCode);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINConnMngr::vOnDeviceConnection()
       ***************************************************************************/
      /*!
       * \fn     t_Void vOnDeviceConnection(t_U32, const trDeviceInfo&)
       * \brief  Method called on device connection
       * \retval t_Void
       **************************************************************************/
      t_Void vOnDeviceConnection(t_U32, const trDeviceInfo&)
      {
      }

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINConnMngr::vOnDeviceDisconnection()
       ***************************************************************************/
      /*!
       * \fn     t_Void vOnDeviceDisconnection(t_U32)
       * \brief  Method called on device disconnection
       * \retval t_Void
       **************************************************************************/
      t_Void vOnDeviceDisconnection(t_U32)
      {
      }
      /***************************************************************************
       ** FUNCTION:  spi_tclConnection::bSetDevProjUsage
       ***************************************************************************/
      /*!
       * \fn     bSetDevProjUsage()
       * \brief  Called when the SPI featured is turned ON or OFF by the user.
       *         Mandatory interface
       * \param  enServiceStatus : Sets the particular SPI service ON or OFF
       **************************************************************************/
      t_Bool bSetDevProjUsage(tenEnabledInfo enServiceStatus);


      /***************************************************************************
       ** FUNCTION:  spi_tclConnection::bStartDeviceDetection
       ***************************************************************************/
      /*!
       * \fn     bStartDeviceDetection()
       * \brief  Starts device detection
       * \retval returns true on successful detection and false on failure
       **************************************************************************/
      t_Bool bStartDeviceDetection() 
      {
          return true;
      }

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINConnMngr::vSetRoleSwitchRequestedInfo()
       ***************************************************************************/
      /*!
       * \fn    t_Void vSetRoleSwitchRequestedInfo(const t_U32 cou32DeviceHandle)
       * \brief Method to set the role switch request info
       * \param cou32DeviceHandle : [IN] device handle
       * \retval t_Void
       **************************************************************************/
      virtual t_Void vSetRoleSwitchRequestedInfo(const t_U32 cou32DeviceHandle);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINConnMngr::vSetDeviceSwitchInfo()
       ***************************************************************************/
      /*!
       * \fn    t_Void vSetDeviceSwitchInfo(trDeviceSwitchInfo &rfrDeviceSwitchInfo)
       * \brief Method to set the device switch info
       * \param rfrDeviceSwitchInfo : [IN] device switch info
       * \retval t_Void
       **************************************************************************/
      virtual t_Void vSetDeviceSwitchInfo(trDeviceSwitchInfo &rfrDeviceSwitchInfo);
      
      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINConnMngr::vSetSelectionProgressState
       **************************************************************************/
      /*!
       * \fn      vSetSelectionProgressState()
       * \brief   set selection state to myspin Connmanger
       * \retval  t_Void
       *************************************************************************/
      virtual t_Void vOnSetSelectionProgressState(tenDeviceSelectionState /*enDeviceSelectionState*/);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclMySPINConnMngr::vSetVehicleManufactureInfo()
       ***************************************************************************/
      /*!
       * \fn    t_Void vSetVehicleManufactureInfo(const t_U32 cou32DeviceHandle)
       * \brief Method to set the vehicle manufacturer info
       * \param cou32DeviceHandle : [IN] device handle
       * \retval t_Void
       **************************************************************************/
       t_Void vSetVehicleManufactureInfo(const t_U32 cou32DeviceHandle);

   protected:

   private:

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINConnMngr::vMySPINSessionErrorCb()
       ***************************************************************************/
      /*!
       * \fn      vMySPINSessionErrorCb
       * \brief   Informs the mySPIN Error from Phone
       * \param   enErrorCode : Voice Session Request
       * \sa
       **************************************************************************/
      virtual t_Void vMySPINSessionErrorCb(const t_U32 cou32DeviceHandle,tenMySPINError enErrorCode);

      /***************************************************************************
       ** FUNCTION: t_Bool spi_tclMySPINConnMngr::bValidateConnHndlr(...)
       ***************************************************************************/
      /*!
       * \fn     t_Bool bValidateConnHndlr(t_U8 u8Index)
       * \brief  Method to validate the connection handler
       * \param  u8Index : [IN] Stores the index value
       * \retval t_Void
       **************************************************************************/
      t_Bool bValidateConnHndlr(t_U8 u8Index);

      //! Call baclk structure for connection
      trConnCallbacks m_rConnCbs;

      //! MySPIN connection handler
      spi_tclMySPINConnection* m_apoMySPINConnHndlrs[NUM_MYSPIN_CONN_HNDLRS];

      //@todo - thread safe mechanism to be implemented
      std::map<t_U32, trMySPINDeviceInfo> m_mapDevInfo;

      // list of devices with OTG Support
      std::map<t_U32, t_Bool> m_mapOTGDevice;

      //! TODO use a map
      trDeviceSwitchInfo m_rDeviceSwitchInfo;
      
      tenMySPINError m_enMySPINError;

};

#endif /* SPI_TCL_MYSPINCONNMNGR_H_ */
