/*!
 *******************************************************************************
 * \file             spi_tclMySPINAOAPConnection.h
 * \brief            AOAP Connection class for MySPIN
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 02.11.2015 |  Shiva Kumar Gurija          | Initial Version
 05.04.2016 |  Chaitra Srinivasa           | Adding comments
 \endverbatim
 ******************************************************************************/
#ifndef SPI_TCLMYSPINAOAPCONNECTION_H_
#define SPI_TCLMYSPINAOAPCONNECTION_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "spi_tclMySPINConnection.h"
#include "spi_tclAOAPRespDiscoverer.h"

/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/*!
 * \class spi_tclMySPINConnection
 * \brief Base class for Connection classes. Provides basic connection
 *         interface to be implemented by derived classes
 */

class spi_tclMySPINAOAPConnection: public spi_tclMySPINConnection
{
   public:
      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINAOAPConnection::spi_tclMySPINAOAPConnection
       ***************************************************************************/
      /*!
       * \fn     spi_tclMySPINAOAPConnection()
       * \brief  Default Constructor
       * \sa     ~spi_tclMySPINAOAPConnection()
       **************************************************************************/
      spi_tclMySPINAOAPConnection();

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINAOAPConnection::~spi_tclMySPINAOAPConnection
       ***************************************************************************/
      /*!
       * \fn     ~spi_tclMySPINAOAPConnection()
       * \brief  virtual Destructor
       * \sa     spi_tclMySPINAOAPConnection()
       **************************************************************************/
      ~spi_tclMySPINAOAPConnection();

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINAOAPConnection::vRegisterCallbacks
       ***************************************************************************/
      /*!
       * \fn     vRegisterCallbacks()
       * \brief  interface for the creator class to register for the required
       *        callbacks.
       *         Mandatory interface
       * \param rfrMySPINConnCbs : reference to the callback structure
       *        populated by the caller
       * \retval t_Void
       **************************************************************************/
      t_Void vRegisterCallbacks(const trMySPINConnCbs &corfrMySPINConnCbs);

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINAOAPConnection::bInitializeConnection
       ***************************************************************************/
      /*!
       * \fn     bInitializeConnection()
       * \brief  required initializations.
       *         Mandatory interface
       * \retval returns true on successful initialization and false on failure
       **************************************************************************/
      t_Bool bInitializeConnection();

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINAOAPConnection::vUnInitializeConnection
       ***************************************************************************/
      /*!
       * \fn     vUnInitializeConnection()
       * \brief  Uninitialization of sdk's etc
       *         Mandatory interface
       * \retval t_Void
       **************************************************************************/
      t_Void vUnInitializeConnection();

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINAOAPConnection::vOnLoadSettings
       ***************************************************************************/
      /*!
       * \fn     vOnLoadSettings()
       * \brief  Called on load settings
       *         Optional interface
       * \param corfrheadUnitInfo : Head unit information
       * \param corfrVehicleInfo : Vehicle info
       * \param u16VehicleType : Vehicle type
       * \retval t_Void
       **************************************************************************/
      t_Void vOnLoadSettings(const trHeadUnitInfo &corfrheadUnitInfo,
                             const trVehicleInfo& corfrVehicleInfo,
                             t_U16 u16VehicleType);

      /***************************************************************************
       ** FUNCTION:  spi_tclMySPINAOAPConnection::vOnSelectDevice
       ***************************************************************************/
      /*!
       * \fn     vOnSelectDevice
       * \brief  Called when a device is selected by the user. Optional interface
       * \param  u32DeviceHandle : Uniquely identifies the target Device.
       * \param  enDevConnType   : Identifies the Connection Type.
       * \param  enDevSelectType : Identifies the Connection Request.
       * \param  corUsrCntxt      : User Context Details.
       * \retval t_Void
       **************************************************************************/
      t_Void vOnSelectDevice(const t_U32 cou32DevID, tenDeviceConnectionType enDevConnType,
               tenDeviceConnectionReq enDevSelectType, const trUserContext corUsrCntxt,
               const trMySPINDevInfo& corfrMySPINDevInfo);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclMySPINAOAPConnection::vOnSelectDeviceResult()
       ***************************************************************************/
      /*!
       * \fn      t_Void vOnSelectDeviceResult
       * \brief   To perform the actions that are required, after the select device is
       *           successful/failed
       * \pram    cou32DeviceHandle  : [IN] Uniquely identifies the target Device.
       * \pram    enDevSelReq : [IN] Identifies the Connection Request.
       * \pram    coenRespCode: [IN] Response code. Success/Failure
       * \retval  t_Void
       **************************************************************************/
      t_Void vOnSelectDeviceResult(const t_U32 cou32DevID, const tenDeviceConnectionReq coenConnReq,
               const tenResponseCode coenRespCode);

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

      //! call back structure for MySPIN connection
      trMySPINConnCbs m_rMySPINConnCbs;

      //! structure for MySPIN accessory information
      trMySPINAccInfo m_rAccInfo;

      //@todo - thread safe mechanism to be implemented
      t_Bool m_bSelectionInProgress;

      //maintain a map to know the switch state of the Phones.
      // DevID, SwitchInProgress || already in AOAP mode.

};
#endif // SPI_TCLMYSPINAOAPCONNECTION_H_
