/***********************************************************************/
/*!
 * \file    spi_tclOnCarResourceMngr.cpp
 * \brief   OnCar Resource Manager
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    OnCar Resource Manager
 AUTHOR:         Unmukt Jain
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 21.03.2018  | Unmukt Jain           | Initial Version
 20.8.2018   | Ashwini Savadi        | Audio Resource Manager adaptation for
                                        Media.
 \endverbatim
 *************************************************************************/

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "spi_tclResorceMngrDefines.h"
#include "spi_tclOnCarResourceMngr.h"
#include "spi_tclOnCarManager.h"
#include "spi_tclOnCarCmdVideo.h"
#include "spi_tclOnCarVideoResourceMngr.h"
#include "spi_tclOnCarAudioResourceMngr.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_RSRCMNGR
#include "trcGenProj/Header/spi_tclOnCarResourceMngr.cpp.trc.h"
#endif
#endif
//lint -save -e1055 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1401 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e19 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e58 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e48 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e808 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e63 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e64 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e746 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e515 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e516 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/
static tenNavAppState senCurAccNavAppState = e8SPI_NAV_NOT_ACTIVE;

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarResourceMngr::spi_tclOnCarResourceMngr()
 ***************************************************************************/
spi_tclOnCarResourceMngr::spi_tclOnCarResourceMngr():
m_u32SelDevID(0),m_poVideoRscMngr(NULL),m_poAudioRscMngr(NULL)
{
   ETG_TRACE_USR1(("spi_tclOnCarResourceMngr() entered "));
   m_poVideoRscMngr = new(std::nothrow) spi_tclOnCarVideoResourceMngr(this);
   m_poAudioRscMngr = new(std::nothrow) spi_tclOnCarAudioResourceMngr(this);
   m_rDeviceAppStates.enSpeechAppState = e8SPI_SPEECH_UNKNOWN;
   m_rDeviceAppStates.enPhoneAppState  = e8SPI_PHONE_UNKNOWN;
   m_rDeviceAppStates.enNavAppState    = e8SPI_NAV_UNKNOWN;
}

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarResourceMngr::~spi_tclOnCarResourceMngr()
 ***************************************************************************/
spi_tclOnCarResourceMngr::~spi_tclOnCarResourceMngr()
{
   ETG_TRACE_USR1(("~spi_tclOnCarResourceMngr() entered"));
   RELEASE_MEM(m_poVideoRscMngr);
   RELEASE_MEM(m_poAudioRscMngr);
   m_rDeviceAppStates.enSpeechAppState = e8SPI_SPEECH_UNKNOWN;
   m_rDeviceAppStates.enPhoneAppState  = e8SPI_PHONE_UNKNOWN;
   m_rDeviceAppStates.enNavAppState    = e8SPI_NAV_UNKNOWN;
}

/***************************************************************************
 ** FUNCTION:  t_Void  spi_tclOnCarResourceMngr::vRegRsrcMngrCallBack()
 ***************************************************************************/
t_Void spi_tclOnCarResourceMngr::vRegRsrcMngrCallBack(trRsrcMngrCallback rRsrcMngrCallback)
{
   ETG_TRACE_USR1(("spi_tclOnCarResourceMngr::vRegRsrcMngrCallBack entered"));
   m_rRsrcMngrCb = rRsrcMngrCallback;
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclResourceMngrBase::bInitialize()
 ***************************************************************************/
t_Bool spi_tclOnCarResourceMngr::bInitialize()
{
   ETG_TRACE_USR1(("spi_tclOnCarResourceMngr::bInitialize entered"));

   t_Bool bRet = false;

   spi_tclOnCarManager *poOnCarManager = spi_tclOnCarManager::getInstance();
   if(NULL!= poOnCarManager)
   {
       bRet = poOnCarManager->bRegisterObject((spi_tclOnCarRespSession*)this);
       bRet = poOnCarManager->bRegisterObject((spi_tclOnCarRespVideo*) this);
       bRet = poOnCarManager->bRegisterObject((spi_tclOnCarRespAudio*) this);
   }
   if(NULL != m_poVideoRscMngr)
   {
       m_poVideoRscMngr->bInitialize();
   }
   if(NULL != m_poAudioRscMngr)
   {
       m_poAudioRscMngr->bInitialize();
   }
   return bRet;
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclOnCarResourceMngr::vUninitialize()
 ***************************************************************************/
t_Void spi_tclOnCarResourceMngr::vUnInitialize()
{
    if (NULL != m_poVideoRscMngr)
    {
        m_poVideoRscMngr->vUnInitialize();
    }//if(NULL != m_poVideoRscMngr)
    if(NULL != m_poAudioRscMngr)
    {
        m_poAudioRscMngr->vUnInitialize();
    }//if(NULL != m_poVideoRscMngr)
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclOnCarResourceMngr::vSetAccessoryDisplayContext()
 ***************************************************************************/
t_Void spi_tclOnCarResourceMngr::vSetAccessoryDisplayContext(const t_U32 cou32DevId, t_Bool bDisplayFlag,
         tenDisplayContext enDisplayContext, const trUserContext& rfrcUsrCntxt)
{
   SPI_INTENTIONALLY_UNUSED(rfrcUsrCntxt);
   ETG_TRACE_USR1(("spi_tclOnCarResourceMngr::vSetAccessoryDisplayContext"));
   if (NULL != m_poVideoRscMngr)
   {
       m_poVideoRscMngr->vSetAccessoryDisplayContext(cou32DevId,
               bDisplayFlag,
               enDisplayContext);
   }//if(NULL != poVideoRsrcMngr)
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclOnCarResourceMngr::vSetAccessoryDisplayContext()
 ***************************************************************************/
t_Void spi_tclOnCarResourceMngr::vSelectDevice(const t_U32 cou32DevId, tenDeviceConnectionReq enConnReq,
                                               tenDeviceCategory enDevCat)
{
    SPI_INTENTIONALLY_UNUSED(enDevCat);
    ETG_TRACE_USR1(("spi_tclOnCarResourceMngr::vSelectDevice"));
    if(e8DEVCONNREQ_SELECT == enConnReq)
    {
        m_u32SelDevID = cou32DevId;
    }
    if (NULL != m_rRsrcMngrCb.fvSelectDeviceResult)
    {
        m_rRsrcMngrCb.fvSelectDeviceResult(true);
    }
}
/***************************************************************************
 ** FUNCTION:  t_Void  spi_tclOnCarResourceMngr::vOnSPISelectDeviceResult()
 ***************************************************************************/
t_Void spi_tclOnCarResourceMngr::vOnSPISelectDeviceResult(t_U32 u32DevID, tenDeviceConnectionReq enDeviceConnReq,
         tenResponseCode enRespCode, tenErrorCode enErrorCode)
{
   ETG_TRACE_USR1(("spi_tclOnCarResourceMngr::vOnSPISelectDeviceResult"));
   if (NULL != m_poVideoRscMngr)
   {
       m_poVideoRscMngr->vOnSPISelectDeviceResult(u32DevID,
            enDeviceConnReq, enRespCode, enErrorCode);
   }//if(NULL != poVideoRsrcMngr)
   if(e8DEVCONNREQ_SELECT == enDeviceConnReq && e8FAILURE == enRespCode)
   {
       m_u32SelDevID = 0;
   }
   //!Reset the Application states once AAP device is disconnected/deselected
   if((e8DEVCONNREQ_DESELECT == enDeviceConnReq) && (NULL != m_rRsrcMngrCb.fvPostDeviceAppState) &&
            (NULL != m_rRsrcMngrCb.fvSetDeviceAppState))
   {
      m_rDeviceAppStates.enSpeechAppState = e8SPI_SPEECH_END;
      m_rDeviceAppStates.enPhoneAppState  = e8SPI_PHONE_NOT_ACTIVE;
      m_rDeviceAppStates.enNavAppState    = e8SPI_NAV_NOT_ACTIVE;

      vAcquireDevAppStateLock();
      m_rRsrcMngrCb.fvSetDeviceAppState(m_rDeviceAppStates.enSpeechAppState,
               m_rDeviceAppStates.enPhoneAppState, m_rDeviceAppStates.enNavAppState);
      vReleaseDevAppStateLock();

      m_rRsrcMngrCb.fvPostDeviceAppState(m_rDeviceAppStates.enSpeechAppState,
               m_rDeviceAppStates.enPhoneAppState, m_rDeviceAppStates.enNavAppState, corEmptyUsrContext);
   }
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclOnCarResourceMngr::vUpdateDeviceDisplayCntxt()
 ***************************************************************************/
t_Void spi_tclOnCarResourceMngr::vUpdateDeviceDisplayCntxt(t_Bool bDisplayFlag, tenDisplayContextReason enDisplayContextReason)
{
   /*lint -esym(40,fvPostDeviceDisplayContext) fvPostDeviceDisplayContext is not declared */
   ETG_TRACE_USR2(("spi_tclOnCarResourceMngr::vUpdateDeviceDisplayCntxt bDisplayFlag-%d", ETG_ENUM(BOOL, bDisplayFlag)));
   if (NULL != m_rRsrcMngrCb.fvPostDeviceDisplayContext)
   {
      (m_rRsrcMngrCb.fvPostDeviceDisplayContext)(bDisplayFlag, enDisplayContextReason,
               tenDiPOEntity::e8DIPO_ENTITY_NA, corEmptyUsrContext);
   }//if(NULL != m_rRsrcMngrCb.fvPostDeviceDisplayContext)
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclOnCarResourceMngr::vOnSessionStatusInfo()
 ***************************************************************************/
t_Void spi_tclOnCarResourceMngr::vOnSessionStatusInfo(tenSessionStatus enSessionStatus)
{
   /*lint -esym(40,fvUpdateSessionStatus)fvUpdateSessionStatus Undeclared identifier */
   ETG_TRACE_USR2(("spi_tclOnCarResourceMngr::vOnSessionStatusInfo enSessionStatus = %d\n", ETG_ENUM(SESSION_STATUS, enSessionStatus)));
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclOnCarResourceMngr::vSetAccessoryDisplayMode(t_U32...
 ***************************************************************************/
t_Void spi_tclOnCarResourceMngr::vSetAccessoryDisplayMode(const t_U32 cou32DeviceHandle, const trDisplayContext corDisplayContext,
         const trDisplayConstraint corDisplayConstraint, const tenDisplayInfo coenDisplayInfo)
{
   ETG_TRACE_USR1(("spi_tclOnCarResourceMngr::vSetAccessoryDisplayMode()"));
   if (NULL != m_poVideoRscMngr)
   {
       m_poVideoRscMngr->vSetAccessoryDisplayMode(cou32DeviceHandle,
         corDisplayContext, corDisplayConstraint, coenDisplayInfo);
   }//if(NULL != poVideoRsrcMngr)
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclOnCarResourceMngr::vRequestProjUI()
***************************************************************************/
t_Void spi_tclOnCarResourceMngr::vRequestProjUI(t_U32 u32DevId,t_U32 u32AppId)
{
   if (NULL != m_poVideoRscMngr)
   {
       m_poVideoRscMngr->vRequestProjUI(u32DevId,u32AppId);
   }//if(NULL != poVideoRsrcMngr)
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclOnCarResourceMngr::vSetAccessoryAudioContext(t_U32...
 ***************************************************************************/
t_Void spi_tclOnCarResourceMngr::vSetAccessoryAudioContext(const t_U32 cou32DevId,
         const tenAudioContext coenAudioCntxt, t_Bool bReqFlag, const trUserContext& rfrcUsrCntxt)
{
   SPI_INTENTIONALLY_UNUSED(rfrcUsrCntxt);
   ETG_TRACE_USR1(("spi_tclOnCarResourceMngr::vSetAccessoryAudioContext"));
   if(NULL != m_poAudioRscMngr)
   {
    m_poAudioRscMngr->vSetAccessoryAudioContext(cou32DevId,
           coenAudioCntxt,
           bReqFlag);
   }
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclOnCarResourceMngr::vSetAccessoryAppState(...
 ***************************************************************************/
t_Void spi_tclOnCarResourceMngr::vSetAccessoryAppState(tenSpeechAppState enAccSpeechAppState, tenPhoneAppState enAccPhoneAppState,
                                                       tenNavAppState enAccNavAppState, const trUserContext& rfrcUsrCntxt)
{
   ETG_TRACE_USR1(("spi_tclOnCarResourceMngr::vSetAccessoryAppState : Nav State - %d\n  ",
   ETG_ENUM(NAV_APP_STATE, enAccNavAppState)));
   //!Accessory Phone and Speech App states are not used since device does not require this info.
   SPI_INTENTIONALLY_UNUSED(enAccSpeechAppState);
   SPI_INTENTIONALLY_UNUSED(enAccPhoneAppState);
   SPI_INTENTIONALLY_UNUSED(rfrcUsrCntxt);
   spi_tclOnCarManager *poOnCarManager = spi_tclOnCarManager::getInstance();
   spi_tclOnCarCmdSession *poOnCarCmdSession = NULL;
   if((NULL != poOnCarManager) && (0 != m_u32SelDevID)
       && ((enAccNavAppState != senCurAccNavAppState) && (e8SPI_NAV_ACTIVE == enAccNavAppState)))
   {
      poOnCarCmdSession = poOnCarManager->poGetSessionInstance();
      if((NULL != poOnCarCmdSession) && (NULL != m_rRsrcMngrCb.fvPostDeviceAppState) &&
               (NULL != m_rRsrcMngrCb.fvSetDeviceAppState))
      {       
         poOnCarCmdSession->vSetNavigationFocus(enAccNavAppState);
         m_rDeviceAppStates.enNavAppState = (e8SPI_NAV_ACTIVE == enAccNavAppState) ? e8SPI_NAV_NOT_ACTIVE:e8SPI_NAV_ACTIVE;
         vAcquireDevAppStateLock();
         m_rRsrcMngrCb.fvSetDeviceAppState(m_rDeviceAppStates.enSpeechAppState,
                  m_rDeviceAppStates.enPhoneAppState, m_rDeviceAppStates.enNavAppState);
         vReleaseDevAppStateLock();
         m_rRsrcMngrCb.fvPostDeviceAppState(m_rDeviceAppStates.enSpeechAppState,
                  m_rDeviceAppStates.enPhoneAppState, m_rDeviceAppStates.enNavAppState, corEmptyUsrContext);
      }
   }  
   senCurAccNavAppState = enAccNavAppState;
}

/***************************************************************************
 ** FUNCTION: t_Void spi_tclOnCarResourceMngr::vPostOnCarSessionStateMsg(...
 ***************************************************************************/
t_Void spi_tclOnCarResourceMngr::vPostOnCarSessionStateMsg(const tenOnCarSessionState enOnCarSessionState)
{
    ETG_TRACE_USR1(("spi_tclOnCarResourceMngr::vPostOnCarSessionStateMsg session state=%d",enOnCarSessionState));
    if(0 != m_u32SelDevID)
    {
        if(e8_ONCAR_SESSION_STATE_START == enOnCarSessionState)
        {
            if(NULL != m_rRsrcMngrCb.fvUpdateSessionStatus)
            {
                m_rRsrcMngrCb.fvUpdateSessionStatus(m_u32SelDevID, e8DEV_TYPE_ONCAR, e8_SESSION_ACTIVE);
            }
        }
        else if(e8_ONCAR_SESSION_STATE_STOP == enOnCarSessionState)
        {
            if(NULL != m_rRsrcMngrCb.fvUpdateSessionStatus)
            {
                m_rRsrcMngrCb.fvUpdateSessionStatus(m_u32SelDevID, e8DEV_TYPE_ONCAR, e8_SESSION_INACTIVE);
            }
        }
        else if(e8_ONCAR_SESSION_STATE_USR_INTERACT_NEEDED == enOnCarSessionState)
        {
            vDevAuthAndAccessInfoCb(m_u32SelDevID,e8_HANDSET_INTERACTION_REQUIRED);
        }
        else if(e8_ONCAR_SESSION_STATE_USR_INTERACT_NOT_NEEDED == enOnCarSessionState)
        {
            vDevAuthAndAccessInfoCb(m_u32SelDevID,e8_HANDSET_INTERACTION_NOT_REQUIRED);
        }
    }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclOnCarResourceMngr::vVideoFocusCallback()
***************************************************************************/
t_Void spi_tclOnCarResourceMngr::vPostOnCarRequestVideoFocusMsg(const tenOnCarVideoFocus enOnCarVideoFocus,
                                                          const tenOnCarVideoFocusReason enOnCarVideoFocusReason)
{
    if (NULL != m_poVideoRscMngr)
    {
        m_poVideoRscMngr->vPostOnCarRequestVideoFocusMsg(enOnCarVideoFocus,enOnCarVideoFocusReason);
    }//if(NULL != poVideoRsrcMngr)
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclOnCarResourceMngr::vVideoFocusCallback()
***************************************************************************/
t_Void spi_tclOnCarResourceMngr::vPostOnCarStartVideoPlaybackMsg()
{
    if (NULL != m_poVideoRscMngr)
    {
        m_poVideoRscMngr->vPostOnCarStartVideoPlaybackMsg();
    }//if(NULL != poVideoRsrcMngr)
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclOnCarResourceMngr::vVideoFocusCallback()
***************************************************************************/
t_Void spi_tclOnCarResourceMngr::vPostOnCarStopVideoPlaybackMsg()
{
    if (NULL != m_poVideoRscMngr)
    {
        m_poVideoRscMngr->vPostOnCarStopVideoPlaybackMsg();
    }//if(NULL != poVideoRsrcMngr)
}
/***************************************************************************
 ** FUNCTION: t_Void spi_tclOnCarResourceMngr::vPostaudioFocusRequestCallback(..
 ***************************************************************************/
t_Void spi_tclOnCarResourceMngr::vPostaudioFocusRequestCallback(const tenOnCarAudioStreamType enStreamType,
        const tenOnCarAudioFocusRequest enFocusRequest)
{
    ETG_TRACE_USR1(("spi_tclOnCarResourceMngr::vPostaudioFocusRequestCallback() Entered"));
    ETG_TRACE_USR1(("spi_tclOnCarResourceMngr::vPostaudioFocusRequestCallback() enStreamType=%d, enFocusRequest=%d",enStreamType,enFocusRequest));
    if(NULL != m_poAudioRscMngr)
    {
        m_poAudioRscMngr->vPostaudioFocusRequestCallback(enStreamType, enFocusRequest);
    }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclOnCarResourceMngr::vPostOnCarAppStateMsg(const...
***************************************************************************/
t_Void spi_tclOnCarResourceMngr::vPostOnCarAppStateMsg(const tenNavAppState enNavAppState,
                                    const tenSpeechAppState enSpeechAppState,
                                    const tenPhoneAppState enPhoneAppState)
{
    ETG_TRACE_USR1(("spi_tclOnCarResourceMngr::vPostOnCarAppStateMsg entered"));
    if((NULL != m_rRsrcMngrCb.fvPostDeviceAppState) &&
               (NULL != m_rRsrcMngrCb.fvSetDeviceAppState))
    {        
         trUserContext rDummyUsrCntxt;
         vAcquireDevAppStateLock();
         m_rRsrcMngrCb.fvSetDeviceAppState(enSpeechAppState,
                  enPhoneAppState, enNavAppState);
         vReleaseDevAppStateLock();
         m_rRsrcMngrCb.fvPostDeviceAppState(enSpeechAppState,
                  enPhoneAppState, enNavAppState, rDummyUsrCntxt);
      
    }   
    
}

/***************************************************************************
** FUNCTION: t_Void spi_tclOnCarResourceMngr::vDevAuthAndAccessInfoCb()
***************************************************************************/
t_Void spi_tclOnCarResourceMngr::vDevAuthAndAccessInfoCb(const t_U32 cou32DevId,
                               const tenHandsetInteractionStatus coenHandsetInteractionReqd)
{
   /*lint -esym(40,fpvDeviceAuthAndAccessCb) fpvDeviceAuthAndAccessCb Undeclared identifier */
   /*lint -esym(746,fpvDeviceAuthAndAccessCb)call to function fpvDeviceAuthAndAccessCb() not made in the presence of a prototype */

   if (NULL != m_rRsrcMngrCb.fpvDeviceAuthAndAccessCb)
   {
      (m_rRsrcMngrCb.fpvDeviceAuthAndAccessCb)(cou32DevId,coenHandsetInteractionReqd);
   }//if (NULL != m_rRsrcMngrCb.fpvD
}
//lint restore
///////////////////////////////////////////////////////////////////////////////
// <EOF>
