/***********************************************************************/
/*!
 * \file    spi_tclOnCarResourceMngr.h
 * \brief   OnCar Resource Manager
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    OnCar Resource Manager
 AUTHOR:         Unmukt Jain
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 21.03.2018  | Unmukt Jain           | Initial Version
 \endverbatim
 *************************************************************************/

#ifndef _SPI_TCLONCARRESOURCEMNGR_H_
#define _SPI_TCLONCARRESOURCEMNGR_H_

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "spi_tclResorceMngrDefines.h"
#include "spi_tclResourceMngrBase.h"
#include "spi_tclOnCarRespSession.h"
#include "spi_tclOnCarRespVideo.h"
#include "spi_tclOnCarRespAudio.h"

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/
class spi_tclOnCarVideoResourceMngr;
class spi_tclOnCarAudioResourceMngr;

/****************************************************************************/
/*!
 * \class  spi_tclOnCarResourceMngr
 * \brief  Oncar Resource Manager
 ****************************************************************************/
class spi_tclOnCarResourceMngr: public spi_tclResourceMngrBase, public spi_tclOnCarRespSession, public spi_tclOnCarRespVideo,public spi_tclOnCarRespAudio
{

   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarResourceMngr::spi_tclOnCarResourceMngr()
       ***************************************************************************/
      /*!
       * \fn      spi_tclOnCarResourceMngr()
       * \brief   Default Constructor
       * \param   t_Void
       * \sa      ~spi_tclOnCarResourceMngr()
       **************************************************************************/
    spi_tclOnCarResourceMngr();

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarResourceMngr::~spi_tclOnCarResourceMngr()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclOnCarResourceMngr()
       * \brief   Destructor
       * \param   t_Void
       * \sa      spi_tclOnCarResourceMngr()
       **************************************************************************/
      ~spi_tclOnCarResourceMngr();

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclOnCarResourceMngr::bInitialize()
       ***************************************************************************/
      /*!
       * \fn      t_Bool bInitialize()
       * \brief   To Initialize all the Resource Manager related classes
       * \retval  t_Bool
       * \sa      vUninitialize()
       * \retval  t_Bool
       **************************************************************************/
      t_Bool bInitialize();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarResourceMngr::vUninitialize()
       ***************************************************************************/
      /*!
       * \fn      t_Void vUninitialize()
       * \brief   To Uninitialize all the Resource Manager related classes
       * \retval  t_Void
       * \sa      bInitialize()
       **************************************************************************/
      t_Void vUnInitialize();

      /***************************************************************************
       ** FUNCTION:  t_Void  spi_tclOnCarResourceMngr::vRegRsrcMngrCallBack()
       ***************************************************************************/
      /*!
       * \fn      t_Void vRegRsrcMngrCallBack()
       * \brief   To Register for the asynchronous responses that are required from
       *          ML/DiPo Resource Manager
       * \param   rRsrcMngrCallback : [IN] Resource Manager callbacks structure
       * \retval  t_Void
       **************************************************************************/
      t_Void vRegRsrcMngrCallBack(trRsrcMngrCallback rRsrcMngrCallback);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarResourceMngr::vSetAccessoryDisplayContext()
       ***************************************************************************/
      /*!
       * \fn      virtual t_Void vSetAccessoryDisplayContext(const t_U32 cou32DevId,
       *        t_Bool bDisplayFlag, tenDisplayContext enDisplayContext)
       * \brief   To send accessory display context related info .
       * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
       * \param   enDevConnType : [IN] Device connection Type USB/WIFI
       * \pram    rfrcUsrCntxt: [IN] User Context Details.
       * \retval  t_Void
       **************************************************************************/
      t_Void vSetAccessoryDisplayContext(const t_U32 cou32DevId, t_Bool bDisplayFlag,
               tenDisplayContext enDisplayContext, const trUserContext& rfrcUsrCntxt);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclResourceMngrBase::vSelectDevice()
       ***************************************************************************/
      /*!
       * \fn     t_Void vSelectDevice(const t_U32 cou32DevId, tenDeviceConnectionReq enConnReq,
       *              tenDeviceCategory enDevCat)
       * \brief  method to send the select device request to resouce manager
       * \param  cou32DevId : [IN] Uniquely identifies the target Device.
       * \param  enConnReq  : [IN] Device selection type.
       * \param  enDevCat   : [IN] Device category.
       * \retval t_Void
       **************************************************************************/
      t_Void vSelectDevice(const t_U32 cou32DevId, tenDeviceConnectionReq enConnReq,
               tenDeviceCategory enDevCat);

      /***************************************************************************
       ** FUNCTION:  t_Void  spi_tclOnCarResourceMngr::vOnSPISelectDeviceResult()
       ***************************************************************************/
      /*!
       * \fn      t_Void vOnSPISelectDeviceResult()
       * \brief   Interface to receive result of SPI device selection/deselection
       * \param   u32DevID : [IN] Resource Manager callbacks structure.
       * \param   enDevCat : [IN] Category of the device
       * \param   enDeviceConnReq : [IN] Select/ deselect.
       * \param   enRespCode : [IN] Response code (success/failure)
       * \param   enErrorCode : [IN] Error
       * \retval  t_Void
       **************************************************************************/
      t_Void vOnSPISelectDeviceResult(t_U32 u32DevID, tenDeviceConnectionReq enDeviceConnReq,
               tenResponseCode enRespCode, tenErrorCode enErrorCode);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarResourceMngr::vUpdateDeviceDisplayCntxt()
       ***************************************************************************/
      /*!
       * \fn      virtual t_Void vUpdateDeviceDisplayCntxt(t_Bool bDisplayFlag,
       *           tenDisplayContextReason enDisplayContextReason)
       * \brief   Request HMI to enable/diable Layer
       * \pram    bDisplayFlag      : [IN] TRUE - enable layer
       *                                   FALSE - disable layer
       * \param   enDisplayContextReason  : [IN] Display context reason
       * \retval  t_Void
       **************************************************************************/
      t_Void vUpdateDeviceDisplayCntxt(t_Bool bDisplayFlag, tenDisplayContextReason enDisplayContextReason);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarResourceMngr::vOnSessionStatusInfo()
       ***************************************************************************/
      /*!
       * \fn      vOnSessionStatusInfo
       * \brief
       * \param  enSessionStatus : indicates current status of android auto session
       * \retval  t_Void
       **************************************************************************/
      t_Void vOnSessionStatusInfo(tenSessionStatus enSessionStatus);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclOnCarResourceMngr::vSetAccessoryDisplayMode(t_U32...
       ***************************************************************************/
      /*!
       * \fn     vSetAccessoryDisplayMode()
       * \brief  Accessory display mode update request.
       * \param  [IN] cou32DeviceHandle      : Uniquely identifies the target Device.
       * \pram    enDevCat    : [IN] Identifies the Connection Request.
       * \param  [IN] corDisplayContext : Display context info
       * \param  [IN] corDisplayConstraint : DiDisplay constraint info
       * \param  [IN] coenDisplayInfo       : Display info flag
       * \retval  t_Void
       * \sa
       **************************************************************************/
      t_Void vSetAccessoryDisplayMode(const t_U32 cou32DeviceHandle, const trDisplayContext corDisplayContext,
                       const trDisplayConstraint corDisplayConstraint, const tenDisplayInfo coenDisplayInfo);

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarResourceMngr::t_Void vSetAccessoryAudioContext(...)
       ***************************************************************************/
      /*!
       * \fn      t_Void vSetAccessoryAudioContext(t_U32, tenAudioContext,
       *                                      t_Bool, const trUserContext&)
       * \brief   Method to set accessory audio context
       * \retval  t_Void
       ***************************************************************************/
      t_Void vSetAccessoryAudioContext(t_U32, tenAudioContext, t_Bool, const trUserContext&);

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarResourceMngr::t_Void vSetAccessoryAppState(...)
       ***************************************************************************/
      /*!
       * \fn      t_Void vSetAccessoryAppState(tenSpeechAppState, tenPhoneAppState,
       *                                           tenNavAppState, const trUserContext&)
       * \brief   Method to set accessory app state
       * \retval  t_Void
       ***************************************************************************/
      t_Void vSetAccessoryAppState(tenSpeechAppState, tenPhoneAppState, tenNavAppState, const trUserContext&);

      /***************************************************************************
      ** FUNCTION:  t_Void spi_tclOnCarResourceMngr::vRequestProjUI()
      ***************************************************************************/
      /*!
      * \fn      t_Void vRequestProjUI(t_U32 u32DevId,
      *                 ct_U32 u32AppId)
      * \brief   To Launch the Video for the requested app
      * \pram    u32DevId  : [IN] Uniquely identifies the target Device.
      * \pram    u32AppId  : [IN] Application Id
      * \retval  t_Void
      **************************************************************************/
      t_Void vRequestProjUI(t_U32 u32DevId,t_U32 u32AppId);
      
      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarResourceMngr::vPostOnCarAppStateMsg()
       ***************************************************************************/
      /*!
       * \fn      t_Void vPostOnCarAppStateMsg()
       * \brief   Called when app status is sent by OnCar device.
       *          Mandatory interface to be implemented.
       * \param   [IN] tenNavAppState enNavAppState : nav app state
       * \param   [IN] tenSpeechAppState enSpeechAppState :  speech app state 
       * \param   [IN] tenPhoneAppState tenPhoneAppState : phone app state
       * \sa      None
       **************************************************************************/       
       t_Void vPostOnCarAppStateMsg(const tenNavAppState enNavAppState,
                                    const tenSpeechAppState enSpeechAppState,
                                    const tenPhoneAppState tenPhoneAppState);     

       /***************************************************************************
       ** FUNCTION: t_Void spi_tclOnCarResourceMngr::vDevAuthAndAccessInfoCb()
       ***************************************************************************/
       /*!
       * \fn     t_Void vDevAuthAndAccessInfoCb(const t_U32 cou32DevId,
       *            const tenHandsetInteractionStatus coenHandsetInteractionReqd)
       * \brief  method to update the authorization and access to AAP projection device
       * \param  cou32DevId                 : [IN] Uniquely identifies the target Device.
       * \param  coenHandsetInteractionReqd : [IN] Handset/user interaction requirement status
       * \retval t_Void
       **************************************************************************/
       t_Void vDevAuthAndAccessInfoCb(const t_U32 cou32DevId,
                const tenHandsetInteractionStatus coenHandsetInteractionReqd);

      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/

   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
      ** FUNCTION:  spi_tclOnCarResourceMngr::vPostOnCarSessionStateMsg()
      ***************************************************************************/
      /*!
      * \fn      virtual vPostOnCarSessionStateMsg()
      * \brief   Invoked to provide information about OnCar session state
      * \param   enOnCarSessionState: OnCar session state
      **************************************************************************/
      t_Void vPostOnCarSessionStateMsg(const tenOnCarSessionState enOnCarSessionState);

      /***************************************************************************
      ** FUNCTION:  t_Void spi_tclOnCarResourceMngr::vPostOnCarRequestVideoFocusMsg()
      ***************************************************************************/
      /*!
      * \fn      t_Void vPostOnCarRequestVideoFocusMsg(tenVideoFocus enVideoFocus,
      *                 tenVideoFocusReason enVideoFocusReason)
      * \brief   Method to update that the Video Focus is requested
      *          or rejected from the MD
      * \param   enVideoFocus         : [IN] Video Focus Mode
      * \param   enVideoFocusReason   : [IN] Reason for the video focus request.
      * \retval  t_Void
      **************************************************************************/
      t_Void vPostOnCarRequestVideoFocusMsg(const tenOnCarVideoFocus enOnCarVideoFocus,
                                            const tenOnCarVideoFocusReason enOnCarVideoFocusReason);

      /***************************************************************************
      ** FUNCTION:  spi_tclOnCarResourceMngr::vPostOnCarStartVideoPlaybackMsg()
      ***************************************************************************/
      /*!
      * \fn      virtual vPostOnCarStartVideoPlaybackMsg()
      * \brief   Invoked to provide information about OnCar Start Video Playback
      **************************************************************************/
      t_Void vPostOnCarStartVideoPlaybackMsg();

      /***************************************************************************
      ** FUNCTION:  spi_tclOnCarResourceMngr::vPostOnCarStopVideoPlaybackMsg()
      ***************************************************************************/
      /*!
      * \fn      virtual vPostOnCarStopVideoPlaybackMsg()
      * \brief   Invoked to provide information about OnCar Stop Video Playback
      **************************************************************************/
      t_Void vPostOnCarStopVideoPlaybackMsg();

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarResourceMngr::vPostaudioFocusRequestCallback()
       ***************************************************************************/
      /*!
      * \fn      virtual vPostaudioFocusRequestCallback()
      * \brief   Invoked to provide information about OnCar Audio Focus Request
      **************************************************************************/
      t_Void vPostaudioFocusRequestCallback(const tenOnCarAudioStreamType enStreamType,
            const tenOnCarAudioFocusRequest enFocusRequest);
      /***************************************************************************
       ****************************END OF PROTECTED********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarResourceMngr(const spi_tclOnCarResourceMngr...
       ***************************************************************************/
      /*!
       * \fn      spi_tclOnCarResourceMngr(const spi_tclOnCarResourceMngr& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclOnCarResourceMngr()
       ***************************************************************************/
      spi_tclOnCarResourceMngr(const spi_tclOnCarResourceMngr& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarResourceMngr& operator=( const spi_tclOnCar...
       ***************************************************************************/
      /*!
       * \fn      spi_tclOnCarResourceMngr& operator=(const spi_tclOnCarResourceMngr& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclOnCarResourceMngr(const spi_tclOnCarResourceMngr& otrSrc)
       ***************************************************************************/
      spi_tclOnCarResourceMngr& operator=(const spi_tclOnCarResourceMngr& corfoSrc);

      t_U32 m_u32SelDevID;

      //! Callback functions to Resource manager
      trRsrcMngrCallback m_rRsrcMngrCb;
      //! Pointer to OnCar Video Resource Manager
      spi_tclOnCarVideoResourceMngr *m_poVideoRscMngr;
      spi_tclOnCarAudioResourceMngr *m_poAudioRscMngr;
      
      //!Structure varaible to store device app states
      trDiPOAppState m_rDeviceAppStates;

      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/
}; //class spi_tclOnCarResourceMngr

#endif //_SPI_TCLONCARRESOURCEMNGR_H_
///////////////////////////////////////////////////////////////////////////////
// <EOF>
