/***********************************************************************/
/*!
 * \file   spi_tclOnCarAudioResourceMngr.h
 * \brief  OnCar Audio resource manager
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    OnCar Audio resource manager
 AUTHOR:         jun5kor
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 22.03.2018  | Unmukt Jain           | Initial Version
 20..8.2018  | Ashwini Savadi        | Audio Resource Manager adaptation for
                                       Media.

 \endverbatim
 *************************************************************************/

#ifndef _SPI_TCLONCARAUDIORESOURCEMNGR_H_
#define _SPI_TCLONCARAUDIORESOURCEMNGR_H_

#include "SPITypes.h"
#include "SPI_OnCarTypes.h"
#include "Lock.h"
/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/


/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/
class spi_tclOnCarResourceMngr;

/****************************************************************************/
/*!
 * \class   spi_tclOnCarAudioResourceMngr
 * \brief   OnCar Audio resource manager
 *
 *           This class implements the logic to when to accept/reject audio request for phone.
 *
 ****************************************************************************/
class spi_tclOnCarAudioResourceMngr
{
   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarAudioResourceMngr::spi_tclOnCarAudioResourceMngr()
       ***************************************************************************/
      /*!
       * \fn      spi_tclOnCarAudioResourceMngr(spi_tclOnCarResourceMngr* poAAPRsrcMngr)
       * \brief   parameterized  Constructor
       * \param   poOnCarRsrcMngr : [IN] OnCar resource manager
       * \sa      ~spi_tclOnCarAudioResourceMngr()
       **************************************************************************/
    spi_tclOnCarAudioResourceMngr(spi_tclOnCarResourceMngr* poOnCarRsrcMngr);

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarAudioResourceMngr::~spi_tclOnCarAudioResourceMngr()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclOnCarAudioResourceMngr()
       * \brief   Destructor
       * \sa      spi_tclOnCarAudioResourceMngr()
       **************************************************************************/
      ~spi_tclOnCarAudioResourceMngr();

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclOnCarAudioResourceMngr::bInitialize()
       ***************************************************************************/
      /*!
       * \fn      t_Bool bInitialize()
       * \brief   To Initialize all the Video resources
       * \retval  t_Bool
       * \sa      vUninitialize()
       **************************************************************************/
      t_Bool bInitialize();

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarAudioResourceMngr::vUninitialize()
       ***************************************************************************/
      /*!
       * \fn      t_Void vUninitialize()
       * \brief    To Uninitialize  the Audio resources
       * \retval  t_Void
       * \sa      bInitialize()
       **************************************************************************/
      t_Void vUnInitialize();

      /***************************************************************************
      ** FUNCTION:  t_Void spi_tclOnCarAudioResourceMngr::vSetAccessoryAudioContext(...)
      ***************************************************************************/
      /*!
      * \fn     vSetAccessoryAudioContext(const t_U32 cou32DevId, const t_U8 cu8AudioCntxt
      *           t_Bool bDisplayFlag)
      * \brief   To send accessory audio context related info .
      * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
      * \param   cu8AudioCntxt : [IN] Audio Context
      * \pram    bReqFlag : [IN] Request/ Release flag
      * \retval  t_Void
      **************************************************************************/
      t_Void vSetAccessoryAudioContext(const t_U32 cou32DevId, const tenAudioContext coenAudioCntxt, t_Bool bReqFlag);

      /***************************************************************************
      ** FUNCTION:  spi_tclOnCarResourceMngr::vPostaudioFocusRequestCallback()
      ***************************************************************************/
      /*!
      * \fn      virtual vPostaudioFocusRequestCallback()
      * \brief   Invoked to provide information about OnCar Audio Focus Request
      **************************************************************************/
      t_Void vPostaudioFocusRequestCallback(const tenOnCarAudioStreamType enStreamType,
                    const tenOnCarAudioFocusRequest enDevFocusRequest);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarAudioResourceMngr::vOnSPISelectDeviceResult()
       ***************************************************************************/
      /*!
       * \fn      t_Void vOnSPISelectDeviceResult(t_U32 u32DevID,
       *             tenDeviceConnectionReq enDevConnReq,
       *             tenResponseCode enRespCode,
       *             tenErrorCode enErrorCode)
       * \brief   Called when SelectDevice operation is complete & with the result
       *           of the operation.
       * \param   u32DevID : [IN] Unique handle of selected device
       * \param   enDevConnReq: [IN]  Connection request type for the device
       * \param   enRespCode: [IN]  Response code enumeration
       * \param   enErrorCode: [IN]  Error code enumeration
       * \retval  None
       **************************************************************************/
      t_Void vOnSPISelectDeviceResult(t_U32 u32DevID, tenDeviceConnectionReq enDevConnReq, tenResponseCode enRespCode,
               tenErrorCode enErrorCode);

      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/

   private:

      //! Lock
         Lock                          m_oAudioRsrcMngrCbLock;
      //! Stores current accessory(native) audio focus state
         tenOnCarAccessoryAudioFocusState   m_enCurAccFocusState;
      //! Stores latest audio flag received in vSetAccessoryAudioContext()
         t_Bool                        m_bCurCtxtFlag;
      //! Stores latest audio context received in vSetAccessoryAudioContext()
         tenAudioContext               m_enCurAudioCntxt;
      //! Stores current audio context received in vSetAccessoryAudioContext()
         tenOnCarAudioContextType   m_enCurAccAudContextType;
      /***************************************************************************
       *********************************PRIVATE**********************************
       ***************************************************************************/
      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarAudioResourceMngr::spi_tclOnCarAudioResourceMngr()
       ***************************************************************************/
      /*!
       * \fn      spi_tclOnCarAudioResourceMngr()
       * \brief   default  Constructor
       * \sa      spi_tclOnCarAudioResourceMngr()
       **************************************************************************/
       spi_tclOnCarAudioResourceMngr();
      /***************************************************************************
       ** FUNCTION:  tenAccessoryAudioFocusState spi_tclOnCarAudioResourceMngr::enGetCurrentAccFocusState()
       ***************************************************************************/
      /*!
       * \fn      enGetCurrentAccFocusState()
       * \brief   Function to read current Accessory Audio Focus state
       * \param   None
       * \retval  tenAccessoryAudioFocusState: Current Accessory Audio Focus state
       **************************************************************************/
       tenOnCarAccessoryAudioFocusState enGetCurrentAccFocusState();
      /***************************************************************************
        ** FUNCTION:  t_Void spi_tclOnCarAudioResourceMngr::vSetCurrentAccAudioCtxtType()
       ***************************************************************************/
      /*!
       * \fn      vSetCurrentAccFocusState()
       * \brief   Function to read current Accessory Focus state
       * \param   enNewAccAudFocusState : [IN] Accessory Audio Focus State
       * \retval  None
       **************************************************************************/
       t_Void vSetCurrentAccFocusState(tenOnCarAccessoryAudioFocusState enNewAccAudFocusState);
      /***************************************************************************
       ** FUNCTION:  tenAudioContextType spi_tclOnCarAudioResourceMngr::enGetCurrentAccAudioCtxtType()
       ***************************************************************************/
      /*!
       * \fn      enGetCurrentAccAudioCtxtType()
       * \brief   Function to read current Accessory Audio Context
       * \param   None
       * \retval  tenOnCarAudioContextType: Current Accessory Audio Focus state
       **************************************************************************/
       tenOnCarAudioContextType enGetCurrentAccAudioCtxtType();
      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclOnCarAudioResourceMngr::vSetCurrentAccAudioCtxtType()
       ***************************************************************************/
      /*!
       * \fn      vSetCurrentAccAudioCtxtType()
       * \brief   Function to read current Accessory Audio Context
       * \param   enNewAccAudioCtxtType : [IN] Accessory Audio Context
       * \retval  None
       **************************************************************************/
       t_Void vSetCurrentAccAudioCtxtType(tenOnCarAudioContextType enNewAccAudioCtxtType);
       /***************************************************************************
        ** FUNCTION: spi_tclOnCarAudioResourceMngr::bGetAudioFocusNotification()
        ***************************************************************************/
       /*!
        * \fn      vUpdateFocusGainedTransientState()
        * \brief   Function to update the device audio focus request when the Car has gained focus transiently.
        * \param   enAudResourceOwner : [IN] Current Audio resource owner
        * \param   enAudContextType : [IN] Current Audio context
        * \param   enCurAccAudFocusState : [IN] Current Accessory audio focus state
        * \param   rfenNewDevAudFocusState : [OUT] New Audio Focus state of device to be sent as notification
        * \param   rfenNewAccAudFocusState : [OUT] New Accessory audio focus state
        * \retval  t_Bool: True - if there is a change in device audio focus which needs to be notified.
        **************************************************************************/
        t_Bool bGetAudioFocusNotification(tenOnCarAudioResourceOwner enAudResourceOwner,
                tenOnCarAudioContextType enAudContextType,
                tenOnCarAccessoryAudioFocusState enCurAccAudFocusState,
                tenOnCarDeviceAudioFocusState& rfenNewDevAudFocusState,
                tenOnCarAccessoryAudioFocusState& rfenNewAccAudFocusState);
        /***************************************************************************
        ** FUNCTION: spi_tclOnCarAudioResourceMngr::bGetAudioFocusResponse()
        ***************************************************************************/
        /*!
        * \fn      bGetAudioFocusResponse()
        * \brief   Evaluates response for Audio FOcus request from device based on current audio context.
        * \param   enDevAudFocusRequest : [IN] Audio Focus request from device
        * \param   enCurAccAudFocusState : [IN] Current Accessory audio focus state
        * \param   enCurAccAudContext : [IN] Current Accessory audio context
        * \param   rfenNewDevAudFocusState : [OUT] New Audio Focus state of device to be sent as response
        * \param   rfenNewAccAudFocusState : [OUT] New Accessory audio focus state
        * \retval  t_Bool: True - if audio focus request is valid in current audio context, else False.
        **************************************************************************/
        t_Bool bGetAudioFocusResponse(tenOnCarDeviceAudioFocusRequest enDevAudFocusRequest,
                tenOnCarAccessoryAudioFocusState enCurAccAudFocusState,
                tenOnCarAudioContextType enCurAccAudContext,
                tenOnCarDeviceAudioFocusState& rfeNewDevAudFocusState,
                tenOnCarAccessoryAudioFocusState& rfenNewAccAudFocusState);

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarAudioResourceMngr(const spi_tclOnCarAudioResourceMngr...
       ***************************************************************************/
      /*!
       * \fn      spi_tclOnCarAudioResourceMngr(
       *                             const spi_tclOnCarAudioResourceMngr& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclOnCarAudioResourceMngr()
       ***************************************************************************/
      spi_tclOnCarAudioResourceMngr(const spi_tclOnCarAudioResourceMngr& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarAudioResourceMngr& operator=( const spi_tcl...
       ***************************************************************************/
      /*!
       * \fn      spi_tclOnCarAudioResourceMngr& operator=(
       *                          const spi_tclOnCarAudioResourceMngr& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclOnCarAudioResourceMngr(const spi_tclOnCarAudioResourceMngr& otrSrc)
       ***************************************************************************/
      spi_tclOnCarAudioResourceMngr& operator=(const spi_tclOnCarAudioResourceMngr& corfoSrc);
      
      t_Bool m_bIsMediaActive;
      
      t_Bool m_bIsGuidanceActive;

      /***************************************************************************
       ****************************END OF PRIVATE********************************
       ***************************************************************************/

}; //class spi_tclOnCarAudioResourceMngr

#endif //_SPI_TCLONCARAUDIORESOURCEMNGR_H_
///////////////////////////////////////////////////////////////////////////////
// <EOF>
