
/***********************************************************************/
/*!
* \file   spi_tclOnCarVideoDispatcher.h
* \brief  Message Dispatcher for Video Messages. implemented using
 *        double dispatch mechanism
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Message Dispatcher for Video Messages
AUTHOR:         Unmukt Jain
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
20.02.2018  | Unmukt Jain           | Initial Version

\endverbatim
*************************************************************************/
#ifndef _SPI_TCLONCARVIDEODISPATCHER_H_
#define _SPI_TCLONCARVIDEODISPATCHER_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "SPI_OnCarTypes.h"

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/
class spi_tclOnCarVideoDispatcher;


/****************************************************************************/
/*!
* \class    OnCarVideoMsgBase
* \brief    Base Message type for all
****************************************************************************/
class OnCarVideoMsgBase: public trMsgBase
{
public:
   /***************************************************************************
   ** FUNCTION:  OnCarVideoMsgBase::OnCarVideoMsgBase
   ***************************************************************************/
   /*!
   * \fn      OnCarVideoMsgBase()
   * \brief   Default constructor
   **************************************************************************/
    OnCarVideoMsgBase();

   /***************************************************************************
   ** FUNCTION:  OnCarVideoMsgBase::vDispatchMsg
   ***************************************************************************/
   /*!
   * \fn      vDispatchMsg(spi_tclOnCarVideoDispatcher* poDispatcher)
   * \brief   Pure virtual function to be overridden by inherited classes for
   *          dispatching the message
   * \param   poDispatcher: pointer to Video Message Dispatcher
   **************************************************************************/
   virtual t_Void vDispatchMsg( spi_tclOnCarVideoDispatcher* poDispatcher) = 0;

   /***************************************************************************
   ** FUNCTION:  OnCarVideoMsgBase::~OnCarVideoMsgBase
   ***************************************************************************/
   /*!
   * \fn      ~OnCarVideoMsgBase()
   * \brief   Destructor
   **************************************************************************/
   virtual ~OnCarVideoMsgBase(){}

};  //class OnCarVideoMsgBase

/****************************************************************************/
/*!
 * \class OnCarStartVideoPlaybackMsg
 * \brief OnCar Start video Playback message
 ****************************************************************************/
class OnCarStartVideoPlaybackMsg : public OnCarVideoMsgBase
{
   public:

      /***************************************************************************
       ** FUNCTION:  OnCarStartVideoPlaybackMsg::OnCarStartVideoPlaybackMsg
       ***************************************************************************/
      /*!
       * \fn      OnCarStartVideoPlaybackMsg()
       * \brief   Default constructor
       **************************************************************************/
      OnCarStartVideoPlaybackMsg();

      /***************************************************************************
       ** FUNCTION:  OnCarStartVideoPlaybackMsg::~OnCarStartVideoPlaybackMsg
       ***************************************************************************/
      /*!
       * \fn      ~OnCarStartVideoPlaybackMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~OnCarStartVideoPlaybackMsg(){}

      /***************************************************************************
       ** FUNCTION:  OnCarStartVideoPlaybackMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclOnCarVideoDispatcher* povideoDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
      * \param  povideoDispatcher : pointer to Message dispatcher for video
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclOnCarVideoDispatcher* povideoDispatcher);

      /***************************************************************************
       ** FUNCTION:  OnCarStartVideoPlaybackMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  OnCarStartVideoPlaybackMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg();
};
/****************************************************************************/
/*!
 * \class OnCarStopVideoPlaybackMsg
 * \brief OnCar Stop video playback message
 ****************************************************************************/
class OnCarStopVideoPlaybackMsg : public OnCarVideoMsgBase
{
   public:

      /***************************************************************************
       ** FUNCTION:  OnCarStopVideoPlaybackMsg::OnCarStopVideoPlaybackMsg
       ***************************************************************************/
      /*!
       * \fn      OnCarStopVideoPlaybackMsg()
       * \brief   Default constructor
       **************************************************************************/
      OnCarStopVideoPlaybackMsg();

      /***************************************************************************
       ** FUNCTION:  OnCarStopVideoPlaybackMsg::~OnCarStopVideoPlaybackMsg
       ***************************************************************************/
      /*!
       * \fn      ~OnCarStopVideoPlaybackMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~OnCarStopVideoPlaybackMsg(){}

      /***************************************************************************
       ** FUNCTION:  OnCarStopVideoPlaybackMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclOnCarVideoDispatcher* povideoDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
      * \param  povideoDispatcher : pointer to Message dispatcher for video
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclOnCarVideoDispatcher* povideoDispatcher);

      /***************************************************************************
       ** FUNCTION:  OnCarStopVideoPlaybackMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  OnCarStopVideoPlaybackMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class OnCarRequestVideoFocusMsg
 * \brief OnCar Request Video Focus message
 ****************************************************************************/
class OnCarRequestVideoFocusMsg : public OnCarVideoMsgBase
{
   public:
       tenOnCarVideoFocus m_enOnCarVideoFocus;
       tenOnCarVideoFocusReason m_enOnCarVideoFocusReason;

      /***************************************************************************
       ** FUNCTION:  OnCarStopVideoPlaybackMsg::OnCarStopVideoPlaybackMsg
       ***************************************************************************/
      /*!
       * \fn      OnCarStopVideoPlaybackMsg()
       * \brief   Default constructor
       **************************************************************************/
      OnCarRequestVideoFocusMsg();

      /***************************************************************************
       ** FUNCTION:  OnCarStopVideoPlaybackMsg::~OnCarStopVideoPlaybackMsg
       ***************************************************************************/
      /*!
       * \fn      ~OnCarStopVideoPlaybackMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~OnCarRequestVideoFocusMsg(){}

      /***************************************************************************
       ** FUNCTION:  OnCarStopVideoPlaybackMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclOnCarVideoDispatcher* povideoDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
      * \param  povideoDispatcher : pointer to Message dispatcher for video
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclOnCarVideoDispatcher* povideoDispatcher);

      /***************************************************************************
       ** FUNCTION:  OnCarRequestVideoFocusMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  OnCarStopVideoPlaybackMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg();
};
/****************************************************************************/
/*!
 * \class OnCarVideoErrorMsg
 * \brief OnCar video error message
 ****************************************************************************/
class OnCarVideoErrorMsg : public OnCarVideoMsgBase
{
   public:
      tenOnCarSinkError m_enOnCarSinkError;

      /***************************************************************************
       ** FUNCTION:  OnCarVideoErrorMsg::OnCarVideoErrorMsg
       ***************************************************************************/
      /*!
       * \fn      OnCarVideoErrorMsg()
       * \brief   Default constructor
       **************************************************************************/
      OnCarVideoErrorMsg();

      /***************************************************************************
       ** FUNCTION:  OnCarVideoErrorMsg::~OnCarVideoErrorMsg
       ***************************************************************************/
      /*!
       * \fn      ~OnCarVideoErrorMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~OnCarVideoErrorMsg(){}

      /***************************************************************************
       ** FUNCTION:  OnCarVideoErrorMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclOnCarVideoDispatcher* povideoDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
      * \param  povideoDispatcher : pointer to Message dispatcher for video
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclOnCarVideoDispatcher* povideoDispatcher);

      /***************************************************************************
       ** FUNCTION:  OnCarVideoErrorMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  OnCarVideoErrorMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class OnCarSupportedResolutionMsg
 * \brief OnCar video error message
 ****************************************************************************/
class OnCarSupportedResolutionMsg : public OnCarVideoMsgBase
{
   public:

   t_U32 m_u32Width;
   t_U32 m_u32Height;

      /***************************************************************************
       ** FUNCTION:  OnCarSupportedResolutionMsg::OnCarSupportedResolutionMsg
       ***************************************************************************/
      /*!
       * \fn      OnCarSupportedResolutionMsg()
       * \brief   Default constructor
       **************************************************************************/
      OnCarSupportedResolutionMsg();

      /***************************************************************************
       ** FUNCTION:  OnCarSupportedResolutionMsg::~OnCarSupportedResolutionMsg
       ***************************************************************************/
      /*!
       * \fn      ~OnCarSupportedResolutionMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~OnCarSupportedResolutionMsg(){}

      /***************************************************************************
       ** FUNCTION:  OnCarSupportedResolutionMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclOnCarVideoDispatcher* povideoDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
      * \param  povideoDispatcher : pointer to Message dispatcher for video
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclOnCarVideoDispatcher* povideoDispatcher);

      /***************************************************************************
       ** FUNCTION:  OnCarSupportedResolutionMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  OnCarSupportedResolutionMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg();
};
/****************************************************************************/
/*!
* \class    spi_tclOnCarVideoDispatcher
* \brief    Message Dispatcher for Video Messages
****************************************************************************/
class spi_tclOnCarVideoDispatcher
{

public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclAAPVideoDispatcher::spi_tclAAPVideoDispatcher()
   ***************************************************************************/
   /*!
   * \fn      spi_tclOnCarVideoDispatcher()
   * \brief   Default Constructor
   * \param   t_Void
   * \sa      ~spi_tclOnCarVideoDispatcher()
   **************************************************************************/
    spi_tclOnCarVideoDispatcher();

   /***************************************************************************
   ** FUNCTION:  spi_tclOnCarVideoDispatcher::~spi_tclOnCarVideoDispatcher()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclOnCarVideoDispatcher()
   * \brief   Destructor
   * \param   t_Void
   * \sa      spi_tclOnCarVideoDispatcher()
   **************************************************************************/
   ~spi_tclOnCarVideoDispatcher();

   /************************************************************************************************************************
    ** FUNCTION:  spi_tclOnCarVideoDispatcher::vHandleVideoMsg(OnCarStartVideoPlaybackMsg* poOnCarStartVideoPlaybackMsg)
    **************************************************************************************************************************/
   /*!
    * \fn      vHandleVideoMsg(OnCarStartVideoPlaybackMsg* poOnCarStartVideoPlaybackMsg)
    * \param   poOnCarStartVideoPlaybackMsg : pointer to OnCarStartVideoPlaybackMsg.
    **************************************************************************/
   t_Void vHandleVideoMsg(OnCarStartVideoPlaybackMsg* poOnCarStartVideoPlaybackMsg) const;

   /************************************************************************************************************************
   ** FUNCTION:  spi_tclOnCarVideoDispatcher::vHandleVideoMsg(OnCarStopVideoPlaybackMsg* poOnCarStopVideoPlaybackMsg)
   **************************************************************************************************************************/
   /*!
   * \fn      vHandleVideoMsg(OnCarStopVideoPlaybackMsg* poOnCarStopVideoPlaybackMsg)
   * \param   poOnCarStopVideoPlaybackMsg : pointer to OnCarStopVideoPlaybackMsg.
   **************************************************************************/
   t_Void vHandleVideoMsg(OnCarStopVideoPlaybackMsg* poOnCarStopVideoPlaybackMsg) const;

   /************************************************************************************************************************
   ** FUNCTION:  spi_tclOnCarVideoDispatcher::vHandleVideoMsg(OnCarRequestVideoFocusMsg* poOnCarRequestVideoFocusMsg)
   **************************************************************************************************************************/
   /*!
   * \fn      vHandleVideoMsg(OnCarRequestVideoFocusMsg* poOnCarRequestVideoFocusMsg)
   * \param   poOnCarRequestVideoFocusMsg : pointer to OnCarRequestVideoFocusMsg.
   **************************************************************************/
   t_Void vHandleVideoMsg(OnCarRequestVideoFocusMsg* poOnCarRequestVideoFocusMsg) const;

   /***************************************************************************
    ** FUNCTION:  spi_tclOnCarVideoDispatcher::vHandleVideoMsg(OnCarVideoErrorMsg* poOnCarVideoErrorMsg)
    ***************************************************************************/
   /*!
    * \fn      vHandleVideoMsg(OnCarVideoErrorMsg* poOnCarVideoErrorMsg)
    * \param   poOnCarVideoErrorMsg : pointer to OnCarVideoErrorMsg.
    **************************************************************************/
   t_Void vHandleVideoMsg(OnCarVideoErrorMsg* poOnCarVideoErrorMsg) const;

   /***************************************************************************
    ** FUNCTION:  spi_tclOnCarVideoDispatcher::vHandleVideoMsg(OnCarSupportedResolutionMsg* poOnCarSupportedResolutionMsg)
    ***************************************************************************/
   /*!
    * \fn      vHandleVideoMsg(OnCarSupportedResolutionMsg* poOnCarSupportedResolutionMsg)
    * \param   poOnCarSupportedResolutionMsg : pointer to OnCarSupportedResolutionMsg.
    **************************************************************************/
   t_Void vHandleVideoMsg(OnCarSupportedResolutionMsg* poOnCarSupportedResolutionMsg) const;

   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:

   /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclOnCarVideoDispatcher(const spi_tclOnCarVideoDispatcher...
   ***************************************************************************/
   /*!
   * \fn      spi_tclOnCarVideoDispatcher(
   *                             const spi_tclOnCarVideoDispatcher& corfoSrc)
   * \brief   Copy constructor - Do not allow the creation of copy constructor
   * \param   corfoSrc : [IN] reference to source data interface object
   * \retval
   * \sa      spi_tclAAPVideoDispatcher()
   ***************************************************************************/
   spi_tclOnCarVideoDispatcher(const spi_tclOnCarVideoDispatcher& corfoSrc);


   /***************************************************************************
   ** FUNCTION:  spi_tclOnCarVideoDispatcher& operator=( const spi_tclOnCarV...
   ***************************************************************************/
   /*!
   * \fn      spi_tclOnCarVideoDispatcher& operator=(
   *                          const spi_tclOnCarVideoDispatcher& corfoSrc))
   * \brief   Assignment operator
   * \param   corfoSrc : [IN] reference to source data interface object
   * \retval
   * \sa      spi_tclOnCarVideoDispatcher(const spi_tclOnCarVideoDispatcher& otrSrc)
   ***************************************************************************/
   spi_tclOnCarVideoDispatcher& operator=(const spi_tclOnCarVideoDispatcher& corfoSrc);


   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/


   /***************************************************************************
   ****************************END OF PRIVATE *********************************
   ***************************************************************************/


}; //class spi_tclOnCarVideoDispatcher



#endif //_SPI_TCLONCARVIDEODISPATCHER_H_

///////////////////////////////////////////////////////////////////////////////
// <EOF>
