/*!
 *******************************************************************************
 * \file              spi_tclOnCarVideoCbs.h
 * \brief             Video Endpoint callbacks handler for OnCar
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Video Endpoint callbacks handler for OnCar
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 09.03.2018 |  Unmukt Jain                 | Initial Version

 \endverbatim
 ******************************************************************************/

#ifndef _SPI_TCLONCARVIDEOCBS_H_
#define _SPI_TCLONCARVIDEOCBS_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#ifdef _LINUXX86MAKE_ //for unit testing
  #include "Mock_OnCarVideoEndpoint.h"
#else
  #include "OnCarVideoEndpoint.h"
#endif
#include "BaseTypes.h"

/* This class includes a general set of IOnCarVideoSinkCallbacks that must be set up for the Video Endpoint */
class spi_tclOnCarVideoCbs : public IOnCarVideoSinkCallbacks
{
public:

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclOnCarVideoCbs::spi_tclOnCarVideoCbs()
    ***************************************************************************/
   /*!
    * \fn      spi_tclOnCarVideoCbs()
    * \brief   Constructor
    * \sa      ~spi_tclOnCarVideoCbs()
    **************************************************************************/
    spi_tclOnCarVideoCbs() { }

    /***************************************************************************
     ** FUNCTION:  virtual spi_tclOnCarVideoCbs::~spi_tclOnCarVideoCbs()
     ***************************************************************************/
    /*!
     * \fn      virtual ~spi_tclOnCarVideoCbs()
     * \brief   Destructor
     * \sa      spi_tclOnCarVideoCbs()
     **************************************************************************/
    virtual ~spi_tclOnCarVideoCbs() {}

    /**********Start of functions overridden from IOnCarVideoSinkCallbacks**********/

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclOnCarVideoCbs::startVideoPlaybackRequestCallback()
    ***************************************************************************/
    /*!
    * Called when MD wants to start video streaming. This callback should be called after
    * HU has granted video focus to MD through setVideoFocus .It is expected that when this
    * callback is called MD will start sending video packets as soon as HU acknowledges
    * this request by invoking  acknowledgeStartVideoRequest().
    */
    void startVideoPlaybackRequestCallback();

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclOnCarVideoCbs::videoErrorCallback()
    ***************************************************************************/
    /*!
     * Called when error has occured during video playback.
     * @param error enum containing error code.
     */
     void videoErrorCallback(ONCARSINKERROR error);

    /***************************************************************************
     ** FUNCTION:  t_Void spi_tclOnCarVideoCbs::stopVideoPlaybackRequestCallback()
     ***************************************************************************/
    /*!
     * Called when MD wants to stop video streaming. This callback should be called after
     * HU has granted video focus to MD through setVideoFocus .It is expected that when this
     * callback is called MD will stop sending video packets as soon as HU acknowledges
     * this request by invoking  acknowledgeStopVideoRequest().
     */
      void stopVideoPlaybackRequestCallback();

    /***************************************************************************
     ** FUNCTION:  t_Void spi_tclOnCarVideoCbs::requestVideoFocusCallback()
     ***************************************************************************/
    /*!
     * Called when the OnCar source wishes to change the Video focus.
     * @param focus Enumeration of VIDEOFOCUS.
     * @param reason Enumeration of VIDEOFOCUS_REASON.
     */
      void requestVideoFocusCallback(const VIDEOFOCUS focus,const VIDEOFOCUS_REASON reason);

    /***************************************************************************
     ** FUNCTION:  t_Void spi_tclOnCarVideoCbs::supportedResolution()
     ***************************************************************************/
    /*!
     * Called by MD to tell HU about its supported resolution.
     * @param width  width of the projection in pixels.
     * @param height height of the projection in pixels.
     */
      void supportedResolution (uint32_t width, uint32_t height);

    /***********End of functions overridden from IOnCarVideoSinkCallbacks**********/


private:

    /***************************************************************************
     ** FUNCTION: spi_tclOnCarVideoCbs(const spi_tclOnCarVideoCbs &rfcoObject)
     ***************************************************************************/
    /*!
     * \fn      spi_tclOnCarVideoCbs(const spi_tclOnCarVideoCbs &rfcoObject)
     * \brief   Copy constructor not implemented hence made private
     **************************************************************************/
    spi_tclOnCarVideoCbs(const spi_tclOnCarVideoCbs& rfcoObject);

    /***************************************************************************
     ** FUNCTION: const spi_tclOnCarVideoCbs & operator=(
     **                                 const spi_tclOnCarVideoCbs &rfcoObject);
     ***************************************************************************/
    /*!
     * \fn      const spi_tclOnCarVideoCbs & operator=(const spi_tclOnCarVideoCbs &rfcoObject);
     * \brief   assignment operator not implemented hence made private
     **************************************************************************/
    const spi_tclOnCarVideoCbs& operator=(const spi_tclOnCarVideoCbs& rfcoObject);
};


#endif /* _SPI_TCLONCARVIDEOCBS_H_ */
