
/***********************************************************************/
/*!
* \file   spi_tclOnCarRespVideo.h
* \brief  VideoSink Call backs output interface
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    VideoSink Call backs output interface
AUTHOR:         Unmukt Jain
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
22.03.2018  | Unmukt Jain           | Initial Version
\endverbatim
*************************************************************************/
#ifndef _SPI_TCLONCARRESPVIDEO_H_
#define _SPI_TCLONCARRESPVIDEO_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "RespBase.h"
#include "SPI_OnCarTypes.h"

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
* \class  spi_tclOnCarRespVideo
* \brief  VideoSink Call backs output interface
* updates all the registered clients, whenever there is
* an update on OnCar session
*****************************************************************************/
class spi_tclOnCarRespVideo:public RespBase
{

public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclOnCarRespVideo::spi_tclOnCarRespVideo()
   ***************************************************************************/
   /*!
   * \fn      spi_tclOnCarRespVideo()
   * \brief   Default Constructor
   * \sa      ~spi_tclOnCarRespVideo()
   **************************************************************************/
    spi_tclOnCarRespVideo():RespBase(e16ONCAR_VIDEO_REGID){}

   /***************************************************************************
   ** FUNCTION:  spi_tclOnCarRespVideo::~spi_tclOnCarRespVideo()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclOnCarRespVideo()
   * \brief   Destructor
   * \sa      spi_tclOnCarRespVideo()
   **************************************************************************/
   virtual ~spi_tclOnCarRespVideo(){}

   /***************************************************************************
   ** FUNCTION:  spi_tclOnCarRespVideo::vPostOnCarStartVideoPlaybackMsg()
   ***************************************************************************/
   /*!
   * \fn      virtual vPostOnCarStartVideoPlaybackMsg()
   * \brief   Invoked to provide information about OnCar Start Video Playback
   **************************************************************************/
   virtual t_Void vPostOnCarStartVideoPlaybackMsg(){}

   /***************************************************************************
   ** FUNCTION:  spi_tclOnCarRespVideo::vPostOnCarStopVideoPlaybackMsg()
   ***************************************************************************/
   /*!
   * \fn      virtual vPostOnCarStopVideoPlaybackMsg()
   * \brief   Invoked to provide information about OnCar stop Video Playback
   **************************************************************************/
   virtual t_Void vPostOnCarStopVideoPlaybackMsg(){}

   /***************************************************************************
   ** FUNCTION:  spi_tclOnCarRespVideo::vPostOnCarRequestVideoFocusMsg()
   ***************************************************************************/
   /*!
   * \fn      virtual vPostOnCarRequestVideoFocusMsg()
   * \brief   Invoked to provide information about OnCar request Video Focus
   * \param   enOnCarVideoFocus: OnCar Video Focus
   * \param   enOnCarVideoFocusReason: OnCar Video Focus Reason
   **************************************************************************/
   virtual t_Void vPostOnCarRequestVideoFocusMsg(const tenOnCarVideoFocus enOnCarVideoFocus,
                                                const tenOnCarVideoFocusReason enOnCarVideoFocusReason)
   {
      SPI_INTENTIONALLY_UNUSED(enOnCarVideoFocus);
      SPI_INTENTIONALLY_UNUSED(enOnCarVideoFocusReason);
   }

   /***************************************************************************
   ** FUNCTION:  spi_tclOnCarRespVideo::vPostOnCarVideoErrorMsg()
   ***************************************************************************/
   /*!
   * \fn      virtual vPostOnCarVideoErrorMsg()
   * \brief   Invoked to provide information about OnCar session error
   * \param   enOnCarSinkError: OnCar session error
   **************************************************************************/
   virtual t_Void vPostOnCarVideoErrorMsg(const tenOnCarSinkError enOnCarSinkError)
   {
       SPI_INTENTIONALLY_UNUSED(enOnCarSinkError);
   }

   /***************************************************************************
   ** FUNCTION:  spi_tclOnCarRespVideo::vPostOnCarSupportedResolutionMsg()
   ***************************************************************************/
   /*!
   * \fn      virtual vPostOnCarSupportedResolutionMsg()
   * \brief   Invoked to provide information about OnCar Supported Resolution
   * \param   u32Width: Width
   * \param   u32Height: Height
   **************************************************************************/
   virtual t_Void vPostOnCarSupportedResolutionMsg(t_U32 u32Width,t_U32 u32Height)
   {
      SPI_INTENTIONALLY_UNUSED(u32Width);
      SPI_INTENTIONALLY_UNUSED(u32Height);
   }

   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:

   /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclOnCarRespVideo(const spi_tclOnCarRespVideo...
   ***************************************************************************/
   /*!
   * \fn      spi_tclOnCarRespVideo(const spi_tclOnCarRespVideo& corfoSrc)
   * \brief   Copy constructor - Do not allow the creation of copy constructor
   * \param   corfoSrc : [IN] reference to source data interface object
   * \retval
   * \sa      spi_tclOnCarRespVideo()
   ***************************************************************************/
   spi_tclOnCarRespVideo(const spi_tclOnCarRespVideo& corfoSrc);


   /***************************************************************************
   ** FUNCTION:  spi_tclOnCarRespVideo& operator=( const spi_tclAAP...
   ***************************************************************************/
   /*!
   * \fn      spi_tclOnCarRespVideo& operator=(const spi_tclOnCarRespVideo& corfoSrc))
   * \brief   Assignment operator
   * \param   corfoSrc : [IN] reference to source data interface object
   * \retval
   * \sa      spi_tclOnCarRespVideo(const spi_tclOnCarRespVideo& otrSrc)
   ***************************************************************************/
   spi_tclOnCarRespVideo& operator=(const spi_tclOnCarRespVideo& corfoSrc);


   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/


   /***************************************************************************
   ****************************END OF PRIVATE *********************************
   ***************************************************************************/


}; //class spi_tclOnCarRespVideo

#endif //_SPI_TCLONCARRESPVIDEO_H_

///////////////////////////////////////////////////////////////////////////////
// <EOF>
