
/***********************************************************************/
/*!
* \file  spi_tclOnCarCmdVideo.h
* \brief Wrapper class for OnCar Video Sink
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Wrapper class for OnCar Video Sink
AUTHOR:         Unmukt Jain
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
13.02.2018  | Unmukt Jain           | Initial Version

\endverbatim
*************************************************************************/

#ifndef _SPI_TCLONCARCMDVIDEO_H_
#define _SPI_TCLONCARCMDVIDEO_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "SPI_OnCarTypes.h"
#include "spi_tclOnCarVideoCbs.h"
#include "Lock.h"

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
* \class    spi_tclOnCarCmdVideo
* \brief    Wrapper class to interact with UBridge's API.
****************************************************************************/
class spi_tclOnCarCmdVideo
{

public:

    /***************************************************************************
    *********************************PUBLIC*************************************
    ***************************************************************************/

    /***************************************************************************
    ** FUNCTION:  spi_tclOnCarCmdVideo::spi_tclOnCarCmdVideo()
    ***************************************************************************/
    /*!
    * \fn      spi_tclOnCarCmdVideo()
    * \brief   Default Constructor
    * \sa      ~spi_tclOnCarCmdVideo()
    **************************************************************************/
    spi_tclOnCarCmdVideo();

    /***************************************************************************
    ** FUNCTION:  spi_tclOnCarCmdVideo::~spi_tclOnCarCmdVideo()
    ***************************************************************************/
    /*!
    * \fn      ~spi_tclOnCarCmdVideo()
    * \brief   Destructor
    * \sa      spi_tclOnCarCmdVideo()
    **************************************************************************/
    ~spi_tclOnCarCmdVideo();

    /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclOnCarCmdVideo::bInitialize()
    ***************************************************************************/
    /*!
    * \fn      t_Bool bInitialize()
    * \brief   method to create and initialize video sink
    * \param   corfrOnCarVideoConfig : [IN] Video configuration
    * \sa      vUninitialize()
    * \retval  t_Bool
    **************************************************************************/
    t_Bool bInitialize(const trOnCarVideoConfig& corfrOnCarVideoConfig);

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclOnCarCmdVideo::vDestroyVideoEndpointInstance()
    ***************************************************************************/
    /*!
    * \fn      t_Void vDestroyVideoEndpointInstance()
    * \brief   method to destroy video sink
    * \sa      None
    * \retval  t_Void
    **************************************************************************/
    t_Void vDestroyVideoEndpointInstance();

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclOnCarCmdVideo::vUninitialize()
    ***************************************************************************/
    /*!
    * \fn      t_Void vUninitialize()
    * \brief   method to destroy video sink
    * \sa      None
    * \retval  t_Void
    **************************************************************************/
    t_Void vUninitialize();

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclOnCarCmdVideo::vSetVideoFocus(tenVideoFocus enVideoFocus)
    ***************************************************************************/
    /*!
    * \fn      t_Void vSetVideoFocus(tenVideoFocus enVideoFocus)
    * \brief   method to request or Grant/Deny Video Focus to/from MD
    * \param   enVideoFocus : [IN] Video Focus mode
    * \retval  t_Void
    **************************************************************************/
    t_Void vSetVideoFocus(tenOnCarVideoFocus enVideoFocus);

    /***************************************************************************
     ** FUNCTION:  t_Void spi_tclOnCarCmdVideo::acknowledgeStartVideoRequest()
     ***************************************************************************/
     /*!
     * \fn      t_Void acknowledgeStartVideoRequest()
     * \brief   method to acknowledge the start video request from Oncar
     * \retval  t_Void
     **************************************************************************/
    t_Void acknowledgeStartVideoRequest();

    /***************************************************************************
     ** FUNCTION:  t_Void spi_tclOnCarCmdVideo::acknowledgeStopVideoRequest()
     ***************************************************************************/
     /*!
     * \fn      t_Void acknowledgeStopVideoRequest()
     * \brief   method to acknowledge the stop video request from Oncar
     * \retval  t_Void
     **************************************************************************/
    t_Void acknowledgeStopVideoRequest();

    /***************************************************************************
    ****************************END OF PUBLIC***********************************
    ***************************************************************************/

protected:

    /***************************************************************************
    *********************************PROTECTED**********************************
    ***************************************************************************/

    /***************************************************************************
    ** FUNCTION:  spi_tclOnCarCmdVideo(const spi_tclOnCarCmdVideo...
    ***************************************************************************/
    /*!
    * \fn      spi_tclOnCarCmdVideo(const spi_tclOnCarCmdVideo& corfoSrc)
    * \brief   Copy constructor - Do not allow the creation of copy constructor
    * \param   corfoSrc : [IN] reference to source data interface object
    * \retval
    * \sa      spi_tclOnCarCmdVideo()
    ***************************************************************************/
    spi_tclOnCarCmdVideo(const spi_tclOnCarCmdVideo& corfoSrc);


    /***************************************************************************
    ** FUNCTION:  spi_tclOnCarCmdVideo& operator=( const spi_tclOnCarCmdVideo...
    ***************************************************************************/
    /*!
    * \fn      spi_tclOnCarCmdVideo& operator=(const spi_tclOnCarCmdVideo& corfoSrc))
    * \brief   Assignment operator
    * \param   corfoSrc : [IN] reference to source data interface object
    * \retval
    * \sa      spi_tclOnCarCmdVideo(const spi_tclOnCarCmdVideo& otrSrc)
    ***************************************************************************/
    spi_tclOnCarCmdVideo& operator=(const spi_tclOnCarCmdVideo& corfoSrc);


    /***************************************************************************
    ****************************END OF PROTECTED********************************
    ***************************************************************************/

private:

    /***************************************************************************
    *********************************PRIVATE************************************
    ***************************************************************************/
    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclOnCarCmdVideo::vSetVideoConfig()
    ***************************************************************************/
    /*!
    * \fn      t_Void vSetVideoConfig(const trAAPVideoConfig& corfrAAPVideoConfig)
    * \brief   method to set the video configuration for Video Sink
    * \param   corfrAAPVideoConfig : [IN] Video configuration
    * \retval  t_Void
    **************************************************************************/
    t_Void vSetVideoConfig(const trOnCarVideoConfig& corfrOnCarVideoConfig );

    //! shared pointer for OnCar Video callbacks
    std::shared_ptr<IOnCarVideoSinkCallbacks> m_spoVideoCbs;

    //! Video Endpoint pointer
    OnCarVideoEndpoint* m_poOnCarVideoEndpoint;

    //! Lock object for Video endpoint
    Lock  m_oEndpointLock;

    /***************************************************************************
    ****************************END OF PRIVATE *********************************
    ***************************************************************************/


}; //class spi_tclOnCarCmdVideo

#endif //_SPI_TCLONCARCMDVIDEO_H_

///////////////////////////////////////////////////////////////////////////////
// <EOF>
