/***********************************************************************/
/*!
 * \file  spi_tclOnCarSessionDispatcher.h
 * \brief Message Dispatcher for Session Messages. implemented using
 *       double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Session Messages
 AUTHOR:         Unmukt Jain
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 23.02.2018  | Unmukt Jain           | Initial Version

 \endverbatim
 *************************************************************************/

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/

#include "RespRegister.h"
#include "spi_tclOnCarSessionDispatcher.h"
#include "spi_tclOnCarRespSession.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
#include "trcGenProj/Header/spi_tclOnCarSessionDispatcher.cpp.trc.h"
#endif
#endif

//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(                               \
         DISPATCHER* poDispatcher)                          \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleSessionMsg(this);                \
   }                                                        \
   vDeAllocateMsg();                                        \
}


/***************************************************************************
 ** FUNCTION:  OnCarSessionMsgBase::OnCarSessionMsgBase
 ***************************************************************************/
OnCarSessionMsgBase::OnCarSessionMsgBase(): m_u32DeviceHandle(0)
{
   ETG_TRACE_USR1(("OnCarSessionMsgBase::OnCarSessionMsgBase entered"));
   vSetServiceID (e32MODULEID_ONCARSESSION);
}

/***************************************************************************
 ** FUNCTION:  OnCarSessionStateMsg::OnCarSessionStateMsg
 ***************************************************************************/
OnCarSessionStateMsg::OnCarSessionStateMsg():m_OnCarSessionState(e8_ONCAR_SESSION_STATE_UNKNOWN)
{
	ETG_TRACE_USR1(("OnCarSessionStateMsg::OnCarSessionStateMsg entered"));
}

/***************************************************************************
 ** FUNCTION:  OnCarSessionErrorMsg::OnCarSessionErrorMsg
 ***************************************************************************/
OnCarSessionErrorMsg::OnCarSessionErrorMsg():m_enOnCarSinkError(e32_ONCAR_SINK_NO_ERROR)
{
	ETG_TRACE_USR1(("OnCarSessionErrorMsg::OnCarSessionErrorMsg entered"));
}

/***************************************************************************
 ** FUNCTION:  OnCarSinkAppStateMsg::OnCarSinkAppStateMsg
 ***************************************************************************/
OnCarSinkAppStateMsg::OnCarSinkAppStateMsg(): m_enNavAppState(e8SPI_NAV_UNKNOWN),
                                              m_enSpeechAppState(e8SPI_SPEECH_UNKNOWN),
                                              m_enPhoneAppState(e8SPI_PHONE_UNKNOWN)
{
   ETG_TRACE_USR1(("OnCarSinkAppStateMsg::OnCarSinkAppStateMsg entered"));	
}
/***************************************************************************
 ** FUNCTION:  OnCarSessionStateMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(OnCarSessionStateMsg,spi_tclOnCarSessionDispatcher);

//! Class OnCarSessionErrorMsg
/***************************************************************************
 ** FUNCTION:  OnCarSessionErrorMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(OnCarSessionErrorMsg,spi_tclOnCarSessionDispatcher);

//! Class OnCarSinkAppStateMsg
/***************************************************************************
 ** FUNCTION:  OnCarSinkAppStateMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(OnCarSinkAppStateMsg,spi_tclOnCarSessionDispatcher);

//! Class spi_tclOnCarSessionDispatcher
/***************************************************************************
 ** FUNCTION:  spi_tclOnCarSessionDispatcher::spi_tclOnCarSessionDispatcher
 ***************************************************************************/
spi_tclOnCarSessionDispatcher::spi_tclOnCarSessionDispatcher()
{
   ETG_TRACE_USR1(("spi_tclOnCarSessionDispatcher::spi_tclOnCarSessionDispatcher entered"));
}

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarSessionDispatcher::~spi_tclOnCarSessionDispatcher
 ***************************************************************************/
spi_tclOnCarSessionDispatcher::~spi_tclOnCarSessionDispatcher()
{
   ETG_TRACE_USR1(("spi_tclOnCarSessionDispatcher::~spi_tclOnCarSessionDispatcher"));
}

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarSessionDispatcher::vHandleSessionMsg(OnCarSessionStateMsg* poOnCarSessionStateMsg)
 ***************************************************************************/
t_Void spi_tclOnCarSessionDispatcher::vHandleSessionMsg(OnCarSessionStateMsg* poOnCarSessionStateMsg) const
{
   ETG_TRACE_USR1(("spi_tclOnCarSessionDispatcher OnCarSessionStateMsg ::vHandleSessionMsg entered"));
   if (NULL != poOnCarSessionStateMsg)
   {
      CALL_REG_OBJECTS(spi_tclOnCarRespSession,
               e16ONCAR_SESSION_REGID,
               vPostOnCarSessionStateMsg(poOnCarSessionStateMsg->m_OnCarSessionState));
   } // if (NULL != poOnCarSessionStateMsg)
}

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarSessionDispatcher::vHandleSessionMsg(OnCarSessionErrorMsg* poOnCarSessionErrorMsg)
 ***************************************************************************/
t_Void spi_tclOnCarSessionDispatcher::vHandleSessionMsg(OnCarSessionErrorMsg* poOnCarSessionErrorMsg) const
{
   ETG_TRACE_USR1(("spi_tclOnCarSessionDispatcher OnCarSessionErrorMsg ::vHandleSessionMsg entered"));
   if (NULL != poOnCarSessionErrorMsg)
   {
      CALL_REG_OBJECTS(spi_tclOnCarRespSession,
               e16ONCAR_SESSION_REGID,
               vPostOnCarSessionErrorMsg(poOnCarSessionErrorMsg->m_enOnCarSinkError));
   } // if (NULL != poOnCarSessionErrorMsg)
}

/***************************************************************************
 ** FUNCTION:  spi_tclOnCarSessionDispatcher::vHandleSessionMsg(OnCarSinkAppStateMsg* poOnCarSessionErrorMsg)
 ***************************************************************************/
t_Void spi_tclOnCarSessionDispatcher::vHandleSessionMsg(OnCarSinkAppStateMsg* poOnCarSinkAppStateMsg) const
{
   ETG_TRACE_USR1(("spi_tclOnCarSessionDispatcher OnCarSinkAppStateMsg::vHandleSessionMsg entered"));
   if (NULL != poOnCarSinkAppStateMsg)
   {
      CALL_REG_OBJECTS(spi_tclOnCarRespSession,
               e16ONCAR_SESSION_REGID,
               vPostOnCarAppStateMsg((poOnCarSinkAppStateMsg->m_enNavAppState), 
			                            (poOnCarSinkAppStateMsg->m_enSpeechAppState),
 										(poOnCarSinkAppStateMsg->m_enPhoneAppState)));
   } // if (NULL != poOnCarSinkAppStateMsg)
   else
   {
	   ETG_TRACE_USR1(("poOnCarSinkAppStateMsg is NULL-----------------------"));
   }
}
